/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.udflib.handler;

import com.github.stephenc.javaisotools.sabre.ContentHandler;
import com.github.stephenc.javaisotools.sabre.DataReference;
import com.github.stephenc.javaisotools.sabre.HandlerException;
import com.github.stephenc.javaisotools.sabre.StructureHandler;
import com.github.stephenc.javaisotools.sabre.impl.ByteArrayDataReference;
import com.github.stephenc.javaisotools.sabre.impl.WordDataReference;
import com.github.stephenc.javaisotools.udflib.SabreUDFElement;
import com.github.stephenc.javaisotools.udflib.handler.UDF102Handler;
import com.github.stephenc.javaisotools.udflib.structures.ExtendedFileEntry;
import com.github.stephenc.javaisotools.udflib.structures.FileIdentifierDescriptor;
import com.github.stephenc.javaisotools.udflib.structures.Long_ad;
import com.github.stephenc.javaisotools.udflib.structures.PartitionDescriptor;
import com.github.stephenc.javaisotools.udflib.structures.Short_ad;
import com.github.stephenc.javaisotools.udflib.structures.Timestamp;
import com.github.stephenc.javaisotools.udflib.structures.VolumeRecognitionSequence;
import com.github.stephenc.javaisotools.udflib.tools.BinaryTools;
import com.github.stephenc.javaisotools.udflib.tools.Permissions;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;

public class UDF201Handler
extends UDF102Handler {
    public UDF201Handler(StructureHandler myStructureHandler, ContentHandler myContentHandler) {
        super(myStructureHandler, myContentHandler);
        this.udfVersionIdentifierSuffix = new byte[]{1, 2, 0, 0, 0, 0, 0, 0};
        this.minimumUDFReadRevision = 513;
        this.minimumUDFWriteRevision = 513;
        this.maximumUDFWriteRevision = 513;
        this.descriptorVersion = 3;
    }

    protected void createAndPassVRS() throws HandlerException {
        VolumeRecognitionSequence myVolumeRecognitionSequene = new VolumeRecognitionSequence(VolumeRecognitionSequence.NSRVersion.NSR03);
        super.data(new ByteArrayDataReference(myVolumeRecognitionSequene.getBytes()));
    }

    protected void createAndPassPD() throws HandlerException {
        InputStream myInputStream = null;
        long tagLocation = 0L;
        long volumeDescriptorSequenceNumber = 0L;
        long partitionStartingBlock = 0L;
        long partitionEndingBlock = 0L;
        String applicationIdentifier = "";
        byte[] applicationIdentifierSuffix = new byte[]{};
        try {
            DataReference myDataReference = (DataReference)this.dataReferenceStack.pop();
            myInputStream = myDataReference.createInputStream();
            applicationIdentifierSuffix = BinaryTools.readByteArray(myInputStream, (int)myDataReference.getLength());
            myInputStream.close();
            myInputStream = null;
            myDataReference = (DataReference)this.dataReferenceStack.pop();
            myInputStream = myDataReference.createInputStream();
            applicationIdentifier = new String(BinaryTools.readByteArray(myInputStream, (int)myDataReference.getLength()));
            myInputStream.close();
            myInputStream = null;
            myInputStream = ((DataReference)this.dataReferenceStack.pop()).createInputStream();
            partitionEndingBlock = BinaryTools.readUInt32AsLong(myInputStream);
            myInputStream.close();
            myInputStream = null;
            myInputStream = ((DataReference)this.dataReferenceStack.pop()).createInputStream();
            partitionStartingBlock = BinaryTools.readUInt32AsLong(myInputStream);
            myInputStream.close();
            myInputStream = null;
            myInputStream = ((DataReference)this.dataReferenceStack.pop()).createInputStream();
            volumeDescriptorSequenceNumber = BinaryTools.readUInt32AsLong(myInputStream);
            myInputStream.close();
            myInputStream = null;
            myInputStream = ((DataReference)this.dataReferenceStack.pop()).createInputStream();
            tagLocation = BinaryTools.readUInt32AsLong(myInputStream);
            myInputStream.close();
            myInputStream = null;
        }
        catch (IOException myIOException) {
            throw new HandlerException(myIOException);
        }
        finally {
            if (myInputStream != null) {
                try {
                    myInputStream.close();
                }
                catch (IOException myIOException) {}
            }
        }
        PartitionDescriptor myPartitionDescriptor = new PartitionDescriptor();
        myPartitionDescriptor.DescriptorTag.TagSerialNumber = this.tagSerialNumber;
        myPartitionDescriptor.DescriptorTag.DescriptorVersion = this.descriptorVersion;
        myPartitionDescriptor.DescriptorTag.TagLocation = tagLocation;
        myPartitionDescriptor.VolumeDescriptorSequenceNumber = volumeDescriptorSequenceNumber;
        myPartitionDescriptor.PartitionFlags = 1;
        myPartitionDescriptor.PartitionNumber = 0;
        try {
            myPartitionDescriptor.PartitionContents.setIdentifier("+NSR03");
            myPartitionDescriptor.ImplementationIdentifier.setIdentifier(applicationIdentifier);
        }
        catch (Exception myException) {
            throw new HandlerException(myException);
        }
        myPartitionDescriptor.AccessType = 1L;
        myPartitionDescriptor.PartitonStartingLocation = partitionStartingBlock;
        myPartitionDescriptor.PartitionLength = partitionEndingBlock - partitionStartingBlock;
        myPartitionDescriptor.ImplementationIdentifier.IdentifierSuffix = applicationIdentifierSuffix;
        super.startElement(new SabreUDFElement(SabreUDFElement.UDFElementType.DescriptorTag));
        super.data(new WordDataReference(5L));
        super.data(new WordDataReference(tagLocation));
        super.data(new WordDataReference(this.tagSerialNumber));
        super.data(new WordDataReference(this.descriptorVersion));
        super.data(new ByteArrayDataReference(myPartitionDescriptor.getBytesWithoutDescriptorTag()));
        super.endElement();
    }

    protected void createAndPassFE() throws HandlerException {
        InputStream myInputStream = null;
        long tagLocation = 0L;
        int fileLinkCount = 0;
        Calendar accessTime = Calendar.getInstance();
        Calendar modificationTime = Calendar.getInstance();
        Calendar attributeTime = Calendar.getInstance();
        Calendar creationTime = Calendar.getInstance();
        long uniqueId = 0L;
        String applicationIdentifier = "";
        byte[] applicationIdentifierSuffix = new byte[]{};
        int fileType = 0;
        try {
            this.dataReferenceStack.pop();
            myInputStream = ((DataReference)this.dataReferenceStack.pop()).createInputStream();
            fileType = (int)BinaryTools.readUInt32AsLong(myInputStream);
            myInputStream.close();
            myInputStream = null;
            DataReference myDataReference = (DataReference)this.dataReferenceStack.pop();
            myInputStream = myDataReference.createInputStream();
            applicationIdentifierSuffix = BinaryTools.readByteArray(myInputStream, (int)myDataReference.getLength());
            myInputStream.close();
            myInputStream = null;
            myDataReference = (DataReference)this.dataReferenceStack.pop();
            myInputStream = myDataReference.createInputStream();
            applicationIdentifier = new String(BinaryTools.readByteArray(myInputStream, (int)myDataReference.getLength()));
            myInputStream.close();
            myInputStream = null;
            myInputStream = ((DataReference)this.dataReferenceStack.pop()).createInputStream();
            uniqueId = BinaryTools.readUInt64AsLong(myInputStream);
            myInputStream.close();
            myInputStream = null;
            myInputStream = ((DataReference)this.dataReferenceStack.pop()).createInputStream();
            creationTime.setTimeInMillis(BinaryTools.readUInt64AsLong(myInputStream));
            myInputStream.close();
            myInputStream = null;
            myInputStream = ((DataReference)this.dataReferenceStack.pop()).createInputStream();
            attributeTime.setTimeInMillis(BinaryTools.readUInt64AsLong(myInputStream));
            myInputStream.close();
            myInputStream = null;
            myInputStream = ((DataReference)this.dataReferenceStack.pop()).createInputStream();
            modificationTime.setTimeInMillis(BinaryTools.readUInt64AsLong(myInputStream));
            myInputStream.close();
            myInputStream = null;
            myInputStream = ((DataReference)this.dataReferenceStack.pop()).createInputStream();
            accessTime.setTimeInMillis(BinaryTools.readUInt64AsLong(myInputStream));
            myInputStream.close();
            myInputStream = null;
            myInputStream = ((DataReference)this.dataReferenceStack.pop()).createInputStream();
            fileLinkCount = (int)BinaryTools.readUInt32AsLong(myInputStream);
            myInputStream.close();
            myInputStream = null;
            myInputStream = ((DataReference)this.dataReferenceStack.pop()).createInputStream();
            tagLocation = BinaryTools.readUInt32AsLong(myInputStream);
            myInputStream.close();
            myInputStream = null;
        }
        catch (IOException myIOException) {
            throw new HandlerException(myIOException);
        }
        finally {
            if (myInputStream != null) {
                try {
                    myInputStream.close();
                }
                catch (IOException myIOException) {}
            }
        }
        ExtendedFileEntry myExtendedFileEntry = new ExtendedFileEntry();
        myExtendedFileEntry.DescriptorTag.TagSerialNumber = this.tagSerialNumber;
        myExtendedFileEntry.DescriptorTag.DescriptorVersion = this.descriptorVersion;
        myExtendedFileEntry.DescriptorTag.TagLocation = tagLocation;
        myExtendedFileEntry.Uid = -1L;
        myExtendedFileEntry.Gid = -1L;
        myExtendedFileEntry.Permissions = Permissions.OTHER_Read | Permissions.GROUP_Read | Permissions.OWNER_Read;
        myExtendedFileEntry.FileLinkCount = fileLinkCount;
        myExtendedFileEntry.RecordFormat = 0;
        myExtendedFileEntry.RecordDisplayAttributes = 0;
        myExtendedFileEntry.RecordLength = 0L;
        myExtendedFileEntry.AccessTime = new Timestamp(accessTime);
        myExtendedFileEntry.ModificationTime = new Timestamp(modificationTime);
        myExtendedFileEntry.AttributeTime = new Timestamp(attributeTime);
        myExtendedFileEntry.CreationTime = new Timestamp(creationTime);
        myExtendedFileEntry.Checkpoint = 1L;
        try {
            myExtendedFileEntry.ImplementationIdentifier.setIdentifier(applicationIdentifier);
        }
        catch (Exception myException) {
            throw new HandlerException(myException);
        }
        myExtendedFileEntry.ImplementationIdentifier.IdentifierSuffix = applicationIdentifierSuffix;
        myExtendedFileEntry.ICBTag.PriorRecordedNumberofDirectEntries = 0L;
        myExtendedFileEntry.ICBTag.NumberofEntries = 1;
        myExtendedFileEntry.ICBTag.StrategyType = 4;
        myExtendedFileEntry.UniqueID = uniqueId;
        if (fileType == 0) {
            myExtendedFileEntry.ICBTag.FileType = (byte)5;
            this.createAndPassNormalFE(myExtendedFileEntry);
        } else if (fileType == 1) {
            myExtendedFileEntry.ICBTag.FileType = (byte)4;
            this.createAndPassDirectoryFE(myExtendedFileEntry);
        }
    }

    private void createAndPassNormalFE(ExtendedFileEntry myExtendedFileEntry) throws HandlerException {
        InputStream myInputStream = null;
        long fileSize = 0L;
        long dataLocation = 0L;
        byte[] fileData = new byte[]{};
        try {
            myInputStream = ((DataReference)this.dataReferenceStack.pop()).createInputStream();
            dataLocation = BinaryTools.readUInt32AsLong(myInputStream);
            myInputStream.close();
            myInputStream = null;
            DataReference myDataReference = (DataReference)this.dataReferenceStack.pop();
            fileSize = myDataReference.getLength();
            myInputStream = myDataReference.createInputStream();
            if (fileSize <= (long)(this.blockSize - ExtendedFileEntry.fixedPartLength)) {
                fileData = BinaryTools.readByteArray(myInputStream, (int)fileSize);
            }
            myInputStream.close();
            myInputStream = null;
        }
        catch (IOException myIOException) {
            throw new HandlerException(myIOException);
        }
        finally {
            if (myInputStream != null) {
                try {
                    myInputStream.close();
                }
                catch (IOException myIOException) {}
            }
        }
        myExtendedFileEntry.ICBTag.FileType = (byte)5;
        myExtendedFileEntry.ObjectSize = myExtendedFileEntry.InformationLength = fileSize;
        if (fileSize <= (long)(this.blockSize - ExtendedFileEntry.fixedPartLength)) {
            myExtendedFileEntry.ICBTag.Flags = 3;
            myExtendedFileEntry.LogicalBlocksRecorded = 0L;
            myExtendedFileEntry.LengthofAllocationDescriptors = fileSize;
            myExtendedFileEntry.AllocationDescriptors = fileData;
        } else {
            myExtendedFileEntry.ICBTag.Flags = 1;
            myExtendedFileEntry.LogicalBlocksRecorded = fileSize / (long)this.blockSize;
            if (fileSize % (long)this.blockSize != 0L) {
                ++myExtendedFileEntry.LogicalBlocksRecorded;
            }
            ArrayList<Long_ad> allocationDescriptors = new ArrayList<Long_ad>();
            long restFileSize = fileSize;
            long currentExtentPosition = dataLocation;
            while (restFileSize > 0L) {
                Long_ad allocationDescriptor = new Long_ad();
                allocationDescriptor.ExtentLength = restFileSize < this.maximumAllocationLength ? restFileSize : this.maximumAllocationLength;
                allocationDescriptor.ExtentLocation.part_num = 0;
                allocationDescriptor.ExtentLocation.lb_num = currentExtentPosition;
                allocationDescriptors.add(allocationDescriptor);
                restFileSize -= this.maximumAllocationLength;
                currentExtentPosition += this.maximumAllocationLength / (long)this.blockSize;
                if (this.maximumAllocationLength % (long)this.blockSize == 0L) continue;
                ++currentExtentPosition;
            }
            byte[] allocationDescriptorBytes = new byte[allocationDescriptors.size() * 16];
            int allocationDescriptorBytesPosition = 0;
            for (int i = 0; i < allocationDescriptors.size(); ++i) {
                byte[] singleAllocationDescriptorBytes = ((Long_ad)allocationDescriptors.get(i)).getBytes();
                System.arraycopy(singleAllocationDescriptorBytes, 0, allocationDescriptorBytes, allocationDescriptorBytesPosition, singleAllocationDescriptorBytes.length);
                allocationDescriptorBytesPosition += singleAllocationDescriptorBytes.length;
            }
            myExtendedFileEntry.AllocationDescriptors = allocationDescriptorBytes;
            myExtendedFileEntry.LengthofAllocationDescriptors = allocationDescriptorBytes.length;
        }
        super.startElement(new SabreUDFElement(SabreUDFElement.UDFElementType.DescriptorTag));
        super.data(new WordDataReference(266L));
        super.data(new WordDataReference(myExtendedFileEntry.DescriptorTag.TagLocation));
        super.data(new WordDataReference(this.tagSerialNumber));
        super.data(new WordDataReference(this.descriptorVersion));
        super.data(new ByteArrayDataReference(myExtendedFileEntry.getBytesWithoutDescriptorTag()));
        super.endElement();
    }

    private void createAndPassDirectoryFE(ExtendedFileEntry myExtendedFileEntry) throws HandlerException {
        int i;
        InputStream myInputStream = null;
        ArrayList<FileIdentifierDescriptor> childFileIdentifierDescriptors = new ArrayList<FileIdentifierDescriptor>();
        long dataLocation = 0L;
        int partitionToStoreMetadataOn = 0;
        try {
            myInputStream = ((DataReference)this.dataReferenceStack.pop()).createInputStream();
            dataLocation = BinaryTools.readUInt32AsLong(myInputStream);
            myInputStream.close();
            myInputStream = null;
            myInputStream = ((DataReference)this.dataReferenceStack.pop()).createInputStream();
            partitionToStoreMetadataOn = (int)BinaryTools.readUInt32AsLong(myInputStream);
            myInputStream.close();
            myInputStream = null;
            myInputStream = ((DataReference)this.dataReferenceStack.pop()).createInputStream();
            long parentDirectoryLocation = BinaryTools.readUInt32AsLong(myInputStream);
            myInputStream.close();
            myInputStream = null;
            myInputStream = ((DataReference)this.dataReferenceStack.pop()).createInputStream();
            long parentDirectoryUniqueId = BinaryTools.readUInt64AsLong(myInputStream);
            myInputStream.close();
            myInputStream = null;
            FileIdentifierDescriptor parentDirectoryFileIdentifierDescriptor = new FileIdentifierDescriptor();
            parentDirectoryFileIdentifierDescriptor.DescriptorTag.TagLocation = myExtendedFileEntry.DescriptorTag.TagLocation;
            parentDirectoryFileIdentifierDescriptor.DescriptorTag.TagSerialNumber = this.tagSerialNumber;
            parentDirectoryFileIdentifierDescriptor.DescriptorTag.DescriptorVersion = this.descriptorVersion;
            parentDirectoryFileIdentifierDescriptor.ICB.ExtentLength = this.blockSize;
            parentDirectoryFileIdentifierDescriptor.ICB.ExtentLocation.part_num = partitionToStoreMetadataOn;
            parentDirectoryFileIdentifierDescriptor.FileVersionNumber = 1;
            parentDirectoryFileIdentifierDescriptor.FileCharacteristics = (short)10;
            parentDirectoryFileIdentifierDescriptor.ICB.ExtentLocation.lb_num = parentDirectoryLocation;
            parentDirectoryFileIdentifierDescriptor.ICB.implementationUse = new byte[6];
            parentDirectoryFileIdentifierDescriptor.ICB.implementationUse[2] = (byte)(parentDirectoryUniqueId & 0xFFL);
            parentDirectoryFileIdentifierDescriptor.ICB.implementationUse[3] = (byte)(parentDirectoryUniqueId >> 8 & 0xFFL);
            parentDirectoryFileIdentifierDescriptor.ICB.implementationUse[4] = (byte)(parentDirectoryUniqueId >> 16 & 0xFFL);
            parentDirectoryFileIdentifierDescriptor.ICB.implementationUse[5] = (byte)(parentDirectoryUniqueId >> 32 & 0xFFL);
            childFileIdentifierDescriptors.add(parentDirectoryFileIdentifierDescriptor);
            myInputStream = ((DataReference)this.dataReferenceStack.pop()).createInputStream();
            int numberOfChildFiles = (int)BinaryTools.readUInt32AsLong(myInputStream);
            myInputStream.close();
            myInputStream = null;
            for (i = 0; i < numberOfChildFiles; ++i) {
                myInputStream = ((DataReference)this.dataReferenceStack.pop()).createInputStream();
                int childFileType = (int)BinaryTools.readUInt32AsLong(myInputStream);
                myInputStream.close();
                myInputStream = null;
                DataReference myDataReference = (DataReference)this.dataReferenceStack.pop();
                myInputStream = myDataReference.createInputStream();
                String childFileIdentifier = new String(BinaryTools.readByteArray(myInputStream, (int)myDataReference.getLength()));
                myInputStream.close();
                myInputStream = null;
                myInputStream = ((DataReference)this.dataReferenceStack.pop()).createInputStream();
                long childFileLocation = BinaryTools.readUInt32AsLong(myInputStream);
                myInputStream.close();
                myInputStream = null;
                myInputStream = ((DataReference)this.dataReferenceStack.pop()).createInputStream();
                long childFileUniqueId = BinaryTools.readUInt64AsLong(myInputStream);
                myInputStream.close();
                myInputStream = null;
                FileIdentifierDescriptor childFileIdentifierDescriptor = new FileIdentifierDescriptor();
                childFileIdentifierDescriptor.DescriptorTag.TagLocation = myExtendedFileEntry.DescriptorTag.TagLocation;
                childFileIdentifierDescriptor.DescriptorTag.TagSerialNumber = this.tagSerialNumber;
                childFileIdentifierDescriptor.DescriptorTag.DescriptorVersion = this.descriptorVersion;
                childFileIdentifierDescriptor.ICB.ExtentLength = this.blockSize;
                childFileIdentifierDescriptor.ICB.ExtentLocation.lb_num = childFileLocation;
                childFileIdentifierDescriptor.ICB.ExtentLocation.part_num = partitionToStoreMetadataOn;
                childFileIdentifierDescriptor.ICB.implementationUse = new byte[6];
                childFileIdentifierDescriptor.ICB.implementationUse[2] = (byte)(childFileUniqueId & 0xFFL);
                childFileIdentifierDescriptor.ICB.implementationUse[3] = (byte)(childFileUniqueId >> 8 & 0xFFL);
                childFileIdentifierDescriptor.ICB.implementationUse[4] = (byte)(childFileUniqueId >> 16 & 0xFFL);
                childFileIdentifierDescriptor.ICB.implementationUse[5] = (byte)(childFileUniqueId >> 32 & 0xFFL);
                childFileIdentifierDescriptor.FileVersionNumber = 1;
                try {
                    childFileIdentifierDescriptor.setFileIdentifier(childFileIdentifier);
                }
                catch (Exception myException) {
                    throw new HandlerException(myException);
                }
                if (childFileType == 1) {
                    childFileIdentifierDescriptor.FileCharacteristics = (short)2;
                }
                childFileIdentifierDescriptors.add(childFileIdentifierDescriptor);
            }
        }
        catch (IOException myIOException) {
            throw new HandlerException(myIOException);
        }
        finally {
            if (myInputStream != null) {
                try {
                    myInputStream.close();
                }
                catch (IOException myIOException) {}
            }
        }
        int directoryFileDataLength = 0;
        for (int i2 = 0; i2 < childFileIdentifierDescriptors.size(); ++i2) {
            directoryFileDataLength += ((FileIdentifierDescriptor)childFileIdentifierDescriptors.get(i2)).getLength();
        }
        myExtendedFileEntry.ObjectSize = myExtendedFileEntry.InformationLength = (long)directoryFileDataLength;
        if (directoryFileDataLength <= this.blockSize - ExtendedFileEntry.fixedPartLength) {
            myExtendedFileEntry.ICBTag.Flags = 3;
            myExtendedFileEntry.LogicalBlocksRecorded = 0L;
            myExtendedFileEntry.LengthofAllocationDescriptors = directoryFileDataLength;
            myExtendedFileEntry.AllocationDescriptors = new byte[directoryFileDataLength];
            int pos = 0;
            for (int i3 = 0; i3 < childFileIdentifierDescriptors.size(); ++i3) {
                byte[] childFileIdentifierDescriptorBytes = ((FileIdentifierDescriptor)childFileIdentifierDescriptors.get(i3)).getBytes();
                System.arraycopy(childFileIdentifierDescriptorBytes, 0, myExtendedFileEntry.AllocationDescriptors, pos, childFileIdentifierDescriptorBytes.length);
                pos += childFileIdentifierDescriptorBytes.length;
            }
            super.startElement(new SabreUDFElement(SabreUDFElement.UDFElementType.DescriptorTag));
            super.data(new WordDataReference(266L));
            super.data(new WordDataReference(myExtendedFileEntry.DescriptorTag.TagLocation));
            super.data(new WordDataReference(this.tagSerialNumber));
            super.data(new WordDataReference(this.descriptorVersion));
            super.data(new ByteArrayDataReference(myExtendedFileEntry.getBytesWithoutDescriptorTag()));
            super.endElement();
        } else {
            myExtendedFileEntry.ICBTag.Flags = 0;
            myExtendedFileEntry.LogicalBlocksRecorded = directoryFileDataLength / this.blockSize;
            if (directoryFileDataLength % this.blockSize != 0) {
                ++myExtendedFileEntry.LogicalBlocksRecorded;
            }
            Short_ad allocationDescriptor = new Short_ad();
            allocationDescriptor.ExtentLength = directoryFileDataLength;
            allocationDescriptor.ExtentPosition = dataLocation;
            if (directoryFileDataLength % this.blockSize != 0) {
                directoryFileDataLength += this.blockSize - directoryFileDataLength % this.blockSize;
            }
            byte[] data = new byte[directoryFileDataLength];
            long currentRealPosition = dataLocation * (long)this.blockSize;
            int pos = 0;
            for (i = 0; i < childFileIdentifierDescriptors.size(); ++i) {
                long tagLocationBlock = currentRealPosition / (long)this.blockSize;
                FileIdentifierDescriptor childFileIdentifierDescriptor = (FileIdentifierDescriptor)childFileIdentifierDescriptors.get(i);
                childFileIdentifierDescriptor.DescriptorTag.TagLocation = tagLocationBlock;
                byte[] childFileIdentifierDescriptorBytes = ((FileIdentifierDescriptor)childFileIdentifierDescriptors.get(i)).getBytes();
                System.arraycopy(childFileIdentifierDescriptorBytes, 0, data, pos, childFileIdentifierDescriptorBytes.length);
                pos += childFileIdentifierDescriptorBytes.length;
                currentRealPosition += (long)childFileIdentifierDescriptorBytes.length;
            }
            myExtendedFileEntry.AllocationDescriptors = allocationDescriptor.getBytes();
            myExtendedFileEntry.LengthofAllocationDescriptors = myExtendedFileEntry.AllocationDescriptors.length;
            super.startElement(new SabreUDFElement(SabreUDFElement.UDFElementType.DescriptorTag));
            super.data(new WordDataReference(266L));
            super.data(new WordDataReference(myExtendedFileEntry.DescriptorTag.TagLocation));
            super.data(new WordDataReference(this.tagSerialNumber));
            super.data(new WordDataReference(this.descriptorVersion));
            super.data(new ByteArrayDataReference(myExtendedFileEntry.getBytesWithoutDescriptorTag()));
            super.endElement();
            super.data(new ByteArrayDataReference(data));
        }
    }
}

