/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.udflib.handler;

import com.github.stephenc.javaisotools.sabre.DataReference;
import com.github.stephenc.javaisotools.sabre.Element;
import com.github.stephenc.javaisotools.sabre.Fixup;
import com.github.stephenc.javaisotools.sabre.HandlerException;
import com.github.stephenc.javaisotools.sabre.StreamHandler;
import com.github.stephenc.javaisotools.sabre.impl.FileFixup;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;

public class SerializationHandler
implements StreamHandler {
    private File myOutputFile;
    private DataOutputStream myDataOutputStream;
    private long position;

    public SerializationHandler(File outputFile) throws HandlerException {
        this.myOutputFile = outputFile;
        this.position = 0L;
    }

    public void startDocument() throws HandlerException {
        this.position = 0L;
        try {
            this.myDataOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this.myOutputFile)));
        }
        catch (IOException myIOException) {
            throw new HandlerException(myIOException);
        }
    }

    public void endDocument() throws HandlerException {
        try {
            this.myDataOutputStream.close();
        }
        catch (IOException myIOException) {
            throw new HandlerException(myIOException);
        }
    }

    public void startElement(Element myElement) throws HandlerException {
    }

    public void endElement() throws HandlerException {
    }

    public void data(DataReference myDataReference) throws HandlerException {
        InputStream myInputStream = null;
        try {
            long length;
            int bufferLength = 32768;
            byte[] buffer = new byte[bufferLength];
            long lengthToWrite = length = myDataReference.getLength();
            int bytesToRead = 0;
            int bytesHandled = 0;
            myInputStream = myDataReference.createInputStream();
            while (lengthToWrite > 0L) {
                bytesToRead = lengthToWrite > (long)bufferLength ? bufferLength : (int)lengthToWrite;
                bytesHandled = myInputStream.read(buffer, 0, bytesToRead);
                if (bytesHandled == -1) {
                    throw new HandlerException("Cannot read all data from reference.");
                }
                this.myDataOutputStream.write(buffer, 0, bytesHandled);
                lengthToWrite -= (long)bytesHandled;
                this.position += (long)bytesHandled;
            }
            this.myDataOutputStream.flush();
        }
        catch (IOException myIOException) {
            throw new HandlerException(myIOException);
        }
        finally {
            try {
                if (myInputStream != null) {
                    myInputStream.close();
                    myInputStream = null;
                }
            }
            catch (IOException myIOException) {}
        }
    }

    public Fixup fixup(DataReference myDataReference) throws HandlerException {
        try {
            FileFixup fixup = new FileFixup(new RandomAccessFile(this.myOutputFile, "rw"), this.position, myDataReference.getLength());
            this.data(myDataReference);
            return fixup;
        }
        catch (FileNotFoundException e) {
            throw new HandlerException(e);
        }
    }

    public long mark() throws HandlerException {
        return this.position;
    }
}

