/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.joliet.impl;

import com.github.stephenc.javaisotools.iso9660.ISO9660Directory;
import com.github.stephenc.javaisotools.iso9660.ISO9660File;
import com.github.stephenc.javaisotools.iso9660.NamingConventions;
import com.github.stephenc.javaisotools.sabre.HandlerException;
import java.util.Vector;

public class JolietNamingConventions
extends NamingConventions {
    public static boolean FORCE_DOT_DELIMITER = true;

    public JolietNamingConventions() {
        super("Joliet");
    }

    public void apply(ISO9660Directory dir) throws HandlerException {
        String filename = this.normalize(dir.getName());
        if (filename.length() > 64) {
            filename = filename.substring(0, 64);
        }
        if (filename.length() == 0) {
            throw new HandlerException(this.getID() + ": Empty directory name encountered.");
        }
        this.setFilename(dir, filename);
    }

    public void apply(ISO9660File file) throws HandlerException {
        String filename = this.normalize(file.getFilename());
        String extension = this.normalize(file.getExtension());
        file.enforceDotDelimiter(FORCE_DOT_DELIMITER);
        if (filename.length() == 0 && extension.length() == 0) {
            throw new HandlerException(this.getID() + ": Empty file name encountered.");
        }
        if (file.enforces8plus3()) {
            if (filename.length() > 8) {
                filename = filename.substring(0, 8);
            }
            if (extension.length() > 3) {
                String mapping = JolietNamingConventions.getExtensionMapping(extension);
                extension = mapping != null && mapping.length() <= 3 ? this.normalize(mapping) : extension.substring(0, 3);
            }
        }
        if (filename.length() + extension.length() + (file.getVersion() + "").length() + 2 > 64) {
            if (filename.length() >= extension.length()) {
                filename = filename.substring(0, 64 - extension.length());
            } else {
                extension = extension.substring(0, 64 - filename.length());
            }
        }
        this.setFilename(file, filename, extension);
    }

    private String normalize(String name) {
        return name.replaceAll("[*/:;?\\\\]", "_");
    }

    public void addDuplicate(Vector duplicates, String name, int version) {
        String[] data = new String[]{name.toUpperCase(), version + ""};
        duplicates.add(data);
    }

    public boolean checkFilenameEquality(String name1, String name2) {
        return name1.equalsIgnoreCase(name2);
    }

    public void checkPathLength(String isoPath) {
        if (isoPath.length() > 120) {
            System.out.println(this.getID() + ": Path length exceeds limit: " + isoPath);
        }
    }
}

