/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.eltorito.impl;

import com.github.stephenc.javaisotools.iso9660.BootConfig;
import com.github.stephenc.javaisotools.iso9660.ConfigException;
import com.github.stephenc.javaisotools.iso9660.ISO9660File;
import com.github.stephenc.javaisotools.sabre.HandlerException;
import java.io.File;

public class ElToritoConfig
extends BootConfig {
    private boolean bootable = true;
    private boolean genBootInfoTable;
    private int platformID;
    private int bootMediaType;
    private int loadSegment;
    private int systemType;
    private int sectorCount;
    private String idString;
    private ISO9660File bootImage;
    public static int PLATFORM_ID_X86 = 0;
    public static int PLATFORM_ID_PPC = 1;
    public static int PLATFORM_ID_MAC = 2;
    public static int PLATFORM_ID_EFI = 239;
    public static int BOOT_MEDIA_TYPE_NO_EMU = 0;
    public static int BOOT_MEDIA_TYPE_1_2MEG_DISKETTE = 1;
    public static int BOOT_MEDIA_TYPE_1_44MEG_DISKETTE = 2;
    public static int BOOT_MEDIA_TYPE_2_88MEG_DISKETTE = 3;
    public static int BOOT_MEDIA_TYPE_HD = 4;
    public static int LOAD_SEGMENT_7C0 = 0;

    public ElToritoConfig(File bootImage, int emulation, int platformID, String idString, int sectorCount, int loadSegment) throws HandlerException, ConfigException {
        super("EL TORITO SPECIFICATION", "");
        this.loadSegment = loadSegment;
        this.bootImage = new ISO9660File(bootImage);
        this.setIDString(idString);
        this.systemType = 0;
        this.sectorCount = sectorCount;
        this.setPlatformID(platformID);
        this.setEmulation(emulation);
        this.genBootInfoTable = false;
    }

    public ISO9660File getBootImage() {
        return this.bootImage;
    }

    public void setBootImage(ISO9660File bootImage) {
        this.bootImage = bootImage;
    }

    public boolean getBootable() {
        return this.bootable;
    }

    public void setBootable(boolean bootable) {
        this.bootable = bootable;
    }

    public void setGenBootInfoTable(boolean genBootInfoTable) throws ConfigException {
        if (genBootInfoTable && this.bootMediaType != BOOT_MEDIA_TYPE_NO_EMU) {
            throw new ConfigException(this, "Boot info table generation requires no-emulation image.");
        }
        this.genBootInfoTable = genBootInfoTable;
    }

    public boolean getGenBootInfoTable() {
        return this.genBootInfoTable;
    }

    public void setPlatformID(int platformID) throws ConfigException {
        if (platformID < 0 || platformID > 2) {
            throw new ConfigException(this, "Invalid Platform ID: " + platformID);
        }
        this.platformID = platformID;
    }

    public int getPlatformID() {
        return this.platformID;
    }

    public void setIDString(String idString) throws ConfigException {
        if (idString.length() > 24) {
            throw new ConfigException(this, "The ID string may be no longer than 24 characters.");
        }
        this.idString = idString;
    }

    public String getIDString() {
        return this.idString;
    }

    public int getBootMediaType() {
        return this.bootMediaType;
    }

    public void setEmulation(int bootMediaType) throws ConfigException {
        if (bootMediaType < 0 || bootMediaType > 4) {
            throw new ConfigException(this, "Invalid Boot Media Type: " + bootMediaType);
        }
        this.bootMediaType = bootMediaType;
    }

    public int getLoadSegment() {
        return this.loadSegment;
    }

    public void setLoadSegment(int loadSegment) {
        this.loadSegment = loadSegment;
    }

    public int getSectorCount() {
        return this.sectorCount;
    }

    public void setSectorCount(int sectorCount) {
        this.sectorCount = sectorCount;
    }

    public int getSystemType() {
        return this.systemType;
    }

    public void setSystemType(int systemType) {
        this.systemType = systemType;
    }
}

