/*
 * Decompiled with CFR 0.152.
 */
package toothpick;

import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import toothpick.Injector;
import toothpick.InjectorImpl;
import toothpick.Scope;
import toothpick.ScopeImpl;
import toothpick.ScopeNode;
import toothpick.configuration.Configuration;
import toothpick.configuration.ConfigurationHolder;

public class Toothpick {
    private static final ConcurrentHashMap<Object, Scope> MAP_KEY_TO_SCOPE = new ConcurrentHashMap();
    private static final ConcurrentHashMap<Object, Scope> ROOT_SCOPES = new ConcurrentHashMap();
    static Injector injector = new InjectorImpl();

    protected Toothpick() {
        throw new RuntimeException("Constructor can't be invoked even via reflection.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Scope openRootScope() {
        ConcurrentHashMap<Object, Scope> concurrentHashMap = ROOT_SCOPES;
        synchronized (concurrentHashMap) {
            if (ROOT_SCOPES.size() > 1) {
                throw new RuntimeException("openRootScope() is not supported when multiple root scopes are enabled. Use 'Configuration.preventMultipleRootScopes()' to enable it.");
            }
            if (ROOT_SCOPES.size() == 1) {
                return ROOT_SCOPES.values().iterator().next();
            }
            return Toothpick.openScope(Toothpick.class);
        }
    }

    public static boolean isScopeOpen(Object name) {
        if (name == null) {
            throw new IllegalArgumentException("null scope names are not allowed.");
        }
        return MAP_KEY_TO_SCOPE.containsKey(name);
    }

    public static Scope openScopes(Object ... names) {
        if (names == null) {
            throw new IllegalArgumentException("null scope names are not allowed.");
        }
        if (names.length == 0) {
            throw new IllegalArgumentException("Minimally, one scope name is required.");
        }
        ScopeNode lastScope = null;
        ScopeNode previousScope = (ScopeNode)Toothpick.openScope(names[0], true);
        for (int i = 1; i < names.length; ++i) {
            lastScope = (ScopeNode)Toothpick.openScope(names[i], false);
            previousScope = lastScope = previousScope.addChild(lastScope);
        }
        return previousScope;
    }

    public static Scope openScope(Object name) {
        return Toothpick.openScope(name, true);
    }

    public static Scope openScope(Object name, Scope.ScopeConfig scopeConfig) {
        if (Toothpick.isScopeOpen(name)) {
            return Toothpick.openScope(name);
        }
        Scope scope = Toothpick.openScope(name, true);
        scopeConfig.configure(scope);
        return scope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Scope openScope(Object name, boolean isRootScope) {
        ConcurrentHashMap<Object, Scope> concurrentHashMap = ROOT_SCOPES;
        synchronized (concurrentHashMap) {
            if (name == null) {
                throw new IllegalArgumentException("null scope names are not allowed.");
            }
            Scope scope = MAP_KEY_TO_SCOPE.get(name);
            if (scope != null) {
                return scope;
            }
            scope = new ScopeImpl(name);
            Scope previous = MAP_KEY_TO_SCOPE.putIfAbsent(name, scope);
            if (previous != null) {
                scope = previous;
            } else if (isRootScope) {
                ROOT_SCOPES.put(name, scope);
                ConfigurationHolder.configuration.checkMultipleRootScopes(scope);
            }
            return scope;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeScope(Object name) {
        ConcurrentHashMap<Object, Scope> concurrentHashMap = ROOT_SCOPES;
        synchronized (concurrentHashMap) {
            ScopeNode scope = (ScopeNode)MAP_KEY_TO_SCOPE.remove(name);
            if (scope != null) {
                ScopeNode parentScope = scope.getParentScope();
                if (parentScope != null) {
                    parentScope.removeChild(scope);
                } else {
                    ConfigurationHolder.configuration.onScopeForestReset();
                    ROOT_SCOPES.remove(name);
                }
                Toothpick.removeScopeAndChildrenFromMap(scope);
            }
        }
    }

    public static void reset() {
        for (Object name : Collections.list(MAP_KEY_TO_SCOPE.keys())) {
            Toothpick.closeScope(name);
        }
        ConfigurationHolder.configuration.onScopeForestReset();
        ScopeImpl.resetUnScopedProviders();
    }

    public static void reset(Scope scope) {
        ScopeNode scopeNode = (ScopeNode)scope;
        scopeNode.reset();
    }

    public static void release(Scope scope) {
        ScopeNode scopeNode = (ScopeNode)scope;
        scopeNode.release();
    }

    public static void inject(Object obj, Scope scope) {
        injector.inject(obj, scope);
    }

    private static void removeScopeAndChildrenFromMap(ScopeNode scope) {
        MAP_KEY_TO_SCOPE.remove(scope.getName());
        scope.close();
        for (ScopeNode childScope : scope.childrenScopes.values()) {
            Toothpick.removeScopeAndChildrenFromMap(childScope);
        }
    }

    public static void setConfiguration(Configuration configuration) {
        ConfigurationHolder.configuration = configuration;
    }

    static int getScopeNamesSize() {
        return MAP_KEY_TO_SCOPE.size();
    }
}

