/*
 * Decompiled with CFR 0.152.
 */
package toothpick;

import java.lang.ref.WeakReference;
import javax.inject.Provider;
import toothpick.Lazy;
import toothpick.Scope;

public class ThreadSafeProviderImpl<T>
implements Provider<T>,
Lazy<T> {
    private volatile T instance;
    private WeakReference<Scope> scope;
    private String scopeName;
    private Class<T> clazz;
    private String name;
    private boolean isLazy;

    public ThreadSafeProviderImpl(Scope scope, Class<T> clazz, String name, boolean isLazy) {
        this.scope = new WeakReference<Scope>(scope);
        this.scopeName = scope.getName().toString();
        this.clazz = clazz;
        this.name = name;
        this.isLazy = isLazy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get() {
        if (this.isLazy && this.instance != null) {
            return this.instance;
        }
        ThreadSafeProviderImpl threadSafeProviderImpl = this;
        synchronized (threadSafeProviderImpl) {
            if (this.isLazy) {
                if (this.instance == null) {
                    this.instance = this.getScope().getInstance(this.clazz, this.name);
                    this.scope.clear();
                }
                return this.instance;
            }
            return (T)this.getScope().getInstance(this.clazz, this.name);
        }
    }

    private Scope getScope() {
        Scope scope = (Scope)this.scope.get();
        if (scope == null) {
            throw new IllegalStateException(String.format("The instance provided by the %s cannot be created when the associated scope: %s has been closed", this.isLazy ? "lazy" : "provider", this.scopeName));
        }
        return scope;
    }
}

