/*
 * Decompiled with CFR 0.152.
 */
package toothpick.compiler.factory.generators;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import javax.inject.Singleton;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Types;
import toothpick.Factory;
import toothpick.MemberInjector;
import toothpick.Scope;
import toothpick.compiler.common.generators.CodeGenerator;
import toothpick.compiler.common.generators.targets.ParamInjectionTarget;
import toothpick.compiler.factory.targets.ConstructorInjectionTarget;

public class FactoryGenerator
extends CodeGenerator {
    private static final String FACTORY_SUFFIX = "__Factory";
    private ConstructorInjectionTarget constructorInjectionTarget;

    public FactoryGenerator(ConstructorInjectionTarget constructorInjectionTarget, Types types) {
        super(types);
        this.constructorInjectionTarget = constructorInjectionTarget;
    }

    @Override
    public String brewJava() {
        ClassName className = ClassName.get((TypeElement)this.constructorInjectionTarget.builtClass);
        ParameterizedTypeName parameterizedTypeName = ParameterizedTypeName.get((ClassName)ClassName.get(Factory.class), (TypeName[])new TypeName[]{className});
        TypeSpec.Builder factoryTypeSpec = TypeSpec.classBuilder((String)(FactoryGenerator.getGeneratedSimpleClassName(this.constructorInjectionTarget.builtClass) + FACTORY_SUFFIX)).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addSuperinterface((TypeName)parameterizedTypeName);
        this.emitSuperMemberInjectorFieldIfNeeded(factoryTypeSpec);
        this.emitCreateInstance(factoryTypeSpec);
        this.emitGetTargetScope(factoryTypeSpec);
        this.emitHasScopeAnnotation(factoryTypeSpec);
        this.emitHasSingletonAnnotation(factoryTypeSpec);
        this.emitHasReleasableAnnotation(factoryTypeSpec);
        this.emitHasProvidesSingletonAnnotation(factoryTypeSpec);
        this.emitHasProvidesReleasableAnnotation(factoryTypeSpec);
        JavaFile javaFile = JavaFile.builder((String)className.packageName(), (TypeSpec)factoryTypeSpec.build()).build();
        return javaFile.toString();
    }

    private void emitSuperMemberInjectorFieldIfNeeded(TypeSpec.Builder scopeMemberTypeSpec) {
        if (this.constructorInjectionTarget.superClassThatNeedsMemberInjection != null) {
            ClassName superTypeThatNeedsInjection = ClassName.get((TypeElement)this.constructorInjectionTarget.superClassThatNeedsMemberInjection);
            ParameterizedTypeName memberInjectorSuperParameterizedTypeName = ParameterizedTypeName.get((ClassName)ClassName.get(MemberInjector.class), (TypeName[])new TypeName[]{superTypeThatNeedsInjection});
            FieldSpec.Builder superMemberInjectorField = FieldSpec.builder((TypeName)memberInjectorSuperParameterizedTypeName, (String)"memberInjector", (Modifier[])new Modifier[]{Modifier.PRIVATE}).initializer("new $L__MemberInjector()", new Object[]{FactoryGenerator.getGeneratedFQNClassName(this.constructorInjectionTarget.superClassThatNeedsMemberInjection)});
            scopeMemberTypeSpec.addField(superMemberInjectorField.build());
        }
    }

    @Override
    public String getFqcn() {
        return FactoryGenerator.getGeneratedFQNClassName(this.constructorInjectionTarget.builtClass) + FACTORY_SUFFIX;
    }

    private void emitCreateInstance(TypeSpec.Builder builder) {
        ClassName className = ClassName.get((TypeElement)this.constructorInjectionTarget.builtClass);
        MethodSpec.Builder createInstanceBuilder = MethodSpec.methodBuilder((String)"createInstance").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)ClassName.get(Scope.class), "scope", new Modifier[0]).returns((TypeName)className);
        if (!this.constructorInjectionTarget.parameters.isEmpty() || this.constructorInjectionTarget.superClassThatNeedsMemberInjection != null) {
            createInstanceBuilder.addStatement("scope = getTargetScope(scope)", new Object[0]);
        }
        StringBuilder localVarStatement = new StringBuilder("");
        String simpleClassName = FactoryGenerator.getSimpleClassName(className);
        localVarStatement.append(simpleClassName).append(" ");
        String varName = "" + Character.toLowerCase(className.simpleName().charAt(0));
        varName = varName + className.simpleName().substring(1);
        localVarStatement.append(varName).append(" = ");
        localVarStatement.append("new ");
        localVarStatement.append(simpleClassName).append("(");
        int counter = 1;
        String prefix = "";
        CodeBlock.Builder codeBlockBuilder = CodeBlock.builder();
        if (this.constructorInjectionTarget.throwsThrowable) {
            codeBlockBuilder.beginControlFlow("try", new Object[0]);
        }
        for (ParamInjectionTarget paramInjectionTarget : this.constructorInjectionTarget.parameters) {
            CodeBlock invokeScopeGetMethodWithNameCodeBlock = this.getInvokeScopeGetMethodWithNameCodeBlock(paramInjectionTarget);
            String paramName = "param" + counter++;
            codeBlockBuilder.add("$T $L = scope.", new Object[]{this.getParamType(paramInjectionTarget), paramName});
            codeBlockBuilder.add(invokeScopeGetMethodWithNameCodeBlock);
            codeBlockBuilder.add(";", new Object[0]);
            codeBlockBuilder.add(LINE_SEPARATOR, new Object[0]);
            localVarStatement.append(prefix);
            localVarStatement.append(paramName);
            prefix = ", ";
        }
        localVarStatement.append(")");
        codeBlockBuilder.addStatement(localVarStatement.toString(), new Object[0]);
        if (this.constructorInjectionTarget.superClassThatNeedsMemberInjection != null) {
            codeBlockBuilder.addStatement("memberInjector.inject($L, scope)", new Object[]{varName});
        }
        codeBlockBuilder.addStatement("return $L", new Object[]{varName});
        if (this.constructorInjectionTarget.throwsThrowable) {
            codeBlockBuilder.nextControlFlow("catch($L ex)", new Object[]{ClassName.get(Throwable.class)});
            codeBlockBuilder.addStatement("throw new $L(ex)", new Object[]{ClassName.get(RuntimeException.class)});
            codeBlockBuilder.endControlFlow();
        }
        createInstanceBuilder.addCode(codeBlockBuilder.build());
        builder.addMethod(createInstanceBuilder.build());
    }

    private void emitGetTargetScope(TypeSpec.Builder builder) {
        CodeBlock.Builder getParentScopeCodeBlockBuilder = this.getParentScopeCodeBlockBuilder();
        MethodSpec.Builder getScopeBuilder = MethodSpec.methodBuilder((String)"getTargetScope").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)ClassName.get(Scope.class), "scope", new Modifier[0]).returns((TypeName)ClassName.get(Scope.class)).addStatement("return scope$L", new Object[]{getParentScopeCodeBlockBuilder.build().toString()});
        builder.addMethod(getScopeBuilder.build());
    }

    private void emitHasScopeAnnotation(TypeSpec.Builder builder) {
        String scopeName = this.constructorInjectionTarget.scopeName;
        boolean hasScopeAnnotation = scopeName != null;
        MethodSpec.Builder hasScopeAnnotationBuilder = MethodSpec.methodBuilder((String)"hasScopeAnnotation").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(TypeName.BOOLEAN).addStatement("return $L", new Object[]{hasScopeAnnotation});
        builder.addMethod(hasScopeAnnotationBuilder.build());
    }

    private void emitHasSingletonAnnotation(TypeSpec.Builder builder) {
        boolean hasSingletonAnnotation = this.constructorInjectionTarget.hasSingletonAnnotation;
        MethodSpec.Builder hasScopeAnnotationBuilder = MethodSpec.methodBuilder((String)"hasSingletonAnnotation").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(TypeName.BOOLEAN).addStatement("return $L", new Object[]{hasSingletonAnnotation});
        builder.addMethod(hasScopeAnnotationBuilder.build());
    }

    private void emitHasReleasableAnnotation(TypeSpec.Builder builder) {
        boolean hasReleasableAnnotation = this.constructorInjectionTarget.hasReleasableAnnotation;
        MethodSpec.Builder hasScopeAnnotationBuilder = MethodSpec.methodBuilder((String)"hasReleasableAnnotation").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(TypeName.BOOLEAN).addStatement("return $L", new Object[]{hasReleasableAnnotation});
        builder.addMethod(hasScopeAnnotationBuilder.build());
    }

    private void emitHasProvidesSingletonAnnotation(TypeSpec.Builder builder) {
        MethodSpec.Builder hasProducesSingletonBuilder = MethodSpec.methodBuilder((String)"hasProvidesSingletonAnnotation").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(TypeName.BOOLEAN).addStatement("return $L", new Object[]{this.constructorInjectionTarget.hasProvidesSingletonInScopeAnnotation});
        builder.addMethod(hasProducesSingletonBuilder.build());
    }

    private void emitHasProvidesReleasableAnnotation(TypeSpec.Builder builder) {
        MethodSpec.Builder hasProducesSingletonBuilder = MethodSpec.methodBuilder((String)"hasProvidesReleasableAnnotation").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(TypeName.BOOLEAN).addStatement("return $L", new Object[]{this.constructorInjectionTarget.hasProvidesReleasableAnnotation});
        builder.addMethod(hasProducesSingletonBuilder.build());
    }

    private CodeBlock.Builder getParentScopeCodeBlockBuilder() {
        CodeBlock.Builder getParentScopeCodeBlockBuilder = CodeBlock.builder();
        String scopeName = this.constructorInjectionTarget.scopeName;
        if (scopeName != null) {
            if (Singleton.class.getName().equals(scopeName)) {
                getParentScopeCodeBlockBuilder.add(".getRootScope()", new Object[0]);
            } else {
                getParentScopeCodeBlockBuilder.add(".getParentScope($L.class)", new Object[]{scopeName});
            }
        }
        return getParentScopeCodeBlockBuilder;
    }
}

