/*
 * Decompiled with CFR 0.152.
 */
package toothpick.compiler.factory;

import java.lang.annotation.Annotation;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedOptions;
import javax.inject.Inject;
import javax.inject.Scope;
import javax.inject.Singleton;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.ElementFilter;
import toothpick.InjectConstructor;
import toothpick.ProvidesReleasable;
import toothpick.ProvidesSingleton;
import toothpick.Releasable;
import toothpick.compiler.common.ToothpickProcessor;
import toothpick.compiler.factory.generators.FactoryGenerator;
import toothpick.compiler.factory.targets.ConstructorInjectionTarget;

@SupportedOptions(value={"toothpick_excludes", "toothpick_annotations", "toothpick_crash_when_no_factory_can_be_created"})
public class FactoryProcessor
extends ToothpickProcessor {
    private static final String SUPPRESS_WARNING_ANNOTATION_INJECTABLE_VALUE = "injectable";
    private Map<TypeElement, ConstructorInjectionTarget> mapTypeElementToConstructorInjectionTarget;
    private Boolean crashWhenNoFactoryCanBeCreated;
    private Map<String, TypeElement> allRoundsGeneratedToTypeElement = new HashMap<String, TypeElement>();

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        this.supportedAnnotationTypes.add("javax.inject.Inject");
        this.supportedAnnotationTypes.add("javax.inject.Singleton");
        this.supportedAnnotationTypes.add("toothpick.ProvidesSingleton");
        this.supportedAnnotationTypes.add("toothpick.InjectConstructor");
        this.readOptionAnnotationTypes();
        return this.supportedAnnotationTypes;
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        this.readCommonProcessorOptions();
        this.readCrashWhenNoFactoryCanBeCreatedOption();
        this.mapTypeElementToConstructorInjectionTarget = new LinkedHashMap<TypeElement, ConstructorInjectionTarget>();
        this.findAndParseTargets(roundEnv, annotations);
        for (Map.Entry<TypeElement, ConstructorInjectionTarget> entry : this.mapTypeElementToConstructorInjectionTarget.entrySet()) {
            ConstructorInjectionTarget constructorInjectionTarget = entry.getValue();
            FactoryGenerator factoryGenerator = new FactoryGenerator(constructorInjectionTarget, this.typeUtils);
            TypeElement typeElement = entry.getKey();
            String fileDescription = String.format("Factory for type %s", typeElement);
            this.writeToFile(factoryGenerator, fileDescription, typeElement);
            this.allRoundsGeneratedToTypeElement.put(factoryGenerator.getFqcn(), typeElement);
        }
        return false;
    }

    private void readCrashWhenNoFactoryCanBeCreatedOption() {
        Map<String, String> options = this.processingEnv.getOptions();
        if (this.crashWhenNoFactoryCanBeCreated == null) {
            this.crashWhenNoFactoryCanBeCreated = Boolean.parseBoolean(options.get("toothpick_crash_when_no_factory_can_be_created"));
        }
    }

    private void findAndParseTargets(RoundEnvironment roundEnv, Set<? extends TypeElement> annotations) {
        this.createFactoriesForClassesAnnotatedWithInjectConstructor(roundEnv);
        this.createFactoriesForClassesWithInjectAnnotatedConstructors(roundEnv);
        this.createFactoriesForClassesAnnotatedWith(roundEnv, ProvidesSingleton.class);
        this.createFactoriesForClassesWithInjectAnnotatedFields(roundEnv);
        this.createFactoriesForClassesWithInjectAnnotatedMethods(roundEnv);
        this.createFactoriesForClassesAnnotatedWithScopeAnnotations(roundEnv, annotations);
    }

    private void createFactoriesForClassesAnnotatedWithScopeAnnotations(RoundEnvironment roundEnv, Set<? extends TypeElement> annotations) {
        for (TypeElement typeElement : annotations) {
            if (typeElement.getAnnotation(Scope.class) == null) continue;
            this.checkScopeAnnotationValidity(typeElement);
            this.createFactoriesForClassesAnnotatedWith(roundEnv, typeElement);
        }
    }

    private void createFactoriesForClassesWithInjectAnnotatedMethods(RoundEnvironment roundEnv) {
        for (ExecutableElement methodElement : ElementFilter.methodsIn(roundEnv.getElementsAnnotatedWith(Inject.class))) {
            this.processClassContainingInjectAnnotatedMember(methodElement.getEnclosingElement(), this.mapTypeElementToConstructorInjectionTarget);
        }
    }

    private void createFactoriesForClassesWithInjectAnnotatedFields(RoundEnvironment roundEnv) {
        for (VariableElement fieldElement : ElementFilter.fieldsIn(roundEnv.getElementsAnnotatedWith(Inject.class))) {
            this.processClassContainingInjectAnnotatedMember(fieldElement.getEnclosingElement(), this.mapTypeElementToConstructorInjectionTarget);
        }
    }

    private void createFactoriesForClassesAnnotatedWith(RoundEnvironment roundEnv, Class<? extends Annotation> annotationClass) {
        for (Element element : ElementFilter.typesIn(roundEnv.getElementsAnnotatedWith(annotationClass))) {
            TypeElement annotatedTypeElement = (TypeElement)element;
            this.processClassContainingInjectAnnotatedMember(annotatedTypeElement, this.mapTypeElementToConstructorInjectionTarget);
        }
    }

    private void createFactoriesForClassesAnnotatedWith(RoundEnvironment roundEnv, TypeElement annotationType) {
        for (Element element : ElementFilter.typesIn(roundEnv.getElementsAnnotatedWith(annotationType))) {
            TypeElement annotatedTypeElement = (TypeElement)element;
            this.processClassContainingInjectAnnotatedMember(annotatedTypeElement, this.mapTypeElementToConstructorInjectionTarget);
        }
    }

    private void createFactoriesForClassesWithInjectAnnotatedConstructors(RoundEnvironment roundEnv) {
        for (ExecutableElement constructorElement : ElementFilter.constructorsIn(roundEnv.getElementsAnnotatedWith(Inject.class))) {
            TypeElement enclosingElement = (TypeElement)constructorElement.getEnclosingElement();
            if (!this.isSingleInjectAnnotatedConstructor(constructorElement)) {
                this.error(constructorElement, "Class %s cannot have more than one @Inject annotated constructor.", enclosingElement.getQualifiedName());
            }
            this.processInjectAnnotatedConstructor(constructorElement, this.mapTypeElementToConstructorInjectionTarget);
        }
    }

    private void createFactoriesForClassesAnnotatedWithInjectConstructor(RoundEnvironment roundEnv) {
        for (Element element : ElementFilter.typesIn(roundEnv.getElementsAnnotatedWith(InjectConstructor.class))) {
            TypeElement annotatedTypeElement = (TypeElement)element;
            List<ExecutableElement> constructorElements = ElementFilter.constructorsIn(annotatedTypeElement.getEnclosedElements());
            if (constructorElements.size() != 1 || constructorElements.get(0).getAnnotation(Inject.class) != null) {
                this.error(constructorElements.get(0), "Class %s is annotated with @InjectInjectConstructor. Therefore, It must have one unique constructor and it should not be annotated with @Inject.", annotatedTypeElement.getQualifiedName());
            }
            this.processInjectAnnotatedConstructor(constructorElements.get(0), this.mapTypeElementToConstructorInjectionTarget);
        }
    }

    private void processClassContainingInjectAnnotatedMember(Element enclosingElement, Map<TypeElement, ConstructorInjectionTarget> mapTypeElementToConstructorInjectionTarget) {
        TypeElement typeElement = (TypeElement)this.typeUtils.asElement(enclosingElement.asType());
        if (mapTypeElementToConstructorInjectionTarget.containsKey(typeElement)) {
            return;
        }
        if (this.isExcludedByFilters(typeElement)) {
            return;
        }
        if (!this.canTypeHaveAFactory(typeElement)) {
            return;
        }
        ConstructorInjectionTarget constructorInjectionTarget = this.createConstructorInjectionTarget(typeElement);
        if (constructorInjectionTarget != null) {
            mapTypeElementToConstructorInjectionTarget.put(typeElement, constructorInjectionTarget);
        }
    }

    private boolean isSingleInjectAnnotatedConstructor(Element constructorElement) {
        TypeElement enclosingElement = (TypeElement)constructorElement.getEnclosingElement();
        boolean isSingleInjectedConstructor = true;
        List<ExecutableElement> constructorElements = ElementFilter.constructorsIn(enclosingElement.getEnclosedElements());
        for (ExecutableElement constructorElementInClass : constructorElements) {
            if (constructorElementInClass.getAnnotation(Inject.class) == null || constructorElement.equals(constructorElementInClass)) continue;
            isSingleInjectedConstructor = false;
        }
        return isSingleInjectedConstructor;
    }

    private void processInjectAnnotatedConstructor(ExecutableElement constructorElement, Map<TypeElement, ConstructorInjectionTarget> targetClassMap) {
        TypeElement enclosingElement = (TypeElement)constructorElement.getEnclosingElement();
        if (!this.isValidInjectAnnotatedConstructor(constructorElement)) {
            return;
        }
        if (this.isExcludedByFilters(enclosingElement)) {
            return;
        }
        if (!this.canTypeHaveAFactory(enclosingElement)) {
            this.error(enclosingElement, "The class %s is abstract or private. It cannot have an injected constructor.", enclosingElement.getQualifiedName());
            return;
        }
        targetClassMap.put(enclosingElement, this.createConstructorInjectionTarget(constructorElement));
    }

    private boolean isValidInjectAnnotatedConstructor(ExecutableElement element) {
        TypeElement enclosingElement = (TypeElement)element.getEnclosingElement();
        Set<Modifier> modifiers = element.getModifiers();
        if (modifiers.contains((Object)Modifier.PRIVATE)) {
            this.error(element, "@Inject constructors must not be private in class %s.", enclosingElement.getQualifiedName());
            return false;
        }
        Set<Modifier> parentModifiers = enclosingElement.getModifiers();
        if (parentModifiers.contains((Object)Modifier.PRIVATE)) {
            this.error(element, "Class %s is private. @Inject constructors are not allowed in private classes.", enclosingElement.getQualifiedName());
            return false;
        }
        if (this.isNonStaticInnerClass(enclosingElement)) {
            return false;
        }
        for (VariableElement variableElement : element.getParameters()) {
            if (this.isValidInjectedType(variableElement)) continue;
            return false;
        }
        return true;
    }

    private ConstructorInjectionTarget createConstructorInjectionTarget(ExecutableElement constructorElement) {
        TypeElement enclosingElement = (TypeElement)constructorElement.getEnclosingElement();
        String scopeName = this.getScopeName(enclosingElement);
        boolean hasSingletonAnnotation = this.hasSingletonAnnotation(enclosingElement);
        boolean hasReleasableAnnotation = this.hasReleasableAnnotation(enclosingElement);
        boolean hasProvidesSingletonInScopeAnnotation = this.hasProvidesSingletonInScopeAnnotation(enclosingElement);
        boolean hasProvidesReleasableAnnotation = this.hasProvidesReleasableAnnotation(enclosingElement);
        this.checkReleasableAnnotationValidity(enclosingElement, hasReleasableAnnotation, hasSingletonAnnotation);
        this.checkProvidesReleasableAnnotationValidity(enclosingElement, hasReleasableAnnotation, hasSingletonAnnotation);
        if (hasProvidesSingletonInScopeAnnotation && scopeName == null) {
            this.error(enclosingElement, "The type %s uses @ProvidesSingleton but doesn't have a scope annotation.", enclosingElement.getQualifiedName().toString());
        }
        TypeElement superClassWithInjectedMembers = this.getMostDirectSuperClassWithInjectedMembers(enclosingElement, false);
        ConstructorInjectionTarget constructorInjectionTarget = new ConstructorInjectionTarget(enclosingElement, scopeName, hasSingletonAnnotation, hasReleasableAnnotation, hasProvidesSingletonInScopeAnnotation, hasProvidesReleasableAnnotation, superClassWithInjectedMembers);
        constructorInjectionTarget.parameters.addAll(this.getParamInjectionTargetList(constructorElement));
        constructorInjectionTarget.throwsThrowable = !constructorElement.getThrownTypes().isEmpty();
        return constructorInjectionTarget;
    }

    private ConstructorInjectionTarget createConstructorInjectionTarget(TypeElement typeElement) {
        String scopeName = this.getScopeName(typeElement);
        boolean hasSingletonAnnotation = this.hasSingletonAnnotation(typeElement);
        boolean hasReleasableAnnotation = this.hasReleasableAnnotation(typeElement);
        boolean hasProvidesSingletonInScopeAnnotation = this.hasProvidesSingletonInScopeAnnotation(typeElement);
        boolean hasProvidesReleasableAnnotation = this.hasProvidesReleasableAnnotation(typeElement);
        this.checkReleasableAnnotationValidity(typeElement, hasReleasableAnnotation, hasSingletonAnnotation);
        this.checkProvidesReleasableAnnotationValidity(typeElement, hasReleasableAnnotation, hasSingletonAnnotation);
        if (hasProvidesSingletonInScopeAnnotation && scopeName == null) {
            this.error(typeElement, "The type %s uses @ProvidesSingleton but doesn't have a scope annotation.", typeElement.getQualifiedName().toString());
        }
        TypeElement superClassWithInjectedMembers = this.getMostDirectSuperClassWithInjectedMembers(typeElement, false);
        List<ExecutableElement> constructorElements = ElementFilter.constructorsIn(typeElement.getEnclosedElements());
        for (ExecutableElement executableElement : constructorElements) {
            if (executableElement.getAnnotation(Inject.class) == null) continue;
            return null;
        }
        String cannotCreateAFactoryMessage = " Toothpick can't create a factory for it. If this class is itself a DI entry point (i.e. you call TP.inject(this) at some point),  then you can remove this warning by adding @SuppressWarnings(\"Injectable\") to the class. A typical example is a class using injection to assign its fields, that calls TP.inject(this), but it needs a parameter for its constructor and this parameter is not injectable.";
        for (ExecutableElement constructorElement : constructorElements) {
            if (!constructorElement.getParameters().isEmpty()) continue;
            if (constructorElement.getModifiers().contains((Object)Modifier.PRIVATE)) {
                if (!this.isInjectableWarningSuppressed(typeElement)) {
                    String message = String.format("The class %s has a private default constructor.  Toothpick can't create a factory for it. If this class is itself a DI entry point (i.e. you call TP.inject(this) at some point),  then you can remove this warning by adding @SuppressWarnings(\"Injectable\") to the class. A typical example is a class using injection to assign its fields, that calls TP.inject(this), but it needs a parameter for its constructor and this parameter is not injectable.", typeElement.getQualifiedName().toString());
                    this.crashOrWarnWhenNoFactoryCanBeCreated(constructorElement, message);
                }
                return null;
            }
            ConstructorInjectionTarget constructorInjectionTarget = new ConstructorInjectionTarget(typeElement, scopeName, hasSingletonAnnotation, hasReleasableAnnotation, hasProvidesSingletonInScopeAnnotation, hasProvidesReleasableAnnotation, superClassWithInjectedMembers);
            return constructorInjectionTarget;
        }
        if (!this.isInjectableWarningSuppressed(typeElement)) {
            String string = String.format("The class %s has injected members or a scope annotation but has no @Inject annotated (non-private) constructor  nor a non-private default constructor.  Toothpick can't create a factory for it. If this class is itself a DI entry point (i.e. you call TP.inject(this) at some point),  then you can remove this warning by adding @SuppressWarnings(\"Injectable\") to the class. A typical example is a class using injection to assign its fields, that calls TP.inject(this), but it needs a parameter for its constructor and this parameter is not injectable.", typeElement.getQualifiedName().toString());
            this.crashOrWarnWhenNoFactoryCanBeCreated(typeElement, string);
        }
        return null;
    }

    private void crashOrWarnWhenNoFactoryCanBeCreated(Element element, String message) {
        if (this.crashWhenNoFactoryCanBeCreated != null && this.crashWhenNoFactoryCanBeCreated.booleanValue()) {
            this.error(element, message, new Object[0]);
        } else {
            this.warning(element, message, new Object[0]);
        }
    }

    private String getScopeName(TypeElement typeElement) {
        String scopeName = null;
        boolean hasScopeAnnotation = false;
        for (AnnotationMirror annotationMirror : typeElement.getAnnotationMirrors()) {
            TypeElement annotationTypeElement = (TypeElement)annotationMirror.getAnnotationType().asElement();
            boolean isSingletonAnnotation = annotationTypeElement.getQualifiedName().contentEquals("javax.inject.Singleton");
            if (!isSingletonAnnotation && annotationTypeElement.getAnnotation(Scope.class) != null) {
                this.checkScopeAnnotationValidity(annotationTypeElement);
                if (scopeName != null) {
                    this.error(typeElement, "Only one @Scope qualified annotation is allowed : %s", scopeName);
                }
                scopeName = annotationTypeElement.getQualifiedName().toString();
            }
            if (!isSingletonAnnotation) continue;
            hasScopeAnnotation = true;
        }
        if (hasScopeAnnotation && scopeName == null) {
            scopeName = "javax.inject.Singleton";
        }
        return scopeName;
    }

    private boolean hasSingletonAnnotation(TypeElement typeElement) {
        return typeElement.getAnnotation(Singleton.class) != null;
    }

    private boolean hasReleasableAnnotation(TypeElement typeElement) {
        return typeElement.getAnnotation(Releasable.class) != null;
    }

    private boolean hasProvidesSingletonInScopeAnnotation(TypeElement typeElement) {
        return typeElement.getAnnotation(ProvidesSingleton.class) != null;
    }

    private boolean hasProvidesReleasableAnnotation(TypeElement typeElement) {
        return typeElement.getAnnotation(ProvidesReleasable.class) != null;
    }

    private void checkReleasableAnnotationValidity(TypeElement typeElement, boolean hasReleasableAnnotation, boolean hasSingletonAnnotation) {
        if (hasReleasableAnnotation && !hasSingletonAnnotation) {
            this.error(typeElement, "Class %s is annotated with @Releasable, it should also be annotated with either @Singleton.", typeElement.getQualifiedName());
        }
    }

    private void checkProvidesReleasableAnnotationValidity(TypeElement typeElement, boolean hasProvidesReleasableAnnotation, boolean hasProvideSingletonInScopeAnnotation) {
        if (hasProvidesReleasableAnnotation && !hasProvideSingletonInScopeAnnotation) {
            this.error(typeElement, "Class %s is annotated with @ProvidesReleasable, it should also be annotated with either @ProvidesSingleton.", typeElement.getQualifiedName());
        }
    }

    private void checkScopeAnnotationValidity(TypeElement annotation) {
        if (annotation.getAnnotation(Scope.class) == null) {
            this.error(annotation, "Scope Annotation %s does not contain Scope annotation.", annotation.getQualifiedName());
            return;
        }
        Retention retention = annotation.getAnnotation(Retention.class);
        if (retention == null || retention.value() != RetentionPolicy.RUNTIME) {
            this.error(annotation, "Scope Annotation %s does not have RUNTIME retention policy.", annotation.getQualifiedName());
        }
    }

    private boolean isInjectableWarningSuppressed(TypeElement typeElement) {
        return this.hasWarningSuppressed(typeElement, SUPPRESS_WARNING_ANNOTATION_INJECTABLE_VALUE);
    }

    private boolean canTypeHaveAFactory(TypeElement typeElement) {
        boolean isAbstract = typeElement.getModifiers().contains((Object)Modifier.ABSTRACT);
        boolean isPrivate = typeElement.getModifiers().contains((Object)Modifier.PRIVATE);
        return !isAbstract && !isPrivate;
    }

    void setToothpickExcludeFilters(String toothpickExcludeFilters) {
        this.toothpickExcludeFilters = toothpickExcludeFilters;
    }

    void setCrashWhenNoFactoryCanBeCreated(boolean crashWhenNoFactoryCanBeCreated) {
        this.crashWhenNoFactoryCanBeCreated = crashWhenNoFactoryCanBeCreated;
    }

    TypeElement getOriginatingElement(String generatedQualifiedName) {
        return this.allRoundsGeneratedToTypeElement.get(generatedQualifiedName);
    }
}

