/*
 * Decompiled with CFR 0.152.
 */
package com.github.stefvanschie.inventoryframework.nms.v1_15;

import com.github.stefvanschie.inventoryframework.abstraction.CartographyTableInventory;
import com.github.stefvanschie.inventoryframework.adventuresupport.TextHolder;
import com.github.stefvanschie.inventoryframework.nms.v1_15.util.TextHolderUtil;
import java.lang.reflect.Field;
import net.minecraft.server.v1_15_R1.Container;
import net.minecraft.server.v1_15_R1.ContainerCartography;
import net.minecraft.server.v1_15_R1.Containers;
import net.minecraft.server.v1_15_R1.EntityHuman;
import net.minecraft.server.v1_15_R1.EntityPlayer;
import net.minecraft.server.v1_15_R1.IChatBaseComponent;
import net.minecraft.server.v1_15_R1.IInventory;
import net.minecraft.server.v1_15_R1.NonNullList;
import net.minecraft.server.v1_15_R1.Packet;
import net.minecraft.server.v1_15_R1.PacketPlayOutOpenWindow;
import net.minecraft.server.v1_15_R1.PacketPlayOutSetSlot;
import net.minecraft.server.v1_15_R1.PacketPlayOutWindowItems;
import net.minecraft.server.v1_15_R1.PlayerConnection;
import org.bukkit.craftbukkit.v1_15_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_15_R1.inventory.CraftInventoryCartography;
import org.bukkit.craftbukkit.v1_15_R1.inventory.CraftInventoryView;
import org.bukkit.craftbukkit.v1_15_R1.inventory.CraftItemStack;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CartographyTableInventoryImpl
extends CartographyTableInventory {
    public CartographyTableInventoryImpl(@NotNull InventoryHolder inventoryHolder) {
        super(inventoryHolder);
    }

    @Override
    public void openInventory(@NotNull Player player, @NotNull TextHolder title, @Nullable ItemStack[] items) {
        int itemAmount = items.length;
        if (itemAmount != 3) {
            throw new IllegalArgumentException("The amount of items for a cartography table should be 3, but is '" + itemAmount + "'");
        }
        EntityPlayer entityPlayer = this.getEntityPlayer(player);
        ContainerCartographyTableImpl containerCartographyTable = new ContainerCartographyTableImpl(entityPlayer, items);
        entityPlayer.activeContainer = containerCartographyTable;
        int id = containerCartographyTable.windowId;
        IChatBaseComponent message = TextHolderUtil.toComponent(title);
        PacketPlayOutOpenWindow packet = new PacketPlayOutOpenWindow(id, Containers.CARTOGRAPHY_TABLE, message);
        entityPlayer.playerConnection.sendPacket((Packet)packet);
        this.sendItems(player, items);
    }

    @Override
    public void sendItems(@NotNull Player player, @Nullable ItemStack[] items) {
        NonNullList nmsItems = NonNullList.a((Object)net.minecraft.server.v1_15_R1.ItemStack.a, (Object[])new net.minecraft.server.v1_15_R1.ItemStack[]{CraftItemStack.asNMSCopy((ItemStack)items[0]), CraftItemStack.asNMSCopy((ItemStack)items[1]), CraftItemStack.asNMSCopy((ItemStack)items[2])});
        EntityPlayer entityPlayer = this.getEntityPlayer(player);
        this.getPlayerConnection(entityPlayer).sendPacket((Packet)new PacketPlayOutWindowItems(this.getWindowId(entityPlayer), nmsItems));
    }

    @Override
    public void clearCursor(@NotNull Player player) {
        this.getPlayerConnection(this.getEntityPlayer(player)).sendPacket((Packet)new PacketPlayOutSetSlot(-1, -1, net.minecraft.server.v1_15_R1.ItemStack.a));
    }

    @Contract(pure=true)
    private int getWindowId(@NotNull EntityPlayer entityPlayer) {
        return entityPlayer.activeContainer.windowId;
    }

    @NotNull
    @Contract(pure=true)
    private PlayerConnection getPlayerConnection(@NotNull EntityPlayer entityPlayer) {
        return entityPlayer.playerConnection;
    }

    @NotNull
    @Contract(pure=true)
    private EntityPlayer getEntityPlayer(@NotNull Player player) {
        return ((CraftPlayer)player).getHandle();
    }

    private class ContainerCartographyTableImpl
    extends ContainerCartography {
        @NotNull
        private final Player player;
        @Nullable
        private CraftInventoryView bukkitEntity;
        @NotNull
        private final Field resultInventoryField;

        public ContainerCartographyTableImpl(@Nullable EntityPlayer entityPlayer, ItemStack[] items) {
            super(entityPlayer.nextContainerCounter(), entityPlayer.inventory);
            this.player = entityPlayer.getBukkitEntity();
            try {
                this.resultInventoryField = ContainerCartography.class.getDeclaredField("resultInventory");
                this.resultInventoryField.setAccessible(true);
            }
            catch (NoSuchFieldException exception) {
                throw new RuntimeException(exception);
            }
            this.inventory.setItem(0, CraftItemStack.asNMSCopy((ItemStack)items[0]));
            this.inventory.setItem(1, CraftItemStack.asNMSCopy((ItemStack)items[1]));
            this.getResultInventory().setItem(0, CraftItemStack.asNMSCopy((ItemStack)items[2]));
        }

        @NotNull
        public CraftInventoryView getBukkitView() {
            if (this.bukkitEntity == null) {
                CraftInventoryCartography inventory = new CraftInventoryCartography(this.inventory, this.getResultInventory()){

                    @NotNull
                    @Contract(pure=true)
                    public InventoryHolder getHolder() {
                        return CartographyTableInventoryImpl.this.inventoryHolder;
                    }
                };
                this.bukkitEntity = new CraftInventoryView((HumanEntity)this.player, (Inventory)inventory, (Container)this);
            }
            return this.bukkitEntity;
        }

        @Contract(pure=true, value="_ -> true")
        public boolean canUse(@Nullable EntityHuman entityhuman) {
            return true;
        }

        public void a(IInventory inventory) {
        }

        public void b(EntityHuman entityhuman) {
        }

        @NotNull
        @Contract(pure=true)
        private IInventory getResultInventory() {
            try {
                return (IInventory)this.resultInventoryField.get((Object)this);
            }
            catch (IllegalAccessException exception) {
                throw new RuntimeException(exception);
            }
        }
    }
}

