/*
 * Decompiled with CFR 0.152.
 */
package com.github.stefvanschie.inventoryframework.gui.type;

import com.github.stefvanschie.inventoryframework.HumanEntityCache;
import com.github.stefvanschie.inventoryframework.adventuresupport.TextHolder;
import com.github.stefvanschie.inventoryframework.exception.XMLLoadException;
import com.github.stefvanschie.inventoryframework.gui.InventoryComponent;
import com.github.stefvanschie.inventoryframework.gui.type.util.InventoryBased;
import com.github.stefvanschie.inventoryframework.gui.type.util.NamedGui;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class HopperGui
extends NamedGui
implements InventoryBased {
    @NotNull
    private InventoryComponent slotsComponent = new InventoryComponent(5, 1);
    @NotNull
    private InventoryComponent playerInventoryComponent = new InventoryComponent(9, 4);

    public HopperGui(@NotNull String title) {
        super(title);
    }

    public HopperGui(@NotNull TextHolder title) {
        super(title);
    }

    @Override
    public void show(@NotNull HumanEntity humanEntity) {
        if (this.isDirty()) {
            this.inventory = this.createInventory();
            this.markChanges();
        }
        this.getInventory().clear();
        this.getSlotsComponent().display(this.getInventory(), 0);
        this.getPlayerInventoryComponent().display();
        if (this.getPlayerInventoryComponent().hasItem()) {
            HumanEntityCache humanEntityCache = this.getHumanEntityCache();
            if (!humanEntityCache.contains(humanEntity)) {
                humanEntityCache.storeAndClear(humanEntity);
            }
            this.getPlayerInventoryComponent().placeItems(humanEntity.getInventory(), 0);
        }
        humanEntity.openInventory(this.getInventory());
    }

    @Override
    @NotNull
    @Contract(pure=true)
    public HopperGui copy() {
        HopperGui gui = new HopperGui(this.getTitleHolder());
        gui.slotsComponent = this.slotsComponent.copy();
        gui.playerInventoryComponent = this.playerInventoryComponent.copy();
        gui.setOnTopClick(this.onTopClick);
        gui.setOnBottomClick(this.onBottomClick);
        gui.setOnGlobalClick(this.onGlobalClick);
        gui.setOnOutsideClick(this.onOutsideClick);
        gui.setOnClose(this.onClose);
        return gui;
    }

    @Override
    public void click(@NotNull InventoryClickEvent event) {
        int rawSlot = event.getRawSlot();
        if (rawSlot >= 0 && rawSlot <= 4) {
            this.getSlotsComponent().click(this, event, rawSlot);
        } else {
            this.getPlayerInventoryComponent().click(this, event, rawSlot - 5);
        }
    }

    @NotNull
    public Inventory getInventory() {
        if (this.inventory == null) {
            this.inventory = this.createInventory();
        }
        return this.inventory;
    }

    @Override
    @Contract(pure=true)
    public boolean isPlayerInventoryUsed() {
        return this.getPlayerInventoryComponent().hasItem();
    }

    @Override
    @NotNull
    @Contract(pure=true)
    public Inventory createInventory() {
        Inventory inventory = this.getTitleHolder().asInventoryTitle((InventoryHolder)this, InventoryType.HOPPER);
        this.addInventory(inventory, this);
        return inventory;
    }

    @Override
    @Contract(pure=true)
    public int getViewerCount() {
        return this.getInventory().getViewers().size();
    }

    @Override
    @NotNull
    @Contract(pure=true)
    public List<HumanEntity> getViewers() {
        return new ArrayList<HumanEntity>(this.getInventory().getViewers());
    }

    @NotNull
    @Contract(pure=true)
    public InventoryComponent getSlotsComponent() {
        return this.slotsComponent;
    }

    @NotNull
    @Contract(pure=true)
    public InventoryComponent getPlayerInventoryComponent() {
        return this.playerInventoryComponent;
    }

    @Nullable
    @Contract(pure=true)
    public static HopperGui load(@NotNull Object instance, @NotNull InputStream inputStream) {
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(inputStream);
            Element documentElement = document.getDocumentElement();
            documentElement.normalize();
            return HopperGui.load(instance, documentElement);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            e.printStackTrace();
            return null;
        }
    }

    @NotNull
    public static HopperGui load(@NotNull Object instance, @NotNull Element element) {
        if (!element.hasAttribute("title")) {
            throw new XMLLoadException("Provided XML element's gui tag doesn't have the mandatory title attribute set");
        }
        HopperGui hopperGui = new HopperGui(element.getAttribute("title"));
        hopperGui.initializeOrThrow(instance, element);
        if (element.hasAttribute("populate")) {
            return hopperGui;
        }
        NodeList childNodes = element.getChildNodes();
        for (int index = 0; index < childNodes.getLength(); ++index) {
            InventoryComponent component;
            Node item = childNodes.item(index);
            if (item.getNodeType() != 1) continue;
            Element componentElement = (Element)item;
            if (!componentElement.getTagName().equalsIgnoreCase("component")) {
                throw new XMLLoadException("Gui element contains non-component tags");
            }
            if (!componentElement.hasAttribute("name")) {
                throw new XMLLoadException("Component tag does not have a name specified");
            }
            switch (componentElement.getAttribute("name")) {
                case "slots": {
                    component = hopperGui.getSlotsComponent();
                    break;
                }
                case "player-inventory": {
                    component = hopperGui.getPlayerInventoryComponent();
                    break;
                }
                default: {
                    throw new XMLLoadException("Unknown component name");
                }
            }
            component.load(instance, componentElement);
        }
        return hopperGui;
    }
}

