/*
 * Decompiled with CFR 0.152.
 */
package com.github.stefvanschie.inventoryframework.gui;

import com.github.stefvanschie.inventoryframework.util.UUIDTagType;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.NamespacedKey;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GuiItem {
    public static final NamespacedKey KEY_UUID = new NamespacedKey((Plugin)JavaPlugin.getProvidingPlugin(GuiItem.class), "IF-uuid");
    @Nullable
    private Consumer<InventoryClickEvent> action;
    @NotNull
    private List<Object> properties;
    @NotNull
    private final ItemStack item;
    private boolean visible;
    @NotNull
    private UUID uuid = UUID.randomUUID();

    public GuiItem(@NotNull ItemStack item, @Nullable Consumer<InventoryClickEvent> action) {
        this.action = action;
        this.visible = true;
        this.properties = new ArrayList<Object>();
        this.item = item;
        this.applyUUID();
    }

    public GuiItem(@NotNull ItemStack item) {
        this(item, null);
    }

    @NotNull
    @Contract(pure=true)
    public GuiItem copy() {
        GuiItem guiItem = new GuiItem(this.item.clone(), this.action);
        guiItem.visible = this.visible;
        guiItem.uuid = this.uuid;
        guiItem.properties = new ArrayList<Object>(this.properties);
        ItemMeta meta = guiItem.item.getItemMeta();
        if (meta == null) {
            throw new IllegalArgumentException("item must be able to have ItemMeta (it mustn't be AIR)");
        }
        meta.getPersistentDataContainer().set(KEY_UUID, (PersistentDataType)UUIDTagType.INSTANCE, (Object)guiItem.uuid);
        guiItem.item.setItemMeta(meta);
        return guiItem;
    }

    public void callAction(@NotNull InventoryClickEvent event) {
        if (this.action == null) {
            return;
        }
        try {
            this.action.accept(event);
        }
        catch (Throwable t) {
            Logger logger = JavaPlugin.getProvidingPlugin(this.getClass()).getLogger();
            logger.log(Level.SEVERE, "Exception while handling click event in inventory '" + event.getView().getTitle() + "', slot=" + event.getSlot() + ", item=" + this.item.getType(), t);
        }
    }

    public void applyUUID() {
        ItemMeta meta = this.item.getItemMeta();
        if (meta != null) {
            meta.getPersistentDataContainer().set(KEY_UUID, (PersistentDataType)UUIDTagType.INSTANCE, (Object)this.uuid);
            this.item.setItemMeta(meta);
        }
    }

    public void setAction(@NotNull Consumer<InventoryClickEvent> action) {
        this.action = action;
    }

    @NotNull
    @Contract(pure=true)
    public List<Object> getProperties() {
        return this.properties;
    }

    public void setProperties(@NotNull List<Object> properties) {
        this.properties = properties;
    }

    @NotNull
    @Contract(pure=true)
    public ItemStack getItem() {
        return this.item;
    }

    @NotNull
    @Contract(pure=true)
    public UUID getUUID() {
        return this.uuid;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }
}

