/*
 * Decompiled with CFR 0.152.
 */
package stonehorse.candy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import stonehorse.candy.Lists;
import stonehorse.candy.Maybe;
import stonehorse.candy.NullableBooleans;
import stonehorse.candy.Trampoline;
import stonehorse.candy.Tuples;

public class Iterables {
    private Iterables() {
    }

    public static <A> List<A> forceList(Iterable<A> iterable) {
        ArrayList<A> list = new ArrayList<A>();
        if (Objects.isNull(iterable)) {
            return list;
        }
        for (A e : iterable) {
            list.add(e);
        }
        return list;
    }

    public static <A> List<A> list(Iterable<A> iterable) {
        if (Objects.isNull(iterable)) {
            return null;
        }
        if (iterable instanceof List) {
            return (List)iterable;
        }
        return Iterables.forceList(iterable);
    }

    public static <A> Set<A> forceSet(Iterable<A> iterable) {
        HashSet<A> set = new HashSet<A>();
        if (Objects.isNull(iterable)) {
            return set;
        }
        for (A e : iterable) {
            set.add(e);
        }
        return set;
    }

    public static <A> Set<A> set(Iterable<A> iterable) {
        if (Objects.isNull(iterable)) {
            return null;
        }
        if (iterable instanceof Set) {
            return (Set)iterable;
        }
        return Iterables.forceSet(iterable);
    }

    public static <A, V> A fold(BiFunction<? super A, ? super V, ? extends A> f, A accumulator, Iterable<? extends V> elements) {
        if (Objects.isNull(elements) || Objects.isNull(f)) {
            return accumulator;
        }
        for (V v : elements) {
            accumulator = f.apply(accumulator, v);
        }
        return accumulator;
    }

    public static <T> T reduce(BiFunction<? super T, ? super T, ? extends T> f, Iterable<? extends T> elements) {
        return Iterables.fold(f, Iterables.first(elements), Iterables.rest(elements));
    }

    public static <T> Iterable<T> filter(Predicate<? super T> f, Iterable<T> data) {
        if (Objects.isNull(data) || Objects.isNull(f)) {
            return null;
        }
        return () -> {
            Iterator i = data.iterator();
            if (i.hasNext()) {
                return Trampoline.lazy(Iterables.filterI(f, i)).iterator();
            }
            return Collections.emptyIterator();
        };
    }

    private static <T> Supplier<Trampoline.Continuation<T>> filterI(Predicate<? super T> f, Iterator<T> elements) {
        return () -> {
            if (!elements.hasNext()) {
                return Trampoline.stop();
            }
            Object t = elements.next();
            if (f.test((Object)t)) {
                return Trampoline.seq(Iterables.filterI(f, elements), t);
            }
            return Trampoline.recur(Iterables.filterI(f, elements));
        };
    }

    public static <A, V> Iterable<V> map(Function<? super A, V> f, Iterable<A> data) {
        if (Objects.isNull(data) || Objects.isNull(f)) {
            return null;
        }
        return () -> {
            Iterator i = data.iterator();
            if (!i.hasNext()) {
                return Collections.emptyIterator();
            }
            return Trampoline.lazy(Iterables.mapI(f, i)).iterator();
        };
    }

    private static <A, V> Supplier<Trampoline.Continuation<V>> mapI(Function<? super A, ? extends V> f, Iterator<A> elements) {
        return () -> {
            Object v = f.apply((Object)elements.next());
            if (elements.hasNext()) {
                return Trampoline.seq(Iterables.mapI(f, elements), v);
            }
            return Trampoline.done(v);
        };
    }

    public static <A, B, V> Iterable<V> map(BiFunction<? super A, ? super B, V> f, Iterable<? extends A> i1, Iterable<? extends B> i2) {
        if (Objects.isNull(i1) || Objects.isNull(i2) || Objects.isNull(f)) {
            return null;
        }
        return () -> Trampoline.lazy(Iterables.mapI(f, i1.iterator(), i2.iterator())).iterator();
    }

    private static <A, B, V> Supplier<Trampoline.Continuation<V>> mapI(BiFunction<? super A, ? super B, ? extends V> f, Iterator<? extends A> i1, Iterator<? extends B> i2) {
        return () -> {
            if (!i1.hasNext()) {
                return Trampoline.stop();
            }
            if (!i2.hasNext()) {
                return Trampoline.stop();
            }
            Object v = f.apply((Object)i1.next(), (Object)i2.next());
            if (i1.hasNext() && i2.hasNext()) {
                return Trampoline.seq(Iterables.mapI(f, i1, i2), v);
            }
            return Trampoline.done(v);
        };
    }

    public static <A, V> Iterable<V> reductions(BiFunction<? super V, ? super A, ? extends V> f, V accumulator, Iterable<? extends A> elements) {
        if (Objects.isNull(elements) || Objects.isNull(f)) {
            return null;
        }
        return () -> Trampoline.lazy(Iterables.reductionsI(f, accumulator, elements.iterator())).iterator();
    }

    private static <V, A> Supplier<Trampoline.Continuation<V>> reductionsI(BiFunction<? super V, ? super A, ? extends V> f, V a, Iterator<? extends A> elements) {
        return () -> {
            if (!elements.hasNext()) {
                return Trampoline.stop();
            }
            Object acc = f.apply((Object)a, (Object)elements.next());
            if (elements.hasNext()) {
                return Trampoline.seq(Iterables.reductionsI(f, acc, elements), acc);
            }
            return Trampoline.done(acc);
        };
    }

    public static <T> Iterable<T> drop(int num, Iterable<T> iterable) {
        if (iterable == null) {
            return null;
        }
        return () -> {
            if (num < 1) {
                return iterable.iterator();
            }
            return Trampoline.lazy(Iterables.dropI(num, iterable.iterator())).iterator();
        };
    }

    private static <T> Supplier<Trampoline.Continuation<T>> dropI(int num, Iterator<? extends T> i) {
        return () -> {
            if (0 < num) {
                if (i.hasNext()) {
                    i.next();
                    return Trampoline.recur(Iterables.dropI(num - 1, i));
                }
                return Trampoline.stop();
            }
            if (i.hasNext()) {
                Object v = i.next();
                return Trampoline.seq(Iterables.dropI(0, i), v);
            }
            return Trampoline.stop();
        };
    }

    public static <T> T first(Iterable<T> iterable) {
        if (Objects.isNull(iterable)) {
            return null;
        }
        Iterator<T> iterator = iterable.iterator();
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    public static <T> T second(Iterable<T> iterable) {
        if (Objects.isNull(iterable)) {
            return null;
        }
        return Iterables.first(Iterables.drop(1, iterable));
    }

    public static <T> T nth(int i, Iterable<T> iterable) {
        if (Objects.isNull(iterable)) {
            return null;
        }
        if (i < 0) {
            return null;
        }
        return Iterables.first(Iterables.drop(i, iterable));
    }

    public static <T> Iterable<T> take(int num, Iterable<T> iterable) {
        if (Objects.isNull(iterable)) {
            return null;
        }
        return () -> {
            if (num < 1) {
                return Collections.emptyIterator();
            }
            return Trampoline.lazy(Iterables.takeI(num, iterable.iterator())).iterator();
        };
    }

    private static <T> Supplier<Trampoline.Continuation<T>> takeI(int num, Iterator<? extends T> iterator) {
        return () -> {
            if (!iterator.hasNext()) {
                return Trampoline.stop();
            }
            if (num > 0) {
                return Trampoline.seq(Iterables.takeI(num - 1, iterator), iterator.next());
            }
            return Trampoline.stop();
        };
    }

    public static <T> Iterable<T> takeWhile(Predicate<? super T> pred, Iterable<T> iterable) {
        return () -> {
            if (Objects.isNull(iterable) || Objects.isNull(pred)) {
                return null;
            }
            return Trampoline.lazy(Iterables.takeWhileI(pred, iterable.iterator())).iterator();
        };
    }

    private static <T> Supplier<Trampoline.Continuation<T>> takeWhileI(Predicate<? super T> pred, Iterator<? extends T> iterator) {
        return () -> {
            if (!iterator.hasNext()) {
                return Trampoline.stop();
            }
            Object t = iterator.next();
            if (pred.test((Object)t)) {
                return Trampoline.seq(Iterables.takeWhileI(pred, iterator), t);
            }
            return Trampoline.stop();
        };
    }

    public static <T> T last(Iterable<T> i) {
        return Iterables.fold((a, v) -> v, null, i);
    }

    public static <T> Iterable<T> takeNth(int nth, Iterable<T> iterable) {
        if (Objects.isNull(iterable)) {
            return null;
        }
        return () -> Trampoline.lazy(Iterables.takeNthI(iterable.iterator(), nth, 0)).iterator();
    }

    private static <T> Supplier<Trampoline.Continuation<T>> takeNthI(Iterator<? extends T> iterator, int nth, int cnt) {
        return () -> {
            if (NullableBooleans.not(iterator.hasNext())) {
                return Trampoline.stop();
            }
            Object v = iterator.next();
            if (cnt == 0) {
                return Trampoline.seq(Iterables.takeNthI(iterator, nth, nth - 1), v);
            }
            return Trampoline.recur(Iterables.takeNthI(iterator, nth, cnt - 1));
        };
    }

    public static <V, A> Iterable<A> flatMap(Function<? super V, Iterable<A>> f, Iterable<? extends V> data) {
        if (Objects.isNull(data) || Objects.isNull(f)) {
            return null;
        }
        return Trampoline.lazy(Iterables.flatMapI(f, null, data.iterator()));
    }

    private static <V, A> Supplier<Trampoline.Continuation<A>> flatMapI(Function<? super V, Iterable<A>> f, Iterator<A> current, Iterator<? extends V> data) {
        return () -> {
            if (NullableBooleans.not(Objects.isNull(current)) && current.hasNext()) {
                Object a = current.next();
                return Trampoline.seq(Iterables.flatMapI(f, current, data), a);
            }
            if (data != null && data.hasNext()) {
                Iterable c = (Iterable)f.apply((Object)data.next());
                if (null != c) {
                    return Trampoline.recur(Iterables.flatMapI(f, c.iterator(), data));
                }
                return Trampoline.recur(Iterables.flatMapI(f, null, data));
            }
            return Trampoline.stop();
        };
    }

    public static <T> Iterable<T> next(Iterable<T> iterable) {
        if (iterable == null) {
            return null;
        }
        Iterator<T> it = iterable.iterator();
        if (it == null || !it.hasNext()) {
            return null;
        }
        it.next();
        if (!it.hasNext()) {
            return null;
        }
        return () -> {
            Iterator i = iterable.iterator();
            if (i == null || !i.hasNext()) {
                return null;
            }
            i.next();
            if (i.hasNext()) {
                return i;
            }
            return null;
        };
    }

    public static <T> Iterable<T> rest(Iterable<T> iterable) {
        if (iterable == null) {
            return Collections.emptyList();
        }
        return () -> {
            Iterator i = iterable.iterator();
            if (i == null || !i.hasNext()) {
                return Collections.emptyIterator();
            }
            i.next();
            if (i.hasNext()) {
                return i;
            }
            return Collections.emptyIterator();
        };
    }

    public static <T> Iterable<T> dropLast(int num, Iterable<T> iterable) {
        if (iterable == null) {
            return null;
        }
        return () -> {
            if (num < 1) {
                return iterable.iterator();
            }
            return Maybe.maybe(Iterables.map((a, b) -> a, iterable, Iterables.drop(num, iterable))).map(Iterable::iterator).orElse(null);
        };
    }

    public static <T> Iterable<T> dropWhile(Predicate<? super T> predicate, Iterable<T> iterable) {
        if (iterable == null || predicate == null) {
            return null;
        }
        return () -> Trampoline.lazy(Iterables.dropWhileI(predicate, true, iterable.iterator())).iterator();
    }

    private static <T> Supplier<Trampoline.Continuation<T>> dropWhileI(Predicate<? super T> predicate, boolean dropping, Iterator<T> i) {
        return () -> {
            if (i.hasNext()) {
                Object v = i.next();
                if (dropping && predicate.test((Object)v)) {
                    return Trampoline.recur(Iterables.dropWhileI(predicate, true, i));
                }
                return Trampoline.seq(Iterables.dropWhileI(predicate, false, i), v);
            }
            return Trampoline.stop();
        };
    }

    public static <T> Iterable<Iterable<T>> partition(int num, Iterable<T> iterable) {
        if (num < 1) {
            throw new IllegalArgumentException();
        }
        if (iterable == null) {
            return null;
        }
        return () -> {
            Iterator iterator = iterable.iterator();
            if (iterator == null) {
                return null;
            }
            return Trampoline.lazy(Iterables.partitionI(num, Lists.arrayList(), iterator)).iterator();
        };
    }

    private static <T> Supplier<Trampoline.Continuation<Iterable<T>>> partitionI(int num, List<T> acc, Iterator<T> iterator) {
        return () -> {
            if (iterator.hasNext()) {
                acc.add(iterator.next());
                if (acc.size() >= num) {
                    return Trampoline.seq(Iterables.partitionI(num, Lists.arrayList(), iterator), acc);
                }
                return Trampoline.recur(Iterables.partitionI(num, acc, iterator));
            }
            return Trampoline.stop();
        };
    }

    public static <T> Iterable<Iterable<T>> partitionBy(Function<? super T, Object> function, Iterable<T> iterable) {
        if (function == null) {
            return null;
        }
        if (iterable == null) {
            return null;
        }
        return () -> {
            Iterator iterator = iterable.iterator();
            if (iterator == null) {
                return null;
            }
            return Trampoline.lazy(Iterables.partitionByI(function, Tuples.of(null, null), iterator)).iterator();
        };
    }

    private static <T> Supplier<Trampoline.Continuation<Iterable<T>>> partitionByI(Function<? super T, Object> function, Tuples.T2<Object, List<T>> acc, Iterator<T> iterator) {
        return () -> {
            if (iterator.hasNext()) {
                Object v = iterator.next();
                Object o = function.apply((Object)v);
                if (Objects.equals(acc._1(), o)) {
                    if (acc._2() == null) {
                        return Trampoline.recur(Iterables.partitionByI(function, Tuples.of(o, Lists.arrayList(v)), iterator));
                    }
                    ((List)acc._2()).add(v);
                    return Trampoline.recur(Iterables.partitionByI(function, Tuples.of(o, acc._2()), iterator));
                }
                if (acc._2() == null) {
                    return Trampoline.recur(Iterables.partitionByI(function, Tuples.of(o, Lists.arrayList(v)), iterator));
                }
                return Trampoline.seq(Iterables.partitionByI(function, Tuples.of(o, Lists.arrayList(v)), iterator), acc._2());
            }
            if (acc._2() == null) {
                return Trampoline.stop();
            }
            return Trampoline.done(acc._2());
        };
    }

    public static <T> Iterable<Iterable<T>> splitAt(int i, Iterable<T> iterable) {
        if (iterable == null || i < 0) {
            return null;
        }
        return Lists.asList(Iterables.take(i, iterable), Iterables.drop(i, iterable));
    }

    public static <T> Iterable<Iterable<T>> splitWith(Predicate<T> p, Iterable<T> iterable) {
        if (iterable == null || p == null) {
            return null;
        }
        return Lists.asList(Iterables.takeWhile(p, iterable), Iterables.dropWhile(p, iterable));
    }

    public static <T> Iterable<T> concat(Iterable<T> a, Iterable<T> b) {
        if (null == a && null == b) {
            return null;
        }
        return () -> {
            if (a == null) {
                return b.iterator();
            }
            if (b == null) {
                return a.iterator();
            }
            return Trampoline.lazy(Iterables.concatI(a.iterator(), Lists.asList(b).iterator())).iterator();
        };
    }

    private static <T> Supplier<Trampoline.Continuation<T>> concatI(Iterator<? extends T> current, Iterator<? extends Iterable<? extends T>> following) {
        return () -> {
            if (current == null && following == null) {
                return Trampoline.stop();
            }
            if (null != current && current.hasNext()) {
                Object t = current.next();
                return Trampoline.seq(Iterables.concatI(current, following), t);
            }
            if (following.hasNext()) {
                Iterable iterable = (Iterable)following.next();
                if (iterable == null) {
                    return Trampoline.recur(Iterables.concatI(null, following));
                }
                return Trampoline.recur(Iterables.concatI(iterable.iterator(), following));
            }
            return Trampoline.stop();
        };
    }

    public static <T> Iterable<T> withLast(Iterable<T> iterable, T b) {
        if (iterable == null) {
            return null;
        }
        return () -> {
            Iterator i = iterable.iterator();
            if (i == null || NullableBooleans.not(i.hasNext())) {
                return Lists.asList(b).iterator();
            }
            return Trampoline.lazy(Iterables.withLastI(i, b)).iterator();
        };
    }

    private static <T> Supplier<Trampoline.Continuation<T>> withLastI(Iterator<T> a, T b) {
        return () -> {
            if (a.hasNext()) {
                Object n = a.next();
                return Trampoline.seq(Iterables.withLastI(a, b), n);
            }
            return Trampoline.done(b);
        };
    }

    public static <T> Iterable<T> with(T t, Iterable<? extends T> iterable) {
        return () -> {
            if (null == iterable) {
                return Lists.asList(t).iterator();
            }
            return Trampoline.lazy(Iterables.withI(t, iterable.iterator())).iterator();
        };
    }

    private static <T> Supplier<Trampoline.Continuation<T>> withI(T a, Iterator<? extends T> i) {
        return () -> {
            if (i.hasNext()) {
                return Trampoline.seq(Iterables.withI(i.next(), i), a);
            }
            return Trampoline.done(a);
        };
    }

    public static <T> Iterable<T> iterate(Function<? super T, ? extends T> function, T initial) {
        return () -> {
            if (Objects.isNull(function)) {
                return Lists.asList(initial).iterator();
            }
            return Iterables.with(initial, Trampoline.lazy(Iterables.iterateI(function, initial))).iterator();
        };
    }

    private static <T> Supplier<Trampoline.Continuation<T>> iterateI(Function<? super T, ? extends T> function, T val) {
        return () -> {
            Object n = function.apply((Object)val);
            return Trampoline.seq(Iterables.iterateI(function, n), n);
        };
    }

    public static <T> Stream<T> stream(Iterable<T> iterable) {
        return StreamSupport.stream(iterable.spliterator(), false);
    }

    public static <T> Iterable<T> iterable(Stream<T> stream) {
        return stream::iterator;
    }

    public static <T> Iterable<T> repeatedly(Supplier<T> supplier) {
        if (Objects.isNull(supplier)) {
            return null;
        }
        return () -> Trampoline.lazy(Iterables.repeatedlyI(supplier)).iterator();
    }

    private static <T> Supplier<Trampoline.Continuation<T>> repeatedlyI(Supplier<? extends T> supplier) {
        return () -> Trampoline.seq(Iterables.repeatedlyI(supplier), supplier.get());
    }

    public static <T> Iterable<T> repeat(T x) {
        return () -> Trampoline.lazy(Iterables.repeatI(x, null)).iterator();
    }

    public static <T> Iterable<T> repeat(int lim, T t) {
        if (lim < 1) {
            return Collections.emptyList();
        }
        return () -> Trampoline.lazy(Iterables.repeatI(t, lim)).iterator();
    }

    private static <T> Supplier<Trampoline.Continuation<T>> repeatI(T t, Integer lim) {
        return () -> {
            if (lim == null) {
                return Trampoline.seq(Iterables.repeatI(t, null), t);
            }
            if (lim > 0) {
                return Trampoline.seq(Iterables.repeatI(t, lim - 1), t);
            }
            if (lim == 0) {
                return Trampoline.done(t);
            }
            return Trampoline.stop();
        };
    }

    public static Iterable<Integer> range() {
        return () -> Trampoline.lazy(Iterables.rangeI(Integer.MAX_VALUE, 1, 0)).iterator();
    }

    public static Iterable<Integer> range(int n) {
        if (n < 0) {
            return Collections.emptyList();
        }
        return () -> Trampoline.lazy(Iterables.rangeI(n, 1, 0)).iterator();
    }

    public static Iterable<Integer> range(int from, int to) {
        if (from == to) {
            return Collections.emptyList();
        }
        return () -> {
            if (to < from) {
                return Trampoline.lazy(Iterables.rangeI(from, -1, to)).iterator();
            }
            return Trampoline.lazy(Iterables.rangeI(to, 1, from)).iterator();
        };
    }

    public static Iterable<Integer> range(int from, int to, int step) {
        return () -> Trampoline.lazy(Iterables.rangeI(to, step, from)).iterator();
    }

    private static Supplier<Trampoline.Continuation<Integer>> rangeI(int to, int step, int n) {
        return () -> {
            if (step > 0 && n >= to) {
                return Trampoline.stop();
            }
            if (step < 0 && n <= to) {
                return Trampoline.stop();
            }
            return Trampoline.seq(Iterables.rangeI(to, step, n + step), n);
        };
    }

    public static <T> Iterable<T> cycle(Iterable<T> in) {
        if (!Optional.ofNullable(in).map(Iterable::iterator).map(Iterator::hasNext).orElse(false).booleanValue()) {
            return Collections.emptyList();
        }
        return () -> Trampoline.lazy(Iterables.cycleI(in, in.iterator())).iterator();
    }

    private static <T> Supplier<Trampoline.Continuation<T>> cycleI(Iterable<T> in, Iterator<T> iterator) {
        return () -> {
            Iterator i = iterator;
            if (!i.hasNext()) {
                i = in.iterator();
            }
            Object t = i.next();
            return Trampoline.seq(Iterables.cycleI(in, i), t);
        };
    }
}

