/*
 * Decompiled with CFR 0.152.
 */
package com.statsig.androidsdk;

import android.content.SharedPreferences;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.statsig.androidsdk.APIDynamicConfig;
import com.statsig.androidsdk.APIFeatureGate;
import com.statsig.androidsdk.Cache;
import com.statsig.androidsdk.DeprecatedStickyUserExperiments;
import com.statsig.androidsdk.DynamicConfig;
import com.statsig.androidsdk.EvaluationDetails;
import com.statsig.androidsdk.EvaluationReason;
import com.statsig.androidsdk.FeatureGate;
import com.statsig.androidsdk.InitializeResponse;
import com.statsig.androidsdk.Layer;
import com.statsig.androidsdk.StatsigClient;
import com.statsig.androidsdk.StatsigOverrides;
import com.statsig.androidsdk.StatsigUser;
import com.statsig.androidsdk.StatsigUtil;
import com.statsig.androidsdk.StickyUserExperiments;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010$\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u001a\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\t2\b\u0010\u0019\u001a\u0004\u0018\u00010\u0014H\u0002J\b\u0010\u001a\u001a\u00020\u0016H\u0002J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\tJ\b\u0010\u001e\u001a\u00020\nH\u0002J\u0006\u0010\u001f\u001a\u00020\u0010J\u000e\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\tJ\u0012\u0010#\u001a\u0004\u0018\u00010\u00142\u0006\u0010$\u001a\u00020\tH\u0002J\u001c\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\n\b\u0002\u0010)\u001a\u0004\u0018\u00010\u0012H\u0002J\u0016\u0010*\u001a\u00020!2\u0006\u0010+\u001a\u00020\t2\u0006\u0010,\u001a\u00020(J\"\u0010-\u001a\u00020.2\b\u0010/\u001a\u0004\u0018\u0001002\u0006\u00101\u001a\u00020\t2\b\b\u0002\u0010,\u001a\u00020(J4\u00102\u001a\u0004\u0018\u00010\u00142\u0006\u00103\u001a\u00020\t2\b\u0010\u0019\u001a\u0004\u0018\u00010\u00142\u0006\u0010,\u001a\u00020(2\u0006\u00104\u001a\u00020&2\u0006\u00105\u001a\u00020(H\u0002J\u0012\u00106\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0018\u001a\u00020\tH\u0002J\"\u00107\u001a\u00020!2\u0006\u00103\u001a\u00020\t2\u0006\u00104\u001a\u00020&2\b\u00108\u001a\u0004\u0018\u00010\u0014H\u0002J\u000e\u00109\u001a\u00020\u00162\u0006\u0010\u0004\u001a\u00020\u0005J\b\u0010:\u001a\u00020\nH\u0002J\"\u0010;\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020\t2\u0012\u0010<\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00010=J\u0016\u0010>\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\t2\u0006\u0010<\u001a\u00020(J\"\u0010?\u001a\u00020\u00162\u0006\u00101\u001a\u00020\t2\u0012\u0010<\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00010=J\u0006\u0010@\u001a\u00020\u0016J\u000e\u0010A\u001a\u00020\u00162\u0006\u00103\u001a\u00020\tJ\u0010\u0010B\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\tH\u0002J\u0016\u0010C\u001a\u00020\u00162\u0006\u0010D\u001a\u00020E2\u0006\u0010F\u001a\u00020\tR\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00140\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006G"}, d2={"Lcom/statsig/androidsdk/Store;", "", "sharedPrefs", "Landroid/content/SharedPreferences;", "user", "Lcom/statsig/androidsdk/StatsigUser;", "(Landroid/content/SharedPreferences;Lcom/statsig/androidsdk/StatsigUser;)V", "cacheById", "", "", "Lcom/statsig/androidsdk/Cache;", "currentCache", "currentUserCacheKey", "gson", "Lcom/google/gson/Gson;", "localOverrides", "Lcom/statsig/androidsdk/StatsigOverrides;", "reason", "Lcom/statsig/androidsdk/EvaluationReason;", "stickyDeviceExperiments", "Lcom/statsig/androidsdk/APIDynamicConfig;", "attemptToMigrateDeprecatedStickyUserExperiments", "", "attemptToSaveStickyValue", "expName", "latestValue", "cacheStickyValues", "checkGate", "Lcom/statsig/androidsdk/FeatureGate;", "gateName", "createEmptyCache", "getAllOverrides", "getConfig", "Lcom/statsig/androidsdk/DynamicConfig;", "configName", "getConfigData", "hashedConfigName", "getEvaluationDetails", "Lcom/statsig/androidsdk/EvaluationDetails;", "valueExists", "", "reasonOverride", "getExperiment", "experimentName", "keepDeviceValue", "getLayer", "Lcom/statsig/androidsdk/Layer;", "client", "Lcom/statsig/androidsdk/StatsigClient;", "layerName", "getPossiblyStickyValue", "name", "details", "isLayer", "getStickyValue", "hydrateDynamicConfig", "config", "loadAndResetForUser", "loadCacheForCurrentUser", "overrideConfig", "value", "", "overrideGate", "overrideLayer", "removeAllOverrides", "removeOverride", "removeStickyValue", "save", "data", "Lcom/statsig/androidsdk/InitializeResponse;", "cacheKey", "build_release"})
public final class Store {
    @NotNull
    private final SharedPreferences sharedPrefs;
    @NotNull
    private final Gson gson;
    @NotNull
    private String currentUserCacheKey;
    @NotNull
    private Map<String, Cache> cacheById;
    @NotNull
    private Cache currentCache;
    @NotNull
    private Map<String, APIDynamicConfig> stickyDeviceExperiments;
    @NotNull
    private StatsigOverrides localOverrides;
    @NotNull
    private EvaluationReason reason;

    public Store(@NotNull SharedPreferences sharedPrefs, @NotNull StatsigUser user) {
        Intrinsics.checkNotNullParameter((Object)sharedPrefs, (String)"sharedPrefs");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        this.sharedPrefs = sharedPrefs;
        this.gson = new Gson();
        String cachedResponse = StatsigUtil.INSTANCE.getFromSharedPrefs$build_release(this.sharedPrefs, "Statsig.CACHE_BY_USER");
        String cachedDeviceValues = StatsigUtil.INSTANCE.getFromSharedPrefs$build_release(this.sharedPrefs, "Statsig.STICKY_DEVICE_EXPERIMENTS");
        String cachedLocalOverrides = StatsigUtil.INSTANCE.getFromSharedPrefs$build_release(this.sharedPrefs, "Statsig.LOCAL_OVERRIDES");
        boolean bl = false;
        this.cacheById = new LinkedHashMap();
        this.currentUserCacheKey = user.getCacheKey$build_release();
        if (cachedResponse != null) {
            Type type2 = new TypeToken<Map<String, Cache>>(){}.getType();
            try {
                Map<String, Cache> map = (Map<String, Cache>)this.gson.fromJson(cachedResponse, type2);
                this.cacheById = map == null ? this.cacheById : map;
            }
            catch (Exception _) {
                StatsigUtil.INSTANCE.removeFromSharedPrefs$build_release(this.sharedPrefs, "Statsig.CACHE_BY_USER");
            }
        }
        boolean type2 = false;
        this.stickyDeviceExperiments = new LinkedHashMap();
        if (cachedDeviceValues != null) {
            Type type3 = new TypeToken<Map<String, APIDynamicConfig>>(){}.getType();
            try {
                Map<String, APIDynamicConfig> _ = (Map<String, APIDynamicConfig>)this.gson.fromJson(cachedDeviceValues, type3);
                this.stickyDeviceExperiments = _ == null ? this.stickyDeviceExperiments : _;
            }
            catch (Exception _) {
                StatsigUtil.INSTANCE.removeFromSharedPrefs$build_release(this.sharedPrefs, "Statsig.STICKY_DEVICE_EXPERIMENTS");
            }
        }
        this.localOverrides = StatsigOverrides.Companion.empty();
        if (cachedLocalOverrides != null) {
            try {
                Object type3 = this.gson.fromJson(cachedLocalOverrides, StatsigOverrides.class);
                Intrinsics.checkNotNullExpressionValue((Object)type3, (String)"gson.fromJson(cachedLocalOverrides, StatsigOverrides::class.java)");
                this.localOverrides = (StatsigOverrides)type3;
            }
            catch (Exception _) {
                StatsigUtil.INSTANCE.removeFromSharedPrefs$build_release(this.sharedPrefs, "Statsig.LOCAL_OVERRIDES");
            }
        }
        this.reason = EvaluationReason.Uninitialized;
        this.currentCache = this.loadCacheForCurrentUser();
        this.attemptToMigrateDeprecatedStickyUserExperiments(user);
    }

    public final void loadAndResetForUser(@NotNull StatsigUser user) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        this.reason = EvaluationReason.Uninitialized;
        this.currentUserCacheKey = user.getCacheKey$build_release();
        this.currentCache = this.loadCacheForCurrentUser();
    }

    private final Cache loadCacheForCurrentUser() {
        Cache cache;
        Cache cachedValues = this.cacheById.get(this.currentUserCacheKey);
        if (cachedValues != null) {
            this.reason = EvaluationReason.Cache;
            cache = cachedValues;
        } else {
            cache = this.createEmptyCache();
        }
        return cache;
    }

    public final void save(@NotNull InitializeResponse data, @NotNull String cacheKey) {
        String cacheString;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)cacheKey, (String)"cacheKey");
        Object object = this.cacheById.get(cacheKey);
        Cache cache = object == null ? this.createEmptyCache() : object;
        cache.setValues(data);
        cache.setEvaluationTime(System.currentTimeMillis());
        object = this.cacheById;
        boolean bl = false;
        object.put(cacheKey, cache);
        if (Intrinsics.areEqual((Object)cacheKey, (Object)this.currentUserCacheKey)) {
            this.currentCache = cache;
            this.reason = EvaluationReason.Network;
        }
        if ((cacheString = this.gson.toJson(this.cacheById)).length() / 1024 > 1024 && this.cacheById.size() > 1) {
            bl = false;
            this.cacheById = new LinkedHashMap();
            Map<String, Cache> map = this.cacheById;
            String string = this.currentUserCacheKey;
            Cache cache2 = this.currentCache;
            boolean bl2 = false;
            map.put(string, cache2);
            cacheString = this.gson.toJson(this.cacheById);
        }
        String string = cacheString;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"cacheString");
        StatsigUtil.INSTANCE.saveStringToSharedPrefs$build_release(this.sharedPrefs, "Statsig.CACHE_BY_USER", string);
    }

    @NotNull
    public final FeatureGate checkGate(@NotNull String gateName) {
        APIFeatureGate aPIFeatureGate;
        Intrinsics.checkNotNullParameter((Object)gateName, (String)"gateName");
        Boolean overriddenValue = this.localOverrides.getGates().get(gateName);
        if (overriddenValue != null) {
            return new FeatureGate(gateName, this.getEvaluationDetails(false, EvaluationReason.LocalOverride), overriddenValue, "override", null, 16, null);
        }
        String hashName = StatsigUtil.INSTANCE.getHashedString(gateName);
        Map<String, APIFeatureGate> map = this.currentCache.getValues().getFeatureGates();
        APIFeatureGate aPIFeatureGate2 = aPIFeatureGate = map == null ? null : map.get(hashName);
        if (aPIFeatureGate == null) {
            return new FeatureGate(gateName, Store.getEvaluationDetails$default(this, false, null, 2, null), false, "", null, 16, null);
        }
        APIFeatureGate gate = aPIFeatureGate;
        return new FeatureGate(gate.getName(), Store.getEvaluationDetails$default(this, true, null, 2, null), gate.getValue(), gate.getRuleID(), gate.getSecondaryExposures());
    }

    @NotNull
    public final DynamicConfig getConfig(@NotNull String configName) {
        Intrinsics.checkNotNullParameter((Object)configName, (String)"configName");
        Map<String, Object> overrideValue = this.localOverrides.getConfigs().get(configName);
        if (overrideValue != null) {
            return new DynamicConfig(configName, overrideValue, "override", this.getEvaluationDetails(false, EvaluationReason.LocalOverride), null, false, false, false, null, 496, null);
        }
        String hashName = StatsigUtil.INSTANCE.getHashedString(configName);
        APIDynamicConfig data = this.getConfigData(hashName);
        return this.hydrateDynamicConfig(configName, Store.getEvaluationDetails$default(this, data != null, null, 2, null), data);
    }

    private final APIDynamicConfig getConfigData(String hashedConfigName) {
        InitializeResponse values = this.currentCache.getValues();
        if (values.getConfigs() == null || !values.getConfigs().containsKey(hashedConfigName)) {
            return null;
        }
        return values.getConfigs().get(hashedConfigName);
    }

    @NotNull
    public final DynamicConfig getExperiment(@NotNull String experimentName, boolean keepDeviceValue) {
        Intrinsics.checkNotNullParameter((Object)experimentName, (String)"experimentName");
        Map<String, Object> overrideValue = this.localOverrides.getConfigs().get(experimentName);
        if (overrideValue != null) {
            return new DynamicConfig(experimentName, overrideValue, "override", this.getEvaluationDetails(false, EvaluationReason.LocalOverride), null, false, false, false, null, 496, null);
        }
        String hashName = StatsigUtil.INSTANCE.getHashedString(experimentName);
        Map<String, APIDynamicConfig> map = this.currentCache.getValues().getConfigs();
        APIDynamicConfig latestValue = map == null ? null : map.get(hashName);
        EvaluationDetails details = Store.getEvaluationDetails$default(this, latestValue != null, null, 2, null);
        APIDynamicConfig finalValue = this.getPossiblyStickyValue(experimentName, latestValue, keepDeviceValue, details, false);
        return this.hydrateDynamicConfig(experimentName, details, finalValue);
    }

    @NotNull
    public final Layer getLayer(@Nullable StatsigClient client, @NotNull String layerName, boolean keepDeviceValue) {
        Object[] objectArray;
        String string;
        boolean bl;
        boolean bl2;
        boolean bl3;
        String string2;
        Map map;
        Object object;
        APIDynamicConfig finalValue;
        Intrinsics.checkNotNullParameter((Object)layerName, (String)"layerName");
        Map<String, Object> overrideValue = this.localOverrides.getLayers().get(layerName);
        if (overrideValue != null) {
            return new Layer(null, layerName, overrideValue, "override", this.getEvaluationDetails(false, EvaluationReason.LocalOverride), null, null, false, false, false, null, null, 4064, null);
        }
        String hashedLayerName = StatsigUtil.INSTANCE.getHashedString(layerName);
        Map<String, APIDynamicConfig> map2 = this.currentCache.getValues().getLayerConfigs();
        APIDynamicConfig latestValue = map2 == null ? null : map2.get(hashedLayerName);
        EvaluationDetails details = Store.getEvaluationDetails$default(this, latestValue != null, null, 2, null);
        APIDynamicConfig aPIDynamicConfig = finalValue = this.getPossiblyStickyValue(layerName, latestValue, keepDeviceValue, details, true);
        Object object2 = object = aPIDynamicConfig == null ? null : aPIDynamicConfig.getValue();
        if (object == null) {
            boolean bl4 = false;
            map = MapsKt.emptyMap();
        } else {
            map = object;
        }
        object = finalValue;
        String string3 = object == null ? "" : ((string2 = ((APIDynamicConfig)object).getRuleID()) == null ? "" : string2);
        APIDynamicConfig aPIDynamicConfig2 = finalValue;
        object = aPIDynamicConfig2 == null ? null : aPIDynamicConfig2.getSecondaryExposures();
        Object object3 = object == null ? new Map[]{} : object;
        aPIDynamicConfig2 = finalValue;
        object = aPIDynamicConfig2 == null ? null : aPIDynamicConfig2.getUndelegatedSecondaryExposures();
        Object object4 = object == null ? new Map[]{} : object;
        object = finalValue;
        boolean bl5 = object == null ? false : (bl3 = ((APIDynamicConfig)object).isUserInExperiment());
        object = finalValue;
        boolean bl6 = object == null ? false : (bl2 = ((APIDynamicConfig)object).isExperimentActive());
        object = finalValue;
        boolean bl7 = object == null ? false : (bl = ((APIDynamicConfig)object).isDeviceBased());
        object = finalValue;
        String string4 = object == null ? "" : ((string = ((APIDynamicConfig)object).getAllocatedExperimentName()) == null ? "" : string);
        object = finalValue;
        return new Layer(client, layerName, map, string3, details, (Map<String, String>[])object3, (Map<String, String>[])object4, bl5, bl6, bl7, string4, object == null ? null : ((objectArray = ((APIDynamicConfig)object).getExplicitParameters()) == null ? null : ArraysKt.toSet((Object[])objectArray)));
    }

    public static /* synthetic */ Layer getLayer$default(Store store, StatsigClient statsigClient, String string, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return store.getLayer(statsigClient, string, bl);
    }

    private final EvaluationDetails getEvaluationDetails(boolean valueExists, EvaluationReason reasonOverride) {
        EvaluationDetails evaluationDetails;
        if (valueExists) {
            Long l = this.currentCache.getEvaluationTime();
            long l2 = l == null ? System.currentTimeMillis() : l;
            evaluationDetails = new EvaluationDetails(this.reason, l2);
        } else {
            EvaluationReason evaluationReason = reasonOverride;
            EvaluationReason actualReason = evaluationReason == null ? (this.reason == EvaluationReason.Uninitialized ? EvaluationReason.Uninitialized : EvaluationReason.Unrecognized) : evaluationReason;
            evaluationDetails = new EvaluationDetails(actualReason, System.currentTimeMillis());
        }
        return evaluationDetails;
    }

    static /* synthetic */ EvaluationDetails getEvaluationDetails$default(Store store, boolean bl, EvaluationReason evaluationReason, int n, Object object) {
        if ((n & 2) != 0) {
            evaluationReason = null;
        }
        return store.getEvaluationDetails(bl, evaluationReason);
    }

    private final APIDynamicConfig getPossiblyStickyValue(String name, APIDynamicConfig latestValue, boolean keepDeviceValue, EvaluationDetails details, boolean isLayer) {
        Object object;
        if (!keepDeviceValue) {
            this.removeStickyValue(name);
            return latestValue;
        }
        APIDynamicConfig stickyValue = this.getStickyValue(name);
        if (stickyValue == null) {
            this.attemptToSaveStickyValue(name, latestValue);
            return latestValue;
        }
        APIDynamicConfig latestExperimentValue = null;
        if (isLayer) {
            object = stickyValue.getAllocatedExperimentName();
            if (object != null) {
                Object object2 = object;
                boolean bl = false;
                boolean bl2 = false;
                Object it = object2;
                boolean bl3 = false;
                Map<String, APIDynamicConfig> map = this.currentCache.getValues().getConfigs();
                latestExperimentValue = map == null ? null : map.get(it);
            }
        } else {
            latestExperimentValue = latestValue;
        }
        object = latestExperimentValue;
        if (Intrinsics.areEqual((Object)(object == null ? null : Boolean.valueOf(((APIDynamicConfig)object).isExperimentActive())), (Object)true)) {
            details.setReason(EvaluationReason.Sticky);
            return stickyValue;
        }
        object = latestValue;
        if (Intrinsics.areEqual((Object)(object == null ? null : Boolean.valueOf(((APIDynamicConfig)object).isExperimentActive())), (Object)true)) {
            this.attemptToSaveStickyValue(name, latestValue);
        } else {
            this.removeStickyValue(name);
        }
        return latestValue;
    }

    public final void overrideGate(@NotNull String gateName, boolean value) {
        Intrinsics.checkNotNullParameter((Object)gateName, (String)"gateName");
        Object object = this.localOverrides.getGates();
        Boolean bl = value;
        boolean bl2 = false;
        object.put((String)gateName, (Boolean)bl);
        object = this.gson.toJson((Object)this.localOverrides);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"gson.toJson(localOverrides)");
        StatsigUtil.INSTANCE.saveStringToSharedPrefs$build_release(this.sharedPrefs, "Statsig.LOCAL_OVERRIDES", (String)object);
    }

    public final void overrideConfig(@NotNull String configName, @NotNull Map<String, ? extends Object> value) {
        Intrinsics.checkNotNullParameter((Object)configName, (String)"configName");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        Object object = this.localOverrides.getConfigs();
        boolean bl = false;
        object.put((String)configName, value);
        object = this.gson.toJson((Object)this.localOverrides);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"gson.toJson(localOverrides)");
        StatsigUtil.INSTANCE.saveStringToSharedPrefs$build_release(this.sharedPrefs, "Statsig.LOCAL_OVERRIDES", (String)object);
    }

    public final void overrideLayer(@NotNull String layerName, @NotNull Map<String, ? extends Object> value) {
        Intrinsics.checkNotNullParameter((Object)layerName, (String)"layerName");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        Object object = this.localOverrides.getLayers();
        boolean bl = false;
        object.put((String)layerName, value);
        object = this.gson.toJson((Object)this.localOverrides);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"gson.toJson(localOverrides)");
        StatsigUtil.INSTANCE.saveStringToSharedPrefs$build_release(this.sharedPrefs, "Statsig.LOCAL_OVERRIDES", (String)object);
    }

    public final void removeOverride(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.localOverrides.getConfigs().remove(name);
        this.localOverrides.getGates().remove(name);
        this.localOverrides.getLayers().remove(name);
        String string = this.gson.toJson((Object)this.localOverrides);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"gson.toJson(localOverrides)");
        StatsigUtil.INSTANCE.saveStringToSharedPrefs$build_release(this.sharedPrefs, "Statsig.LOCAL_OVERRIDES", string);
    }

    public final void removeAllOverrides() {
        this.localOverrides = StatsigOverrides.Companion.empty();
        String string = this.gson.toJson((Object)this.localOverrides);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"gson.toJson(localOverrides)");
        StatsigUtil.INSTANCE.saveStringToSharedPrefs$build_release(this.sharedPrefs, "Statsig.LOCAL_OVERRIDES", string);
    }

    @NotNull
    public final StatsigOverrides getAllOverrides() {
        return new StatsigOverrides(this.localOverrides.getGates(), this.localOverrides.getConfigs(), this.localOverrides.getLayers());
    }

    private final DynamicConfig hydrateDynamicConfig(String name, EvaluationDetails details, APIDynamicConfig config) {
        String string;
        boolean bl;
        boolean bl2;
        boolean bl3;
        String string2;
        Map map;
        Object object;
        APIDynamicConfig aPIDynamicConfig = config;
        Object object2 = object = aPIDynamicConfig == null ? null : aPIDynamicConfig.getValue();
        if (object == null) {
            boolean bl4 = false;
            map = MapsKt.emptyMap();
        } else {
            map = object;
        }
        object = config;
        String string3 = object == null ? "" : ((string2 = ((APIDynamicConfig)object).getRuleID()) == null ? "" : string2);
        APIDynamicConfig aPIDynamicConfig2 = config;
        object = aPIDynamicConfig2 == null ? null : aPIDynamicConfig2.getSecondaryExposures();
        Object object3 = object == null ? new Map[]{} : object;
        object = config;
        boolean bl5 = object == null ? false : (bl3 = ((APIDynamicConfig)object).isUserInExperiment());
        object = config;
        boolean bl6 = object == null ? false : (bl2 = ((APIDynamicConfig)object).isExperimentActive());
        object = config;
        boolean bl7 = object == null ? false : (bl = ((APIDynamicConfig)object).isDeviceBased());
        object = config;
        return new DynamicConfig(name, map, string3, details, (Map<String, String>[])object3, bl5, bl6, bl7, object == null ? "" : ((string = ((APIDynamicConfig)object).getAllocatedExperimentName()) == null ? "" : string));
    }

    private final Cache createEmptyCache() {
        boolean bl = false;
        bl = false;
        bl = false;
        InitializeResponse emptyInitResponse = new InitializeResponse(MapsKt.emptyMap(), MapsKt.emptyMap(), MapsKt.emptyMap(), false, 0L);
        boolean bl2 = false;
        StickyUserExperiments emptyStickyUserExperiments = new StickyUserExperiments(new LinkedHashMap());
        return new Cache(emptyInitResponse, emptyStickyUserExperiments, System.currentTimeMillis());
    }

    private final void removeStickyValue(String expName) {
        String expNameHash = StatsigUtil.INSTANCE.getHashedString(expName);
        this.currentCache.getStickyUserExperiments().getExperiments().remove(expNameHash);
        this.stickyDeviceExperiments.remove(expNameHash);
        this.cacheStickyValues();
    }

    private final void attemptToSaveStickyValue(String expName, APIDynamicConfig latestValue) {
        if (latestValue == null) {
            return;
        }
        String expNameHash = StatsigUtil.INSTANCE.getHashedString(expName);
        if (latestValue.isExperimentActive() && latestValue.isUserInExperiment()) {
            if (latestValue.isDeviceBased()) {
                Map<String, APIDynamicConfig> map = this.stickyDeviceExperiments;
                boolean bl = false;
                map.put(expNameHash, latestValue);
            } else {
                Map<String, APIDynamicConfig> map = this.currentCache.getStickyUserExperiments().getExperiments();
                boolean bl = false;
                map.put(expNameHash, latestValue);
            }
            this.cacheStickyValues();
        }
    }

    private final APIDynamicConfig getStickyValue(String expName) {
        String hashName = StatsigUtil.INSTANCE.getHashedString(expName);
        APIDynamicConfig aPIDynamicConfig = this.currentCache.getStickyUserExperiments().getExperiments().get(hashName);
        return aPIDynamicConfig == null ? this.stickyDeviceExperiments.get(hashName) : aPIDynamicConfig;
    }

    private final void cacheStickyValues() {
        String string = this.gson.toJson(this.cacheById);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"gson.toJson(cacheById)");
        StatsigUtil.INSTANCE.saveStringToSharedPrefs$build_release(this.sharedPrefs, "Statsig.CACHE_BY_USER", string);
        string = this.gson.toJson(this.stickyDeviceExperiments);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"gson.toJson(stickyDeviceExperiments)");
        StatsigUtil.INSTANCE.saveStringToSharedPrefs$build_release(this.sharedPrefs, "Statsig.STICKY_DEVICE_EXPERIMENTS", string);
    }

    private final void attemptToMigrateDeprecatedStickyUserExperiments(StatsigUser user) {
        String string = StatsigUtil.INSTANCE.getFromSharedPrefs$build_release(this.sharedPrefs, "Statsig.STICKY_USER_EXPERIMENTS");
        if (string == null) {
            return;
        }
        String oldStickyUserExperimentValues = string;
        StatsigUtil.INSTANCE.removeFromSharedPrefs$build_release(this.sharedPrefs, "Statsig.STICKY_USER_EXPERIMENTS");
        try {
            Map<String, Object> map;
            DeprecatedStickyUserExperiments stickyUserExperiments;
            block7: {
                block6: {
                    stickyUserExperiments = (DeprecatedStickyUserExperiments)this.gson.fromJson(oldStickyUserExperimentValues, DeprecatedStickyUserExperiments.class);
                    if (!Intrinsics.areEqual((Object)stickyUserExperiments.getUserID(), (Object)user.getUserID())) break block6;
                    map = this.currentCache.getStickyUserExperiments().getExperiments();
                    boolean bl = false;
                    if (!(!map.isEmpty())) break block7;
                }
                return;
            }
            this.currentCache.setStickyUserExperiments(new StickyUserExperiments(stickyUserExperiments.getExperiments()));
            map = this.cacheById;
            String string2 = this.currentUserCacheKey;
            Cache cache = this.currentCache;
            boolean bl = false;
            map.put(string2, (APIDynamicConfig)((Object)cache));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

