/*
 * Decompiled with CFR 0.152.
 */
package com.statsig.androidsdk;

import android.content.SharedPreferences;
import com.google.gson.Gson;
import com.statsig.androidsdk.LogEvent;
import com.statsig.androidsdk.StatsigMetadata;
import com.statsig.androidsdk.StatsigNetwork;
import com.statsig.androidsdk.StatsigUser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.GlobalScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u000eJ\"\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00032\b\u0010\u0016\u001a\u0004\u0018\u00010\u00032\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018J(\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0016\u001a\u00020\u00032\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018J\u0006\u0010\u001d\u001a\u00020\u0011R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/statsig/androidsdk/StatsigLogger;", "", "sdkKey", "", "api", "statsigMetadata", "Lcom/statsig/androidsdk/StatsigMetadata;", "sharedPrefs", "Landroid/content/SharedPreferences;", "(Ljava/lang/String;Ljava/lang/String;Lcom/statsig/androidsdk/StatsigMetadata;Landroid/content/SharedPreferences;)V", "configExposures", "", "events", "", "Lcom/statsig/androidsdk/LogEvent;", "gateExposures", "flush", "", "log", "event", "logConfigExposure", "configName", "ruleID", "user", "Lcom/statsig/androidsdk/StatsigUser;", "logGateExposure", "gateName", "value", "", "onUpdateUser", "build_release"})
public final class StatsigLogger {
    @NotNull
    private final String sdkKey;
    @NotNull
    private final String api;
    @NotNull
    private final StatsigMetadata statsigMetadata;
    @Nullable
    private final SharedPreferences sharedPrefs;
    @NotNull
    private List<LogEvent> events;
    @NotNull
    private Set<String> gateExposures;
    @NotNull
    private Set<String> configExposures;

    public StatsigLogger(@NotNull String sdkKey, @NotNull String api, @NotNull StatsigMetadata statsigMetadata, @Nullable SharedPreferences sharedPrefs) {
        Intrinsics.checkNotNullParameter((Object)sdkKey, (String)"sdkKey");
        Intrinsics.checkNotNullParameter((Object)api, (String)"api");
        Intrinsics.checkNotNullParameter((Object)statsigMetadata, (String)"statsigMetadata");
        this.sdkKey = sdkKey;
        this.api = api;
        this.statsigMetadata = statsigMetadata;
        this.sharedPrefs = sharedPrefs;
        this.events = new ArrayList();
        this.gateExposures = new HashSet();
        this.configExposures = new HashSet();
    }

    public final void log(@NotNull LogEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.events.add(event);
        if (this.events.size() >= 500) {
            this.flush();
        }
        if (this.events.size() == 1) {
            StatsigLogger logger = this;
            BuildersKt.launch$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(logger, null){
                int label;
                final /* synthetic */ StatsigLogger $logger;
                {
                    this.$logger = $logger;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            this.label = 1;
                            v0 = DelayKt.delay((long)60000L, (Continuation)((Continuation)this));
                            if (v0 == var2_2) {
                                return var2_2;
                            }
                            ** GOTO lbl13
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl13:
                            // 2 sources

                            this.$logger.flush();
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
    }

    public final synchronized void flush() {
        if (this.events.size() == 0) {
            return;
        }
        List flushEvents = new ArrayList(this.events.size());
        flushEvents.addAll((Collection)this.events);
        this.events = new ArrayList();
        Object object = new Pair[]{TuplesKt.to((Object)"events", (Object)flushEvents), TuplesKt.to((Object)"statsigMetadata", (Object)this.statsigMetadata)};
        Map body = MapsKt.mapOf((Pair[])object);
        object = new Gson().toJson((Object)body);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"Gson().toJson(body)");
        StatsigNetwork.Companion.apiPostLogs(this.api, this.sdkKey, (String)object, this.sharedPrefs);
    }

    public final void onUpdateUser() {
        this.flush();
        this.configExposures = new HashSet();
        this.gateExposures = new HashSet();
    }

    public final void logGateExposure(@NotNull String gateName, boolean value, @NotNull String ruleID, @Nullable StatsigUser user) {
        Intrinsics.checkNotNullParameter((Object)gateName, (String)"gateName");
        Intrinsics.checkNotNullParameter((Object)ruleID, (String)"ruleID");
        if (this.gateExposures.contains(gateName)) {
            return;
        }
        this.gateExposures.add(gateName);
        LogEvent event = new LogEvent("statsig::gate_exposure");
        event.setUser(user);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"gate", (Object)gateName), TuplesKt.to((Object)"gateValue", (Object)String.valueOf(value)), TuplesKt.to((Object)"ruleID", (Object)ruleID)};
        event.setMetadata(MapsKt.mapOf((Pair[])pairArray));
        this.log(event);
    }

    public final void logConfigExposure(@NotNull String configName, @Nullable String ruleID, @Nullable StatsigUser user) {
        Intrinsics.checkNotNullParameter((Object)configName, (String)"configName");
        if (this.configExposures.contains(configName)) {
            return;
        }
        this.configExposures.add(configName);
        LogEvent event = new LogEvent("statsig::config_exposure");
        event.setUser(user);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"config", (Object)configName), TuplesKt.to((Object)"ruleID", (Object)ruleID)};
        event.setMetadata(MapsKt.mapOf((Pair[])pairArray));
        this.log(event);
    }
}

