/*
 * Decompiled with CFR 0.152.
 */
package com.statsig.androidsdk;

import android.util.Base64;
import com.statsig.androidsdk.HashAlgorithm;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import kotlin.Metadata;
import kotlin.UInt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002J\u0018\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\bJ\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a8\u0006\n"}, d2={"Lcom/statsig/androidsdk/Hashing;", "", "()V", "getDJB2HashString", "", "input", "getHashedString", "algorithm", "Lcom/statsig/androidsdk/HashAlgorithm;", "getSHA256HashString", "build_release"})
public final class Hashing {
    @NotNull
    public static final Hashing INSTANCE = new Hashing();

    private Hashing() {
    }

    @NotNull
    public final String getHashedString(@NotNull String input, @Nullable HashAlgorithm algorithm) {
        String string;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        HashAlgorithm hashAlgorithm = algorithm;
        int n = hashAlgorithm == null ? -1 : WhenMappings.$EnumSwitchMapping$0[hashAlgorithm.ordinal()];
        switch (n) {
            case 1: {
                string = this.getDJB2HashString(input);
                break;
            }
            case 2: {
                string = this.getSHA256HashString(input);
                break;
            }
            case 3: {
                string = input;
                break;
            }
            default: {
                string = this.getSHA256HashString(input);
            }
        }
        return string;
    }

    private final String getSHA256HashString(String input) {
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        String string = input;
        Object object = Charsets.UTF_8;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes((Charset)object);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] inputBytes = byArray;
        byte[] bytes = md.digest(inputBytes);
        object = Base64.encodeToString((byte[])bytes, (int)2);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"encodeToString(bytes, android.util.Base64.NO_WRAP)");
        return object;
    }

    private final String getDJB2HashString(String input) {
        int hash = 0;
        String string = input;
        int n = 0;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        char[] cArray = string2.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
        char[] cArray2 = cArray;
        int n2 = 0;
        n = cArray2.length;
        while (n2 < n) {
            char c = cArray2[n2];
            ++n2;
            char c2 = c;
            boolean bl = false;
            hash = (hash << 5) - hash + c2;
            hash &= hash;
        }
        int n3 = hash;
        n2 = 0;
        return Integer.toUnsignedString(UInt.constructor-impl((int)n3));
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[HashAlgorithm.values().length];
            nArray[HashAlgorithm.DJB2.ordinal()] = 1;
            nArray[HashAlgorithm.SHA256.ordinal()] = 2;
            nArray[HashAlgorithm.NONE.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

