/*
 * Decompiled with CFR 0.152.
 */
package com.github.starnowski.posmulten.postgresql.test.utils;

import java.sql.ResultSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.jdbc.core.JdbcTemplate;

public class TestUtils {
    public static final String CLEAR_DATABASE_SCRIPT_PATH = "/com/github/starnowski/posmulten/postgresql/core/clean-database.sql";
    public static String VALID_CURRENT_TENANT_ID_PROPERTY_NAME = "c.c_ten";

    public static boolean isAnyRecordExists(JdbcTemplate jdbcTemplate, String sql) {
        return (Boolean)jdbcTemplate.execute(statement -> statement.executeQuery(sql).isBeforeFirst());
    }

    public static String selectAndReturnFirstRecordAsString(JdbcTemplate jdbcTemplate, String sql) {
        return (String)jdbcTemplate.execute(statement -> {
            StringBuilder sb = new StringBuilder();
            sb.append(sql);
            ResultSet rs = statement.executeQuery(sb.toString());
            rs.next();
            return rs.getString(1);
        });
    }

    public static Boolean selectAndReturnFirstRecordAsBoolean(JdbcTemplate jdbcTemplate, String sql) {
        return (Boolean)jdbcTemplate.execute(statement -> {
            StringBuilder sb = new StringBuilder();
            sb.append(sql);
            ResultSet rs = statement.executeQuery(sb.toString());
            rs.next();
            return rs.getBoolean(1);
        });
    }

    public static boolean isFunctionExists(JdbcTemplate jdbcTemplate, String functionName, String schema) {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT 1 FROM pg_proc pg, pg_catalog.pg_namespace pgn WHERE ");
        sb.append("pg.proname = '");
        sb.append(functionName);
        sb.append("' AND ");
        if (schema == null) {
            sb.append("pgn.nspname = 'public'");
        } else {
            sb.append("pgn.nspname = '");
            sb.append(schema);
            sb.append("'");
        }
        sb.append(" AND ");
        sb.append("pg.pronamespace =  pgn.oid");
        return TestUtils.isAnyRecordExists(jdbcTemplate, sb.toString());
    }

    public static boolean selectAndReturnFirstRecordAsBooleanWithSettingCurrentTenantId(JdbcTemplate jdbcTemplate, String selectStatement, String setCurrentTenantIdStatement) {
        return (Boolean)jdbcTemplate.execute(statement -> {
            statement.execute(setCurrentTenantIdStatement);
            ResultSet rs = statement.executeQuery(selectStatement);
            rs.next();
            return rs.getBoolean(1);
        });
    }

    public static Long selectAndReturnFirstRecordAsLongWithSettingCurrentTenantId(JdbcTemplate jdbcTemplate, String selectStatement, String setCurrentTenantIdStatement) {
        return (Long)jdbcTemplate.execute(statement -> {
            statement.execute(setCurrentTenantIdStatement);
            ResultSet rs = statement.executeQuery(selectStatement);
            rs.next();
            return rs.getLong(1);
        });
    }

    public static Map<String, Long> selectAndReturnMapOfStatementsAndItResultsForListOfSelectStatements(JdbcTemplate jdbcTemplate, List<String> selectStatements) {
        return selectStatements.stream().map(selectStatement -> {
            Long result = (Long)jdbcTemplate.execute(statement -> {
                ResultSet rs = statement.executeQuery((String)selectStatement);
                rs.next();
                return rs.getLong(1);
            });
            return new StatementAndItLongResult((String)selectStatement, result);
        }).collect(Collectors.toMap(sr -> ((StatementAndItLongResult)sr).statement, sr -> ((StatementAndItLongResult)sr).result));
    }

    public static void dropFunction(JdbcTemplate jdbcTemplate, String functionName, String schema, String ... argumentsTypes) {
        String functionReference = TestUtils.returnFunctionReference(functionName, schema);
        String argumentsTypesPhrase = argumentsTypes == null ? "" : String.join((CharSequence)",", argumentsTypes);
        jdbcTemplate.execute("DROP FUNCTION IF EXISTS " + functionReference + "(" + argumentsTypesPhrase + ")");
    }

    public static String returnFunctionReference(String functionName, String schema) {
        return schema == null ? functionName : schema + "." + functionName;
    }

    public static boolean isConstraintExists(JdbcTemplate jdbcTemplate, String schema, String table, String constraintName) {
        String template = "SELECT 1\n\t\tFROM information_schema.table_constraints\n\t\tWHERE table_schema = '%s' AND table_name = '%s' AND constraint_name = '%s'";
        String selectStatement = String.format(template, schema == null ? "public" : schema, table, constraintName);
        return TestUtils.isAnyRecordExists(jdbcTemplate, selectStatement);
    }

    private static class StatementAndItLongResult {
        private final String statement;
        private final Long result;

        public StatementAndItLongResult(String statement, Long result) {
            this.statement = statement;
            this.result = result;
        }
    }
}

