/*
 * Decompiled with CFR 0.152.
 */
package com.example.utils.extensions;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import androidx.core.content.ContextCompat;
import com.example.agreement.R;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000\"\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u0001\u001a\u0012\u0010\n\u001a\u00020\u0005*\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006\r"}, d2={"convertDpToPixels", "", "dp", "", "createBitmapFromView", "Landroid/graphics/Bitmap;", "view", "Landroid/view/View;", "width", "height", "getBitmapFromView", "context", "Landroid/content/Context;", "agreement_release"})
public final class ViewExtensionsKt {
    @NotNull
    public static final Bitmap getBitmapFromView(@NotNull View $this$getBitmapFromView, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)$this$getBitmapFromView, (String)"$this$getBitmapFromView");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Bitmap returnedBitmap = Bitmap.createBitmap((int)$this$getBitmapFromView.getWidth(), (int)$this$getBitmapFromView.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(returnedBitmap);
        Drawable bgDrawable = $this$getBitmapFromView.getBackground();
        if (bgDrawable != null) {
            bgDrawable.draw(canvas);
        } else {
            canvas.drawColor(ContextCompat.getColor((Context)context, (int)R.color.white));
        }
        $this$getBitmapFromView.draw(canvas);
        Bitmap bitmap = returnedBitmap;
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"returnedBitmap");
        return bitmap;
    }

    @NotNull
    public static final Bitmap createBitmapFromView(@NotNull View view, int width, int height) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        if (width > 0 && height > 0) {
            view.measure(View.MeasureSpec.makeMeasureSpec((int)ViewExtensionsKt.convertDpToPixels(width), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)ViewExtensionsKt.convertDpToPixels(height), (int)0x40000000));
        }
        view.layout(0, 0, view.getMeasuredWidth(), view.getMeasuredHeight());
        Bitmap bitmap = Bitmap.createBitmap((int)view.getMeasuredWidth(), (int)view.getMeasuredHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        Drawable drawable = view.getBackground();
        if (drawable != null) {
            drawable.draw(canvas);
        }
        view.draw(canvas);
        Bitmap bitmap2 = bitmap;
        Intrinsics.checkNotNullExpressionValue((Object)bitmap2, (String)"bitmap");
        return bitmap2;
    }

    public static final int convertDpToPixels(float dp) {
        Resources resources = Resources.getSystem();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"Resources.getSystem()");
        return MathKt.roundToInt((float)TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)resources.getDisplayMetrics()));
    }
}

