/*
 * Decompiled with CFR 0.152.
 */
package com.example.utils;

import android.content.Context;
import android.os.Environment;
import android.util.Log;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\f\u001a\u0004\u0018\u00010\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0004J\u000e\u0010\u0010\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eJ\u0012\u0010\u0011\u001a\u0004\u0018\u00010\n2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/example/utils/ImageViewFileUtil;", "", "()V", "JPG_FILE_PREFIX", "", "JPG_FILE_SUFFIX", "LOG_TAG", "createDirectory", "", "directory", "Ljava/io/File;", "directoryDoesNotExists", "getAppSpecificAlbumStorageDir", "context", "Landroid/content/Context;", "albumName", "getPrivateTempDirectory", "getPublicAlbumDirectoryAtPictures", "agreement_release"})
public final class ImageViewFileUtil {
    private static final String LOG_TAG = "NOT_CREATED";
    @NotNull
    public static final String JPG_FILE_SUFFIX = ".jpg";
    @NotNull
    public static final String JPG_FILE_PREFIX = "IMG-";
    public static final ImageViewFileUtil INSTANCE;

    @NotNull
    public final File getPrivateTempDirectory(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        File file = context.getFilesDir();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"context.filesDir");
        return file;
    }

    @Nullable
    public final File getAppSpecificAlbumStorageDir(@NotNull Context context, @NotNull String albumName) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)albumName, (String)"albumName");
        File file = new File(context.getExternalFilesDir(Environment.DIRECTORY_PICTURES), albumName);
        if (!file.mkdirs()) {
            Log.e((String)LOG_TAG, (String)"Directory not created");
        }
        return file;
    }

    @Nullable
    public final File getPublicAlbumDirectoryAtPictures(@Nullable String albumName) {
        File directory = new File(Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_PICTURES), albumName);
        if (this.directoryDoesNotExists(directory) && !INSTANCE.createDirectory(directory)) {
            Log.d((String)"a", (String)"Directory not created");
            return null;
        }
        return directory;
    }

    private final boolean directoryDoesNotExists(File directory) {
        return !directory.exists();
    }

    private final boolean createDirectory(File directory) {
        return directory.mkdirs();
    }

    private ImageViewFileUtil() {
    }

    static {
        ImageViewFileUtil imageViewFileUtil;
        INSTANCE = imageViewFileUtil = new ImageViewFileUtil();
    }
}

