/*
 * Decompiled with CFR 0.152.
 */
package net.iryndin.jdbf.reader;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import net.iryndin.jdbf.core.DbfMetadata;
import net.iryndin.jdbf.core.DbfRecord;
import net.iryndin.jdbf.reader.MemoReader;
import net.iryndin.jdbf.util.DbfMetadataUtils;
import net.iryndin.jdbf.util.IOUtils;

public class DbfReader
implements Closeable {
    private static final int HEADER_HALF_SIZE = 16;
    private InputStream dbfInputStream;
    private MemoReader memoReader;
    private DbfMetadata metadata;
    private byte[] oneRecordBuffer;
    private int recordsCounter = 0;
    private static final int BUFFER_SIZE = 8192;

    public DbfReader(File dbfFile) throws IOException {
        this(new FileInputStream(dbfFile));
    }

    public DbfReader(File dbfFile, File memoFile) throws IOException {
        this(new FileInputStream(dbfFile), new FileInputStream(memoFile));
    }

    public DbfReader(InputStream dbfInputStream) throws IOException {
        this.dbfInputStream = new BufferedInputStream(dbfInputStream, 8192);
        this.readMetadata();
    }

    public DbfReader(InputStream dbfInputStream, InputStream memoInputStream) throws IOException {
        this.dbfInputStream = new BufferedInputStream(dbfInputStream, 8192);
        this.memoReader = new MemoReader(memoInputStream);
        this.readMetadata();
    }

    public DbfMetadata getMetadata() {
        return this.metadata;
    }

    private void readMetadata() throws IOException {
        this.dbfInputStream.mark(0x100000);
        this.metadata = new DbfMetadata();
        this.readHeader();
        DbfMetadataUtils.readFields(this.metadata, this.dbfInputStream);
        this.oneRecordBuffer = new byte[this.metadata.getOneRecordLength()];
        this.findFirstRecord();
    }

    private void readHeader() throws IOException {
        byte[] bytes = new byte[16];
        if (IOUtils.readFully(this.dbfInputStream, bytes) != 16) {
            throw new IOException("The file is corrupted or is not a dbf file");
        }
        DbfMetadataUtils.fillHeaderFields(this.metadata, bytes);
        if (IOUtils.readFully(this.dbfInputStream, bytes) != 16) {
            throw new IOException("The file is corrupted or is not a dbf file");
        }
    }

    @Override
    public void close() throws IOException {
        if (this.memoReader != null) {
            this.memoReader.close();
            this.memoReader = null;
        }
        if (this.dbfInputStream != null) {
            this.dbfInputStream.close();
            this.dbfInputStream = null;
        }
        this.metadata = null;
        this.recordsCounter = 0;
    }

    public void findFirstRecord() throws IOException {
        this.seek(this.dbfInputStream, this.metadata.getFullHeaderLength());
    }

    private void seek(InputStream inputStream, int position) throws IOException {
        inputStream.reset();
        inputStream.skip(position);
    }

    public DbfRecord read() throws IOException {
        Arrays.fill(this.oneRecordBuffer, (byte)0);
        int readLength = IOUtils.readFully(this.dbfInputStream, this.oneRecordBuffer);
        if (readLength < this.metadata.getOneRecordLength()) {
            return null;
        }
        return this.createDbfRecord();
    }

    private DbfRecord createDbfRecord() {
        return new DbfRecord(this.oneRecordBuffer, this.metadata, this.memoReader, ++this.recordsCounter);
    }
}

