/*
 * Decompiled with CFR 0.152.
 */
package com.github.spullara.mustache.mojo;

import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.MustacheException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.util.Collections;
import java.util.Set;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.compiler.util.scan.InclusionScanException;
import org.codehaus.plexus.compiler.util.scan.SimpleSourceInclusionScanner;
import org.codehaus.plexus.compiler.util.scan.StaleSourceScanner;
import org.codehaus.plexus.compiler.util.scan.mapping.SourceMapping;
import org.codehaus.plexus.compiler.util.scan.mapping.SuffixMapping;

@Mojo(name="validate", defaultPhase=LifecyclePhase.PROCESS_RESOURCES)
public class MustacheValidationMojo
extends AbstractMojo {
    @Parameter(defaultValue="src/main/resources")
    private File sourceDirectory;
    @Parameter(defaultValue="target/classes")
    private File outputDirectory;
    @Parameter(defaultValue="mustache")
    private String extension;
    @Parameter(defaultValue="false")
    private boolean includeStale;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        StaleSourceScanner scanner = this.includeStale ? new StaleSourceScanner(1024L, Collections.singleton("**/*." + this.extension), Collections.emptySet()) : new SimpleSourceInclusionScanner(Collections.singleton("**/*." + this.extension), Collections.emptySet());
        scanner.addSourceMapping((SourceMapping)new SuffixMapping("." + this.extension, "." + this.extension));
        DefaultMustacheFactory mustacheFactory = new DefaultMustacheFactory();
        try {
            Set files = scanner.getIncludedSources(this.sourceDirectory, this.outputDirectory);
            for (File file : files) {
                try {
                    mustacheFactory.compile((Reader)new FileReader(file), file.getAbsolutePath());
                }
                catch (MustacheException e) {
                    throw new MojoFailureException(e.getMessage(), (Throwable)e);
                    return;
                }
            }
        }
        catch (FileNotFoundException | InclusionScanException e) {
            throw new MojoExecutionException(e.getMessage());
        }
    }
}

