/*
 * Decompiled with CFR 0.152.
 */
package com.github.mustachejava.reflect;

import com.github.mustachejava.reflect.Guard;
import com.github.mustachejava.util.GuardException;
import com.github.mustachejava.util.Wrapper;
import java.util.Arrays;

public class GuardedWrapper
implements Wrapper {
    protected static final GuardException guardException = new GuardException();
    private static boolean compile = Boolean.getBoolean("mustache.compile");
    protected final Guard[] guards;
    private int hashCode;

    public GuardedWrapper(Guard[] guards) {
        this.guards = guards;
    }

    @Override
    public Object call(Object[] scopes) throws GuardException {
        this.guardCall(scopes);
        return null;
    }

    protected void guardCall(Object[] scopes) throws GuardException {
        for (Guard predicate : this.guards) {
            if (predicate.apply(scopes)) continue;
            throw guardException;
        }
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            for (Guard predicate : this.guards) {
                this.hashCode += this.hashCode * 43 + predicate.hashCode();
            }
            if (this.hashCode == 0) {
                this.hashCode = 1;
            }
        }
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (o instanceof GuardedWrapper) {
            GuardedWrapper other = (GuardedWrapper)o;
            return this.guards == null && other.guards == null || Arrays.equals(other.guards, this.guards);
        }
        return false;
    }

    public Guard[] getGuards() {
        return this.guards;
    }

    static {
        guardException.setStackTrace(new StackTraceElement[0]);
    }
}

