/*
 * Decompiled with CFR 0.152.
 */
package com.github.mustachejava.util;

import com.github.mustachejava.util.RingBuffer;
import com.github.mustachejava.util.State;
import java.util.logging.Logger;

public class HtmlState
implements State<HTML> {
    private static Logger l = Logger.getLogger("HTMLAwareWriter");
    private HTML state;
    private HTML quoteState;
    private HTML bodyState;
    private final RingBuffer ringBuffer = new RingBuffer(6);

    @Override
    public HTML getState() {
        return this.state;
    }

    public HtmlState() {
        this(HTML.BODY);
    }

    public HtmlState(HTML state) {
        this.state = state;
    }

    @Override
    public void nextState(char[] cbuf, int off, int len) {
        int end = off + len;
        for (int i = off; i < end; ++i) {
            char c = cbuf[i];
            switch (this.state) {
                case ATTRIBUTES: {
                    this.attr(c);
                    break;
                }
                case BODY: {
                    this.body(c);
                    break;
                }
                case TAG: {
                    this.tag(c);
                    break;
                }
                case ATTR_NAME: {
                    this.attrName(c);
                    break;
                }
                case ATTR_EQUAL: {
                    this.attrEqual(c);
                    break;
                }
                case DQ_VALUE: {
                    this.dqValue(c);
                    break;
                }
                case SCRIPT_DQ_VALUE: {
                    this.scriptDqValue(c);
                    break;
                }
                case TAG_NAME: {
                    this.tagName(c);
                    break;
                }
                case END_TAG: {
                    this.endTag(c);
                    break;
                }
                case END_TAG_NAME: {
                    this.endTagName(c);
                    break;
                }
                case ESCAPE: {
                    this.escape();
                    break;
                }
                case SCRIPT: {
                    this.script(c);
                    break;
                }
                case SCRIPT_SQ_VALUE: {
                    this.scriptSqValue(c);
                    break;
                }
                case SCRIPT_CHECK: {
                    this.scriptCheck(c);
                    break;
                }
                case AFTER_END_TAG_NAME: {
                    this.afterEndTagName(c);
                    break;
                }
                case SQ_VALUE: {
                    this.sqValue(c);
                    break;
                }
                case NQ_VALUE: {
                    this.nqValue(c);
                    break;
                }
                case PRAGMA: {
                    this.pragma(c);
                    break;
                }
                case COMMENT: {
                    this.comment(c);
                }
            }
            if (this.state != HTML.TAG_NAME && this.state != HTML.PRAGMA && this.state != HTML.COMMENT) continue;
            this.ringBuffer.append(c);
        }
    }

    private void scriptCheck(char c) {
        if (c == '/') {
            this.bodyState = HTML.BODY;
            this.state = HTML.END_TAG;
        } else if (!this.ws(c)) {
            this.state = HTML.SCRIPT;
        }
    }

    private void pragma(char c) {
        if (c == '-') {
            if (this.ringBuffer.compare("!-", false)) {
                this.state = HTML.COMMENT;
                this.ringBuffer.clear();
            }
        } else if (c == '>') {
            this.state = this.bodyState;
        }
    }

    private void scriptSqValue(char c) {
        if (c == '\\') {
            this.quoteState = this.state;
            this.state = HTML.ESCAPE;
        } else if (c == '\'') {
            this.state = HTML.SCRIPT;
        }
    }

    private void scriptDqValue(char c) {
        if (c == '\\') {
            this.quoteState = this.state;
            this.state = HTML.ESCAPE;
        } else if (c == '\"') {
            this.state = HTML.SCRIPT;
        }
    }

    private void script(char c) {
        if (c == '\"') {
            this.state = HTML.SCRIPT_DQ_VALUE;
        } else if (c == '\'') {
            this.state = HTML.SCRIPT_SQ_VALUE;
        } else if (c == '<') {
            this.state = HTML.SCRIPT_CHECK;
        }
    }

    private void afterEndTagName(char c) {
        if (!this.ws(c)) {
            if (c == '>') {
                this.state = this.bodyState;
            } else {
                this.error(c);
            }
        }
    }

    private void endTagName(char c) {
        if (!this.namePart(c)) {
            if (c == '>') {
                this.state = this.bodyState;
            } else if (this.ws(c)) {
                this.state = HTML.AFTER_END_TAG_NAME;
            } else {
                this.error(c);
            }
        }
    }

    private void endTag(char c) {
        if (this.nameStart(c)) {
            this.state = HTML.END_TAG_NAME;
        } else if (!Character.isWhitespace(c)) {
            if (c == '>') {
                this.state = this.bodyState;
            } else {
                this.error(c);
            }
        }
    }

    private boolean nameStart(char c) {
        return Character.isJavaIdentifierStart(c);
    }

    private void comment(char c) {
        if (c == '>' && this.ringBuffer.compare("--", false)) {
            this.state = this.bodyState;
        }
    }

    private void nqValue(char c) {
        if (this.ws(c)) {
            this.state = HTML.ATTRIBUTES;
        } else if (c == '<') {
            this.error(c);
        } else if (c == '>') {
            this.state = this.bodyState;
        }
    }

    private void escape() {
        this.state = this.quoteState;
    }

    private void sqValue(char c) {
        if (c == '\\') {
            this.state = HTML.ESCAPE;
            this.quoteState = HTML.SQ_VALUE;
        } else if (c == '\'') {
            this.state = HTML.ATTRIBUTES;
        } else if (c == '<' || c == '>') {
            this.error(c);
        }
    }

    private void dqValue(char c) {
        if (c == '\\') {
            this.state = HTML.ESCAPE;
            this.quoteState = HTML.DQ_VALUE;
        } else if (c == '\"') {
            this.state = HTML.ATTRIBUTES;
        } else if (c == '<' || c == '>') {
            this.error(c);
        }
    }

    private void attrEqual(char c) {
        if (c == '\"') {
            this.state = HTML.DQ_VALUE;
        } else if (c == '\'') {
            this.state = HTML.SQ_VALUE;
        } else if (!this.ws(c)) {
            this.state = HTML.NQ_VALUE;
        }
    }

    private boolean ws(char c) {
        return Character.isWhitespace(c);
    }

    private void attrName(char c) {
        if (!this.namePart(c)) {
            if (c == '=') {
                this.state = HTML.ATTR_EQUAL;
            } else if (!this.ws(c)) {
                if (c == '>') {
                    this.state = this.bodyState;
                } else {
                    this.error(c);
                }
            }
        }
    }

    private void attr(char c) {
        if (this.nameStart(c)) {
            this.state = HTML.ATTR_NAME;
        } else if (c == '>') {
            this.state = this.bodyState;
        } else if (c == '/') {
            this.state = HTML.AFTER_END_TAG_NAME;
        } else if (!this.ws(c)) {
            this.error(c);
        }
    }

    private void tagName(char c) {
        if (!this.namePart(c)) {
            if (this.ws(c)) {
                this.setBodyTag();
                this.state = HTML.ATTRIBUTES;
            } else if (c == '>') {
                this.setBodyTag();
                this.state = this.bodyState;
            }
        }
    }

    private boolean namePart(char c) {
        return Character.isJavaIdentifierPart(c) || c == '-';
    }

    private void setBodyTag() {
        this.bodyState = this.ringBuffer.compare("script", true) ? HTML.SCRIPT : HTML.BODY;
    }

    private void tag(char c) {
        if (this.nameStart(c)) {
            this.state = HTML.TAG_NAME;
            this.ringBuffer.clear();
        } else if (c == '/') {
            this.state = HTML.END_TAG;
        } else if (c == '!') {
            this.state = HTML.PRAGMA;
            this.ringBuffer.clear();
        } else if (!this.ws(c)) {
            this.error(c);
        }
    }

    private void error(char c) {
        l.warning("Invalid: " + new StringBuilder().append(c) + " (" + (Object)((Object)this.state) + ")");
        this.state = this.bodyState;
    }

    private void body(char c) {
        if (c == '<') {
            this.bodyState = this.state;
            this.state = HTML.TAG;
        }
    }

    public static enum HTML {
        ATTRIBUTES,
        BODY,
        TAG,
        ATTR_NAME,
        ATTR_EQUAL,
        DQ_VALUE,
        SCRIPT_DQ_VALUE,
        TAG_NAME,
        END_TAG,
        END_TAG_NAME,
        ESCAPE,
        SCRIPT,
        SCRIPT_SQ_VALUE,
        SCRIPT_CHECK,
        AFTER_END_TAG_NAME,
        SQ_VALUE,
        NQ_VALUE,
        PRAGMA,
        COMMENT;

    }
}

