/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.test;

import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public final class CountMatcher<T>
extends TypeSafeMatcher<Iterable<T>> {
    private final int minCount;
    private final int maxCount;
    private final Matcher<T> matcher;

    public CountMatcher(int minCount, int maxCount, Matcher<T> matcher) {
        this.minCount = minCount;
        this.maxCount = maxCount;
        this.matcher = matcher;
    }

    public static <T> Matcher<Iterable<T>> containsExactly(int count, Matcher<T> matcher) {
        return new CountMatcher<T>(count, count, matcher);
    }

    public static <T> Matcher<Iterable<T>> containsBetween(int minCount, int maxCount, Matcher<T> matcher) {
        return new CountMatcher<T>(minCount, maxCount, matcher);
    }

    protected boolean matchesSafely(Iterable<T> iterable) {
        int numberOfmatches = 0;
        for (T item : iterable) {
            if (!this.matcher.matches(item)) continue;
            ++numberOfmatches;
        }
        return numberOfmatches >= this.minCount && numberOfmatches <= this.maxCount;
    }

    public void describeTo(Description desc) {
        if (this.minCount == this.maxCount) {
            desc.appendText("Iterable containing exactly ").appendValue((Object)this.minCount).appendText(" ").appendDescriptionOf(this.matcher);
        } else {
            desc.appendText("Iterable containing at least ").appendValue((Object)this.minCount).appendText(" and at most ").appendValue((Object)this.maxCount).appendText(" ").appendDescriptionOf(this.matcher);
        }
    }

    protected void describeMismatchSafely(Iterable<T> items, Description mismatchDescription) {
        if (!items.iterator().hasNext()) {
            mismatchDescription.appendText("The collection was empty");
        } else {
            for (T item : items) {
                mismatchDescription.appendText("\n");
                if (this.matcher.matches(item)) {
                    mismatchDescription.appendText("Match:   ");
                } else {
                    mismatchDescription.appendText("Mismatch:");
                }
                this.matcher.describeMismatch(item, mismatchDescription);
            }
        }
    }
}

