/*
 * Decompiled with CFR 0.152.
 */
package com.github.spotbugs.snom.internal;

import com.android.build.gradle.AppExtension;
import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.LibraryExtension;
import com.android.build.gradle.api.BaseVariant;
import com.github.spotbugs.snom.SpotBugsTask;
import com.github.spotbugs.snom.internal.SpotBugsTaskFactory;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.plugins.JavaBasePlugin;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lcom/github/spotbugs/snom/internal/SpotBugsTaskFactory;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "generate", "", "project", "Lorg/gradle/api/Project;", "generateForJava", "generateForAndroid", "Companion", "spotbugs-gradle-plugin"})
public final class SpotBugsTaskFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final Logger log = LoggerFactory.getLogger(SpotBugsTaskFactory.class);

    public final void generate(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.generateForJava(project);
        this.generateForAndroid(project);
    }

    private final void generateForJava(Project project) {
        project.getPlugins().withType(JavaBasePlugin.class).configureEach(arg_0 -> SpotBugsTaskFactory.generateForJava$lambda$5(arg_0 -> SpotBugsTaskFactory.generateForJava$lambda$4(project, this, arg_0), arg_0));
    }

    private final void generateForAndroid(Project project) {
        Action action2 = arg_0 -> SpotBugsTaskFactory.generateForAndroid$lambda$13(project, this, arg_0);
        project.getPlugins().withId("com.android.application", action2);
        project.getPlugins().withId("com.android.library", action2);
    }

    private static final Unit generateForJava$lambda$4$lambda$2$lambda$0(SourceSet $sourceSet, SpotBugsTask it) {
        it.getSourceDirs().setFrom((Iterable)$sourceSet.getAllSource().getSourceDirectories());
        it.getClassDirs().setFrom((Iterable)$sourceSet.getOutput());
        it.getAuxClassPaths().setFrom((Iterable)$sourceSet.getCompileClasspath());
        it.setDescription("Run SpotBugs analysis for the source set '" + $sourceSet.getName() + "'");
        return Unit.INSTANCE;
    }

    private static final void generateForJava$lambda$4$lambda$2$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit generateForJava$lambda$4$lambda$2(SpotBugsTaskFactory this$0, Project $project, SourceSet sourceSet) {
        String name = sourceSet.getTaskName("spotbugs", null);
        this$0.log.debug("Creating SpotBugsTask for {}", (Object)sourceSet);
        $project.getTasks().register(name, SpotBugsTask.class, arg_0 -> SpotBugsTaskFactory.generateForJava$lambda$4$lambda$2$lambda$1(arg_0 -> SpotBugsTaskFactory.generateForJava$lambda$4$lambda$2$lambda$0(sourceSet, arg_0), arg_0));
        return Unit.INSTANCE;
    }

    private static final void generateForJava$lambda$4$lambda$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit generateForJava$lambda$4(Project $project, SpotBugsTaskFactory this$0, JavaBasePlugin it) {
        ((JavaPluginExtension)$project.getExtensions().getByType(JavaPluginExtension.class)).getSourceSets().configureEach(arg_0 -> SpotBugsTaskFactory.generateForJava$lambda$4$lambda$3(arg_0 -> SpotBugsTaskFactory.generateForJava$lambda$4$lambda$2(this$0, $project, arg_0), arg_0));
        return Unit.INSTANCE;
    }

    private static final void generateForJava$lambda$5(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final FileTree generateForAndroid$lambda$13$lambda$11$lambda$9$lambda$6(Function1 $tmp0, Object in) {
        return (FileTree)$tmp0.invoke(in);
    }

    private static final DirectoryProperty generateForAndroid$lambda$13$lambda$11$lambda$9$lambda$7(Function1 $tmp0, Object in) {
        return (DirectoryProperty)$tmp0.invoke(in);
    }

    private static final FileCollection generateForAndroid$lambda$13$lambda$11$lambda$9$lambda$8(Function1 $tmp0, Object in) {
        return (FileCollection)$tmp0.invoke(in);
    }

    private static final Unit generateForAndroid$lambda$13$lambda$11$lambda$9(BaseVariant $variant, SpotBugsTask it) {
        TaskProvider javaCompile = $variant.getJavaCompileProvider();
        Object[] objectArray = new Object[]{javaCompile.map(arg_0 -> SpotBugsTaskFactory.generateForAndroid$lambda$13$lambda$11$lambda$9$lambda$6(generateForAndroid.action.1.1.1.1.INSTANCE, arg_0))};
        it.getSourceDirs().setFrom(objectArray);
        objectArray = new Object[]{javaCompile.map(arg_0 -> SpotBugsTaskFactory.generateForAndroid$lambda$13$lambda$11$lambda$9$lambda$7(generateForAndroid.action.1.1.1.2.INSTANCE, arg_0))};
        it.getClassDirs().setFrom(objectArray);
        objectArray = new Object[]{javaCompile.map(arg_0 -> SpotBugsTaskFactory.generateForAndroid$lambda$13$lambda$11$lambda$9$lambda$8(generateForAndroid.action.1.1.1.3.INSTANCE, arg_0))};
        it.getAuxClassPaths().setFrom(objectArray);
        objectArray = new Object[]{javaCompile};
        it.dependsOn(objectArray);
        return Unit.INSTANCE;
    }

    private static final void generateForAndroid$lambda$13$lambda$11$lambda$10(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit generateForAndroid$lambda$13$lambda$11(SpotBugsTaskFactory this$0, Project $project, BaseVariant variant) {
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        String spotbugsTaskName = Companion.toLowerCamelCase("spotbugs", variant.getName());
        this$0.log.debug("Creating SpotBugsTask for {}", (Object)variant.getName());
        $project.getTasks().register(spotbugsTaskName, SpotBugsTask.class, arg_0 -> SpotBugsTaskFactory.generateForAndroid$lambda$13$lambda$11$lambda$10(arg_0 -> SpotBugsTaskFactory.generateForAndroid$lambda$13$lambda$11$lambda$9(variant, arg_0), arg_0));
        return Unit.INSTANCE;
    }

    private static final void generateForAndroid$lambda$13$lambda$12(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void generateForAndroid$lambda$13(Project $project, SpotBugsTaskFactory this$0, Plugin it) {
        DomainObjectSet domainObjectSet;
        BaseExtension baseExtension = (BaseExtension)$project.getExtensions().getByType(BaseExtension.class);
        if (baseExtension instanceof AppExtension) {
            domainObjectSet = ((AppExtension)baseExtension).getApplicationVariants();
        } else if (baseExtension instanceof LibraryExtension) {
            domainObjectSet = (DomainObjectSet)((LibraryExtension)baseExtension).getLibraryVariants();
        } else {
            throw new GradleException("Unrecognized Android extension " + baseExtension);
        }
        DomainObjectSet variants = domainObjectSet;
        variants.configureEach(arg_0 -> SpotBugsTaskFactory.generateForAndroid$lambda$13$lambda$12(arg_0 -> SpotBugsTaskFactory.generateForAndroid$lambda$13$lambda$11(this$0, $project, arg_0), arg_0));
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u00a8\u0006\b"}, d2={"Lcom/github/spotbugs/snom/internal/SpotBugsTaskFactory$Companion;", "", "<init>", "()V", "toLowerCamelCase", "", "head", "tail", "spotbugs-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String toLowerCamelCase(@NotNull String head, @Nullable String tail) {
            StringBuilder stringBuilder;
            Intrinsics.checkNotNullParameter((Object)head, (String)"head");
            CharSequence charSequence = tail;
            if (charSequence == null || charSequence.length() == 0) {
                return head;
            }
            int n = head.length() + tail.length();
            StringBuilder $this$toLowerCamelCase_u24lambda_u240 = stringBuilder = new StringBuilder(n);
            boolean bl = false;
            $this$toLowerCamelCase_u24lambda_u240.append(head);
            $this$toLowerCamelCase_u24lambda_u240.append(Character.toUpperCase(tail.charAt(0)));
            String string = tail.substring(1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            $this$toLowerCamelCase_u24lambda_u240.append(string);
            String string2 = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            return string2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

