/*
 * Decompiled with CFR 0.152.
 */
package com.github.spotbugs.snom;

import com.github.spotbugs.snom.Confidence;
import com.github.spotbugs.snom.Effort;
import com.github.spotbugs.snom.SpotBugsExtension;
import com.github.spotbugs.snom.SpotBugsReport;
import com.github.spotbugs.snom.internal.SpotBugsHtmlReport;
import com.github.spotbugs.snom.internal.SpotBugsRunnerForHybrid;
import com.github.spotbugs.snom.internal.SpotBugsRunnerForJavaExec;
import com.github.spotbugs.snom.internal.SpotBugsSarifReport;
import com.github.spotbugs.snom.internal.SpotBugsTextReport;
import com.github.spotbugs.snom.internal.SpotBugsXmlReport;
import java.io.File;
import java.util.Collection;
import java.util.Set;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.internal.TaskOutputsInternal;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskOutputs;
import org.gradle.api.tasks.VerificationTask;
import org.gradle.jvm.toolchain.JavaLauncher;
import org.gradle.jvm.toolchain.JavaToolchainService;
import org.gradle.jvm.toolchain.JavaToolchainSpec;
import org.gradle.workers.WorkerExecutor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@CacheableTask
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b'\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\r\u001a\u00020\u000eH\u0017J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000eH\u0016J\u0016\u0010_\u001a\u00020\u00102\u0006\u0010`\u001a\u00020a2\u0006\u0010U\u001a\u00020\u000eJ\b\u0010b\u001a\u00020\u0010H\u0002J\b\u0010c\u001a\u00020\u0010H\u0007J \u0010*\u001a\b\u0012\u0004\u0012\u00020,0+2\u0012\u0010d\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020,0+0eJ\b\u0010f\u001a\u00020!H\u0007J\u0013\u0010g\u001a\b\u0012\u0004\u0012\u00020,0hH\u0001\u00a2\u0006\u0002\biR\u0018\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\bR\u0014\u0010\t\u001a\u00020\n8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR4\u0010\u0011\u001a&\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u000e0\u000e \u0007*\u0012\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u000e0\u000e\u0018\u00010\u00120\u0012X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0013R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00128gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00128gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0016R\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00128gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0016R\u001a\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00128gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0016R\u001a\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u001a\u0010$\u001a\b\u0012\u0004\u0012\u00020!0 8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010#R\u0014\u0010&\u001a\u00020'8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R\u0019\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+8G\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u0014\u0010/\u001a\u0002008gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b1\u00102R\u0014\u00103\u001a\u0002008gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b4\u00102R\u0014\u00105\u001a\u0002008gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b6\u00102R\u001a\u00107\u001a\b\u0012\u0004\u0012\u00020!0 8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b8\u0010#R\u001a\u00109\u001a\b\u0012\u0004\u0012\u00020!0\u00128gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b:\u0010\u0016R\u001a\u0010;\u001a\b\u0012\u0004\u0012\u00020!0\u00128gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b<\u0010\u0016R\u001a\u0010=\u001a\b\u0012\u0004\u0012\u00020!0 8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b>\u0010#R\u001a\u0010?\u001a\b\u0012\u0004\u0012\u00020!0 8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b@\u0010#R\u001a\u0010A\u001a\b\u0012\u0004\u0012\u00020!0\u00128gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\bB\u0010\u0016R\u0014\u0010C\u001a\u00020D8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\bE\u0010FR\u0014\u0010G\u001a\u00020D8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\bH\u0010FR\u0014\u0010I\u001a\u00020D8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\bJ\u0010FR\u001a\u0010K\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00128gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\bL\u0010\u0016R\u0014\u0010M\u001a\u0002008gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\bN\u00102R\u001e\u0010O\u001a\u0004\u0018\u00010P8GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bQ\u0010R\"\u0004\bS\u0010TR\u000e\u0010U\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010V\u001a\u00020D8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\bW\u0010FR\u0014\u0010X\u001a\u00020D8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\bY\u0010FR\u001a\u0010Z\u001a\b\u0012\u0004\u0012\u00020[0\u00128gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\\\u0010\u0016R\u0014\u0010]\u001a\u0002008gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b^\u00102\u00a8\u0006j"}, d2={"Lcom/github/spotbugs/snom/SpotBugsTask;", "Lorg/gradle/api/DefaultTask;", "Lorg/gradle/api/tasks/VerificationTask;", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "workerExecutor", "Lorg/gradle/workers/WorkerExecutor;", "getWorkerExecutor", "()Lorg/gradle/workers/WorkerExecutor;", "getIgnoreFailures", "", "setIgnoreFailures", "", "ignoreFailures", "Lorg/gradle/api/provider/Property;", "Lorg/gradle/api/provider/Property;", "showStackTraces", "getShowStackTraces", "()Lorg/gradle/api/provider/Property;", "showProgress", "getShowProgress", "reportLevel", "Lcom/github/spotbugs/snom/Confidence;", "getReportLevel", "effort", "Lcom/github/spotbugs/snom/Effort;", "getEffort", "visitors", "Lorg/gradle/api/provider/ListProperty;", "", "getVisitors", "()Lorg/gradle/api/provider/ListProperty;", "omitVisitors", "getOmitVisitors", "reportsDir", "Lorg/gradle/api/file/DirectoryProperty;", "getReportsDir", "()Lorg/gradle/api/file/DirectoryProperty;", "reports", "Lorg/gradle/api/NamedDomainObjectContainer;", "Lcom/github/spotbugs/snom/SpotBugsReport;", "getReports", "()Lorg/gradle/api/NamedDomainObjectContainer;", "includeFilter", "Lorg/gradle/api/file/RegularFileProperty;", "getIncludeFilter", "()Lorg/gradle/api/file/RegularFileProperty;", "excludeFilter", "getExcludeFilter", "baselineFile", "getBaselineFile", "onlyAnalyze", "getOnlyAnalyze", "projectName", "getProjectName", "release", "getRelease", "extraArgs", "getExtraArgs", "jvmArgs", "getJvmArgs", "maxHeapSize", "getMaxHeapSize", "sourceDirs", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getSourceDirs", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "classDirs", "getClassDirs", "auxClassPaths", "getAuxClassPaths", "useAuxclasspathFile", "getUseAuxclasspathFile", "auxclasspathFile", "getAuxclasspathFile", "classes", "Lorg/gradle/api/file/FileCollection;", "getClasses", "()Lorg/gradle/api/file/FileCollection;", "setClasses", "(Lorg/gradle/api/file/FileCollection;)V", "enableWorkerApi", "pluginJarFiles", "getPluginJarFiles", "spotbugsClasspath", "getSpotbugsClasspath", "launcher", "Lorg/gradle/jvm/toolchain/JavaLauncher;", "getLauncher", "analyseClassFile", "getAnalyseClassFile", "init", "extension", "Lcom/github/spotbugs/snom/SpotBugsExtension;", "configureJavaLauncher", "run", "configureAction", "Lorg/gradle/api/Action;", "getBaseName", "getRequiredReports", "Lkotlin/sequences/Sequence;", "getRequiredReports$spotbugs_gradle_plugin", "spotbugs-gradle-plugin"})
public abstract class SpotBugsTask
extends DefaultTask
implements VerificationTask {
    private final Logger log = LoggerFactory.getLogger(SpotBugsTask.class);
    private final Property<Boolean> ignoreFailures = this.getProject().getObjects().property(Boolean.TYPE);
    @NotNull
    private final NamedDomainObjectContainer<SpotBugsReport> reports;
    @Nullable
    private FileCollection classes;
    private boolean enableWorkerApi = true;

    public SpotBugsTask() {
        ObjectFactory objects = this.getProject().getObjects();
        this.reports = objects.domainObjectContainer(SpotBugsReport.class, arg_0 -> SpotBugsTask._init_$lambda$3(objects, this, arg_0));
        this.setDescription("Run SpotBugs analysis.");
        this.setGroup("verification");
    }

    @Inject
    @NotNull
    public abstract WorkerExecutor getWorkerExecutor();

    @Input
    public boolean getIgnoreFailures() {
        Object object = this.ignoreFailures.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (Boolean)object;
    }

    public void setIgnoreFailures(boolean ignoreFailures) {
        this.ignoreFailures.set((Object)ignoreFailures);
    }

    @Input
    @NotNull
    public abstract Property<Boolean> getShowStackTraces();

    @Optional
    @Input
    @NotNull
    public abstract Property<Boolean> getShowProgress();

    @Input
    @Optional
    @NotNull
    public abstract Property<Confidence> getReportLevel();

    @Input
    @Optional
    @NotNull
    public abstract Property<Effort> getEffort();

    @Input
    @NotNull
    public abstract ListProperty<String> getVisitors();

    @Input
    @NotNull
    public abstract ListProperty<String> getOmitVisitors();

    @Internal(value="Refer the destination of each report instead.")
    @NotNull
    public abstract DirectoryProperty getReportsDir();

    @Internal
    @NotNull
    public final NamedDomainObjectContainer<SpotBugsReport> getReports() {
        return this.reports;
    }

    @Optional
    @InputFile
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public abstract RegularFileProperty getIncludeFilter();

    @Optional
    @InputFile
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public abstract RegularFileProperty getExcludeFilter();

    @Optional
    @InputFile
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public abstract RegularFileProperty getBaselineFile();

    @Input
    @NotNull
    public abstract ListProperty<String> getOnlyAnalyze();

    @Internal
    @NotNull
    public abstract Property<String> getProjectName();

    @Input
    @NotNull
    public abstract Property<String> getRelease();

    @Optional
    @Input
    @NotNull
    public abstract ListProperty<String> getExtraArgs();

    @Optional
    @Input
    @NotNull
    public abstract ListProperty<String> getJvmArgs();

    @Optional
    @Input
    @NotNull
    public abstract Property<String> getMaxHeapSize();

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public abstract ConfigurableFileCollection getSourceDirs();

    @Internal
    @NotNull
    public abstract ConfigurableFileCollection getClassDirs();

    @Classpath
    @NotNull
    public abstract ConfigurableFileCollection getAuxClassPaths();

    @Input
    @Optional
    @NotNull
    public abstract Property<Boolean> getUseAuxclasspathFile();

    @Internal
    @NotNull
    public abstract RegularFileProperty getAuxclasspathFile();

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @SkipWhenEmpty
    @Nullable
    public final FileCollection getClasses() {
        FileCollection fileCollection = this.classes;
        if (fileCollection == null) {
            fileCollection = this.getClassDirs().getAsFileTree().filter(arg_0 -> SpotBugsTask._get_classes_$lambda$1(SpotBugsTask::_get_classes_$lambda$0, arg_0));
        }
        return fileCollection;
    }

    public final void setClasses(@Nullable FileCollection fileCollection) {
        this.classes = fileCollection;
    }

    @Internal
    @NotNull
    public abstract ConfigurableFileCollection getPluginJarFiles();

    @Internal
    @NotNull
    public abstract ConfigurableFileCollection getSpotbugsClasspath();

    @Nested
    @Optional
    @NotNull
    public abstract Property<JavaLauncher> getLauncher();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getAnalyseClassFile();

    public final void init(@NotNull SpotBugsExtension extension, boolean enableWorkerApi) {
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        this.getAuxclasspathFile().convention(this.getProject().getLayout().getBuildDirectory().file("spotbugs/auxclasspath/" + this.getName()));
        this.ignoreFailures.convention((Provider)extension.getIgnoreFailures());
        this.getShowStackTraces().convention((Provider)extension.getShowStackTraces());
        this.getShowProgress().convention((Provider)extension.getShowProgress());
        this.getReportLevel().convention((Provider)extension.getReportLevel());
        this.getEffort().convention((Provider)extension.getEffort());
        this.getVisitors().convention((Provider)extension.getVisitors());
        this.getOmitVisitors().convention((Provider)extension.getOmitVisitors());
        this.getReportsDir().convention((Provider)extension.getReportsDir());
        this.getIncludeFilter().convention((Provider)extension.getIncludeFilter());
        this.getExcludeFilter().convention((Provider)extension.getExcludeFilter());
        this.getBaselineFile().convention((Provider)extension.getBaselineFile());
        this.getOnlyAnalyze().convention((Provider)extension.getOnlyAnalyze());
        this.getProjectName().convention(extension.getProjectName().map(arg_0 -> SpotBugsTask.init$lambda$5(arg_0 -> SpotBugsTask.init$lambda$4(this, arg_0), arg_0)));
        this.getRelease().convention((Provider)extension.getRelease());
        this.getJvmArgs().convention((Provider)extension.getJvmArgs());
        this.getExtraArgs().convention((Provider)extension.getExtraArgs());
        this.getMaxHeapSize().convention((Provider)extension.getMaxHeapSize());
        this.getUseAuxclasspathFile().convention((Provider)extension.getUseAuxclasspathFile());
        if (extension.getUseJavaToolchains().isPresent() && ((Boolean)extension.getUseJavaToolchains().get()).booleanValue()) {
            this.configureJavaLauncher();
        }
        this.enableWorkerApi = enableWorkerApi;
        this.getAnalyseClassFile().set(this.getProject().getLayout().getBuildDirectory().file(this.getName() + "-analyse-class-file.txt"));
        Configuration pluginConfiguration = this.getProject().getConfigurations().getByName("spotbugsPlugins");
        Object[] objectArray = new Object[]{this.getProject().provider(() -> SpotBugsTask.init$lambda$6(pluginConfiguration))};
        this.getPluginJarFiles().from(objectArray);
        Configuration configuration = this.getProject().getConfigurations().getByName("spotbugs");
        Configuration spotbugsSlf4j = this.getProject().getConfigurations().getByName("spotbugsSlf4j");
        Object[] objectArray2 = new Object[1];
        Object[] objectArray3 = new Object[]{this.getProject().provider(() -> SpotBugsTask.init$lambda$7(spotbugsSlf4j)), this.getProject().provider(() -> SpotBugsTask.init$lambda$8(configuration))};
        objectArray2[0] = this.getProject().getLayout().files(objectArray3);
        this.getSpotbugsClasspath().from(objectArray2);
    }

    private final void configureJavaLauncher() {
        JavaToolchainSpec toolchain = ((JavaPluginExtension)this.getProject().getExtensions().getByType(JavaPluginExtension.class)).getToolchain();
        JavaToolchainService service = (JavaToolchainService)this.getProject().getExtensions().getByType(JavaToolchainService.class);
        Provider defaultLauncher = service.launcherFor(toolchain);
        this.getLauncher().convention(defaultLauncher);
    }

    @TaskAction
    public final void run() {
        if (this.enableWorkerApi) {
            this.log.info("Running SpotBugs by Gradle no-isolated Worker...");
            new SpotBugsRunnerForHybrid(this.getWorkerExecutor(), this.getLauncher()).run(this);
        } else {
            this.log.info("Running SpotBugs by JavaExec...");
            new SpotBugsRunnerForJavaExec(this.getLauncher()).run(this);
        }
    }

    @NotNull
    public final NamedDomainObjectContainer<SpotBugsReport> reports(@NotNull Action<NamedDomainObjectContainer<SpotBugsReport>> configureAction) {
        Intrinsics.checkNotNullParameter(configureAction, (String)"configureAction");
        configureAction.execute(this.reports);
        return this.reports;
    }

    @Internal
    @NotNull
    public final String getBaseName() {
        StringBuilder stringBuilder;
        String prunedName = null;
        String string = this.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        prunedName = StringsKt.replaceFirst$default((String)string, (String)"spotbugs", (String)"", (boolean)false, (int)4, null);
        if (((CharSequence)prunedName).length() == 0) {
            prunedName = this.getName();
        }
        StringBuilder $this$getBaseName_u24lambda_u249 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$getBaseName_u24lambda_u249.append(Character.toLowerCase(prunedName.charAt(0)));
        String string2 = prunedName.substring(1);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        $this$getBaseName_u24lambda_u249.append(string2);
        String string3 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
        return string3;
    }

    @Internal
    @NotNull
    public final Sequence<SpotBugsReport> getRequiredReports$spotbugs_gradle_plugin() {
        Collection collection = this.reports.matching(arg_0 -> SpotBugsTask.getRequiredReports$lambda$11(SpotBugsTask::getRequiredReports$lambda$10, arg_0)).getAsMap().values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        return CollectionsKt.asSequence((Iterable)collection);
    }

    private static final boolean _get_classes_$lambda$0(File it) {
        String string = it.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return StringsKt.endsWith$default((String)string, (String)".class", (boolean)false, (int)2, null);
    }

    private static final boolean _get_classes_$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final SpotBugsReport _init_$lambda$3(ObjectFactory $objects, SpotBugsTask this$0, String name) {
        Object object;
        SpotBugsReport spotBugsReport;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        switch (name) {
            case "html": {
                Object[] objectArray = new Object[]{name, $objects, this$0};
                spotBugsReport = (SpotBugsReport)$objects.newInstance(SpotBugsHtmlReport.class, objectArray);
                break;
            }
            case "xml": {
                Object[] objectArray = new Object[]{name, $objects, this$0};
                spotBugsReport = (SpotBugsReport)$objects.newInstance(SpotBugsXmlReport.class, objectArray);
                break;
            }
            case "text": {
                Object[] objectArray = new Object[]{name, $objects, this$0};
                spotBugsReport = (SpotBugsReport)$objects.newInstance(SpotBugsTextReport.class, objectArray);
                break;
            }
            case "sarif": {
                Object[] objectArray = new Object[]{name, $objects, this$0};
                spotBugsReport = (SpotBugsReport)$objects.newInstance(SpotBugsSarifReport.class, objectArray);
                break;
            }
            default: {
                throw new InvalidUserDataException(name + " is invalid as the report name");
            }
        }
        Object it = object = spotBugsReport;
        boolean bl = false;
        TaskOutputsInternal taskOutputsInternal = this$0.getOutputs();
        Intrinsics.checkNotNull((Object)taskOutputsInternal, (String)"null cannot be cast to non-null type org.gradle.api.tasks.TaskOutputs");
        ((TaskOutputs)taskOutputsInternal).file((Object)((SpotBugsReport)it).getOutputLocation());
        return object;
    }

    private static final String init$lambda$4(SpotBugsTask this$0, String p) {
        return p + " (" + this$0.getName() + ')';
    }

    private static final String init$lambda$5(Function1 $tmp0, Object in) {
        return (String)$tmp0.invoke(in);
    }

    private static final Set init$lambda$6(Configuration $pluginConfiguration) {
        return $pluginConfiguration.getFiles();
    }

    private static final Set init$lambda$7(Configuration $spotbugsSlf4j) {
        return $spotbugsSlf4j.getFiles();
    }

    private static final Set init$lambda$8(Configuration $configuration) {
        return $configuration.getFiles();
    }

    private static final boolean getRequiredReports$lambda$10(SpotBugsReport it) {
        Object object = it.getRequired().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (Boolean)object;
    }

    private static final boolean getRequiredReports$lambda$11(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

