/*
 * Decompiled with CFR 0.152.
 */
package com.github.spotbugs.snom.internal;

import com.github.spotbugs.snom.Confidence;
import com.github.spotbugs.snom.Effort;
import com.github.spotbugs.snom.SpotBugsReport;
import com.github.spotbugs.snom.SpotBugsTask;
import com.github.spotbugs.snom.internal.SpotBugsRunner;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.gradle.api.GradleException;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0004J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0004J\u0010\u0010\f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0016\u0010\u0013\u001a\u00020\b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00120\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\nH&R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/github/spotbugs/snom/internal/SpotBugsRunner;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "buildArguments", "", "", "task", "Lcom/github/spotbugs/snom/SpotBugsTask;", "buildJvmArguments", "createFileForAuxClasspath", "generateFile", "", "files", "Lorg/gradle/api/file/FileCollection;", "file", "Ljava/io/File;", "join", "", "run", "spotbugs-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nSpotBugsRunner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpotBugsRunner.kt\ncom/github/spotbugs/snom/internal/SpotBugsRunner\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,176:1\n1855#2,2:177\n1855#2,2:180\n1#3:179\n*S KotlinDebug\n*F\n+ 1 SpotBugsRunner.kt\ncom/github/spotbugs/snom/internal/SpotBugsRunner\n*L\n61#1:177,2\n154#1:180,2\n*E\n"})
public abstract class SpotBugsRunner {
    private final Logger log = LoggerFactory.getLogger(SpotBugsRunner.class);

    public abstract void run(@NotNull SpotBugsTask var1);

    @NotNull
    protected final List<String> buildArguments(@NotNull SpotBugsTask task) {
        Intrinsics.checkNotNullParameter((Object)((Object)task), (String)"task");
        List args = new ArrayList();
        ConfigurableFileCollection plugins = task.getPluginJarFiles();
        if (!plugins.isEmpty()) {
            args.add("-pluginList");
            Set set = plugins.getFiles();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getFiles(...)");
            args.add(this.join(set));
        }
        args.add("-timestampNow");
        if (!task.getAuxClassPaths().isEmpty()) {
            Object object = task.getUseAuxclasspathFile().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            if (((Boolean)object).booleanValue()) {
                args.add("-auxclasspathFromFile");
                String auxClasspathFile2 = this.createFileForAuxClasspath(task);
                this.log.debug("Using auxclasspath file: {}", (Object)auxClasspathFile2);
                args.add(auxClasspathFile2);
            } else {
                args.add("-auxclasspath");
                Set set = task.getAuxClassPaths().getFiles();
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getFiles(...)");
                args.add(this.join(set));
            }
        }
        if (!task.getSourceDirs().isEmpty()) {
            args.add("-sourcepath");
            String string = task.getSourceDirs().getAsPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAsPath(...)");
            args.add(string);
        }
        Object object = task.getShowProgress().getOrElse((Object)false);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getOrElse(...)");
        if (((Boolean)object).booleanValue()) {
            args.add("-progress");
        }
        Object $this$forEach$iv = task.getRequiredReports$spotbugs_gradle_plugin();
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv = iterator.next();
            SpotBugsReport report = (SpotBugsReport)element$iv;
            boolean bl = false;
            File reportFile = (File)report.getOutputLocation().getAsFile().get();
            File dir = reportFile.getParentFile();
            dir.mkdirs();
            args.add(report.toCommandLineOption() + "=" + reportFile.getAbsolutePath());
        }
        if (task.getEffort().isPresent()) {
            $this$forEach$iv = ((Effort)((Object)task.getEffort().get())).name();
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            String string = ((String)$this$forEach$iv).toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            args.add("-effort:" + string);
        }
        if (task.getReportLevel().isPresent()) {
            ((Confidence)((Object)task.getReportLevel().get())).toCommandLineOption().ifPresent(arg_0 -> SpotBugsRunner.buildArguments$lambda$1((Function1)new Function1<String, Unit>((List<String>)args){
                final /* synthetic */ List<String> $args;
                {
                    this.$args = $args;
                    super(1);
                }

                public final void invoke(@NotNull String e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    this.$args.add(e);
                }
            }, arg_0));
        }
        if (task.getVisitors().isPresent()) {
            Object object2 = task.getVisitors().get();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
            if (!((Collection)object2).isEmpty()) {
                args.add("-visitors");
                String string = ((List)task.getVisitors().get()).stream().collect(Collectors.joining(","));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"collect(...)");
                args.add(string);
            }
        }
        if (task.getOmitVisitors().isPresent()) {
            Object object3 = task.getOmitVisitors().get();
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"get(...)");
            if (!((Collection)object3).isEmpty()) {
                args.add("-omitVisitors");
                String string = ((List)task.getOmitVisitors().get()).stream().collect(Collectors.joining(","));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"collect(...)");
                args.add(string);
            }
        }
        if (task.getIncludeFilter().isPresent()) {
            args.add("-include");
            String string = ((RegularFile)task.getIncludeFilter().get()).getAsFile().getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
            args.add(string);
        }
        if (task.getExcludeFilter().isPresent()) {
            args.add("-exclude");
            String string = ((RegularFile)task.getExcludeFilter().get()).getAsFile().getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
            args.add(string);
        }
        if (task.getBaselineFile().isPresent()) {
            args.add("-excludeBugs");
            String string = ((RegularFile)task.getBaselineFile().get()).getAsFile().getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
            args.add(string);
        }
        if (task.getOnlyAnalyze().isPresent()) {
            args.add("-onlyAnalyze");
            String string = ((List)task.getOnlyAnalyze().get()).stream().collect(Collectors.joining(","));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"collect(...)");
            args.add(string);
        }
        args.add("-projectName");
        Object object4 = task.getProjectName().get();
        Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"get(...)");
        args.add(object4);
        args.add("-release");
        Object object5 = task.getRelease().get();
        Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"get(...)");
        args.add(object5);
        File file = (File)task.getAnalyseClassFile().getAsFile().get();
        FileCollection fileCollection = task.getClasses();
        if (fileCollection != null) {
            FileCollection it = fileCollection;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)file);
            this.generateFile(it, file);
        }
        args.add("-analyzeFromFile");
        String string = file.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
        args.add(string);
        Object object6 = task.getExtraArgs().getOrElse((Object)CollectionsKt.emptyList());
        Intrinsics.checkNotNullExpressionValue((Object)object6, (String)"getOrElse(...)");
        args.addAll((Collection)object6);
        this.log.debug("Arguments for SpotBugs are generated: {}", (Object)args);
        return args;
    }

    private final String createFileForAuxClasspath(SpotBugsTask task) {
        OpenOption[] auxClasspath2 = task.getAuxClassPaths().getFiles().stream().map(arg_0 -> SpotBugsRunner.createFileForAuxClasspath$lambda$3(createFileForAuxClasspath.auxClasspath.1.INSTANCE, arg_0)).collect(Collectors.joining("\n"));
        try {
            Path auxClasspathFile2 = (Path)task.getAuxclasspathFile().map(arg_0 -> SpotBugsRunner.createFileForAuxClasspath$lambda$4(createFileForAuxClasspath.auxClasspathFile.1.INSTANCE, arg_0)).get();
            try {
                Files.createDirectories(auxClasspathFile2.getParent(), new FileAttribute[0]);
                if (!Files.exists(auxClasspathFile2, new LinkOption[0])) {
                    Files.createFile(auxClasspathFile2, new FileAttribute[0]);
                }
                Intrinsics.checkNotNull((Object)auxClasspath2);
                OpenOption[] openOptionArray = auxClasspath2;
                byte[] byArray = openOptionArray.getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                openOptionArray = new OpenOption[]{StandardOpenOption.TRUNCATE_EXISTING};
                Files.write(auxClasspathFile2, byArray, openOptionArray);
                return ((Object)auxClasspathFile2.normalize()).toString();
            }
            catch (Exception e) {
                throw new GradleException("Could not create auxiliary classpath file for SpotBugsTask at " + auxClasspathFile2.normalize(), (Throwable)e);
            }
        }
        catch (Exception e) {
            throw new GradleException("Could not create auxiliary classpath file for SpotBugsTask", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void generateFile(FileCollection files, File file) {
        try {
            Object object = file;
            Object object2 = Charsets.UTF_8;
            int n = 8192;
            Object object3 = object;
            object3 = new OutputStreamWriter((OutputStream)new FileOutputStream((File)object3), (Charset)object2);
            object = object3 instanceof BufferedWriter ? (BufferedWriter)object3 : new BufferedWriter((Writer)object3, n);
            object2 = null;
            try {
                void $this$forEach$iv;
                BufferedWriter writer = (BufferedWriter)object;
                boolean bl = false;
                FileCollection fileCollection = files.filter(arg_0 -> SpotBugsRunner.generateFile$lambda$7$lambda$5(generateFile.1.1.INSTANCE, arg_0));
                Intrinsics.checkNotNullExpressionValue((Object)fileCollection, (String)"filter(...)");
                Iterable iterable = (Iterable)fileCollection;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    File it = (File)element$iv;
                    boolean bl2 = false;
                    writer.write(it.getAbsolutePath());
                    writer.newLine();
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
            }
        }
        catch (IOException e) {
            throw new GradleException("Fail to generate the text file to list target .class files", (Throwable)e);
        }
    }

    @NotNull
    protected final List<String> buildJvmArguments(@NotNull SpotBugsTask task) {
        Intrinsics.checkNotNullParameter((Object)((Object)task), (String)"task");
        List args = (List)task.getJvmArgs().getOrElse((Object)CollectionsKt.emptyList());
        this.log.debug("Arguments for JVM process are generated: {}", (Object)args);
        Intrinsics.checkNotNull((Object)args);
        return args;
    }

    private final String join(Collection<? extends File> files) {
        String string = files.stream().map(arg_0 -> SpotBugsRunner.join$lambda$8(join.1.INSTANCE, arg_0)).collect(Collectors.joining(File.pathSeparator));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"collect(...)");
        return string;
    }

    private static final void buildArguments$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final String createFileForAuxClasspath$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(p0);
    }

    private static final Path createFileForAuxClasspath$lambda$4(Function1 $tmp0, Object in) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Path)$tmp0.invoke(in);
    }

    private static final boolean generateFile$lambda$7$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final String join$lambda$8(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(p0);
    }
}

