/*
 * Decompiled with CFR 0.152.
 */
package com.github.spotbugs.snom;

import com.github.spotbugs.snom.Confidence;
import com.github.spotbugs.snom.Effort;
import com.github.spotbugs.snom.SpotBugsExtension;
import com.github.spotbugs.snom.SpotBugsReport;
import com.github.spotbugs.snom.SpotBugsTask;
import com.github.spotbugs.snom.internal.SpotBugsHtmlReport;
import com.github.spotbugs.snom.internal.SpotBugsRunnerForHybrid;
import com.github.spotbugs.snom.internal.SpotBugsRunnerForJavaExec;
import com.github.spotbugs.snom.internal.SpotBugsSarifReport;
import com.github.spotbugs.snom.internal.SpotBugsTextReport;
import com.github.spotbugs.snom.internal.SpotBugsXmlReport;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.VerificationTask;
import org.gradle.jvm.toolchain.JavaLauncher;
import org.gradle.jvm.toolchain.JavaToolchainService;
import org.gradle.jvm.toolchain.JavaToolchainSpec;
import org.gradle.workers.WorkerExecutor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@CacheableTask
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u001f\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b'\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010Y\u001a\u00020ZH\u0002J\b\u0010[\u001a\u00020#H\u0007J\b\u0010\\\u001a\u00020\u001eH\u0017J\u001b\u0010]\u001a\u0010\u0012\f\u0012\n '*\u0004\u0018\u00010B0B0^H\u0001\u00a2\u0006\u0002\b_J\u0016\u0010`\u001a\u00020Z2\u0006\u0010a\u001a\u00020b2\u0006\u0010\u001d\u001a\u00020\u001eJ \u0010@\u001a\b\u0012\u0004\u0012\u00020B0A2\u0012\u0010c\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020B0A0dJ\b\u0010e\u001a\u00020ZH\u0007J\u0010\u0010f\u001a\u00020Z2\u0006\u0010&\u001a\u00020\u001eH\u0016R\u0014\u0010\u0004\u001a\u00020\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0007R\u0014\u0010\u000e\u001a\u00020\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0007R\u0014\u0010\u0010\u001a\u00020\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000bR\u001e\u0010\u0012\u001a\u0004\u0018\u00010\u00138GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00198gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\u00020\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0007R\u001a\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R2\u0010&\u001a&\u0012\f\u0012\n '*\u0004\u0018\u00010\u001e0\u001e '*\u0012\u0012\f\u0012\n '*\u0004\u0018\u00010\u001e0\u001e\u0018\u00010\u00190\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010(\u001a\u00020\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010\u0007R\u001a\u0010*\u001a\b\u0012\u0004\u0012\u00020#0\"8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010%R\u001a\u0010,\u001a\b\u0012\u0004\u0012\u00020-0\u00198gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010\u001cR\u0016\u0010/\u001a\n '*\u0004\u0018\u00010000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u00101\u001a\b\u0012\u0004\u0012\u00020#0\u00198gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u0010\u001cR\u001a\u00103\u001a\b\u0012\u0004\u0012\u00020#0\"8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b4\u0010%R\u001a\u00105\u001a\b\u0012\u0004\u0012\u00020#0\"8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b6\u0010%R\u0014\u00107\u001a\u00020\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b8\u0010\u000bR\u001a\u00109\u001a\b\u0012\u0004\u0012\u00020#0\u00198gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b:\u0010\u001cR\u001a\u0010;\u001a\b\u0012\u0004\u0012\u00020#0\u00198gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b<\u0010\u001cR\u001a\u0010=\u001a\b\u0012\u0004\u0012\u00020>0\u00198gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b?\u0010\u001cR\u0019\u0010@\u001a\b\u0012\u0004\u0012\u00020B0A8G\u00a2\u0006\b\n\u0000\u001a\u0004\bC\u0010DR\u0014\u0010E\u001a\u00020F8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\bG\u0010HR\u001a\u0010I\u001a\b\u0012\u0004\u0012\u00020\u001e0\u00198gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\bJ\u0010\u001cR\u001a\u0010K\u001a\b\u0012\u0004\u0012\u00020\u001e0\u00198gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\bL\u0010\u001cR\u0014\u0010M\u001a\u00020\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\bN\u0010\u000bR\u0014\u0010O\u001a\u00020\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\bP\u0010\u000bR\u001a\u0010Q\u001a\b\u0012\u0004\u0012\u00020\u001e0\u00198gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\bR\u0010\u001cR\u001a\u0010S\u001a\b\u0012\u0004\u0012\u00020#0\"8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\bT\u0010%R\u0014\u0010U\u001a\u00020V8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\bW\u0010X\u00a8\u0006g"}, d2={"Lcom/github/spotbugs/snom/SpotBugsTask;", "Lorg/gradle/api/DefaultTask;", "Lorg/gradle/api/tasks/VerificationTask;", "()V", "analyseClassFile", "Lorg/gradle/api/file/RegularFileProperty;", "getAnalyseClassFile", "()Lorg/gradle/api/file/RegularFileProperty;", "auxClassPaths", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getAuxClassPaths", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "auxclasspathFile", "getAuxclasspathFile", "baselineFile", "getBaselineFile", "classDirs", "getClassDirs", "classes", "Lorg/gradle/api/file/FileCollection;", "getClasses", "()Lorg/gradle/api/file/FileCollection;", "setClasses", "(Lorg/gradle/api/file/FileCollection;)V", "effort", "Lorg/gradle/api/provider/Property;", "Lcom/github/spotbugs/snom/Effort;", "getEffort", "()Lorg/gradle/api/provider/Property;", "enableWorkerApi", "", "excludeFilter", "getExcludeFilter", "extraArgs", "Lorg/gradle/api/provider/ListProperty;", "", "getExtraArgs", "()Lorg/gradle/api/provider/ListProperty;", "ignoreFailures", "kotlin.jvm.PlatformType", "includeFilter", "getIncludeFilter", "jvmArgs", "getJvmArgs", "launcher", "Lorg/gradle/jvm/toolchain/JavaLauncher;", "getLauncher", "log", "Lorg/slf4j/Logger;", "maxHeapSize", "getMaxHeapSize", "omitVisitors", "getOmitVisitors", "onlyAnalyze", "getOnlyAnalyze", "pluginJarFiles", "getPluginJarFiles", "projectName", "getProjectName", "release", "getRelease", "reportLevel", "Lcom/github/spotbugs/snom/Confidence;", "getReportLevel", "reports", "Lorg/gradle/api/NamedDomainObjectContainer;", "Lcom/github/spotbugs/snom/SpotBugsReport;", "getReports", "()Lorg/gradle/api/NamedDomainObjectContainer;", "reportsDir", "Lorg/gradle/api/file/DirectoryProperty;", "getReportsDir", "()Lorg/gradle/api/file/DirectoryProperty;", "showProgress", "getShowProgress", "showStackTraces", "getShowStackTraces", "sourceDirs", "getSourceDirs", "spotbugsClasspath", "getSpotbugsClasspath", "useAuxclasspathFile", "getUseAuxclasspathFile", "visitors", "getVisitors", "workerExecutor", "Lorg/gradle/workers/WorkerExecutor;", "getWorkerExecutor", "()Lorg/gradle/workers/WorkerExecutor;", "configureJavaLauncher", "", "getBaseName", "getIgnoreFailures", "getRequiredReports", "", "getRequiredReports$spotbugs_gradle_plugin", "init", "extension", "Lcom/github/spotbugs/snom/SpotBugsExtension;", "configureAction", "Lorg/gradle/api/Action;", "run", "setIgnoreFailures", "spotbugs-gradle-plugin"})
public abstract class SpotBugsTask
extends DefaultTask
implements VerificationTask {
    private final Logger log = LoggerFactory.getLogger(SpotBugsTask.class);
    private final Property<Boolean> ignoreFailures = this.getProject().getObjects().property(Boolean.TYPE);
    @NotNull
    private final NamedDomainObjectContainer<SpotBugsReport> reports;
    @Nullable
    private FileCollection classes;
    private boolean enableWorkerApi = true;

    public SpotBugsTask() {
        ObjectFactory objects = this.getProject().getObjects();
        NamedDomainObjectContainer namedDomainObjectContainer = objects.domainObjectContainer(SpotBugsReport.class, arg_0 -> SpotBugsTask._init_$lambda$1(objects, this, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)namedDomainObjectContainer, (String)"domainObjectContainer(...)");
        this.reports = namedDomainObjectContainer;
        this.setDescription("Run SpotBugs analysis.");
        this.setGroup("verification");
    }

    @Inject
    @NotNull
    public abstract WorkerExecutor getWorkerExecutor();

    @Input
    public boolean getIgnoreFailures() {
        Object object = this.ignoreFailures.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (Boolean)object;
    }

    public void setIgnoreFailures(boolean ignoreFailures) {
        this.ignoreFailures.set((Object)ignoreFailures);
    }

    @Input
    @NotNull
    public abstract Property<Boolean> getShowStackTraces();

    @Optional
    @Input
    @NotNull
    public abstract Property<Boolean> getShowProgress();

    @Input
    @Optional
    @NotNull
    public abstract Property<Confidence> getReportLevel();

    @Input
    @Optional
    @NotNull
    public abstract Property<Effort> getEffort();

    @Input
    @NotNull
    public abstract ListProperty<String> getVisitors();

    @Input
    @NotNull
    public abstract ListProperty<String> getOmitVisitors();

    @Internal(value="Refer the destination of each report instead.")
    @NotNull
    public abstract DirectoryProperty getReportsDir();

    @Internal
    @NotNull
    public final NamedDomainObjectContainer<SpotBugsReport> getReports() {
        return this.reports;
    }

    @Optional
    @InputFile
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public abstract RegularFileProperty getIncludeFilter();

    @Optional
    @InputFile
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public abstract RegularFileProperty getExcludeFilter();

    @Optional
    @InputFile
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public abstract RegularFileProperty getBaselineFile();

    @Input
    @NotNull
    public abstract ListProperty<String> getOnlyAnalyze();

    @Internal
    @NotNull
    public abstract Property<String> getProjectName();

    @Input
    @NotNull
    public abstract Property<String> getRelease();

    @Optional
    @Input
    @NotNull
    public abstract ListProperty<String> getExtraArgs();

    @Optional
    @Input
    @NotNull
    public abstract ListProperty<String> getJvmArgs();

    @Optional
    @Input
    @NotNull
    public abstract Property<String> getMaxHeapSize();

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public abstract ConfigurableFileCollection getSourceDirs();

    @Internal
    @NotNull
    public abstract ConfigurableFileCollection getClassDirs();

    @Classpath
    @NotNull
    public abstract ConfigurableFileCollection getAuxClassPaths();

    @Input
    @Optional
    @NotNull
    public abstract Property<Boolean> getUseAuxclasspathFile();

    @Internal
    @NotNull
    public abstract RegularFileProperty getAuxclasspathFile();

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @SkipWhenEmpty
    @Nullable
    public final FileCollection getClasses() {
        FileCollection fileCollection = this.classes;
        if (fileCollection == null) {
            fileCollection = this.getClassDirs().getAsFileTree().filter(arg_0 -> SpotBugsTask._get_classes_$lambda$0(classes.1.INSTANCE, arg_0));
        }
        return fileCollection;
    }

    public final void setClasses(@Nullable FileCollection fileCollection) {
        this.classes = fileCollection;
    }

    @Internal
    @NotNull
    public abstract ConfigurableFileCollection getPluginJarFiles();

    @Internal
    @NotNull
    public abstract ConfigurableFileCollection getSpotbugsClasspath();

    @Nested
    @Optional
    @NotNull
    public abstract Property<JavaLauncher> getLauncher();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getAnalyseClassFile();

    public final void init(@NotNull SpotBugsExtension extension, boolean enableWorkerApi) {
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        this.getAuxclasspathFile().convention(this.getProject().getLayout().getBuildDirectory().file("spotbugs/auxclasspath/" + this.getName()));
        this.ignoreFailures.convention((Provider)extension.getIgnoreFailures());
        this.getShowStackTraces().convention((Provider)extension.getShowStackTraces());
        this.getShowProgress().convention((Provider)extension.getShowProgress());
        this.getReportLevel().convention((Provider)extension.getReportLevel());
        this.getEffort().convention((Provider)extension.getEffort());
        this.getVisitors().convention((Provider)extension.getVisitors());
        this.getOmitVisitors().convention((Provider)extension.getOmitVisitors());
        this.getReportsDir().convention((Provider)extension.getReportsDir());
        this.getIncludeFilter().convention((Provider)extension.getIncludeFilter());
        this.getExcludeFilter().convention((Provider)extension.getExcludeFilter());
        this.getBaselineFile().convention((Provider)extension.getBaselineFile());
        this.getOnlyAnalyze().convention((Provider)extension.getOnlyAnalyze());
        this.getProjectName().convention(extension.getProjectName().map(arg_0 -> SpotBugsTask.init$lambda$2((Function1)new Function1<String, String>(this){
            final /* synthetic */ SpotBugsTask this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final String invoke(String p) {
                String string = "%s (%s)";
                Object[] objectArray = new Object[]{p, this.this$0.getName()};
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                return string2;
            }
        }, arg_0)));
        this.getRelease().convention((Provider)extension.getRelease());
        this.getJvmArgs().convention((Provider)extension.getJvmArgs());
        this.getExtraArgs().convention((Provider)extension.getExtraArgs());
        this.getMaxHeapSize().convention((Provider)extension.getMaxHeapSize());
        this.getUseAuxclasspathFile().convention((Provider)extension.getUseAuxclasspathFile());
        if (extension.getUseJavaToolchains().isPresent()) {
            Object object = extension.getUseJavaToolchains().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            if (((Boolean)object).booleanValue()) {
                this.configureJavaLauncher();
            }
        }
        this.enableWorkerApi = enableWorkerApi;
        this.getAnalyseClassFile().set(this.getProject().getLayout().getBuildDirectory().file(this.getName() + "-analyse-class-file.txt"));
        Configuration pluginConfiguration = this.getProject().getConfigurations().getByName("spotbugsPlugins");
        Object[] objectArray = new Object[]{this.getProject().provider(() -> SpotBugsTask.init$lambda$3(pluginConfiguration))};
        this.getPluginJarFiles().from(objectArray);
        Configuration configuration = this.getProject().getConfigurations().getByName("spotbugs");
        Configuration spotbugsSlf4j = this.getProject().getConfigurations().getByName("spotbugsSlf4j");
        Object[] objectArray2 = new Object[1];
        Object[] objectArray3 = new Object[]{this.getProject().provider(() -> SpotBugsTask.init$lambda$4(spotbugsSlf4j)), this.getProject().provider(() -> SpotBugsTask.init$lambda$5(configuration))};
        objectArray2[0] = this.getProject().getLayout().files(objectArray3);
        this.getSpotbugsClasspath().from(objectArray2);
    }

    private final void configureJavaLauncher() {
        JavaToolchainSpec toolchain = ((JavaPluginExtension)this.getProject().getExtensions().getByType(JavaPluginExtension.class)).getToolchain();
        JavaToolchainService service = (JavaToolchainService)this.getProject().getExtensions().getByType(JavaToolchainService.class);
        Provider defaultLauncher = service.launcherFor(toolchain);
        this.getLauncher().convention(defaultLauncher);
    }

    @TaskAction
    public final void run() {
        if (this.enableWorkerApi) {
            this.log.info("Running SpotBugs by Gradle no-isolated Worker...");
            new SpotBugsRunnerForHybrid(this.getWorkerExecutor(), this.getLauncher()).run(this);
        } else {
            this.log.info("Running SpotBugs by JavaExec...");
            new SpotBugsRunnerForJavaExec(this.getLauncher()).run(this);
        }
    }

    @NotNull
    public final NamedDomainObjectContainer<SpotBugsReport> reports(@NotNull Action<NamedDomainObjectContainer<SpotBugsReport>> configureAction) {
        Intrinsics.checkNotNullParameter(configureAction, (String)"configureAction");
        configureAction.execute(this.reports);
        return this.reports;
    }

    @Internal
    @NotNull
    public final String getBaseName() {
        StringBuilder stringBuilder;
        String prunedName = null;
        String string = this.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        prunedName = StringsKt.replaceFirst$default((String)string, (String)"spotbugs", (String)"", (boolean)false, (int)4, null);
        if (((CharSequence)prunedName).length() == 0) {
            String string2 = this.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
            prunedName = string2;
        }
        StringBuilder $this$getBaseName_u24lambda_u246 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$getBaseName_u24lambda_u246.append(Character.toLowerCase(prunedName.charAt(0)));
        String string3 = prunedName.substring(1);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        $this$getBaseName_u24lambda_u246.append(string3);
        String string4 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toString(...)");
        return string4;
    }

    @Internal
    @NotNull
    public final Collection<SpotBugsReport> getRequiredReports$spotbugs_gradle_plugin() {
        Collection<SpotBugsReport> collection = this.reports.matching(arg_0 -> SpotBugsTask.getRequiredReports$lambda$7(getRequiredReports.1.INSTANCE, arg_0)).getAsMap().values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        return collection;
    }

    private static final boolean _get_classes_$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final SpotBugsReport _init_$lambda$1(ObjectFactory $objects, SpotBugsTask this$0, String name) {
        SpotBugsReport spotBugsReport;
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        switch (name) {
            case "html": {
                Object[] objectArray = new Object[]{name, $objects, this$0};
                spotBugsReport = (SpotBugsReport)$objects.newInstance(SpotBugsHtmlReport.class, objectArray);
                break;
            }
            case "xml": {
                Object[] objectArray = new Object[]{name, $objects, this$0};
                spotBugsReport = (SpotBugsReport)$objects.newInstance(SpotBugsXmlReport.class, objectArray);
                break;
            }
            case "text": {
                Object[] objectArray = new Object[]{name, $objects, this$0};
                spotBugsReport = (SpotBugsReport)$objects.newInstance(SpotBugsTextReport.class, objectArray);
                break;
            }
            case "sarif": {
                Object[] objectArray = new Object[]{name, $objects, this$0};
                spotBugsReport = (SpotBugsReport)$objects.newInstance(SpotBugsSarifReport.class, objectArray);
                break;
            }
            default: {
                throw new InvalidUserDataException(name + " is invalid as the report name");
            }
        }
        return spotBugsReport;
    }

    private static final String init$lambda$2(Function1 $tmp0, Object in) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(in);
    }

    private static final Set init$lambda$3(Configuration $pluginConfiguration) {
        return $pluginConfiguration.getFiles();
    }

    private static final Set init$lambda$4(Configuration $spotbugsSlf4j) {
        return $spotbugsSlf4j.getFiles();
    }

    private static final Set init$lambda$5(Configuration $configuration) {
        return $configuration.getFiles();
    }

    private static final boolean getRequiredReports$lambda$7(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }
}

