/*
 * Decompiled with CFR 0.152.
 */
package com.github.spotbugs.snom.internal;

import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.jetbrains.annotations.NotNull;

class OutputScanner
extends FilterOutputStream {
    private final ByteArrayOutputStream builder = new ByteArrayOutputStream();
    private boolean failedToReport = false;

    public OutputScanner(OutputStream out) {
        super(out);
    }

    boolean isFailedToReport() {
        return this.failedToReport;
    }

    @Override
    public void write(byte @NotNull [] b, int off, int len) throws IOException {
        super.write(b, off, len);
        this.builder.write(b, off, len);
    }

    @Override
    public void write(int b) throws IOException {
        super.write(b);
        this.builder.write(b);
        if (b == 10) {
            String line = this.builder.toString();
            if (line.contains("Could not generate HTML output")) {
                this.failedToReport = true;
            }
            this.builder.reset();
        }
    }
}

