/*
 * Decompiled with CFR 0.152.
 */
package com.github.spotbugs.snom.internal;

import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class SemanticVersion
implements Comparable<SemanticVersion> {
    private static final Pattern PATTERN = Pattern.compile("^(0|[1-9]\\d*)\\.(0|[1-9]\\d*)\\.(0|[1-9]\\d*)(?:-((?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*)(?:\\.(?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*))*))?(?:\\+([0-9a-zA-Z-]+(?:\\.[0-9a-zA-Z-]+)*))?$");
    private final int major;
    private final int minor;
    private final int patch;

    public SemanticVersion(String version) {
        Matcher matcher = PATTERN.matcher(version);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(version + " is not valid as a semantic version");
        }
        this.major = Integer.parseInt(matcher.group(1), 10);
        this.minor = Integer.parseInt(matcher.group(2), 10);
        this.patch = Integer.parseInt(matcher.group(3), 10);
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPatch() {
        return this.patch;
    }

    @Override
    public int compareTo(SemanticVersion that) {
        return Comparator.comparingInt(SemanticVersion::getMajor).thenComparingInt(SemanticVersion::getMinor).thenComparingInt(SemanticVersion::getPatch).compare(this, that);
    }

    public String toString() {
        return "SemanticVersion(" + this.major + '.' + this.minor + '.' + this.patch + ')';
    }
}

