/*
 * Decompiled with CFR 0.152.
 */
package com.github.spotbugs.snom;

import com.github.spotbugs.snom.SpotBugsBasePlugin;
import com.github.spotbugs.snom.SpotBugsTask;
import com.github.spotbugs.snom.internal.SpotBugsTaskFactory;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpotBugsPlugin
implements Plugin<Project> {
    public static final String CONFIG_NAME = "spotbugs";
    public static final String PLUGINS_CONFIG_NAME = "spotbugsPlugins";
    public static final String SLF4J_CONFIG_NAME = "spotbugsSlf4j";
    public static final String EXTENSION_NAME = "spotbugs";
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public void apply(Project project) {
        project.getPluginManager().apply(SpotBugsBasePlugin.class);
        project.getPluginManager().withPlugin("java-base", javaBase -> {
            this.log.debug("The javaBase plugin has been applied, so making the check task depending on all of SpotBugsTask");
            project.getTasks().named("check").configure(task -> task.dependsOn(new Object[]{project.getTasks().withType(SpotBugsTask.class)}));
        });
        this.createTasks(project);
    }

    private void createTasks(Project project) {
        new SpotBugsTaskFactory().generate(project);
    }
}

