/*
 * Decompiled with CFR 0.152.
 */
package com.github.spotbugs.snom;

import com.github.spotbugs.snom.Confidence;
import com.github.spotbugs.snom.Effort;
import com.github.spotbugs.snom.SpotBugsExtension;
import com.github.spotbugs.snom.SpotBugsPlugin;
import com.github.spotbugs.snom.SpotBugsReport;
import com.github.spotbugs.snom.internal.SpotBugsHtmlReport;
import com.github.spotbugs.snom.internal.SpotBugsRunnerForJavaExec;
import com.github.spotbugs.snom.internal.SpotBugsRunnerForWorker;
import com.github.spotbugs.snom.internal.SpotBugsSarifReport;
import com.github.spotbugs.snom.internal.SpotBugsTextReport;
import com.github.spotbugs.snom.internal.SpotBugsXmlReport;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.io.File;
import java.lang.ref.SoftReference;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.JavaBasePlugin;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.VerificationTask;
import org.gradle.jvm.toolchain.JavaLauncher;
import org.gradle.jvm.toolchain.JavaToolchainService;
import org.gradle.util.ClosureBackedAction;
import org.gradle.workers.WorkerExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@CacheableTask
public abstract class SpotBugsTask
extends DefaultTask
implements VerificationTask,
GroovyObject {
    private static final String FEATURE_FLAG_WORKER_API = "com.github.spotbugs.snom.worker";
    private static final String FEATURE_FLAG_HYBRID_WORKER = "com.github.spotbugs.snom.javaexec-in-worker";
    private final Logger log;
    private final WorkerExecutor workerExecutor;
    @NonNull
    private final Property<Boolean> ignoreFailures;
    @NonNull
    private final Property<Boolean> showStackTraces;
    @Input
    @Optional
    @NonNull
    private final Property<Boolean> showProgress;
    @Input
    @Optional
    @NonNull
    private final Property<Confidence> reportLevel;
    @Input
    @Optional
    @NonNull
    private final Property<Effort> effort;
    @Input
    @NonNull
    private final ListProperty<String> visitors;
    @Input
    @NonNull
    private final ListProperty<String> omitVisitors;
    @org.gradle.api.tasks.Internal(value="Refer the destination of each report instead.")
    @NonNull
    private final DirectoryProperty reportsDir;
    @org.gradle.api.tasks.Internal
    @NonNull
    private final NamedDomainObjectContainer<SpotBugsReport> reports;
    @Optional
    @InputFile
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NonNull
    private final RegularFileProperty includeFilter;
    @Optional
    @InputFile
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NonNull
    private final RegularFileProperty excludeFilter;
    @Optional
    @InputFile
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NonNull
    private final RegularFileProperty baselineFile;
    @Input
    @NonNull
    private final ListProperty<String> onlyAnalyze;
    @org.gradle.api.tasks.Internal
    @NonNull
    private final Property<String> projectName;
    @Input
    @NonNull
    private final Property<String> release;
    @Optional
    @Input
    @NonNull
    private final ListProperty<String> extraArgs;
    @Optional
    @Input
    @NonNull
    private final ListProperty<String> jvmArgs;
    @Optional
    @Input
    @NonNull
    private final Property<String> maxHeapSize;
    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    private FileCollection sourceDirs;
    @org.gradle.api.tasks.Internal
    private FileCollection classDirs;
    @Classpath
    private FileCollection auxClassPaths;
    @Input
    @Optional
    @NonNull
    private final Property<Boolean> useAuxclasspathFile;
    private FileCollection classes;
    private boolean enableWorkerApi;
    private boolean enableHybridWorker;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    private static /* synthetic */ SoftReference $callSiteArray;
    private static /* synthetic */ Class $class$com$github$spotbugs$snom$internal$SpotBugsRunnerForHybrid;

    @Inject
    public SpotBugsTask(ObjectFactory objects, WorkerExecutor workerExecutor) {
        MetaClass metaClass;
        Reference objects2 = new Reference((Object)objects);
        CallSite[] callSiteArray = SpotBugsTask.$getCallSiteArray();
        Object object = callSiteArray[0].call(LoggerFactory.class, SpotBugsTask.class);
        this.log = (Logger)ScriptBytecodeAdapter.castToType((Object)object, Logger.class);
        this.metaClass = metaClass = this.$getStaticMetaClass();
        Object object2 = callSiteArray[1].call(Objects.class, (Object)workerExecutor);
        this.workerExecutor = (WorkerExecutor)ScriptBytecodeAdapter.castToType((Object)object2, WorkerExecutor.class);
        Object object3 = callSiteArray[2].call((Object)((ObjectFactory)objects2.get()));
        this.sourceDirs = (FileCollection)ScriptBytecodeAdapter.castToType((Object)object3, FileCollection.class);
        Object object4 = callSiteArray[3].call((Object)((ObjectFactory)objects2.get()));
        this.auxClassPaths = (FileCollection)ScriptBytecodeAdapter.castToType((Object)object4, FileCollection.class);
        Object object5 = callSiteArray[4].call((Object)((ObjectFactory)objects2.get()), Boolean.class);
        this.ignoreFailures = (Property)ScriptBytecodeAdapter.castToType((Object)object5, Property.class);
        Object object6 = callSiteArray[5].call((Object)((ObjectFactory)objects2.get()), Boolean.class);
        this.showStackTraces = (Property)ScriptBytecodeAdapter.castToType((Object)object6, Property.class);
        Object object7 = callSiteArray[6].call((Object)((ObjectFactory)objects2.get()), Boolean.class);
        this.showProgress = (Property)ScriptBytecodeAdapter.castToType((Object)object7, Property.class);
        Object object8 = callSiteArray[7].call((Object)((ObjectFactory)objects2.get()), Confidence.class);
        this.reportLevel = (Property)ScriptBytecodeAdapter.castToType((Object)object8, Property.class);
        Object object9 = callSiteArray[8].call((Object)((ObjectFactory)objects2.get()), Effort.class);
        this.effort = (Property)ScriptBytecodeAdapter.castToType((Object)object9, Property.class);
        Object object10 = callSiteArray[9].call((Object)((ObjectFactory)objects2.get()), String.class);
        this.visitors = (ListProperty)ScriptBytecodeAdapter.castToType((Object)object10, ListProperty.class);
        Object object11 = callSiteArray[10].call((Object)((ObjectFactory)objects2.get()), String.class);
        this.omitVisitors = (ListProperty)ScriptBytecodeAdapter.castToType((Object)object11, ListProperty.class);
        Object object12 = callSiteArray[11].call((Object)((ObjectFactory)objects2.get()));
        this.reportsDir = (DirectoryProperty)ScriptBytecodeAdapter.castToType((Object)object12, DirectoryProperty.class);
        Object object13 = callSiteArray[12].call((Object)((ObjectFactory)objects2.get()), SpotBugsReport.class, (Object)new _closure1((Object)this, (Object)this, objects2));
        this.reports = (NamedDomainObjectContainer)ScriptBytecodeAdapter.castToType((Object)object13, NamedDomainObjectContainer.class);
        Object object14 = callSiteArray[13].call((Object)((ObjectFactory)objects2.get()));
        this.includeFilter = (RegularFileProperty)ScriptBytecodeAdapter.castToType((Object)object14, RegularFileProperty.class);
        Object object15 = callSiteArray[14].call((Object)((ObjectFactory)objects2.get()));
        this.excludeFilter = (RegularFileProperty)ScriptBytecodeAdapter.castToType((Object)object15, RegularFileProperty.class);
        Object object16 = callSiteArray[15].call((Object)((ObjectFactory)objects2.get()));
        this.baselineFile = (RegularFileProperty)ScriptBytecodeAdapter.castToType((Object)object16, RegularFileProperty.class);
        Object object17 = callSiteArray[16].call((Object)((ObjectFactory)objects2.get()), String.class);
        this.onlyAnalyze = (ListProperty)ScriptBytecodeAdapter.castToType((Object)object17, ListProperty.class);
        Object object18 = callSiteArray[17].call((Object)((ObjectFactory)objects2.get()), String.class);
        this.projectName = (Property)ScriptBytecodeAdapter.castToType((Object)object18, Property.class);
        Object object19 = callSiteArray[18].call((Object)((ObjectFactory)objects2.get()), String.class);
        this.release = (Property)ScriptBytecodeAdapter.castToType((Object)object19, Property.class);
        Object object20 = callSiteArray[19].call((Object)((ObjectFactory)objects2.get()), String.class);
        this.jvmArgs = (ListProperty)ScriptBytecodeAdapter.castToType((Object)object20, ListProperty.class);
        Object object21 = callSiteArray[20].call((Object)((ObjectFactory)objects2.get()), String.class);
        this.extraArgs = (ListProperty)ScriptBytecodeAdapter.castToType((Object)object21, ListProperty.class);
        Object object22 = callSiteArray[21].call((Object)((ObjectFactory)objects2.get()), String.class);
        this.maxHeapSize = (Property)ScriptBytecodeAdapter.castToType((Object)object22, Property.class);
        Object object23 = callSiteArray[22].call((Object)((ObjectFactory)objects2.get()), Boolean.class);
        this.useAuxclasspathFile = (Property)ScriptBytecodeAdapter.castToType((Object)object23, Property.class);
        callSiteArray[23].callCurrent((GroovyObject)this, (Object)"Run SpotBugs analysis.");
        callSiteArray[24].callCurrent((GroovyObject)this, callSiteArray[25].callGetProperty(JavaBasePlugin.class));
    }

    public void setClasses(FileCollection fileCollection) {
        FileCollection fileCollection2;
        CallSite[] callSiteArray = SpotBugsTask.$getCallSiteArray();
        this.classes = fileCollection2 = fileCollection;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @SkipWhenEmpty
    @NonNull
    public FileCollection getClasses() {
        public final class _getClasses_closure2
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _getClasses_closure2(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _getClasses_closure2.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(File file) {
                CallSite[] callSiteArray = _getClasses_closure2.$getCallSiteArray();
                return callSiteArray[0].call(callSiteArray[1].callGetProperty((Object)file), (Object)".class");
            }

            @Generated
            public Object call(File file) {
                CallSite[] callSiteArray = _getClasses_closure2.$getCallSiteArray();
                return callSiteArray[2].callCurrent((GroovyObject)this, (Object)file);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getClasses_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "endsWith";
                stringArray[1] = "name";
                stringArray[2] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[3];
                _getClasses_closure2.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_getClasses_closure2.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _getClasses_closure2.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        CallSite[] callSiteArray = SpotBugsTask.$getCallSiteArray();
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (ScriptBytecodeAdapter.compareEqual((Object)this.classes, null)) {
                if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[26].callCurrent((GroovyObject)this), null)) {
                    throw (Throwable)callSiteArray[27].callConstructor(InvalidUserDataException.class, (Object)"The classDirs property is not set");
                }
                return (FileCollection)ScriptBytecodeAdapter.castToType((Object)callSiteArray[28].call(callSiteArray[29].callGetProperty(callSiteArray[30].callCurrent((GroovyObject)this)), (Object)new _getClasses_closure2((Object)this, (Object)this)), FileCollection.class);
            }
            return this.classes;
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)this.classes, null)) {
            if (ScriptBytecodeAdapter.compareEqual((Object)this.getClassDirs(), null)) {
                throw (Throwable)callSiteArray[31].callConstructor(InvalidUserDataException.class, (Object)"The classDirs property is not set");
            }
            return (FileCollection)ScriptBytecodeAdapter.castToType((Object)callSiteArray[32].call(callSiteArray[33].callGetProperty((Object)this.getClassDirs()), (Object)new _getClasses_closure2((Object)this, (Object)this)), FileCollection.class);
        }
        return this.classes;
    }

    @Nested
    @Optional
    public abstract Property<JavaLauncher> getLauncher();

    public void init(SpotBugsExtension extension, boolean enableWorkerApi, boolean enableHybridWorker) {
        boolean bl;
        boolean bl2;
        CallSite[] callSiteArray = SpotBugsTask.$getCallSiteArray();
        callSiteArray[34].call(this.ignoreFailures, callSiteArray[35].callGroovyObjectGetProperty((Object)extension));
        callSiteArray[36].call(this.showStackTraces, callSiteArray[37].callGroovyObjectGetProperty((Object)extension));
        callSiteArray[38].call(this.showProgress, callSiteArray[39].callGroovyObjectGetProperty((Object)extension));
        callSiteArray[40].call(this.reportLevel, callSiteArray[41].callGroovyObjectGetProperty((Object)extension));
        callSiteArray[42].call(this.effort, callSiteArray[43].callGroovyObjectGetProperty((Object)extension));
        callSiteArray[44].call(this.visitors, callSiteArray[45].callGroovyObjectGetProperty((Object)extension));
        callSiteArray[46].call(this.omitVisitors, callSiteArray[47].callGroovyObjectGetProperty((Object)extension));
        callSiteArray[48].call((Object)this.reportsDir, callSiteArray[49].callGroovyObjectGetProperty((Object)extension));
        callSiteArray[50].call((Object)this.includeFilter, callSiteArray[51].callGroovyObjectGetProperty((Object)extension));
        callSiteArray[52].call((Object)this.excludeFilter, callSiteArray[53].callGroovyObjectGetProperty((Object)extension));
        callSiteArray[54].call((Object)this.baselineFile, callSiteArray[55].callGroovyObjectGetProperty((Object)extension));
        callSiteArray[56].call(this.onlyAnalyze, callSiteArray[57].callGroovyObjectGetProperty((Object)extension));
        public final class _init_closure3
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _init_closure3(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _init_closure3.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object p) {
                CallSite[] callSiteArray = _init_closure3.$getCallSiteArray();
                return callSiteArray[0].call(String.class, (Object)"%s (%s)", p, callSiteArray[1].callCurrent((GroovyObject)this));
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _init_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "format";
                stringArray[1] = "getName";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                _init_closure3.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_init_closure3.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _init_closure3.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[58].call(this.projectName, callSiteArray[59].call(callSiteArray[60].callGroovyObjectGetProperty((Object)extension), (Object)new _init_closure3((Object)this, (Object)this)));
        callSiteArray[61].call(this.release, callSiteArray[62].callGroovyObjectGetProperty((Object)extension));
        callSiteArray[63].call(this.jvmArgs, callSiteArray[64].callGroovyObjectGetProperty((Object)extension));
        callSiteArray[65].call(this.extraArgs, callSiteArray[66].callGroovyObjectGetProperty((Object)extension));
        callSiteArray[67].call(this.maxHeapSize, callSiteArray[68].callGroovyObjectGetProperty((Object)extension));
        callSiteArray[69].call(this.useAuxclasspathFile, callSiteArray[70].callGroovyObjectGetProperty((Object)extension));
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[71].call(callSiteArray[72].callGroovyObjectGetProperty((Object)extension))) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[73].call(callSiteArray[74].callGroovyObjectGetProperty((Object)extension)))) {
                callSiteArray[75].callCurrent((GroovyObject)this);
            }
        } else if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[76].call(callSiteArray[77].callGroovyObjectGetProperty((Object)extension))) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[78].call(callSiteArray[79].callGroovyObjectGetProperty((Object)extension)))) {
            this.configureJavaLauncher();
        }
        this.enableWorkerApi = bl2 = enableWorkerApi;
        this.enableHybridWorker = bl = enableHybridWorker;
    }

    private void configureJavaLauncher() {
        CallSite[] callSiteArray = SpotBugsTask.$getCallSiteArray();
        Object toolchain = callSiteArray[80].callGetProperty(callSiteArray[81].call(callSiteArray[82].call(callSiteArray[83].callGroovyObjectGetProperty((Object)this)), JavaPluginExtension.class));
        JavaToolchainService service = (JavaToolchainService)ScriptBytecodeAdapter.castToType((Object)callSiteArray[84].call(callSiteArray[85].call(callSiteArray[86].callGroovyObjectGetProperty((Object)this)), JavaToolchainService.class), JavaToolchainService.class);
        Provider defaultLauncher = (Provider)ScriptBytecodeAdapter.castToType((Object)callSiteArray[87].call((Object)service, toolchain), Provider.class);
        callSiteArray[88].call(callSiteArray[89].callGroovyObjectGetProperty((Object)this), (Object)defaultLauncher);
    }

    @TaskAction
    public void run() {
        CallSite[] callSiteArray = SpotBugsTask.$getCallSiteArray();
        if (!this.enableWorkerApi) {
            callSiteArray[90].call((Object)this.log, (Object)"Running SpotBugs by JavaExec...");
            callSiteArray[91].call(callSiteArray[92].callConstructor(SpotBugsRunnerForJavaExec.class, callSiteArray[93].callGroovyObjectGetProperty((Object)this)), (Object)this);
        } else if (this.enableHybridWorker) {
            callSiteArray[94].call((Object)this.log, (Object)"Running SpotBugs by Gradle no-isolated Worker...");
            callSiteArray[95].call(callSiteArray[96].callConstructor((Object)SpotBugsTask.$get$$class$com$github$spotbugs$snom$internal$SpotBugsRunnerForHybrid(), (Object)this.workerExecutor, callSiteArray[97].callGroovyObjectGetProperty((Object)this)), (Object)this);
        } else {
            callSiteArray[98].call((Object)this.log, (Object)"Running SpotBugs by Gradle process-isolated Worker...");
            callSiteArray[99].call(callSiteArray[100].callConstructor(SpotBugsRunnerForWorker.class, (Object)this.workerExecutor, callSiteArray[101].callGroovyObjectGetProperty((Object)this)), (Object)this);
        }
    }

    public final NamedDomainObjectContainer<? extends SpotBugsReport> reports(Closure<NamedDomainObjectContainer<? extends SpotBugsReport>> closure) {
        CallSite[] callSiteArray = SpotBugsTask.$getCallSiteArray();
        return (NamedDomainObjectContainer)ScriptBytecodeAdapter.castToType((Object)callSiteArray[102].callCurrent((GroovyObject)this, callSiteArray[103].callConstructor(ClosureBackedAction.class, closure)), NamedDomainObjectContainer.class);
    }

    public final NamedDomainObjectContainer<? extends SpotBugsReport> reports(Action<NamedDomainObjectContainer<? extends SpotBugsReport>> configureAction) {
        CallSite[] callSiteArray = SpotBugsTask.$getCallSiteArray();
        callSiteArray[104].call(configureAction, this.reports);
        return this.reports;
    }

    @org.gradle.api.tasks.Internal
    @NonNull
    public Set<File> getPluginJar() {
        CallSite[] callSiteArray = SpotBugsTask.$getCallSiteArray();
        return (Set)ScriptBytecodeAdapter.castToType((Object)callSiteArray[105].call(callSiteArray[106].call(callSiteArray[107].call(callSiteArray[108].callCurrent((GroovyObject)this)), callSiteArray[109].callGetProperty(SpotBugsPlugin.class))), Set.class);
    }

    @org.gradle.api.tasks.Internal
    @NonNull
    public FileCollection getSpotbugsClasspath() {
        CallSite[] callSiteArray = SpotBugsTask.$getCallSiteArray();
        Configuration config = (Configuration)ScriptBytecodeAdapter.castToType((Object)callSiteArray[110].call(callSiteArray[111].call(callSiteArray[112].callCurrent((GroovyObject)this)), callSiteArray[113].callGetProperty(SpotBugsPlugin.class)), Configuration.class);
        Configuration spotbugsSlf4j = (Configuration)ScriptBytecodeAdapter.castToType((Object)callSiteArray[114].call(callSiteArray[115].call(callSiteArray[116].callCurrent((GroovyObject)this)), callSiteArray[117].callGetProperty(SpotBugsPlugin.class)), Configuration.class);
        return (FileCollection)ScriptBytecodeAdapter.castToType((Object)callSiteArray[118].call(callSiteArray[119].callCurrent((GroovyObject)this), (Object)config, (Object)spotbugsSlf4j), FileCollection.class);
    }

    @Optional
    @Nested
    @Nullable
    public SpotBugsReport getFirstEnabledReport() {
        CallSite[] callSiteArray = SpotBugsTask.$getCallSiteArray();
        public final class _getFirstEnabledReport_closure4
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _getFirstEnabledReport_closure4(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _getFirstEnabledReport_closure4.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object report) {
                CallSite[] callSiteArray = _getFirstEnabledReport_closure4.$getCallSiteArray();
                return DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[0].callGetProperty(report)) || DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[1].callGetProperty(report));
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getFirstEnabledReport_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "enabled";
                stringArray[1] = "required";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                _getFirstEnabledReport_closure4.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_getFirstEnabledReport_closure4.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _getFirstEnabledReport_closure4.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        java.util.Optional report = (java.util.Optional)ScriptBytecodeAdapter.castToType((Object)callSiteArray[120].call(callSiteArray[121].call(callSiteArray[122].call(this.reports), (Object)new _getFirstEnabledReport_closure4((Object)this, (Object)this))), java.util.Optional.class);
        return (SpotBugsReport)ScriptBytecodeAdapter.castToType((Object)callSiteArray[123].call((Object)report, null), SpotBugsReport.class);
    }

    @Optional
    @Nested
    @NonNull
    public Set<SpotBugsReport> getEnabledReports() {
        CallSite[] callSiteArray = SpotBugsTask.$getCallSiteArray();
        public final class _getEnabledReports_closure5
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _getEnabledReports_closure5(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _getEnabledReports_closure5.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _getEnabledReports_closure5.$getCallSiteArray();
                return callSiteArray[0].callGetProperty(it);
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _getEnabledReports_closure5.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getEnabledReports_closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "enabled";
                return new CallSiteArray(_getEnabledReports_closure5.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _getEnabledReports_closure5.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (Set)ScriptBytecodeAdapter.castToType((Object)callSiteArray[124].call(this.reports, (Object)new _getEnabledReports_closure5((Object)this, (Object)this)), Set.class);
    }

    public void setReportLevel(@Nullable String name) {
        CallSite[] callSiteArray = SpotBugsTask.$getCallSiteArray();
        Confidence confidence = (Confidence)ShortTypeHandling.castToEnum(ScriptBytecodeAdapter.compareEqual((Object)name, null) ? null : callSiteArray[125].call(Confidence.class, callSiteArray[126].call((Object)name)), Confidence.class);
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[127].call(callSiteArray[128].callCurrent((GroovyObject)this), (Object)confidence);
        } else {
            callSiteArray[129].call(this.getReportLevel(), (Object)confidence);
        }
    }

    public void setEffort(@Nullable String name) {
        CallSite[] callSiteArray = SpotBugsTask.$getCallSiteArray();
        Effort effort = (Effort)ShortTypeHandling.castToEnum(ScriptBytecodeAdapter.compareEqual((Object)name, null) ? null : callSiteArray[130].call(Effort.class, callSiteArray[131].call((Object)name)), Effort.class);
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[132].call(callSiteArray[133].callCurrent((GroovyObject)this), (Object)effort);
        } else {
            callSiteArray[134].call(this.getEffort(), (Object)effort);
        }
    }

    public void setIgnoreFailures(Provider<Boolean> b) {
        CallSite[] callSiteArray = SpotBugsTask.$getCallSiteArray();
        callSiteArray[135].call(this.ignoreFailures, b);
    }

    public void setIgnoreFailures(boolean b) {
        CallSite[] callSiteArray = SpotBugsTask.$getCallSiteArray();
        callSiteArray[136].call(this.ignoreFailures, (Object)b);
    }

    public void setShowStackTraces(Provider<Boolean> b) {
        CallSite[] callSiteArray = SpotBugsTask.$getCallSiteArray();
        callSiteArray[137].call(this.showStackTraces, b);
    }

    public void setShowStackTraces(boolean b) {
        CallSite[] callSiteArray = SpotBugsTask.$getCallSiteArray();
        callSiteArray[138].call(this.showStackTraces, (Object)b);
    }

    @Input
    public boolean getIgnoreFailures() {
        CallSite[] callSiteArray = SpotBugsTask.$getCallSiteArray();
        return DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[139].call(this.ignoreFailures));
    }

    @Input
    public boolean getShowStackTraces() {
        CallSite[] callSiteArray = SpotBugsTask.$getCallSiteArray();
        return DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[140].call(this.showStackTraces));
    }

    @org.gradle.api.tasks.Internal
    public String getBaseName() {
        CallSite[] callSiteArray = SpotBugsTask.$getCallSiteArray();
        String prunedName = ShortTypeHandling.castToString((Object)callSiteArray[141].call(callSiteArray[142].callGroovyObjectGetProperty((Object)this), (Object)"spotbugs", (Object)""));
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[143].call((Object)prunedName))) {
            Object object = callSiteArray[144].call(callSiteArray[145].callGroovyObjectGetProperty((Object)this));
            prunedName = ShortTypeHandling.castToString((Object)object);
        }
        return ShortTypeHandling.castToString((Object)callSiteArray[146].call(callSiteArray[147].call(callSiteArray[148].call(callSiteArray[149].callConstructor(StringBuilder.class), callSiteArray[150].call(Character.class, callSiteArray[151].call((Object)prunedName, (Object)0))), callSiteArray[152].call((Object)prunedName, (Object)1))));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != SpotBugsTask.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    public final Property<Boolean> getShowProgress() {
        return this.showProgress;
    }

    @Generated
    public final Property<Confidence> getReportLevel() {
        return this.reportLevel;
    }

    @Generated
    public final Property<Effort> getEffort() {
        return this.effort;
    }

    @Generated
    public final ListProperty<String> getVisitors() {
        return this.visitors;
    }

    @Generated
    public final ListProperty<String> getOmitVisitors() {
        return this.omitVisitors;
    }

    @Generated
    public final DirectoryProperty getReportsDir() {
        return this.reportsDir;
    }

    @Generated
    public final NamedDomainObjectContainer<SpotBugsReport> getReports() {
        return this.reports;
    }

    @Generated
    public final RegularFileProperty getIncludeFilter() {
        return this.includeFilter;
    }

    @Generated
    public final RegularFileProperty getExcludeFilter() {
        return this.excludeFilter;
    }

    @Generated
    public final RegularFileProperty getBaselineFile() {
        return this.baselineFile;
    }

    @Generated
    public final ListProperty<String> getOnlyAnalyze() {
        return this.onlyAnalyze;
    }

    @Generated
    public final Property<String> getProjectName() {
        return this.projectName;
    }

    @Generated
    public final Property<String> getRelease() {
        return this.release;
    }

    @Generated
    public final ListProperty<String> getExtraArgs() {
        return this.extraArgs;
    }

    @Generated
    public final ListProperty<String> getJvmArgs() {
        return this.jvmArgs;
    }

    @Generated
    public final Property<String> getMaxHeapSize() {
        return this.maxHeapSize;
    }

    @Generated
    public FileCollection getSourceDirs() {
        return this.sourceDirs;
    }

    @Generated
    public void setSourceDirs(FileCollection fileCollection) {
        this.sourceDirs = fileCollection;
    }

    @Generated
    public FileCollection getClassDirs() {
        return this.classDirs;
    }

    @Generated
    public void setClassDirs(FileCollection fileCollection) {
        this.classDirs = fileCollection;
    }

    @Generated
    public FileCollection getAuxClassPaths() {
        return this.auxClassPaths;
    }

    @Generated
    public void setAuxClassPaths(FileCollection fileCollection) {
        this.auxClassPaths = fileCollection;
    }

    @Generated
    public final Property<Boolean> getUseAuxclasspathFile() {
        return this.useAuxclasspathFile;
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "getLogger";
        stringArray[1] = "requireNonNull";
        stringArray[2] = "fileCollection";
        stringArray[3] = "fileCollection";
        stringArray[4] = "property";
        stringArray[5] = "property";
        stringArray[6] = "property";
        stringArray[7] = "property";
        stringArray[8] = "property";
        stringArray[9] = "listProperty";
        stringArray[10] = "listProperty";
        stringArray[11] = "directoryProperty";
        stringArray[12] = "domainObjectContainer";
        stringArray[13] = "fileProperty";
        stringArray[14] = "fileProperty";
        stringArray[15] = "fileProperty";
        stringArray[16] = "listProperty";
        stringArray[17] = "property";
        stringArray[18] = "property";
        stringArray[19] = "listProperty";
        stringArray[20] = "listProperty";
        stringArray[21] = "property";
        stringArray[22] = "property";
        stringArray[23] = "setDescription";
        stringArray[24] = "setGroup";
        stringArray[25] = "VERIFICATION_GROUP";
        stringArray[26] = "getClassDirs";
        stringArray[27] = "<$constructor$>";
        stringArray[28] = "filter";
        stringArray[29] = "asFileTree";
        stringArray[30] = "getClassDirs";
        stringArray[31] = "<$constructor$>";
        stringArray[32] = "filter";
        stringArray[33] = "asFileTree";
        stringArray[34] = "convention";
        stringArray[35] = "ignoreFailures";
        stringArray[36] = "convention";
        stringArray[37] = "showStackTraces";
        stringArray[38] = "convention";
        stringArray[39] = "showProgress";
        stringArray[40] = "convention";
        stringArray[41] = "reportLevel";
        stringArray[42] = "convention";
        stringArray[43] = "effort";
        stringArray[44] = "convention";
        stringArray[45] = "visitors";
        stringArray[46] = "convention";
        stringArray[47] = "omitVisitors";
        stringArray[48] = "convention";
        stringArray[49] = "reportsDir";
        stringArray[50] = "convention";
        stringArray[51] = "includeFilter";
        stringArray[52] = "convention";
        stringArray[53] = "excludeFilter";
        stringArray[54] = "convention";
        stringArray[55] = "baselineFile";
        stringArray[56] = "convention";
        stringArray[57] = "onlyAnalyze";
        stringArray[58] = "convention";
        stringArray[59] = "map";
        stringArray[60] = "projectName";
        stringArray[61] = "convention";
        stringArray[62] = "release";
        stringArray[63] = "convention";
        stringArray[64] = "jvmArgs";
        stringArray[65] = "convention";
        stringArray[66] = "extraArgs";
        stringArray[67] = "convention";
        stringArray[68] = "maxHeapSize";
        stringArray[69] = "convention";
        stringArray[70] = "useAuxclasspathFile";
        stringArray[71] = "isPresent";
        stringArray[72] = "useJavaToolchains";
        stringArray[73] = "get";
        stringArray[74] = "useJavaToolchains";
        stringArray[75] = "configureJavaLauncher";
        stringArray[76] = "isPresent";
        stringArray[77] = "useJavaToolchains";
        stringArray[78] = "get";
        stringArray[79] = "useJavaToolchains";
        stringArray[80] = "toolchain";
        stringArray[81] = "getByType";
        stringArray[82] = "getExtensions";
        stringArray[83] = "project";
        stringArray[84] = "getByType";
        stringArray[85] = "getExtensions";
        stringArray[86] = "project";
        stringArray[87] = "launcherFor";
        stringArray[88] = "convention";
        stringArray[89] = "launcher";
        stringArray[90] = "info";
        stringArray[91] = "run";
        stringArray[92] = "<$constructor$>";
        stringArray[93] = "launcher";
        stringArray[94] = "info";
        stringArray[95] = "run";
        stringArray[96] = "<$constructor$>";
        stringArray[97] = "launcher";
        stringArray[98] = "info";
        stringArray[99] = "run";
        stringArray[100] = "<$constructor$>";
        stringArray[101] = "launcher";
        stringArray[102] = "reports";
        stringArray[103] = "<$constructor$>";
        stringArray[104] = "execute";
        stringArray[105] = "getFiles";
        stringArray[106] = "getByName";
        stringArray[107] = "getConfigurations";
        stringArray[108] = "getProject";
        stringArray[109] = "PLUGINS_CONFIG_NAME";
        stringArray[110] = "getByName";
        stringArray[111] = "getConfigurations";
        stringArray[112] = "getProject";
        stringArray[113] = "CONFIG_NAME";
        stringArray[114] = "getByName";
        stringArray[115] = "getConfigurations";
        stringArray[116] = "getProject";
        stringArray[117] = "SLF4J_CONFIG_NAME";
        stringArray[118] = "files";
        stringArray[119] = "getProject";
        stringArray[120] = "findFirst";
        stringArray[121] = "filter";
        stringArray[122] = "stream";
        stringArray[123] = "orElse";
        stringArray[124] = "findAll";
        stringArray[125] = "valueOf";
        stringArray[126] = "toUpperCase";
        stringArray[127] = "set";
        stringArray[128] = "getReportLevel";
        stringArray[129] = "set";
        stringArray[130] = "valueOf";
        stringArray[131] = "toUpperCase";
        stringArray[132] = "set";
        stringArray[133] = "getEffort";
        stringArray[134] = "set";
        stringArray[135] = "set";
        stringArray[136] = "set";
        stringArray[137] = "set";
        stringArray[138] = "set";
        stringArray[139] = "get";
        stringArray[140] = "get";
        stringArray[141] = "replaceFirst";
        stringArray[142] = "name";
        stringArray[143] = "isEmpty";
        stringArray[144] = "getName";
        stringArray[145] = "task";
        stringArray[146] = "toString";
        stringArray[147] = "append";
        stringArray[148] = "append";
        stringArray[149] = "<$constructor$>";
        stringArray[150] = "toLowerCase";
        stringArray[151] = "charAt";
        stringArray[152] = "substring";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[153];
        SpotBugsTask.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(SpotBugsTask.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = SpotBugsTask.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }

    private static /* synthetic */ Class $get$$class$com$github$spotbugs$snom$internal$SpotBugsRunnerForHybrid() {
        Class clazz = $class$com$github$spotbugs$snom$internal$SpotBugsRunnerForHybrid;
        if (clazz == null) {
            clazz = $class$com$github$spotbugs$snom$internal$SpotBugsRunnerForHybrid = SpotBugsTask.class$("com.github.spotbugs.snom.internal.SpotBugsRunnerForHybrid");
        }
        return clazz;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public final class _closure1
    extends Closure
    implements GeneratedClosure {
        private /* synthetic */ Reference objects;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private static /* synthetic */ SoftReference $callSiteArray;

        public _closure1(Object _outerInstance, Object _thisObject, Reference objects) {
            Reference reference;
            CallSite[] callSiteArray = _closure1.$getCallSiteArray();
            super(_outerInstance, _thisObject);
            this.objects = reference = objects;
        }

        public Object doCall(Object name) {
            CallSite[] callSiteArray = _closure1.$getCallSiteArray();
            Object object = name;
            if (ScriptBytecodeAdapter.isCase((Object)object, (Object)"html")) {
                return callSiteArray[0].call(this.objects.get(), SpotBugsHtmlReport.class, this.objects.get(), this.getThisObject());
            }
            if (ScriptBytecodeAdapter.isCase((Object)object, (Object)"xml")) {
                return callSiteArray[1].call(this.objects.get(), SpotBugsXmlReport.class, this.objects.get(), this.getThisObject());
            }
            if (ScriptBytecodeAdapter.isCase((Object)object, (Object)"text")) {
                return callSiteArray[2].call(this.objects.get(), SpotBugsTextReport.class, this.objects.get(), this.getThisObject());
            }
            if (ScriptBytecodeAdapter.isCase((Object)object, (Object)"sarif")) {
                return callSiteArray[3].call(this.objects.get(), SpotBugsSarifReport.class, this.objects.get(), this.getThisObject());
            }
            throw (Throwable)callSiteArray[4].callConstructor(InvalidUserDataException.class, callSiteArray[5].call(name, (Object)" is invalid as the report name"));
        }

        @Generated
        public ObjectFactory getObjects() {
            CallSite[] callSiteArray = _closure1.$getCallSiteArray();
            return (ObjectFactory)ScriptBytecodeAdapter.castToType((Object)this.objects.get(), ObjectFactory.class);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != _closure1.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }

        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
            stringArray[0] = "newInstance";
            stringArray[1] = "newInstance";
            stringArray[2] = "newInstance";
            stringArray[3] = "newInstance";
            stringArray[4] = "<$constructor$>";
            stringArray[5] = "plus";
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[6];
            _closure1.$createCallSiteArray_1(stringArray);
            return new CallSiteArray(_closure1.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = _closure1.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }
}

