/*
 * Decompiled with CFR 0.152.
 */
package com.github.spotbugs.snom.internal;

import com.github.spotbugs.snom.SpotBugsReport;
import com.github.spotbugs.snom.SpotBugsTask;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.File;
import javax.inject.Inject;
import org.gradle.api.file.RegularFile;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Provider;

public abstract class SpotBugsTextReport
extends SpotBugsReport {
    @Inject
    public SpotBugsTextReport(ObjectFactory objects, SpotBugsTask task) {
        super(objects, task);
        this.setDestination((Provider<File>)task.getReportsDir().file(task.getBaseName() + ".txt").map(RegularFile::getAsFile));
    }

    @Override
    @NonNull
    public String toCommandLineOption() {
        return "-sortByClass";
    }

    public String getName() {
        return "TEXT";
    }

    @Override
    public String getDisplayName() {
        return String.format("Text type report generated by the task %s", this.getTask().getPath());
    }
}

