/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.ast;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.Expression;
import com.github.sommeri.less4j.core.ast.InterpolableName;
import com.github.sommeri.less4j.core.ast.ListExpressionOperator;
import com.github.sommeri.less4j.core.ast.annotations.NotAstProperty;
import com.github.sommeri.less4j.core.parser.HiddenTokenAwareTree;
import com.github.sommeri.less4j.utils.ArraysUtils;
import java.util.List;

public class Declaration
extends ASTCssNode {
    private InterpolableName name;
    private Expression expression;
    private boolean important;
    private ListExpressionOperator.Operator mergeOperator;

    public Declaration(HiddenTokenAwareTree token, InterpolableName name) {
        this(token, name, null, false, null);
    }

    public Declaration(HiddenTokenAwareTree token, InterpolableName name, Expression expression, ListExpressionOperator.Operator mergeOperator) {
        this(token, name, expression, false, mergeOperator);
    }

    public Declaration(HiddenTokenAwareTree token, InterpolableName name, Expression expression, boolean important, ListExpressionOperator.Operator mergeOperator) {
        super(token);
        this.name = name;
        this.expression = expression;
        this.important = important;
        this.mergeOperator = mergeOperator;
    }

    public String getNameAsString() {
        return this.name.getName();
    }

    public Expression getExpression() {
        return this.expression;
    }

    public boolean isImportant() {
        return this.important;
    }

    public boolean isMerging() {
        return this.mergeOperator != null;
    }

    public void setName(InterpolableName name) {
        this.name = name;
    }

    public void setExpression(Expression expression) {
        this.expression = expression;
    }

    public void setImportant(boolean important) {
        this.important = important;
    }

    public ListExpressionOperator.Operator getMergeOperator() {
        return this.mergeOperator;
    }

    public void setMergeOperator(ListExpressionOperator.Operator mergeOperator) {
        this.mergeOperator = mergeOperator;
    }

    @Override
    public ASTCssNodeType getType() {
        return ASTCssNodeType.DECLARATION;
    }

    @Override
    @NotAstProperty
    public List<? extends ASTCssNode> getChilds() {
        return ArraysUtils.asNonNullList(this.expression, this.name);
    }

    public boolean isFontDeclaration() {
        return this.getNameAsString() != null ? this.getNameAsString().toLowerCase().equals("font") : false;
    }

    public boolean isFilterDeclaration() {
        return this.getNameAsString() != null ? this.getNameAsString().toLowerCase().endsWith("filter") : false;
    }

    public String toString() {
        return "" + this.name + ":" + this.expression;
    }

    @Override
    public Declaration clone() {
        Declaration result = (Declaration)super.clone();
        result.name = this.name == null ? null : this.name.clone();
        result.expression = this.expression == null ? null : this.expression.clone();
        result.configureParentToAllChilds();
        return result;
    }
}

