/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.scopes.local;

import com.github.sommeri.less4j.core.ast.AbstractVariableDeclaration;
import com.github.sommeri.less4j.core.ast.Expression;
import com.github.sommeri.less4j.core.compiler.expressions.ExpressionFilter;
import com.github.sommeri.less4j.core.compiler.scopes.local.KeyValueStorage;
import java.util.Map;
import java.util.Set;

public class VariablesDeclarationsStorage
implements Cloneable {
    private KeyValueStorage<String, Expression> coolStorage = new KeyValueStorage();

    public Expression getValue(String name) {
        return this.coolStorage.getValue(name);
    }

    public void remove(String name) {
        this.coolStorage.remove(name);
    }

    public void store(AbstractVariableDeclaration node) {
        this.store(node.getVariable().getName(), node.getValue());
    }

    public void storeAll(VariablesDeclarationsStorage otherStorage) {
        this.coolStorage.add(otherStorage.coolStorage);
    }

    public void store(AbstractVariableDeclaration node, Expression replacementValue) {
        this.store(node.getVariable().getName(), replacementValue);
    }

    public void store(String name, Expression replacementValue) {
        this.coolStorage.add(name, replacementValue);
    }

    public void storeIfNotPresent(String name, Expression replacementValue) {
        if (!this.contains(name)) {
            this.store(name, replacementValue);
        }
    }

    public void closePlaceholder() {
        this.coolStorage.closeFirstPlaceholder();
    }

    public void addFilteredVariables(ExpressionFilter filter, VariablesDeclarationsStorage variablesSource) {
        for (Map.Entry<String, Expression> entry : variablesSource.coolStorage.getAllEntries()) {
            Expression value;
            String name = entry.getKey();
            if (!filter.accepts(name, value = entry.getValue())) continue;
            this.store(name, filter.apply(value));
        }
    }

    protected boolean contains(String name) {
        return this.coolStorage.contains(name);
    }

    public int size() {
        return this.coolStorage.size();
    }

    public VariablesPlaceholder createPlaceholder() {
        return new VariablesPlaceholder(this.coolStorage.createPlaceholder());
    }

    public void addToFirstPlaceholderIfNotPresent(VariablesDeclarationsStorage otherStorage) {
        Set<Map.Entry<String, Expression>> otherVariables = otherStorage.coolStorage.getAllEntries();
        for (Map.Entry<String, Expression> entry : otherVariables) {
            if (this.contains(entry.getKey())) continue;
            this.coolStorage.addToFirstPlaceholder(entry.getKey(), entry.getValue());
        }
    }

    public void replacePlaceholder(VariablesPlaceholder placeholder, VariablesDeclarationsStorage otherStorage) {
        this.coolStorage.replacePlaceholder(placeholder.coolPlaceholder, otherStorage.coolStorage);
    }

    public VariablesDeclarationsStorage clone() {
        try {
            VariablesDeclarationsStorage clone = (VariablesDeclarationsStorage)super.clone();
            clone.coolStorage = this.coolStorage.clone();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Impossible state.");
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder(this.getClass().getSimpleName()).append("\n");
        result.append("Variables: ").append(this.coolStorage);
        return result.toString();
    }

    public static class VariablesPlaceholder {
        private final KeyValueStorage.ValuePlaceholder<String, Expression> coolPlaceholder;

        public VariablesPlaceholder(KeyValueStorage.ValuePlaceholder<String, Expression> coolPlaceholder) {
            this.coolPlaceholder = coolPlaceholder;
        }
    }
}

