/*
 * Decompiled with CFR 0.152.
 */
package com.softrunapps.paginatedrecyclerview;

import android.app.Activity;
import android.content.Context;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class PaginatedAdapter<ITEM, VH extends RecyclerView.ViewHolder>
extends RecyclerView.Adapter<VH> {
    private List<ITEM> mDataSet = new ArrayList<ITEM>();
    private OnPaginationListener mListener;
    private int mStartPage = 1;
    private int mCurrentPage = 1;
    private int mPageSize = 10;
    private RecyclerView mRecyclerView;
    private boolean loadingNewItems = true;

    @NonNull
    public abstract VH onCreateViewHolder(@NonNull ViewGroup var1, int var2);

    public abstract void onBindViewHolder(@NonNull VH var1, int var2);

    public int getItemCount() {
        return this.mDataSet.size();
    }

    public void submitItems(Collection<? extends ITEM> collection) {
        this.mDataSet.addAll(collection);
        this.notifyDataSetChanged();
        if (this.mListener != null) {
            this.mListener.onCurrentPage(this.mCurrentPage);
            if (collection.size() == this.mPageSize) {
                this.loadingNewItems = false;
            } else {
                this.mListener.onFinish();
            }
        }
    }

    public void submitItem(ITEM item) {
        this.mDataSet.add(item);
        this.notifyDataSetChanged();
    }

    public void submitItem(ITEM item, int position) {
        this.mDataSet.add(position, item);
        this.notifyDataSetChanged();
    }

    public void clear() {
        this.mDataSet.clear();
        this.notifyDataSetChanged();
    }

    protected ITEM getItem(int position) {
        return this.mDataSet.get(position);
    }

    public void setStartPage(int mFirstPage) {
        this.mStartPage = mFirstPage;
        this.mCurrentPage = mFirstPage;
    }

    public int getStartPage() {
        return this.mStartPage;
    }

    public int getCurrentPage() {
        return this.mCurrentPage;
    }

    public RecyclerView getRecyclerView() {
        return this.mRecyclerView;
    }

    public void setRecyclerView(RecyclerView recyclerView) {
        this.mRecyclerView = recyclerView;
        this.initPaginating();
        this.setAdapter();
    }

    public void setDefaultRecyclerView(Activity activity, int recyclerViewId) {
        RecyclerView recyclerView = (RecyclerView)activity.findViewById(recyclerViewId);
        recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)activity));
        recyclerView.setHasFixedSize(true);
        this.mRecyclerView = recyclerView;
        this.initPaginating();
        this.setAdapter();
    }

    private void setAdapter() {
        this.mRecyclerView.setAdapter((RecyclerView.Adapter)this);
    }

    public void setPageSize(int pageSize) {
        this.mPageSize = pageSize;
    }

    private void initPaginating() {
        this.mRecyclerView.addOnScrollListener(new RecyclerView.OnScrollListener(){

            public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
                super.onScrollStateChanged(recyclerView, newState);
            }

            public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
                boolean endHasBeenReached;
                super.onScrolled(recyclerView, dx, dy);
                LinearLayoutManager layoutManager = (LinearLayoutManager)LinearLayoutManager.class.cast(recyclerView.getLayoutManager());
                int totalItemCount = layoutManager.getItemCount();
                int lastVisible = layoutManager.findLastVisibleItemPosition();
                boolean bl = endHasBeenReached = lastVisible + 2 >= totalItemCount;
                if (totalItemCount > 0 && endHasBeenReached && PaginatedAdapter.this.mListener != null && !PaginatedAdapter.this.loadingNewItems) {
                    PaginatedAdapter.this.loadingNewItems = true;
                    PaginatedAdapter.this.mListener.onNextPage(++PaginatedAdapter.this.mCurrentPage);
                }
            }
        });
    }

    public void setOnPaginationListener(OnPaginationListener onPaginationListener) {
        this.mListener = onPaginationListener;
    }

    public static interface OnPaginationListener {
        public void onCurrentPage(int var1);

        public void onNextPage(int var1);

        public void onFinish();
    }
}

