/*
 * Decompiled with CFR 0.152.
 */
package com.smarteist.autoimageslider.IndicatorView.draw.drawer;

import android.graphics.Canvas;
import android.graphics.Paint;
import androidx.annotation.NonNull;
import com.smarteist.autoimageslider.IndicatorView.animation.data.Value;
import com.smarteist.autoimageslider.IndicatorView.draw.data.Indicator;
import com.smarteist.autoimageslider.IndicatorView.draw.drawer.type.BasicDrawer;
import com.smarteist.autoimageslider.IndicatorView.draw.drawer.type.ColorDrawer;
import com.smarteist.autoimageslider.IndicatorView.draw.drawer.type.DropDrawer;
import com.smarteist.autoimageslider.IndicatorView.draw.drawer.type.FillDrawer;
import com.smarteist.autoimageslider.IndicatorView.draw.drawer.type.ScaleDownDrawer;
import com.smarteist.autoimageslider.IndicatorView.draw.drawer.type.ScaleDrawer;
import com.smarteist.autoimageslider.IndicatorView.draw.drawer.type.SlideDrawer;
import com.smarteist.autoimageslider.IndicatorView.draw.drawer.type.SwapDrawer;
import com.smarteist.autoimageslider.IndicatorView.draw.drawer.type.ThinWormDrawer;
import com.smarteist.autoimageslider.IndicatorView.draw.drawer.type.WormDrawer;

public class Drawer {
    private BasicDrawer basicDrawer;
    private ColorDrawer colorDrawer;
    private ScaleDrawer scaleDrawer;
    private WormDrawer wormDrawer;
    private SlideDrawer slideDrawer;
    private FillDrawer fillDrawer;
    private ThinWormDrawer thinWormDrawer;
    private DropDrawer dropDrawer;
    private SwapDrawer swapDrawer;
    private ScaleDownDrawer scaleDownDrawer;
    private int position;
    private int coordinateX;
    private int coordinateY;

    public Drawer(@NonNull Indicator indicator) {
        Paint paint = new Paint();
        paint.setStyle(Paint.Style.FILL);
        paint.setAntiAlias(true);
        this.basicDrawer = new BasicDrawer(paint, indicator);
        this.colorDrawer = new ColorDrawer(paint, indicator);
        this.scaleDrawer = new ScaleDrawer(paint, indicator);
        this.wormDrawer = new WormDrawer(paint, indicator);
        this.slideDrawer = new SlideDrawer(paint, indicator);
        this.fillDrawer = new FillDrawer(paint, indicator);
        this.thinWormDrawer = new ThinWormDrawer(paint, indicator);
        this.dropDrawer = new DropDrawer(paint, indicator);
        this.swapDrawer = new SwapDrawer(paint, indicator);
        this.scaleDownDrawer = new ScaleDownDrawer(paint, indicator);
    }

    public void setup(int position, int coordinateX, int coordinateY) {
        this.position = position;
        this.coordinateX = coordinateX;
        this.coordinateY = coordinateY;
    }

    public void drawBasic(@NonNull Canvas canvas, boolean isSelectedItem) {
        if (this.colorDrawer != null) {
            this.basicDrawer.draw(canvas, this.position, isSelectedItem, this.coordinateX, this.coordinateY);
        }
    }

    public void drawColor(@NonNull Canvas canvas, @NonNull Value value) {
        if (this.colorDrawer != null) {
            this.colorDrawer.draw(canvas, value, this.position, this.coordinateX, this.coordinateY);
        }
    }

    public void drawScale(@NonNull Canvas canvas, @NonNull Value value) {
        if (this.scaleDrawer != null) {
            this.scaleDrawer.draw(canvas, value, this.position, this.coordinateX, this.coordinateY);
        }
    }

    public void drawWorm(@NonNull Canvas canvas, @NonNull Value value) {
        if (this.wormDrawer != null) {
            this.wormDrawer.draw(canvas, value, this.coordinateX, this.coordinateY);
        }
    }

    public void drawSlide(@NonNull Canvas canvas, @NonNull Value value) {
        if (this.slideDrawer != null) {
            this.slideDrawer.draw(canvas, value, this.coordinateX, this.coordinateY);
        }
    }

    public void drawFill(@NonNull Canvas canvas, @NonNull Value value) {
        if (this.fillDrawer != null) {
            this.fillDrawer.draw(canvas, value, this.position, this.coordinateX, this.coordinateY);
        }
    }

    public void drawThinWorm(@NonNull Canvas canvas, @NonNull Value value) {
        if (this.thinWormDrawer != null) {
            this.thinWormDrawer.draw(canvas, value, this.coordinateX, this.coordinateY);
        }
    }

    public void drawDrop(@NonNull Canvas canvas, @NonNull Value value) {
        if (this.dropDrawer != null) {
            this.dropDrawer.draw(canvas, value, this.coordinateX, this.coordinateY);
        }
    }

    public void drawSwap(@NonNull Canvas canvas, @NonNull Value value) {
        if (this.swapDrawer != null) {
            this.swapDrawer.draw(canvas, value, this.position, this.coordinateX, this.coordinateY);
        }
    }

    public void drawScaleDown(@NonNull Canvas canvas, @NonNull Value value) {
        if (this.scaleDownDrawer != null) {
            this.scaleDownDrawer.draw(canvas, value, this.position, this.coordinateX, this.coordinateY);
        }
    }
}

