/*
 * Decompiled with CFR 0.152.
 */
package com.smarteist.autoimageslider;

import androidx.viewpager.widget.ViewPager;

class CircularSliderHandle
implements ViewPager.OnPageChangeListener {
    private CurrentPageListener currentPageListener;
    private ViewPager mViewPager;
    private boolean mIsEndOfCycle = false;
    private int mCurrentPosition;
    private int mPreviousPosition;

    CircularSliderHandle(ViewPager viewPager) {
        this.mViewPager = viewPager;
    }

    void setCurrentPageListener(CurrentPageListener currentPageListener) {
        this.currentPageListener = currentPageListener;
    }

    public void onPageSelected(int position) {
        this.mCurrentPosition = position;
        this.currentPageListener.onCurrentPageChanged(this.mCurrentPosition);
    }

    public void onPageScrollStateChanged(int state) {
        int itemsCount = this.getAdapterItemsCount();
        if (state == 0) {
            if (this.mPreviousPosition == this.mCurrentPosition && !this.mIsEndOfCycle) {
                if (this.mCurrentPosition == 0) {
                    this.mViewPager.setCurrentItem(itemsCount - 1);
                    this.mIsEndOfCycle = true;
                } else {
                    this.mViewPager.setCurrentItem(0);
                    this.mIsEndOfCycle = true;
                }
            } else {
                this.mIsEndOfCycle = false;
            }
            this.mPreviousPosition = this.mViewPager.getCurrentItem();
        }
    }

    private int getAdapterItemsCount() {
        try {
            return this.mViewPager.getAdapter().getCount();
        }
        catch (NullPointerException e) {
            return 0;
        }
    }

    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
    }

    static interface CurrentPageListener {
        public void onCurrentPageChanged(int var1);
    }
}

