/*
 * Decompiled with CFR 0.152.
 */
package com.smarteist.autoimageslider;

import android.content.Context;
import android.content.ContextWrapper;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.support.annotation.DrawableRes;
import android.text.TextUtils;
import android.view.View;
import android.widget.ImageView;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public abstract class SliderView {
    @DrawableRes
    protected int imageRes = 0;
    protected OnSliderClickListener onSliderClickListener;
    protected String description;
    protected String imageUrl;
    protected ImageView.ScaleType scaleType = ImageView.ScaleType.CENTER_CROP;
    protected Context context;

    public abstract View getView();

    abstract void bindViewData(View var1, ImageView var2);

    SliderView(Context context) {
        this.context = context;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int getImageRes() {
        return this.imageRes;
    }

    public String getImageUrl() {
        return this.imageUrl;
    }

    public void setImageUrl(String imageUrl) {
        if (this.imageRes != 0) {
            throw new IllegalStateException("Can't set multiple images");
        }
        this.imageUrl = imageUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setImageByte(byte[] imageByte) {
        ContextWrapper wrapper = new ContextWrapper(this.context);
        File file = new File(wrapper.getCacheDir().getAbsolutePath(), "Cached" + System.currentTimeMillis() + ".jpeg");
        Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])imageByte, (int)0, (int)imageByte.length);
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file);
            bitmap.compress(Bitmap.CompressFormat.PNG, 95, (OutputStream)out);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.imageUrl = String.valueOf(Uri.fromFile((File)file));
    }

    public void setImageDrawable(int imageDrawable) {
        if (!TextUtils.isEmpty((CharSequence)this.imageUrl)) {
            throw new IllegalStateException("Can't set multiple images");
        }
        this.imageRes = imageDrawable;
    }

    public ImageView.ScaleType getScaleType() {
        return this.scaleType;
    }

    public void setImageScaleType(ImageView.ScaleType scaleType) {
        this.scaleType = scaleType;
    }

    public void setOnSliderClickListener(OnSliderClickListener l) {
        this.onSliderClickListener = l;
    }

    public static interface OnSliderClickListener {
        public void onSliderClick(SliderView var1);
    }
}

