/*
 * Decompiled with CFR 0.152.
 */
package fr.arnaudguyon.tabstacker;

import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.util.SparseArray;
import android.view.View;

class ViewData {
    ViewData() {
    }

    static Bundle saveViewHierarchy(@NonNull View view) {
        Bundle bundle = new Bundle();
        SparseArray savedViewHierarchy = new SparseArray();
        view.saveHierarchyState(savedViewHierarchy);
        int count = savedViewHierarchy.size();
        for (int i = 0; i < count; ++i) {
            int key = savedViewHierarchy.keyAt(i);
            Parcelable parcelable = (Parcelable)savedViewHierarchy.get(key);
            String bundleKey = "" + key;
            bundle.putParcelable(bundleKey, parcelable);
        }
        return bundle;
    }

    static void restoreView(Bundle bundle, @NonNull View view) {
        if (bundle == null) {
            return;
        }
        SparseArray savedViewHierarchy = new SparseArray();
        for (String bundleKey : bundle.keySet()) {
            Parcelable parcelable = bundle.getParcelable(bundleKey);
            int key = Integer.parseInt(bundleKey);
            savedViewHierarchy.put(key, (Object)parcelable);
        }
        view.restoreHierarchyState(savedViewHierarchy);
    }
}

