/*
 * Decompiled with CFR 0.152.
 */
package fr.arnaudguyon.tabstacker;

import android.os.Bundle;
import android.support.annotation.AnimRes;
import android.support.v4.app.FragmentTransaction;

public class AnimationSet {
    private int mPushInAnim;
    private int mPushOutAnim;
    private int mPopInAnim;
    private int mPopOutAnim;
    private static final String BUNDLE_PUSH_IN = "pushin";
    private static final String BUNDLE_PUSH_OUT = "pushout";
    private static final String BUNDLE_POP_IN = "popin";
    private static final String BUNDLE_POP_OUT = "popout";

    public AnimationSet(@AnimRes int pushInAnim, @AnimRes int pushOutAnim, @AnimRes int popInAnim, @AnimRes int popOutAnim) {
        this.mPushInAnim = pushInAnim;
        this.mPushOutAnim = pushOutAnim;
        this.mPopInAnim = popInAnim;
        this.mPopOutAnim = popOutAnim;
    }

    void addToTransaction(FragmentTransaction transaction) {
        if (this.mPushInAnim != 0 && this.mPushOutAnim != 0) {
            if (this.mPopInAnim != 0 && this.mPopOutAnim != 0) {
                transaction.setCustomAnimations(this.mPushInAnim, this.mPushOutAnim, this.mPopInAnim, this.mPopOutAnim);
            } else {
                transaction.setCustomAnimations(this.mPushInAnim, this.mPushOutAnim);
            }
        }
    }

    @AnimRes
    int getPopInAnim() {
        return this.mPopInAnim;
    }

    @AnimRes
    int getPopOutAnim() {
        return this.mPopOutAnim;
    }

    @AnimRes
    int getPushInAnim() {
        return this.mPushInAnim;
    }

    @AnimRes
    int getPushOutAnim() {
        return this.mPushOutAnim;
    }

    Bundle saveInstance() {
        Bundle bundle = new Bundle();
        bundle.putInt(BUNDLE_PUSH_IN, this.mPushInAnim);
        bundle.putInt(BUNDLE_PUSH_OUT, this.mPushOutAnim);
        bundle.putInt(BUNDLE_POP_IN, this.mPopInAnim);
        bundle.putInt(BUNDLE_POP_OUT, this.mPopOutAnim);
        return bundle;
    }

    static AnimationSet restoreInstance(Bundle bundle) {
        if (bundle != null) {
            int pushInAnim = bundle.getInt(BUNDLE_PUSH_IN);
            int pushOutAnim = bundle.getInt(BUNDLE_PUSH_OUT);
            int popInAnim = bundle.getInt(BUNDLE_POP_IN);
            int popOutAnim = bundle.getInt(BUNDLE_POP_OUT);
            return new AnimationSet(pushInAnim, pushOutAnim, popInAnim, popOutAnim);
        }
        return null;
    }
}

