/*
 * Decompiled with CFR 0.152.
 */
package com.skydoves.progressview;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import androidx.annotation.ColorInt;
import androidx.annotation.FloatRange;
import androidx.annotation.Px;
import com.skydoves.progressview.OnProgressClickListener;
import com.skydoves.progressview.ProgressViewOrientation;
import com.skydoves.progressview.ViewExtensionKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0014\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010H\u001a\u00020I2\u0006\u0010J\u001a\u00020KH\u0002J\b\u0010L\u001a\u00020IH\u0002J\u0006\u0010M\u001a\u00020IJ\b\u0010N\u001a\u00020IH\u0002J\b\u0010O\u001a\u00020IH\u0002J\f\u0010P\u001a\u00020I*\u00020GH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n8\u0006@FX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR&\u0010\u0010\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n8\u0006@FX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\r\"\u0004\b\u0012\u0010\u000fR&\u0010\u0013\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n8\u0006@FX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\r\"\u0004\b\u0015\u0010\u000fR(\u0010\u0017\u001a\u0004\u0018\u00010\u00162\b\u0010\t\u001a\u0004\u0018\u00010\u0016@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR&\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\t\u001a\u00020\u001c8\u0006@FX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R&\u0010\"\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n8\u0006@FX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\r\"\u0004\b$\u0010\u000fR&\u0010%\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n8\u0006@FX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\r\"\u0004\b'\u0010\u000fR$\u0010)\u001a\u00020(2\u0006\u0010\t\u001a\u00020(@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R\u001c\u0010.\u001a\u0004\u0018\u00010/X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u00101\"\u0004\b2\u00103R$\u00105\u001a\u0002042\u0006\u0010\t\u001a\u000204@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u00107\"\u0004\b8\u00109R&\u0010:\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n8\u0006@FX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b;\u0010\r\"\u0004\b<\u0010\u000fR$\u0010=\u001a\u00020\u001c2\u0006\u0010\t\u001a\u00020\u001c@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b>\u0010\u001f\"\u0004\b?\u0010!R(\u0010A\u001a\u0004\u0018\u00010@2\b\u0010\t\u001a\u0004\u0018\u00010@@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bB\u0010C\"\u0004\bD\u0010ER\u000e\u0010F\u001a\u00020GX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006Q"}, d2={"Lcom/skydoves/progressview/HighlightView;", "Landroid/widget/FrameLayout;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "bodyView", "Landroid/widget/LinearLayout;", "value", "", "color", "getColor", "()I", "setColor", "(I)V", "colorGradientEnd", "getColorGradientEnd", "setColorGradientEnd", "colorGradientStart", "getColorGradientStart", "setColorGradientStart", "Landroid/graphics/drawable/Drawable;", "highlight", "getHighlight", "()Landroid/graphics/drawable/Drawable;", "setHighlight", "(Landroid/graphics/drawable/Drawable;)V", "", "highlightAlpha", "getHighlightAlpha", "()F", "setHighlightAlpha", "(F)V", "highlightColor", "getHighlightColor", "setHighlightColor", "highlightThickness", "getHighlightThickness", "setHighlightThickness", "", "highlighting", "getHighlighting", "()Z", "setHighlighting", "(Z)V", "onProgressClickListener", "Lcom/skydoves/progressview/OnProgressClickListener;", "getOnProgressClickListener", "()Lcom/skydoves/progressview/OnProgressClickListener;", "setOnProgressClickListener", "(Lcom/skydoves/progressview/OnProgressClickListener;)V", "Lcom/skydoves/progressview/ProgressViewOrientation;", "orientation", "getOrientation", "()Lcom/skydoves/progressview/ProgressViewOrientation;", "setOrientation", "(Lcom/skydoves/progressview/ProgressViewOrientation;)V", "padding", "getPadding", "setPadding", "radius", "getRadius", "setRadius", "", "radiusArray", "getRadiusArray", "()[F", "setRadiusArray", "([F)V", "strokeView", "Landroid/view/View;", "applyRadius", "", "gradientDrawable", "Landroid/graphics/drawable/GradientDrawable;", "updateBodyView", "updateHighlightView", "updateHighlighting", "updateStrokeView", "applyMargin", "progressview_release"})
public final class HighlightView
extends FrameLayout {
    private final LinearLayout bodyView;
    private final View strokeView;
    private boolean highlighting;
    @Px
    private int highlightThickness;
    @ColorInt
    private int highlightColor;
    @FloatRange(from=0.0, to=1.0)
    private float highlightAlpha;
    private float radius;
    @Nullable
    private float[] radiusArray;
    @Px
    private int padding;
    @ColorInt
    private int color;
    @ColorInt
    private int colorGradientStart;
    @ColorInt
    private int colorGradientEnd;
    @Nullable
    private Drawable highlight;
    @NotNull
    private ProgressViewOrientation orientation;
    @Nullable
    private OnProgressClickListener onProgressClickListener;

    public final boolean getHighlighting() {
        return this.highlighting;
    }

    public final void setHighlighting(boolean value) {
        this.highlighting = value;
        this.updateHighlighting();
    }

    public final int getHighlightThickness() {
        return this.highlightThickness;
    }

    public final void setHighlightThickness(int value) {
        this.highlightThickness = value;
        this.updateHighlightView();
    }

    public final int getHighlightColor() {
        return this.highlightColor;
    }

    public final void setHighlightColor(int value) {
        this.highlightColor = value;
        this.updateHighlightView();
    }

    public final float getHighlightAlpha() {
        return this.highlightAlpha;
    }

    public final void setHighlightAlpha(float value) {
        this.highlightAlpha = value;
        this.updateHighlightView();
    }

    public final float getRadius() {
        return this.radius;
    }

    public final void setRadius(float value) {
        this.radius = value;
        this.updateHighlightView();
    }

    @Nullable
    public final float[] getRadiusArray() {
        return this.radiusArray;
    }

    public final void setRadiusArray(@Nullable float[] value) {
        this.radiusArray = value;
        this.updateHighlightView();
    }

    public final int getPadding() {
        return this.padding;
    }

    public final void setPadding(int value) {
        this.padding = value;
        this.updateHighlightView();
    }

    public final int getColor() {
        return this.color;
    }

    public final void setColor(int value) {
        this.color = value;
        this.updateHighlightView();
    }

    public final int getColorGradientStart() {
        return this.colorGradientStart;
    }

    public final void setColorGradientStart(int value) {
        this.colorGradientStart = value;
        this.updateHighlightView();
    }

    public final int getColorGradientEnd() {
        return this.colorGradientEnd;
    }

    public final void setColorGradientEnd(int value) {
        this.colorGradientEnd = value;
        this.updateHighlightView();
    }

    @Nullable
    public final Drawable getHighlight() {
        return this.highlight;
    }

    public final void setHighlight(@Nullable Drawable value) {
        this.highlight = value;
        this.updateHighlightView();
    }

    @NotNull
    public final ProgressViewOrientation getOrientation() {
        return this.orientation;
    }

    public final void setOrientation(@NotNull ProgressViewOrientation value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        this.orientation = value;
        this.updateHighlightView();
    }

    @Nullable
    public final OnProgressClickListener getOnProgressClickListener() {
        return this.onProgressClickListener;
    }

    public final void setOnProgressClickListener(@Nullable OnProgressClickListener onProgressClickListener) {
        this.onProgressClickListener = onProgressClickListener;
    }

    public final void updateHighlightView() {
        this.updateBodyView();
        this.updateStrokeView();
        this.updateHighlighting();
    }

    /*
     * WARNING - void declaration
     */
    private final void updateBodyView() {
        Drawable drawable;
        LinearLayout linearLayout = this.bodyView;
        if (this.colorGradientStart != 65555 && this.colorGradientEnd != 65555) {
            void $this$apply;
            GradientDrawable.Orientation gradientOrientation = GradientDrawable.Orientation.LEFT_RIGHT;
            if (this.orientation == ProgressViewOrientation.VERTICAL) {
                gradientOrientation = GradientDrawable.Orientation.TOP_BOTTOM;
            }
            GradientDrawable gradientDrawable = new GradientDrawable(gradientOrientation, new int[]{this.colorGradientStart, this.colorGradientEnd});
            boolean bl = false;
            boolean bl2 = false;
            GradientDrawable gradientDrawable2 = gradientDrawable;
            LinearLayout linearLayout2 = linearLayout;
            boolean bl3 = false;
            this.applyRadius((GradientDrawable)$this$apply);
            Unit unit = Unit.INSTANCE;
            linearLayout = linearLayout2;
            drawable = (Drawable)gradientDrawable;
        } else if (this.highlight == null) {
            void $this$apply;
            GradientDrawable gradientDrawable = new GradientDrawable();
            boolean bl = false;
            boolean bl4 = false;
            GradientDrawable gradientDrawable3 = gradientDrawable;
            LinearLayout linearLayout3 = linearLayout;
            boolean bl5 = false;
            $this$apply.setColor(this.color);
            this.applyRadius((GradientDrawable)$this$apply);
            Unit unit = Unit.INSTANCE;
            linearLayout = linearLayout3;
            drawable = (Drawable)gradientDrawable;
        } else {
            drawable = this.highlight;
        }
        linearLayout.setBackground(drawable);
        this.applyMargin((View)this.bodyView);
    }

    /*
     * WARNING - void declaration
     */
    private final void updateStrokeView() {
        void $this$apply;
        GradientDrawable gradientDrawable = new GradientDrawable();
        boolean bl = false;
        boolean bl2 = false;
        GradientDrawable gradientDrawable2 = gradientDrawable;
        View view = this.strokeView;
        boolean bl3 = false;
        $this$apply.setColor(0);
        $this$apply.setStroke(this.highlightThickness, this.highlightColor);
        this.applyRadius((GradientDrawable)$this$apply);
        Unit unit = Unit.INSTANCE;
        view.setBackground((Drawable)gradientDrawable);
        this.applyMargin(this.strokeView);
    }

    private final void updateHighlighting() {
        if (this.highlighting) {
            this.strokeView.setAlpha(this.highlightAlpha);
        } else {
            this.strokeView.setAlpha(0.0f);
        }
    }

    private final void applyMargin(View $this$applyMargin) {
        ViewGroup.LayoutParams layoutParams = $this$applyMargin.getLayoutParams();
        if (layoutParams == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.view.ViewGroup.MarginLayoutParams");
        }
        ((ViewGroup.MarginLayoutParams)layoutParams).setMargins(this.padding, this.padding, this.padding, this.padding);
    }

    private final void applyRadius(GradientDrawable gradientDrawable) {
        if (this.radiusArray != null) {
            gradientDrawable.setCornerRadii(this.radiusArray);
        } else {
            gradientDrawable.setCornerRadius(this.radius);
        }
    }

    public HighlightView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs);
        this.bodyView = new LinearLayout(context);
        this.strokeView = new View(context);
        this.highlightThickness = ViewExtensionKt.dp2Px((View)this, 0);
        this.highlightColor = ViewExtensionKt.accentColor((View)this);
        this.highlightAlpha = 1.0f;
        this.radius = ViewExtensionKt.dp2Px((View)this, 5);
        this.padding = ViewExtensionKt.dp2Px((View)this, 0);
        this.color = ViewExtensionKt.accentColor((View)this);
        this.colorGradientStart = 65555;
        this.colorGradientEnd = 65555;
        this.orientation = ProgressViewOrientation.HORIZONTAL;
        this.addView((View)this.bodyView);
        this.addView(this.strokeView);
        this.strokeView.setOnClickListener(new View.OnClickListener(){

            public final void onClick(View it) {
                block0: {
                    this.setHighlighting(!this.getHighlighting());
                    OnProgressClickListener onProgressClickListener = this.getOnProgressClickListener();
                    if (onProgressClickListener == null) break block0;
                    onProgressClickListener.onClickProgress(this.getHighlighting());
                }
            }
        });
    }

    public /* synthetic */ HighlightView(Context context, AttributeSet attributeSet, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            attributeSet = null;
        }
        this(context, attributeSet);
    }
}

