/*
 * Decompiled with CFR 0.152.
 */
package com.skydoves.powermenu;

import android.content.Context;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ListAdapter;
import android.widget.ListView;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.annotation.FloatRange;
import androidx.annotation.LayoutRes;
import androidx.annotation.NonNull;
import androidx.annotation.Px;
import androidx.annotation.StyleRes;
import androidx.cardview.widget.CardView;
import androidx.core.content.ContextCompat;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleOwner;
import com.skydoves.powermenu.AbstractMenuBuilder;
import com.skydoves.powermenu.AbstractPowerMenu;
import com.skydoves.powermenu.CircularEffect;
import com.skydoves.powermenu.IPowerMenuAdapter;
import com.skydoves.powermenu.MenuAnimation;
import com.skydoves.powermenu.MenuListAdapter;
import com.skydoves.powermenu.OnDismissedListener;
import com.skydoves.powermenu.OnMenuItemClickListener;
import com.skydoves.powermenu.PowerMenuItem;
import com.skydoves.powermenu.annotations.Dp;
import com.skydoves.powermenu.annotations.Sp;
import com.skydoves.powermenu.databinding.LayoutMaterialPowerMenuLibrarySkydovesBinding;
import com.skydoves.powermenu.databinding.LayoutPowerMenuLibrarySkydovesBinding;
import com.skydoves.powermenu.kotlin.PowerMenuDsl;
import java.util.ArrayList;
import java.util.List;

public class PowerMenu
extends AbstractPowerMenu<PowerMenuItem, MenuListAdapter>
implements IPowerMenuAdapter {
    private LayoutPowerMenuLibrarySkydovesBinding binding;
    private LayoutMaterialPowerMenuLibrarySkydovesBinding materialBinding;

    protected PowerMenu(@NonNull Context context, @NonNull AbstractMenuBuilder abstractMenuBuilder) {
        super(context, abstractMenuBuilder);
        Builder builder = (Builder)abstractMenuBuilder;
        this.setSelectedEffect(builder.selectedEffect);
        if (builder.menuItemClickListener != null) {
            this.setOnMenuItemClickListener(builder.menuItemClickListener);
        }
        if (builder.textColor != -2) {
            this.setTextColor(builder.textColor);
        }
        if (builder.menuColor != -2) {
            this.setMenuColor(builder.menuColor);
        }
        if (builder.selectedTextColor != -2) {
            this.setSelectedTextColor(builder.selectedTextColor);
        }
        if (builder.selectedMenuColor != -2) {
            this.setSelectedMenuColor(builder.selectedMenuColor);
        }
        if (builder.selected != -1) {
            this.setSelectedPosition(builder.selected);
        }
        if (builder.textSize != 12) {
            this.setTextSize(builder.textSize);
        }
        if (builder.textGravity != 0x800003) {
            this.setTextGravity(builder.textGravity);
        }
        if (builder.textTypeface != null) {
            this.setTextTypeface(builder.textTypeface);
        }
        if (builder.iconSize != 35) {
            this.setIconSize(builder.iconSize);
        }
        if (builder.iconPadding != 7) {
            this.setIconPadding(builder.iconPadding);
        }
        if (builder.iconColor != -2) {
            this.setIconColor(builder.iconColor);
        }
        this.menuListView.setAdapter((ListAdapter)this.adapter);
        this.addItemList(builder.powerMenuItems);
    }

    @Override
    protected void initialize(@NonNull Context context, Boolean isMaterial) {
        LayoutInflater layoutInflater = LayoutInflater.from((Context)context);
        if (isMaterial.booleanValue()) {
            this.materialBinding = LayoutMaterialPowerMenuLibrarySkydovesBinding.inflate(layoutInflater, null, false);
        } else {
            this.binding = LayoutPowerMenuLibrarySkydovesBinding.inflate(layoutInflater, null, false);
        }
        super.initialize(context, isMaterial);
        this.adapter = new MenuListAdapter(this.menuListView);
    }

    @Override
    View getMenuRoot(Boolean isMaterial) {
        if (isMaterial.booleanValue()) {
            return this.materialBinding.getRoot();
        }
        return this.binding.getRoot();
    }

    @Override
    ListView getMenuList(Boolean isMaterial) {
        if (isMaterial.booleanValue()) {
            return this.materialBinding.powerMenuListView;
        }
        return this.binding.powerMenuListView;
    }

    @Override
    CardView getMenuCard(Boolean isMaterial) {
        if (isMaterial.booleanValue()) {
            return this.materialBinding.powerMenuCard;
        }
        return this.binding.powerMenuCard;
    }

    @Override
    public void setTextColor(int color) {
        ((MenuListAdapter)this.getAdapter()).setTextColor(color);
    }

    @Override
    public void setMenuColor(int color) {
        ((MenuListAdapter)this.getAdapter()).setMenuColor(color);
    }

    @Override
    public void setSelectedTextColor(int color) {
        ((MenuListAdapter)this.getAdapter()).setSelectedTextColor(color);
    }

    @Override
    public void setSelectedMenuColor(int color) {
        ((MenuListAdapter)this.getAdapter()).setSelectedMenuColor(color);
    }

    @Override
    public void setSelectedEffect(boolean selectedEffect) {
        ((MenuListAdapter)this.getAdapter()).setSelectedEffect(selectedEffect);
    }

    @Override
    public void setIconSize(int iconSize) {
        ((MenuListAdapter)this.getAdapter()).setIconSize(iconSize);
    }

    @Override
    public void setIconColor(int iconColor) {
        ((MenuListAdapter)this.getAdapter()).setIconColor(iconColor);
    }

    @Override
    public void setIconPadding(int iconPadding) {
        ((MenuListAdapter)this.getAdapter()).setIconPadding(iconPadding);
    }

    @Override
    public void setTextSize(@Sp int size) {
        ((MenuListAdapter)this.getAdapter()).setTextSize(size);
    }

    @Override
    public void setTextGravity(int gravity) {
        ((MenuListAdapter)this.getAdapter()).setTextGravity(gravity);
    }

    @Override
    public void setTextTypeface(Typeface typeface) {
        ((MenuListAdapter)this.getAdapter()).setTextTypeface(typeface);
    }

    public static abstract class Factory {
        @NonNull
        public abstract PowerMenu create(@NonNull Context var1, @NonNull LifecycleOwner var2);
    }

    @PowerMenuDsl
    public static class Builder
    extends AbstractMenuBuilder {
        private OnMenuItemClickListener<PowerMenuItem> menuItemClickListener = null;
        @ColorInt
        private int textColor = -2;
        @ColorInt
        private int menuColor = -2;
        private boolean selectedEffect = true;
        @ColorInt
        private int selectedTextColor = -2;
        @ColorInt
        private int selectedMenuColor = -2;
        private int textSize = 12;
        private int textGravity = 0x800003;
        private Typeface textTypeface = null;
        private final List<PowerMenuItem> powerMenuItems;

        public Builder(@NonNull Context context) {
            this.context = context;
            this.powerMenuItems = new ArrayList<PowerMenuItem>();
            this.layoutInflater = (LayoutInflater)context.getSystemService("layout_inflater");
        }

        public Builder setLifecycleOwner(@NonNull LifecycleOwner lifecycleOwner) {
            this.lifecycleOwner = lifecycleOwner;
            return this;
        }

        public Builder setShowBackground(boolean show) {
            this.showBackground = show;
            return this;
        }

        public Builder setOnMenuItemClickListener(OnMenuItemClickListener<PowerMenuItem> menuItemClickListener) {
            this.menuItemClickListener = menuItemClickListener;
            return this;
        }

        public Builder setOnBackgroundClickListener(View.OnClickListener onBackgroundClickListener) {
            this.backgroundClickListener = onBackgroundClickListener;
            return this;
        }

        public Builder setOnDismissListener(OnDismissedListener onDismissListener) {
            this.onDismissedListener = onDismissListener;
            return this;
        }

        public Builder setHeaderView(@LayoutRes int headerView) {
            this.headerView = this.layoutInflater.inflate(headerView, null);
            return this;
        }

        public Builder setHeaderView(View headerView) {
            this.headerView = headerView;
            return this;
        }

        public Builder setFooterView(@LayoutRes int footerView) {
            this.footerView = this.layoutInflater.inflate(footerView, null);
            return this;
        }

        public Builder setFooterView(View footerView) {
            this.footerView = footerView;
            return this;
        }

        public Builder setAnimation(@NonNull MenuAnimation menuAnimation) {
            this.menuAnimation = menuAnimation;
            return this;
        }

        public Builder setAnimationStyle(@StyleRes int style2) {
            this.animationStyle = style2;
            return this;
        }

        public Builder setMenuRadius(@Px float radius) {
            this.menuRadius = radius;
            return this;
        }

        public Builder setMenuShadow(float shadow) {
            this.menuShadow = shadow;
            return this;
        }

        public Builder setWidth(@Px int width) {
            this.width = width;
            return this;
        }

        public Builder setHeight(@Px int height) {
            this.height = height;
            return this;
        }

        public Builder setSize(@Px int width, @Px int height) {
            this.width = width;
            this.height = height;
            return this;
        }

        public Builder setPadding(@Px int padding) {
            this.padding = padding;
            return this;
        }

        public Builder setTextColor(@ColorInt int color) {
            this.textColor = color;
            return this;
        }

        public Builder setTextColorResource(@ColorRes int color) {
            this.textColor = ContextCompat.getColor((Context)this.context, (int)color);
            return this;
        }

        public Builder setTextSize(@Sp int size) {
            this.textSize = size;
            return this;
        }

        public Builder setTextGravity(int gravity) {
            this.textGravity = gravity;
            return this;
        }

        public Builder setTextTypeface(@NonNull Typeface typeface) {
            this.textTypeface = typeface;
            return this;
        }

        public Builder setIconColor(@ColorInt int iconColor) {
            this.iconColor = iconColor;
            return this;
        }

        public Builder setIconSize(@Dp int iconSize) {
            this.iconSize = iconSize;
            return this;
        }

        public Builder setIconPadding(@Dp int iconPadding) {
            this.iconPadding = iconPadding;
            return this;
        }

        public Builder setMenuColor(@ColorInt int color) {
            this.menuColor = color;
            return this;
        }

        public Builder setMenuColorResource(@ColorRes int color) {
            this.menuColor = ContextCompat.getColor((Context)this.context, (int)color);
            return this;
        }

        public Builder setSelectedTextColor(@ColorInt int color) {
            this.selectedTextColor = color;
            return this;
        }

        public Builder setSelectedTextColorResource(@ColorRes int color) {
            this.selectedTextColor = ContextCompat.getColor((Context)this.context, (int)color);
            return this;
        }

        public Builder setSelectedMenuColor(@ColorInt int color) {
            this.selectedMenuColor = color;
            return this;
        }

        public Builder setSelectedMenuColorResource(@ColorRes int color) {
            this.selectedMenuColor = ContextCompat.getColor((Context)this.context, (int)color);
            return this;
        }

        public Builder setSelectedEffect(boolean effect) {
            this.selectedEffect = effect;
            return this;
        }

        public Builder setDividerHeight(@Px int height) {
            this.dividerHeight = height;
            return this;
        }

        public Builder setDivider(Drawable divider) {
            this.divider = divider;
            return this;
        }

        public Builder setBackgroundColor(@ColorInt int color) {
            this.backgroundColor = color;
            return this;
        }

        public Builder setBackgroundColorResource(@ColorRes int color) {
            this.backgroundColor = ContextCompat.getColor((Context)this.context, (int)color);
            return this;
        }

        public Builder setBackgroundAlpha(@FloatRange(from=0.0, to=1.0) float alpha) {
            this.backgroundAlpha = alpha;
            return this;
        }

        public Builder setBackgroundSystemUiVisibility(int visibility) {
            this.backgroundSystemUiVisibility = visibility;
            return this;
        }

        public Builder setFocusable(boolean focusable) {
            this.focusable = focusable;
            return this;
        }

        public Builder setSelected(int position) {
            this.selected = position;
            return this;
        }

        public Builder setIsClipping(boolean isClipping) {
            this.isClipping = isClipping;
            return this;
        }

        public Builder setAutoDismiss(boolean autoDismiss) {
            this.autoDismiss = autoDismiss;
            return this;
        }

        public Builder setDismissIfShowAgain(boolean dismissIfShowAgain) {
            this.dismissIfShowAgain = dismissIfShowAgain;
            return this;
        }

        public Builder addItem(PowerMenuItem item) {
            this.powerMenuItems.add(item);
            return this;
        }

        public Builder addItem(int position, PowerMenuItem item) {
            this.powerMenuItems.add(position, item);
            return this;
        }

        public Builder addItemList(List<PowerMenuItem> itemList) {
            this.powerMenuItems.addAll(itemList);
            return this;
        }

        public Builder setPreferenceName(@NonNull String preferenceName) {
            this.preferenceName = preferenceName;
            return this;
        }

        public Builder setInitializeRule(@NonNull Lifecycle.Event event, int defaultPosition) {
            this.initializeRule = event;
            this.defaultPosition = defaultPosition;
            return this;
        }

        public Builder setCircularEffect(@NonNull CircularEffect circularEffect) {
            this.circularEffect = circularEffect;
            return this;
        }

        public Builder setIsMaterial(Boolean isMaterial) {
            this.isMaterial = isMaterial;
            return this;
        }

        public PowerMenu build() {
            return new PowerMenu(this.context, this);
        }
    }
}

