/*
 * Decompiled with CFR 0.152.
 */
package com.skydoves.balloon.animations;

import android.graphics.Camera;
import android.graphics.Matrix;
import android.view.animation.Animation;
import android.view.animation.Transformation;
import com.skydoves.balloon.animations.BalloonRotateDirection;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0015B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J(\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000eH\u0016J\u0018\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0014H\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/skydoves/balloon/animations/BalloonRotateAnimation;", "Landroid/view/animation/Animation;", "builder", "Lcom/skydoves/balloon/animations/BalloonRotateAnimation$Builder;", "<init>", "(Lcom/skydoves/balloon/animations/BalloonRotateAnimation$Builder;)V", "degreeX", "", "degreeY", "degreeZ", "width", "height", "initialize", "", "", "parentWidth", "parentHeight", "applyTransformation", "interpolatedTime", "transformation", "Landroid/view/animation/Transformation;", "Builder", "balloon_release"})
public final class BalloonRotateAnimation
extends Animation {
    private final float degreeX;
    private final float degreeY;
    private final float degreeZ;
    private float width;
    private float height;

    private BalloonRotateAnimation(Builder builder) {
        this.degreeX = builder.degreeX;
        this.degreeY = (float)(360 * builder.turns) * (float)builder.direction.getValue();
        this.degreeZ = builder.degreeZ;
        this.setDuration(builder.speeds);
        this.setRepeatCount(builder.loops == -1 ? -1 : builder.loops - 1);
    }

    public void initialize(int width, int height, int parentWidth, int parentHeight) {
        super.initialize(width, height, parentWidth, parentHeight);
        this.width = (float)width * 0.5f;
        this.height = (float)height * 0.5f;
    }

    protected void applyTransformation(float interpolatedTime, @NotNull Transformation transformation) {
        Camera camera;
        Intrinsics.checkNotNullParameter((Object)transformation, (String)"transformation");
        float xDegrees = this.degreeX * interpolatedTime;
        float yDegrees = this.degreeY * interpolatedTime;
        float zDegrees = this.degreeZ * interpolatedTime;
        Matrix matrix = transformation.getMatrix();
        Camera $this$applyTransformation_u24lambda_u240 = camera = new Camera();
        boolean bl = false;
        $this$applyTransformation_u24lambda_u240.save();
        $this$applyTransformation_u24lambda_u240.rotateX(xDegrees);
        $this$applyTransformation_u24lambda_u240.rotateY(yDegrees);
        $this$applyTransformation_u24lambda_u240.rotateZ(zDegrees);
        $this$applyTransformation_u24lambda_u240.getMatrix(matrix);
        $this$applyTransformation_u24lambda_u240.restore();
        matrix.preTranslate(-this.width, -this.height);
        matrix.postTranslate(this.width, this.height);
    }

    public /* synthetic */ BalloonRotateAnimation(Builder builder, DefaultConstructorMarker $constructor_marker) {
        this(builder);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u0005J\u000e\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0007J\u000e\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0007J\u000e\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0007J\u000e\u0010\u0014\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u0007J\u000e\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u0007J\u0006\u0010\u0016\u001a\u00020\u0017R\u0012\u0010\u0004\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u00020\u00078\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u00020\u00078\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u00020\u00078\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u00020\u00078\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u00020\u00078\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/skydoves/balloon/animations/BalloonRotateAnimation$Builder;", "", "<init>", "()V", "direction", "Lcom/skydoves/balloon/animations/BalloonRotateDirection;", "turns", "", "loops", "speeds", "degreeX", "degreeZ", "setDirection", "rotateDirection", "setTurns", "turn", "setLoops", "loop", "setSpeeds", "speed", "setDegreeX", "setDegreeZ", "build", "Lcom/skydoves/balloon/animations/BalloonRotateAnimation;", "balloon_release"})
    @SourceDebugExtension(value={"SMAP\nBalloonRotateAnimation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BalloonRotateAnimation.kt\ncom/skydoves/balloon/animations/BalloonRotateAnimation$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,124:1\n1#2:125\n*E\n"})
    public static final class Builder {
        @JvmField
        @NotNull
        public BalloonRotateDirection direction = BalloonRotateDirection.RIGHT;
        @JvmField
        public int turns = 1;
        @JvmField
        public int loops = -1;
        @JvmField
        public int speeds = 2500;
        @JvmField
        public int degreeX;
        @JvmField
        public int degreeZ;

        @NotNull
        public final Builder setDirection(@NotNull BalloonRotateDirection rotateDirection) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)((Object)rotateDirection), (String)"rotateDirection");
            Builder $this$setDirection_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$setDirection_u24lambda_u240.direction = rotateDirection;
            return builder;
        }

        @NotNull
        public final Builder setTurns(int turn) {
            Builder builder;
            Builder $this$setTurns_u24lambda_u241 = builder = this;
            boolean bl = false;
            $this$setTurns_u24lambda_u241.turns = turn;
            return builder;
        }

        @NotNull
        public final Builder setLoops(int loop) {
            Builder builder;
            Builder $this$setLoops_u24lambda_u242 = builder = this;
            boolean bl = false;
            $this$setLoops_u24lambda_u242.loops = loop;
            return builder;
        }

        @NotNull
        public final Builder setSpeeds(int speed) {
            Builder builder;
            Builder $this$setSpeeds_u24lambda_u243 = builder = this;
            boolean bl = false;
            $this$setSpeeds_u24lambda_u243.speeds = speed;
            return builder;
        }

        @NotNull
        public final Builder setDegreeX(int degreeX) {
            Builder builder;
            Builder $this$setDegreeX_u24lambda_u244 = builder = this;
            boolean bl = false;
            $this$setDegreeX_u24lambda_u244.degreeX = degreeX;
            return builder;
        }

        @NotNull
        public final Builder setDegreeZ(int degreeZ) {
            Builder builder;
            Builder $this$setDegreeZ_u24lambda_u245 = builder = this;
            boolean bl = false;
            $this$setDegreeZ_u24lambda_u245.degreeZ = degreeZ;
            return builder;
        }

        @NotNull
        public final BalloonRotateAnimation build() {
            return new BalloonRotateAnimation(this, null);
        }
    }
}

