/*
 * Decompiled with CFR 0.152.
 */
package com.skydoves.balloon.overlay;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.util.AttributeSet;
import android.view.View;
import android.view.Window;
import androidx.annotation.ColorInt;
import androidx.annotation.Px;
import com.skydoves.balloon.extensions.ContextExtensionKt;
import com.skydoves.balloon.internal.ViewPropertyDelegate;
import com.skydoves.balloon.internal.ViewPropertyKt;
import com.skydoves.balloon.overlay.BalloonOverlayCircle;
import com.skydoves.balloon.overlay.BalloonOverlayOval;
import com.skydoves.balloon.overlay.BalloonOverlayRect;
import com.skydoves.balloon.overlay.BalloonOverlayRoundRect;
import com.skydoves.balloon.overlay.BalloonOverlayShape;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0012\u00107\u001a\u0002082\b\u00109\u001a\u0004\u0018\u00010:H\u0014J\u0006\u0010;\u001a\u000208J\b\u0010<\u001a\u00020\u0007H\u0002J0\u0010=\u001a\u0002082\u0006\u0010>\u001a\u00020\u001b2\u0006\u0010?\u001a\u00020\u00072\u0006\u0010@\u001a\u00020\u00072\u0006\u0010A\u001a\u00020\u00072\u0006\u0010B\u001a\u00020\u0007H\u0014J\b\u0010C\u001a\u000208H\u0002R/\u0010\n\u001a\u0004\u0018\u00010\u00012\b\u0010\t\u001a\u0004\u0018\u00010\u00018F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR+\u0010\u0012\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\u00118F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0017\u0010\u0010\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R+\u0010\u001c\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00078G@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b!\u0010\u0010\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R+\u0010#\u001a\u00020\"2\u0006\u0010\t\u001a\u00020\"8G@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b(\u0010\u0010\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R+\u0010)\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00078G@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b,\u0010\u0010\u001a\u0004\b*\u0010\u001e\"\u0004\b+\u0010 R/\u0010.\u001a\u0004\u0018\u00010-2\b\u0010\t\u001a\u0004\u0018\u00010-8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b3\u0010\u0010\u001a\u0004\b/\u00100\"\u0004\b1\u00102R\u000e\u00104\u001a\u000205X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00106\u001a\u000205X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006D"}, d2={"Lcom/skydoves/balloon/overlay/BalloonAnchorOverlayView;", "Landroid/view/View;", "context", "Landroid/content/Context;", "attr", "Landroid/util/AttributeSet;", "defStyle", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "<set-?>", "anchorView", "getAnchorView", "()Landroid/view/View;", "setAnchorView", "(Landroid/view/View;)V", "anchorView$delegate", "Lcom/skydoves/balloon/internal/ViewPropertyDelegate;", "Lcom/skydoves/balloon/overlay/BalloonOverlayShape;", "balloonOverlayShape", "getBalloonOverlayShape", "()Lcom/skydoves/balloon/overlay/BalloonOverlayShape;", "setBalloonOverlayShape", "(Lcom/skydoves/balloon/overlay/BalloonOverlayShape;)V", "balloonOverlayShape$delegate", "bitmap", "Landroid/graphics/Bitmap;", "invalidated", "", "overlayColor", "getOverlayColor", "()I", "setOverlayColor", "(I)V", "overlayColor$delegate", "", "overlayPadding", "getOverlayPadding", "()F", "setOverlayPadding", "(F)V", "overlayPadding$delegate", "overlayPaddingColor", "getOverlayPaddingColor", "setOverlayPaddingColor", "overlayPaddingColor$delegate", "Landroid/graphics/Point;", "overlayPosition", "getOverlayPosition", "()Landroid/graphics/Point;", "setOverlayPosition", "(Landroid/graphics/Point;)V", "overlayPosition$delegate", "paddingColorPaint", "Landroid/graphics/Paint;", "paint", "dispatchDraw", "", "canvas", "Landroid/graphics/Canvas;", "forceInvalidate", "getStatusBarHeight", "onLayout", "changed", "left", "top", "right", "bottom", "prepareBitmap", "balloon_release"})
public final class BalloonAnchorOverlayView
extends View {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    @Nullable
    private final ViewPropertyDelegate anchorView$delegate;
    @NotNull
    private final ViewPropertyDelegate overlayColor$delegate;
    @NotNull
    private final ViewPropertyDelegate overlayPaddingColor$delegate;
    @NotNull
    private final ViewPropertyDelegate overlayPadding$delegate;
    @Nullable
    private final ViewPropertyDelegate overlayPosition$delegate;
    @NotNull
    private final ViewPropertyDelegate balloonOverlayShape$delegate;
    private Bitmap bitmap;
    private final Paint paint;
    private final Paint paddingColorPaint;
    private boolean invalidated;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl(BalloonAnchorOverlayView.class, "anchorView", "getAnchorView()Landroid/view/View;", 0)), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl(BalloonAnchorOverlayView.class, "overlayColor", "getOverlayColor()I", 0)), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl(BalloonAnchorOverlayView.class, "overlayPaddingColor", "getOverlayPaddingColor()I", 0)), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl(BalloonAnchorOverlayView.class, "overlayPadding", "getOverlayPadding()F", 0)), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl(BalloonAnchorOverlayView.class, "overlayPosition", "getOverlayPosition()Landroid/graphics/Point;", 0)), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl(BalloonAnchorOverlayView.class, "balloonOverlayShape", "getBalloonOverlayShape()Lcom/skydoves/balloon/overlay/BalloonOverlayShape;", 0))};
    }

    @Nullable
    public final View getAnchorView() {
        return (View)this.anchorView$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    public final void setAnchorView(@Nullable View view) {
        this.anchorView$delegate.setValue((Object)this, $$delegatedProperties[0], view);
    }

    @ColorInt
    public final int getOverlayColor() {
        return ((Number)this.overlayColor$delegate.getValue((Object)this, $$delegatedProperties[1])).intValue();
    }

    public final void setOverlayColor(int n) {
        this.overlayColor$delegate.setValue((Object)this, $$delegatedProperties[1], n);
    }

    @ColorInt
    public final int getOverlayPaddingColor() {
        return ((Number)this.overlayPaddingColor$delegate.getValue((Object)this, $$delegatedProperties[2])).intValue();
    }

    public final void setOverlayPaddingColor(int n) {
        this.overlayPaddingColor$delegate.setValue((Object)this, $$delegatedProperties[2], n);
    }

    @Px
    public final float getOverlayPadding() {
        return ((Number)this.overlayPadding$delegate.getValue((Object)this, $$delegatedProperties[3])).floatValue();
    }

    public final void setOverlayPadding(float f) {
        this.overlayPadding$delegate.setValue((Object)this, $$delegatedProperties[3], Float.valueOf(f));
    }

    @Nullable
    public final Point getOverlayPosition() {
        return (Point)this.overlayPosition$delegate.getValue((Object)this, $$delegatedProperties[4]);
    }

    public final void setOverlayPosition(@Nullable Point point) {
        this.overlayPosition$delegate.setValue((Object)this, $$delegatedProperties[4], point);
    }

    @NotNull
    public final BalloonOverlayShape getBalloonOverlayShape() {
        return (BalloonOverlayShape)this.balloonOverlayShape$delegate.getValue((Object)this, $$delegatedProperties[5]);
    }

    public final void setBalloonOverlayShape(@NotNull BalloonOverlayShape balloonOverlayShape) {
        Intrinsics.checkNotNullParameter((Object)balloonOverlayShape, (String)"<set-?>");
        this.balloonOverlayShape$delegate.setValue((Object)this, $$delegatedProperties[5], balloonOverlayShape);
    }

    public final void forceInvalidate() {
        this.invalidated = true;
        this.invalidate();
    }

    protected void dispatchDraw(@Nullable Canvas canvas) {
        block4: {
            Bitmap bitmap;
            block3: {
                block2: {
                    if (this.invalidated || this.bitmap == null) break block2;
                    Bitmap bitmap2 = this.bitmap;
                    if (bitmap2 == null) break block3;
                    if (!bitmap2.isRecycled()) break block3;
                }
                this.prepareBitmap();
            }
            if ((bitmap = this.bitmap) == null || bitmap.isRecycled()) break block4;
            Canvas canvas2 = canvas;
            if (canvas2 != null) {
                canvas2.drawBitmap(bitmap, 0.0f, 0.0f, null);
            }
        }
    }

    private final void prepareBitmap() {
        Bitmap localBitmap;
        block18: {
            block17: {
                if (this.getWidth() == 0 || this.getHeight() == 0) break block17;
                View view = this.getAnchorView();
                if (view != null && view.getWidth() == 0) break block17;
                View view2 = this.getAnchorView();
                if (view2 == null) break block18;
                if (view2.getHeight() != 0) break block18;
            }
            return;
        }
        if ((localBitmap = this.bitmap) != null && !localBitmap.isRecycled()) {
            localBitmap.recycle();
        }
        this.bitmap = localBitmap = Bitmap.createBitmap((int)this.getWidth(), (int)this.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(localBitmap);
        Paint paint = this.paint;
        boolean bl = false;
        boolean bl2 = false;
        Paint $this$apply = paint;
        boolean bl3 = false;
        $this$apply.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_OUT));
        $this$apply.setColor(this.getOverlayColor());
        canvas.drawRect(0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight(), this.paint);
        paint = this.paint;
        bl = false;
        bl2 = false;
        $this$apply = paint;
        boolean bl4 = false;
        $this$apply.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.CLEAR));
        $this$apply.setColor(0);
        paint = this.paddingColorPaint;
        bl = false;
        bl2 = false;
        $this$apply = paint;
        boolean bl5 = false;
        $this$apply.setColor(this.getOverlayPaddingColor());
        $this$apply.setStyle(Paint.Style.STROKE);
        $this$apply.setStrokeWidth(this.getOverlayPadding());
        View view = this.getAnchorView();
        if (view != null) {
            RectF rectF;
            paint = view;
            bl = false;
            bl2 = false;
            Paint anchor = paint;
            boolean bl6 = false;
            Rect rect = new Rect();
            anchor.getGlobalVisibleRect(rect);
            Point point = this.getOverlayPosition();
            if (point != null) {
                Point point2 = point;
                boolean bl7 = false;
                boolean bl8 = false;
                Point position = point2;
                boolean bl9 = false;
                rectF = new RectF((float)position.x - this.getOverlayPadding(), (float)position.y - this.getOverlayPadding() + (float)this.getStatusBarHeight(), (float)(position.x + anchor.getWidth()) + this.getOverlayPadding(), (float)(position.y + anchor.getHeight()) + this.getOverlayPadding() + (float)this.getStatusBarHeight());
            } else {
                rectF = new RectF((float)rect.left - this.getOverlayPadding(), (float)rect.top - this.getOverlayPadding(), (float)rect.right + this.getOverlayPadding(), (float)rect.bottom + this.getOverlayPadding());
            }
            RectF anchorRect = rectF;
            float halfOfOverlayPadding = this.getOverlayPadding() / (float)2;
            RectF rectF2 = new RectF(anchorRect);
            boolean bl10 = false;
            boolean bl11 = false;
            RectF $this$apply2 = rectF2;
            boolean bl12 = false;
            $this$apply2.inset(halfOfOverlayPadding, halfOfOverlayPadding);
            RectF anchorPaddingRect = rectF2;
            BalloonOverlayShape overlay = this.getBalloonOverlayShape();
            if (overlay instanceof BalloonOverlayRect) {
                canvas.drawRect(anchorRect, this.paint);
                canvas.drawRect(anchorPaddingRect, this.paddingColorPaint);
            } else if (overlay instanceof BalloonOverlayOval) {
                canvas.drawOval(anchorRect, this.paint);
                canvas.drawOval(anchorPaddingRect, this.paddingColorPaint);
            } else if (overlay instanceof BalloonOverlayCircle) {
                Float f = ((BalloonOverlayCircle)overlay).getRadius();
                if (f != null) {
                    Float f2 = f;
                    bl11 = false;
                    boolean bl13 = false;
                    float radius = ((Number)f2).floatValue();
                    boolean bl14 = false;
                    canvas.drawCircle(anchorRect.centerX(), anchorRect.centerY(), radius, this.paint);
                    canvas.drawCircle(anchorPaddingRect.centerX(), anchorPaddingRect.centerY(), radius - halfOfOverlayPadding, this.paddingColorPaint);
                }
                Integer n = ((BalloonOverlayCircle)overlay).getRadiusRes();
                if (n != null) {
                    Integer n2 = n;
                    bl11 = false;
                    boolean bl15 = false;
                    int radiusRes = ((Number)n2).intValue();
                    boolean bl16 = false;
                    float f3 = anchorRect.centerX();
                    float f4 = anchorRect.centerY();
                    Context context = this.getContext();
                    Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
                    canvas.drawCircle(f3, f4, ContextExtensionKt.dimen(context, radiusRes), this.paint);
                    float f5 = anchorPaddingRect.centerX();
                    float f6 = anchorPaddingRect.centerY();
                    Context context2 = this.getContext();
                    Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context");
                    canvas.drawCircle(f5, f6, ContextExtensionKt.dimen(context2, radiusRes) - halfOfOverlayPadding, this.paddingColorPaint);
                }
            } else if (overlay instanceof BalloonOverlayRoundRect) {
                Pair<Float, Float> pair = ((BalloonOverlayRoundRect)overlay).getRadiusPair();
                if (pair != null) {
                    Pair<Float, Float> pair2 = pair;
                    bl11 = false;
                    boolean bl17 = false;
                    Pair<Float, Float> radiusPair = pair2;
                    boolean bl18 = false;
                    canvas.drawRoundRect(anchorRect, ((Number)radiusPair.getFirst()).floatValue(), ((Number)radiusPair.getSecond()).floatValue(), this.paint);
                    canvas.drawRoundRect(anchorPaddingRect, ((Number)radiusPair.getFirst()).floatValue() - halfOfOverlayPadding, ((Number)radiusPair.getSecond()).floatValue() - halfOfOverlayPadding, this.paddingColorPaint);
                }
                Pair<Integer, Integer> pair3 = ((BalloonOverlayRoundRect)overlay).getRadiusResPair();
                if (pair3 != null) {
                    Pair<Integer, Integer> pair4 = pair3;
                    bl11 = false;
                    boolean bl19 = false;
                    Pair<Integer, Integer> radiusResPair = pair4;
                    boolean bl20 = false;
                    Context context = this.getContext();
                    Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
                    float f = ContextExtensionKt.dimen(context, ((Number)radiusResPair.getFirst()).intValue());
                    Context context3 = this.getContext();
                    Intrinsics.checkNotNullExpressionValue((Object)context3, (String)"context");
                    canvas.drawRoundRect(anchorRect, f, ContextExtensionKt.dimen(context3, ((Number)radiusResPair.getSecond()).intValue()), this.paint);
                    Context context4 = this.getContext();
                    Intrinsics.checkNotNullExpressionValue((Object)context4, (String)"context");
                    float f7 = ContextExtensionKt.dimen(context4, ((Number)radiusResPair.getFirst()).intValue()) - halfOfOverlayPadding;
                    Context context5 = this.getContext();
                    Intrinsics.checkNotNullExpressionValue((Object)context5, (String)"context");
                    canvas.drawRoundRect(anchorPaddingRect, f7, ContextExtensionKt.dimen(context5, ((Number)radiusResPair.getSecond()).intValue()) - halfOfOverlayPadding, this.paddingColorPaint);
                }
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        this.invalidated = false;
    }

    private final int getStatusBarHeight() {
        int n;
        Rect rectangle = new Rect();
        Context context = this.getContext();
        if (context instanceof Activity) {
            Window window = ((Activity)context).getWindow();
            Intrinsics.checkNotNullExpressionValue((Object)window, (String)"context.window");
            window.getDecorView().getWindowVisibleDisplayFrame(rectangle);
            n = rectangle.top;
        } else {
            n = 0;
        }
        return n;
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.invalidated = true;
    }

    @JvmOverloads
    public BalloonAnchorOverlayView(@NotNull Context context, @Nullable AttributeSet attr, int defStyle) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attr, defStyle);
        this.anchorView$delegate = ViewPropertyKt.viewProperty(this, null);
        this.overlayColor$delegate = ViewPropertyKt.viewProperty(this, 0);
        this.overlayPaddingColor$delegate = ViewPropertyKt.viewProperty(this, 0);
        this.overlayPadding$delegate = ViewPropertyKt.viewProperty(this, Float.valueOf(0.0f));
        this.overlayPosition$delegate = ViewPropertyKt.viewProperty(this, null);
        this.balloonOverlayShape$delegate = ViewPropertyKt.viewProperty(this, BalloonOverlayOval.INSTANCE);
        this.paint = new Paint(1);
        this.paddingColorPaint = new Paint(1);
        Paint paint = this.paint;
        boolean bl = false;
        boolean bl2 = false;
        Paint $this$apply = paint;
        boolean bl3 = false;
        $this$apply.setAntiAlias(true);
        $this$apply.setFilterBitmap(true);
        $this$apply.setDither(true);
        paint = this.paddingColorPaint;
        bl = false;
        bl2 = false;
        $this$apply = paint;
        boolean bl4 = false;
        $this$apply.setAntiAlias(true);
        $this$apply.setFilterBitmap(true);
        $this$apply.setDither(true);
    }

    public /* synthetic */ BalloonAnchorOverlayView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @JvmOverloads
    public BalloonAnchorOverlayView(@NotNull Context context, @Nullable AttributeSet attr) {
        this(context, attr, 0, 4, null);
    }

    @JvmOverloads
    public BalloonAnchorOverlayView(@NotNull Context context) {
        this(context, null, 0, 6, null);
    }
}

