/*
 * Decompiled with CFR 0.152.
 */
package com.skydoves.balloon;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.Shader;
import android.graphics.Typeface;
import android.graphics.Xfermode;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.text.method.MovementMethod;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewAnimationUtils;
import android.view.ViewGroup;
import android.view.ViewOutlineProvider;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.PopupWindow;
import android.widget.TextView;
import androidx.annotation.AnimRes;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.annotation.DimenRes;
import androidx.annotation.DrawableRes;
import androidx.annotation.FloatRange;
import androidx.annotation.LayoutRes;
import androidx.annotation.MainThread;
import androidx.annotation.Px;
import androidx.annotation.StringRes;
import androidx.annotation.StyleRes;
import androidx.appcompat.widget.AppCompatImageView;
import androidx.appcompat.widget.AppCompatTextView;
import androidx.core.view.ViewCompat;
import androidx.core.widget.ImageViewCompat;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.OnLifecycleEvent;
import com.skydoves.balloon.ArrowOrientation;
import com.skydoves.balloon.ArrowOrientationRules;
import com.skydoves.balloon.ArrowPositionRules;
import com.skydoves.balloon.AutoDismissRunnable;
import com.skydoves.balloon.Balloon;
import com.skydoves.balloon.Balloon$WhenMappings;
import com.skydoves.balloon.Balloon$dismiss$;
import com.skydoves.balloon.BalloonAnimation;
import com.skydoves.balloon.BalloonHighlightAnimation;
import com.skydoves.balloon.BalloonInlineDsl;
import com.skydoves.balloon.BalloonKt$sam$android_view_View_OnTouchListener$0;
import com.skydoves.balloon.BalloonKt$sam$com_skydoves_balloon_OnBalloonClickListener$0;
import com.skydoves.balloon.BalloonKt$sam$com_skydoves_balloon_OnBalloonDismissListener$0;
import com.skydoves.balloon.BalloonKt$sam$com_skydoves_balloon_OnBalloonInitializedListener$0;
import com.skydoves.balloon.BalloonKt$sam$com_skydoves_balloon_OnBalloonOutsideTouchListener$0;
import com.skydoves.balloon.BalloonKt$sam$com_skydoves_balloon_OnBalloonOverlayClickListener$0;
import com.skydoves.balloon.BalloonKt$sam$i$com_skydoves_balloon_OnBalloonClickListener$0;
import com.skydoves.balloon.BalloonKt$sam$i$com_skydoves_balloon_OnBalloonDismissListener$0;
import com.skydoves.balloon.BalloonKt$sam$i$com_skydoves_balloon_OnBalloonInitializedListener$0;
import com.skydoves.balloon.BalloonKt$sam$i$com_skydoves_balloon_OnBalloonOutsideTouchListener$0;
import com.skydoves.balloon.BalloonKt$sam$i$com_skydoves_balloon_OnBalloonOverlayClickListener$0;
import com.skydoves.balloon.BalloonPersistence;
import com.skydoves.balloon.DefinitionKt;
import com.skydoves.balloon.IconForm;
import com.skydoves.balloon.IconGravity;
import com.skydoves.balloon.OnBalloonClickListener;
import com.skydoves.balloon.OnBalloonDismissListener;
import com.skydoves.balloon.OnBalloonInitializedListener;
import com.skydoves.balloon.OnBalloonOutsideTouchListener;
import com.skydoves.balloon.OnBalloonOverlayClickListener;
import com.skydoves.balloon.R;
import com.skydoves.balloon.TextForm;
import com.skydoves.balloon.annotations.Dp;
import com.skydoves.balloon.annotations.Sp;
import com.skydoves.balloon.databinding.LayoutBalloonLibrarySkydovesBinding;
import com.skydoves.balloon.databinding.LayoutBalloonOverlayLibrarySkydovesBinding;
import com.skydoves.balloon.extensions.ContextExtensionKt;
import com.skydoves.balloon.extensions.DrawableExtensionKt;
import com.skydoves.balloon.extensions.TextViewExtensionKt;
import com.skydoves.balloon.extensions.ViewExtensionKt;
import com.skydoves.balloon.overlay.BalloonAnchorOverlayView;
import com.skydoves.balloon.overlay.BalloonOverlayAnimation;
import com.skydoves.balloon.overlay.BalloonOverlayOval;
import com.skydoves.balloon.overlay.BalloonOverlayShape;
import com.skydoves.balloon.radius.RadiusLayout;
import com.skydoves.balloon.vectortext.VectorTextView;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u00ea\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\u0018\u00002\u00020\u0001:\u0004\u008e\u0001\u008f\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020*H\u0002J\u0010\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/H\u0002J\u0010\u00100\u001a\u00020-2\u0006\u00101\u001a\u000202H\u0002J\b\u00103\u001a\u00020-H\u0002J\b\u00104\u001a\u00020-H\u0002J\b\u00105\u001a\u00020-H\u0002J\u0006\u00106\u001a\u00020-J\u000e\u00107\u001a\u00020\u00172\u0006\u00108\u001a\u000209J \u0010:\u001a\u00020&2\u0006\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020>H\u0002J\u0010\u0010@\u001a\u00020*2\u0006\u0010.\u001a\u00020/H\u0002J\u0010\u0010A\u001a\u00020*2\u0006\u0010.\u001a\u00020/H\u0002J\u0006\u0010B\u001a\u00020/J\n\u0010C\u001a\u0004\u0018\u00010DH\u0002J$\u0010E\u001a\u000e\u0012\u0004\u0012\u00020>\u0012\u0004\u0012\u00020>0F2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020*H\u0002J\u0006\u0010G\u001a\u000202J\b\u0010H\u001a\u00020>H\u0002J\u0006\u0010I\u001a\u00020>J\u0018\u0010J\u001a\u00020>2\u0006\u0010K\u001a\u00020>2\u0006\u0010L\u001a\u00020/H\u0002J\u0006\u0010M\u001a\u00020>J\b\u0010N\u001a\u00020*H\u0002J\b\u0010O\u001a\u00020\u0017H\u0002J\u0010\u0010P\u001a\u00020-2\u0006\u0010.\u001a\u00020/H\u0002J\b\u0010Q\u001a\u00020-H\u0002J\b\u0010R\u001a\u00020-H\u0002J\b\u0010S\u001a\u00020-H\u0002J\b\u0010T\u001a\u00020-H\u0002J\b\u0010U\u001a\u00020-H\u0002J\b\u0010V\u001a\u00020-H\u0002J\b\u0010W\u001a\u00020-H\u0002J\b\u0010X\u001a\u00020-H\u0002J\b\u0010Y\u001a\u00020-H\u0002J\b\u0010Z\u001a\u00020-H\u0002J\u0018\u0010[\u001a\u00020-2\u0006\u0010\\\u001a\u00020]2\u0006\u0010L\u001a\u00020/H\u0002J\b\u0010^\u001a\u00020-H\u0007J\b\u0010_\u001a\u00020-H\u0007J6\u0010`\u001a\u00020\u00002\u0006\u0010a\u001a\u00020\u00002#\b\u0004\u0010b\u001a\u001d\u0012\u0013\u0012\u00110\u0000\u00a2\u0006\f\bd\u0012\b\be\u0012\u0004\b\b(a\u0012\u0004\u0012\u00020-0cH\u0083\bJ,\u0010f\u001a\u00020\u00002\u0006\u0010a\u001a\u00020\u00002\u0006\u0010.\u001a\u00020/2\b\b\u0002\u0010g\u001a\u00020>2\b\b\u0002\u0010h\u001a\u00020>H\u0007J,\u0010i\u001a\u00020\u00002\u0006\u0010a\u001a\u00020\u00002\u0006\u0010.\u001a\u00020/2\b\b\u0002\u0010g\u001a\u00020>2\b\b\u0002\u0010h\u001a\u00020>H\u0007J,\u0010j\u001a\u00020\u00002\u0006\u0010a\u001a\u00020\u00002\u0006\u0010.\u001a\u00020/2\b\b\u0002\u0010g\u001a\u00020>2\b\b\u0002\u0010h\u001a\u00020>H\u0007J,\u0010k\u001a\u00020\u00002\u0006\u0010a\u001a\u00020\u00002\u0006\u0010.\u001a\u00020/2\b\b\u0002\u0010g\u001a\u00020>2\b\b\u0002\u0010h\u001a\u00020>H\u0007J,\u0010l\u001a\u00020\u00002\u0006\u0010a\u001a\u00020\u00002\u0006\u0010.\u001a\u00020/2\b\b\u0002\u0010g\u001a\u00020>2\b\b\u0002\u0010h\u001a\u00020>H\u0007J\u0016\u0010m\u001a\u00020\u00002\u0006\u0010a\u001a\u00020\u00002\u0006\u0010.\u001a\u00020/J&\u0010m\u001a\u00020\u00002\u0006\u0010a\u001a\u00020\u00002\u0006\u0010.\u001a\u00020/2\u0006\u0010g\u001a\u00020>2\u0006\u0010h\u001a\u00020>J\u001a\u0010n\u001a\u00020-2\u0012\u0010b\u001a\u000e\u0012\u0004\u0012\u00020/\u0012\u0004\u0012\u00020-0cJ\u0010\u0010n\u001a\u00020-2\b\u0010o\u001a\u0004\u0018\u00010pJ\u0014\u0010q\u001a\u00020-2\f\u0010b\u001a\b\u0012\u0004\u0012\u00020-0rJ\u0010\u0010q\u001a\u00020-2\b\u0010s\u001a\u0004\u0018\u00010tJ\u001a\u0010u\u001a\u00020-2\u0012\u0010b\u001a\u000e\u0012\u0004\u0012\u00020/\u0012\u0004\u0012\u00020-0cJ\u0010\u0010u\u001a\u00020-2\b\u0010!\u001a\u0004\u0018\u00010 J \u0010v\u001a\u00020-2\u0018\u0010b\u001a\u0014\u0012\u0004\u0012\u00020/\u0012\u0004\u0012\u00020x\u0012\u0004\u0012\u00020-0wJ\u0010\u0010v\u001a\u00020-2\b\u0010y\u001a\u0004\u0018\u00010zJ\u0014\u0010{\u001a\u00020-2\f\u0010b\u001a\b\u0012\u0004\u0012\u00020-0rJ\u0010\u0010{\u001a\u00020-2\b\u0010|\u001a\u0004\u0018\u00010}J \u0010~\u001a\u00020-2\u0018\u0010b\u001a\u0014\u0012\u0004\u0012\u00020/\u0012\u0004\u0012\u00020x\u0012\u0004\u0012\u00020\u00170wJ\u0011\u0010~\u001a\u00020-2\t\u0010\u007f\u001a\u0005\u0018\u00010\u0080\u0001J\u0012\u0010\u0081\u0001\u001a\u00020-2\t\u0010\u007f\u001a\u0005\u0018\u00010\u0080\u0001J\u0007\u0010\u0082\u0001\u001a\u00020\u0017J\u000f\u0010\u0083\u0001\u001a\u00020-2\u0006\u0010.\u001a\u00020/J\"\u0010\u0083\u0001\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\u000e\b\u0004\u0010b\u001a\b\u0012\u0004\u0012\u00020-0rH\u0083\bJ\u001f\u0010\u0083\u0001\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\u0006\u0010g\u001a\u00020>2\u0006\u0010h\u001a\u00020>J%\u0010\u0084\u0001\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\b\b\u0002\u0010g\u001a\u00020>2\b\b\u0002\u0010h\u001a\u00020>H\u0007J%\u0010\u0085\u0001\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\b\b\u0002\u0010g\u001a\u00020>2\b\b\u0002\u0010h\u001a\u00020>H\u0007J%\u0010\u0086\u0001\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\b\b\u0002\u0010g\u001a\u00020>2\b\b\u0002\u0010h\u001a\u00020>H\u0007J%\u0010\u0087\u0001\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\b\b\u0002\u0010g\u001a\u00020>2\b\b\u0002\u0010h\u001a\u00020>H\u0007J%\u0010\u0088\u0001\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\b\b\u0002\u0010g\u001a\u00020>2\b\b\u0002\u0010h\u001a\u00020>H\u0007J\u0011\u0010\u0089\u0001\u001a\u00020-2\u0006\u0010.\u001a\u00020/H\u0002J\t\u0010\u008a\u0001\u001a\u00020-H\u0002J\t\u0010\u008b\u0001\u001a\u00020-H\u0002J\u0011\u0010\u008c\u0001\u001a\u00020-2\u0006\u00101\u001a\u000202H\u0002J\"\u0010\u008d\u0001\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\u000e\b\u0004\u0010b\u001a\b\u0012\u0004\u0012\u00020-0rH\u0083\bJ%\u0010\u008d\u0001\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\b\b\u0002\u0010g\u001a\u00020>2\b\b\u0002\u0010h\u001a\u00020>H\u0007R\u001b\u0010\u0007\u001a\u00020\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u001b\u0010\r\u001a\u00020\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\f\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0018\u001a\u00020\u00198BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001c\u0010\f\u001a\u0004\b\u001a\u0010\u001bR\u001e\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u0017@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u001e\u0010!\u001a\u0004\u0018\u00010 2\b\u0010\u001d\u001a\u0004\u0018\u00010 8\u0006@FX\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0090\u0001"}, d2={"Lcom/skydoves/balloon/Balloon;", "Landroidx/lifecycle/LifecycleObserver;", "context", "Landroid/content/Context;", "builder", "Lcom/skydoves/balloon/Balloon$Builder;", "(Landroid/content/Context;Lcom/skydoves/balloon/Balloon$Builder;)V", "autoDismissRunnable", "Lcom/skydoves/balloon/AutoDismissRunnable;", "getAutoDismissRunnable", "()Lcom/skydoves/balloon/AutoDismissRunnable;", "autoDismissRunnable$delegate", "Lkotlin/Lazy;", "balloonPersistence", "Lcom/skydoves/balloon/BalloonPersistence;", "getBalloonPersistence", "()Lcom/skydoves/balloon/BalloonPersistence;", "balloonPersistence$delegate", "binding", "Lcom/skydoves/balloon/databinding/LayoutBalloonLibrarySkydovesBinding;", "bodyWindow", "Landroid/widget/PopupWindow;", "destroyed", "", "handler", "Landroid/os/Handler;", "getHandler", "()Landroid/os/Handler;", "handler$delegate", "<set-?>", "isShowing", "()Z", "Lcom/skydoves/balloon/OnBalloonInitializedListener;", "onBalloonInitializedListener", "overlayBinding", "Lcom/skydoves/balloon/databinding/LayoutBalloonOverlayLibrarySkydovesBinding;", "overlayWindow", "adjustArrowColorByMatchingCardBackground", "Landroid/graphics/Bitmap;", "imageView", "Landroidx/appcompat/widget/AppCompatImageView;", "x", "", "y", "adjustArrowOrientationByRules", "", "anchor", "Landroid/view/View;", "adjustFitsSystemWindows", "parent", "Landroid/view/ViewGroup;", "applyBalloonAnimation", "applyBalloonOverlayAnimation", "createByBuilder", "dismiss", "dismissWithDelay", "delay", "", "drawableToBitmap", "drawable", "Landroid/graphics/drawable/Drawable;", "width", "", "height", "getArrowConstraintPositionX", "getArrowConstraintPositionY", "getBalloonArrowView", "getBalloonHighlightAnimation", "Landroid/view/animation/Animation;", "getColorsFromBalloonCard", "Lkotlin/Pair;", "getContentView", "getDoubleArrowSize", "getMeasuredHeight", "getMeasuredTextWidth", "measuredWidth", "rootView", "getMeasuredWidth", "getMinArrowPosition", "hasCustomLayout", "initializeArrow", "initializeBackground", "initializeBalloonContent", "initializeBalloonLayout", "initializeBalloonListeners", "initializeBalloonOverlay", "initializeBalloonRoot", "initializeBalloonWindow", "initializeCustomLayout", "initializeIcon", "initializeText", "measureTextWidth", "textView", "Landroidx/appcompat/widget/AppCompatTextView;", "onDestroy", "onPause", "relay", "balloon", "block", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "relayShow", "xOff", "yOff", "relayShowAlignBottom", "relayShowAlignLeft", "relayShowAlignRight", "relayShowAlignTop", "relayShowAsDropDown", "setOnBalloonClickListener", "onBalloonClickListener", "Lcom/skydoves/balloon/OnBalloonClickListener;", "setOnBalloonDismissListener", "Lkotlin/Function0;", "onBalloonDismissListener", "Lcom/skydoves/balloon/OnBalloonDismissListener;", "setOnBalloonInitializedListener", "setOnBalloonOutsideTouchListener", "Lkotlin/Function2;", "Landroid/view/MotionEvent;", "onBalloonOutsideTouchListener", "Lcom/skydoves/balloon/OnBalloonOutsideTouchListener;", "setOnBalloonOverlayClickListener", "onBalloonOverlayClickListener", "Lcom/skydoves/balloon/OnBalloonOverlayClickListener;", "setOnBalloonOverlayTouchListener", "onTouchListener", "Landroid/view/View$OnTouchListener;", "setOnBalloonTouchListener", "shouldShowUp", "show", "showAlignBottom", "showAlignLeft", "showAlignRight", "showAlignTop", "showAsDropDown", "showOverlayWindow", "startBalloonHighlightAnimation", "stopBalloonHighlightAnimation", "traverseAndMeasureTextWidth", "update", "Builder", "Factory", "balloon_release"})
public final class Balloon
implements LifecycleObserver {
    private final LayoutBalloonLibrarySkydovesBinding binding;
    private final LayoutBalloonOverlayLibrarySkydovesBinding overlayBinding;
    private final PopupWindow bodyWindow;
    private final PopupWindow overlayWindow;
    private boolean isShowing;
    private boolean destroyed;
    @JvmField
    @Nullable
    public OnBalloonInitializedListener onBalloonInitializedListener;
    private final Lazy handler$delegate;
    private final Lazy autoDismissRunnable$delegate;
    private final Lazy balloonPersistence$delegate;
    private final Context context;
    private final Builder builder;

    public final boolean isShowing() {
        return this.isShowing;
    }

    private final Handler getHandler() {
        Lazy lazy = this.handler$delegate;
        Balloon balloon2 = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Handler)lazy.getValue();
    }

    private final AutoDismissRunnable getAutoDismissRunnable() {
        Lazy lazy = this.autoDismissRunnable$delegate;
        Balloon balloon2 = this;
        Object var3_3 = null;
        boolean bl = false;
        return (AutoDismissRunnable)lazy.getValue();
    }

    private final BalloonPersistence getBalloonPersistence() {
        Lazy lazy = this.balloonPersistence$delegate;
        Balloon balloon2 = this;
        Object var3_3 = null;
        boolean bl = false;
        return (BalloonPersistence)lazy.getValue();
    }

    private final void createByBuilder() {
        block1: {
            block0: {
                this.initializeBackground();
                this.initializeBalloonRoot();
                this.initializeBalloonWindow();
                this.initializeBalloonLayout();
                this.initializeBalloonContent();
                this.initializeBalloonOverlay();
                this.initializeBalloonListeners();
                FrameLayout frameLayout = this.binding.getRoot();
                Intrinsics.checkNotNullExpressionValue((Object)frameLayout, (String)"binding.root");
                this.adjustFitsSystemWindows((ViewGroup)frameLayout);
                if (this.builder.lifecycleOwner != null || !(this.context instanceof LifecycleOwner)) break block0;
                this.builder.setLifecycleOwner((LifecycleOwner)this.context);
                ((LifecycleOwner)this.context).getLifecycle().addObserver((LifecycleObserver)this);
                break block1;
            }
            LifecycleOwner lifecycleOwner = this.builder.lifecycleOwner;
            if (lifecycleOwner == null || (lifecycleOwner = lifecycleOwner.getLifecycle()) == null) break block1;
            lifecycleOwner.addObserver((LifecycleObserver)this);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void adjustFitsSystemWindows(ViewGroup parent) {
        void $this$mapTo$iv$iv;
        parent.setFitsSystemWindows(false);
        Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)parent.getChildCount());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            View view = parent.getChildAt((int)it);
            collection.add(view);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            View child = (View)element$iv;
            boolean bl = false;
            View view = child;
            Intrinsics.checkNotNullExpressionValue((Object)view, (String)"child");
            view.setFitsSystemWindows(false);
            if (!(child instanceof ViewGroup)) continue;
            this.adjustFitsSystemWindows((ViewGroup)child);
        }
    }

    private final float getMinArrowPosition() {
        return (float)this.builder.arrowSize * this.builder.arrowAlignAnchorPaddingRatio + (float)this.builder.arrowAlignAnchorPadding;
    }

    private final int getDoubleArrowSize() {
        return this.builder.arrowSize * 2;
    }

    private final void initializeArrow(View anchor) {
        AppCompatImageView appCompatImageView = this.binding.balloonArrow;
        boolean bl = false;
        boolean bl2 = false;
        AppCompatImageView $this$with = appCompatImageView;
        boolean bl3 = false;
        $this$with.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(this.builder.arrowSize, this.builder.arrowSize));
        $this$with.setAlpha(this.builder.alpha);
        Drawable drawable = this.builder.arrowDrawable;
        if (drawable != null) {
            Drawable drawable2 = drawable;
            boolean bl4 = false;
            boolean bl5 = false;
            Drawable it = drawable2;
            boolean bl6 = false;
            $this$with.setImageDrawable(it);
        }
        $this$with.setPadding(this.builder.arrowLeftPadding, this.builder.arrowTopPadding, this.builder.arrowRightPadding, this.builder.arrowBottomPadding);
        if (this.builder.arrowColor != Integer.MIN_VALUE) {
            ImageViewCompat.setImageTintList((ImageView)((ImageView)$this$with), (ColorStateList)ColorStateList.valueOf((int)this.builder.arrowColor));
        } else {
            ImageViewCompat.setImageTintList((ImageView)((ImageView)$this$with), (ColorStateList)ColorStateList.valueOf((int)this.builder.backgroundColor));
        }
        boolean $i$f$runOnAfterSDK21 = false;
        if (Build.VERSION.SDK_INT >= 21) {
            boolean bl7 = false;
            $this$with.setOutlineProvider(ViewOutlineProvider.BOUNDS);
        }
        this.binding.balloonCard.post(new Runnable($this$with, this, anchor){
            final /* synthetic */ AppCompatImageView $this_with;
            final /* synthetic */ Balloon this$0;
            final /* synthetic */ View $anchor$inlined;
            {
                this.$this_with = appCompatImageView;
                this.this$0 = balloon2;
                this.$anchor$inlined = view;
            }

            public final void run() {
                OnBalloonInitializedListener onBalloonInitializedListener = this.this$0.onBalloonInitializedListener;
                if (onBalloonInitializedListener != null) {
                    onBalloonInitializedListener.onBalloonInitialized((View)this.this$0.getContentView());
                }
                Balloon.access$adjustArrowOrientationByRules(this.this$0, this.$anchor$inlined);
                switch (Balloon$WhenMappings.$EnumSwitchMapping$0[Balloon.access$getBuilder$p((Balloon)this.this$0).arrowOrientation.ordinal()]) {
                    case 1: {
                        this.$this_with.setRotation(180.0f);
                        this.$this_with.setX(Balloon.access$getArrowConstraintPositionX(this.this$0, this.$anchor$inlined));
                        RadiusLayout radiusLayout = Balloon.access$getBinding$p((Balloon)this.this$0).balloonCard;
                        Intrinsics.checkNotNullExpressionValue((Object)((Object)radiusLayout), (String)"binding.balloonCard");
                        float f = radiusLayout.getY();
                        RadiusLayout radiusLayout2 = Balloon.access$getBinding$p((Balloon)this.this$0).balloonCard;
                        Intrinsics.checkNotNullExpressionValue((Object)((Object)radiusLayout2), (String)"binding.balloonCard");
                        this.$this_with.setY(f + (float)radiusLayout2.getHeight() - 1.0f);
                        ViewCompat.setElevation((View)((View)this.$this_with), (float)Balloon.access$getBuilder$p((Balloon)this.this$0).arrowElevation);
                        if (Balloon.access$getBuilder$p((Balloon)this.this$0).arrowColorMatchBalloon) {
                            Resources resources = this.$this_with.getResources();
                            AppCompatImageView appCompatImageView = this.$this_with;
                            Intrinsics.checkNotNullExpressionValue((Object)appCompatImageView, (String)"this");
                            float f2 = this.$this_with.getX();
                            RadiusLayout radiusLayout3 = Balloon.access$getBinding$p((Balloon)this.this$0).balloonCard;
                            Intrinsics.checkNotNullExpressionValue((Object)((Object)radiusLayout3), (String)"binding.balloonCard");
                            this.$this_with.setForeground((Drawable)new BitmapDrawable(resources, Balloon.access$adjustArrowColorByMatchingCardBackground(this.this$0, appCompatImageView, f2, radiusLayout3.getHeight())));
                        }
                        break;
                    }
                    case 2: {
                        this.$this_with.setRotation(0.0f);
                        this.$this_with.setX(Balloon.access$getArrowConstraintPositionX(this.this$0, this.$anchor$inlined));
                        RadiusLayout radiusLayout = Balloon.access$getBinding$p((Balloon)this.this$0).balloonCard;
                        Intrinsics.checkNotNullExpressionValue((Object)((Object)radiusLayout), (String)"binding.balloonCard");
                        this.$this_with.setY(radiusLayout.getY() - (float)Balloon.access$getBuilder$p((Balloon)this.this$0).arrowSize + 1.0f);
                        if (Balloon.access$getBuilder$p((Balloon)this.this$0).arrowColorMatchBalloon) {
                            Resources resources = this.$this_with.getResources();
                            AppCompatImageView appCompatImageView = this.$this_with;
                            Intrinsics.checkNotNullExpressionValue((Object)appCompatImageView, (String)"this");
                            this.$this_with.setForeground((Drawable)new BitmapDrawable(resources, Balloon.access$adjustArrowColorByMatchingCardBackground(this.this$0, appCompatImageView, this.$this_with.getX(), 0.0f)));
                        }
                        break;
                    }
                    case 3: {
                        this.$this_with.setRotation(-90.0f);
                        RadiusLayout radiusLayout = Balloon.access$getBinding$p((Balloon)this.this$0).balloonCard;
                        Intrinsics.checkNotNullExpressionValue((Object)((Object)radiusLayout), (String)"binding.balloonCard");
                        this.$this_with.setX(radiusLayout.getX() - (float)Balloon.access$getBuilder$p((Balloon)this.this$0).arrowSize + 1.0f);
                        this.$this_with.setY(Balloon.access$getArrowConstraintPositionY(this.this$0, this.$anchor$inlined));
                        if (Balloon.access$getBuilder$p((Balloon)this.this$0).arrowColorMatchBalloon) {
                            Resources resources = this.$this_with.getResources();
                            AppCompatImageView appCompatImageView = this.$this_with;
                            Intrinsics.checkNotNullExpressionValue((Object)appCompatImageView, (String)"this");
                            this.$this_with.setForeground((Drawable)new BitmapDrawable(resources, Balloon.access$adjustArrowColorByMatchingCardBackground(this.this$0, appCompatImageView, 0.0f, this.$this_with.getY())));
                        }
                        break;
                    }
                    case 4: {
                        this.$this_with.setRotation(90.0f);
                        RadiusLayout radiusLayout = Balloon.access$getBinding$p((Balloon)this.this$0).balloonCard;
                        Intrinsics.checkNotNullExpressionValue((Object)((Object)radiusLayout), (String)"binding.balloonCard");
                        float f = radiusLayout.getX();
                        RadiusLayout radiusLayout4 = Balloon.access$getBinding$p((Balloon)this.this$0).balloonCard;
                        Intrinsics.checkNotNullExpressionValue((Object)((Object)radiusLayout4), (String)"binding.balloonCard");
                        this.$this_with.setX(f + (float)radiusLayout4.getWidth() - 1.0f);
                        this.$this_with.setY(Balloon.access$getArrowConstraintPositionY(this.this$0, this.$anchor$inlined));
                        if (Balloon.access$getBuilder$p((Balloon)this.this$0).arrowColorMatchBalloon) {
                            Resources resources = this.$this_with.getResources();
                            AppCompatImageView appCompatImageView = this.$this_with;
                            Intrinsics.checkNotNullExpressionValue((Object)appCompatImageView, (String)"this");
                            RadiusLayout radiusLayout5 = Balloon.access$getBinding$p((Balloon)this.this$0).balloonCard;
                            Intrinsics.checkNotNullExpressionValue((Object)((Object)radiusLayout5), (String)"binding.balloonCard");
                            this.$this_with.setForeground((Drawable)new BitmapDrawable(resources, Balloon.access$adjustArrowColorByMatchingCardBackground(this.this$0, appCompatImageView, radiusLayout5.getWidth(), this.$this_with.getY())));
                        }
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                ViewExtensionKt.visible((View)this.$this_with, Balloon.access$getBuilder$p((Balloon)this.this$0).isVisibleArrow);
            }
        });
    }

    private final Bitmap adjustArrowColorByMatchingCardBackground(AppCompatImageView imageView, float x, float y) {
        LinearGradient linearGradient;
        imageView.setColorFilter(this.builder.backgroundColor, PorterDuff.Mode.SRC_IN);
        Drawable drawable = imageView.getDrawable();
        Intrinsics.checkNotNullExpressionValue((Object)drawable, (String)"imageView.drawable");
        Drawable drawable2 = imageView.getDrawable();
        Intrinsics.checkNotNullExpressionValue((Object)drawable2, (String)"imageView.drawable");
        int n = drawable2.getIntrinsicWidth();
        Drawable drawable3 = imageView.getDrawable();
        Intrinsics.checkNotNullExpressionValue((Object)drawable3, (String)"imageView.drawable");
        Bitmap oldBitmap = this.drawableToBitmap(drawable, n, drawable3.getIntrinsicHeight());
        Pair<Integer, Integer> colors = null;
        try {
            colors = this.getColorsFromBalloonCard(x, y);
        }
        catch (IllegalArgumentException e) {
            throw (Throwable)new IllegalArgumentException("Arrow attached outside balloon. Could not get a matching color.");
        }
        int startColor = ((Number)colors.getFirst()).intValue();
        int endColor = ((Number)colors.getSecond()).intValue();
        Bitmap updatedBitmap = Bitmap.createBitmap((int)oldBitmap.getWidth(), (int)oldBitmap.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(updatedBitmap);
        canvas.drawBitmap(oldBitmap, 0.0f, 0.0f, null);
        Paint paint = new Paint();
        switch (Balloon$WhenMappings.$EnumSwitchMapping$1[this.builder.arrowOrientation.ordinal()]) {
            case 1: 
            case 2: {
                linearGradient = new LinearGradient((float)oldBitmap.getWidth() / (float)2 - (float)(this.builder.arrowSize / 2), 0.0f, (float)oldBitmap.getWidth(), 0.0f, startColor, endColor, Shader.TileMode.CLAMP);
                break;
            }
            case 3: 
            case 4: {
                linearGradient = new LinearGradient((float)oldBitmap.getWidth() / (float)2 + (float)(this.builder.arrowSize / 2), 0.0f, 0.0f, 0.0f, startColor, endColor, Shader.TileMode.CLAMP);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        LinearGradient shader = linearGradient;
        paint.setShader((Shader)shader);
        paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
        canvas.drawRect(0.0f, 0.0f, (float)oldBitmap.getWidth(), (float)oldBitmap.getHeight(), paint);
        imageView.setColorFilter(0, PorterDuff.Mode.SRC_IN);
        Bitmap bitmap = updatedBitmap;
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"updatedBitmap");
        return bitmap;
    }

    private final Pair<Integer, Integer> getColorsFromBalloonCard(float x, float y) {
        RadiusLayout radiusLayout = this.binding.balloonCard;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)radiusLayout), (String)"binding.balloonCard");
        Drawable drawable = radiusLayout.getBackground();
        Intrinsics.checkNotNullExpressionValue((Object)drawable, (String)"binding.balloonCard.background");
        RadiusLayout radiusLayout2 = this.binding.balloonCard;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)radiusLayout2), (String)"binding.balloonCard");
        int n = radiusLayout2.getWidth() + 1;
        RadiusLayout radiusLayout3 = this.binding.balloonCard;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)radiusLayout3), (String)"binding.balloonCard");
        Bitmap bitmap = this.drawableToBitmap(drawable, n, radiusLayout3.getHeight() + 1);
        int startColor = 0;
        int endColor = 0;
        switch (Balloon$WhenMappings.$EnumSwitchMapping$2[this.builder.arrowOrientation.ordinal()]) {
            case 1: 
            case 2: {
                startColor = bitmap.getPixel((int)(x + (float)this.builder.arrowSize / 2.0f), (int)y);
                endColor = bitmap.getPixel((int)(x - (float)this.builder.arrowSize / 2.0f), (int)y);
                break;
            }
            case 3: 
            case 4: {
                startColor = bitmap.getPixel((int)x, (int)(y + (float)this.builder.arrowSize / 2.0f));
                endColor = bitmap.getPixel((int)x, (int)(y - (float)this.builder.arrowSize / 2.0f));
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return new Pair((Object)startColor, (Object)endColor);
    }

    private final Bitmap drawableToBitmap(Drawable drawable, int width, int height) {
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        drawable.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
        drawable.draw(canvas);
        Bitmap bitmap2 = bitmap;
        Intrinsics.checkNotNullExpressionValue((Object)bitmap2, (String)"bitmap");
        return bitmap2;
    }

    private final void adjustArrowOrientationByRules(View anchor) {
        if (this.builder.arrowOrientationRules == ArrowOrientationRules.ALIGN_FIXED) {
            return;
        }
        Rect anchorRect = new Rect();
        anchor.getGlobalVisibleRect(anchorRect);
        int[] location = new int[]{0, 0};
        this.bodyWindow.getContentView().getLocationOnScreen(location);
        if (this.builder.arrowOrientation == ArrowOrientation.TOP && location[1] < anchorRect.bottom) {
            this.builder.setArrowOrientation(ArrowOrientation.BOTTOM);
        } else if (this.builder.arrowOrientation == ArrowOrientation.BOTTOM && location[1] > anchorRect.top) {
            this.builder.setArrowOrientation(ArrowOrientation.TOP);
        }
        this.initializeBalloonContent();
    }

    private final float getArrowConstraintPositionX(View anchor) {
        float f;
        FrameLayout frameLayout = this.binding.balloonContent;
        Intrinsics.checkNotNullExpressionValue((Object)frameLayout, (String)"binding.balloonContent");
        int balloonX = ViewExtensionKt.getViewPointOnScreen((View)((View)frameLayout)).x;
        int anchorX = ViewExtensionKt.getViewPointOnScreen((View)anchor).x;
        float minPosition = this.getMinArrowPosition();
        float maxPosition = (float)this.getMeasuredWidth() - minPosition - (float)this.builder.marginRight - (float)this.builder.marginLeft;
        float arrowHalfSize = (float)this.builder.arrowSize / 2.0f;
        switch (Balloon$WhenMappings.$EnumSwitchMapping$3[this.builder.arrowPositionRules.ordinal()]) {
            case 1: {
                FrameLayout frameLayout2 = this.binding.balloonWrapper;
                Intrinsics.checkNotNullExpressionValue((Object)frameLayout2, (String)"binding.balloonWrapper");
                f = (float)frameLayout2.getWidth() * this.builder.arrowPosition - arrowHalfSize;
                break;
            }
            case 2: {
                if (anchorX + anchor.getWidth() < balloonX) {
                    f = minPosition;
                    break;
                }
                if (balloonX + this.getMeasuredWidth() < anchorX) {
                    f = maxPosition;
                    break;
                }
                float position = (float)anchor.getWidth() * this.builder.arrowPosition + (float)anchorX - (float)balloonX - arrowHalfSize;
                if (position <= (float)this.getDoubleArrowSize()) {
                    f = minPosition;
                    break;
                }
                if (position > (float)(this.getMeasuredWidth() - this.getDoubleArrowSize())) {
                    f = maxPosition;
                    break;
                }
                f = position;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return f;
    }

    private final float getArrowConstraintPositionY(View anchor) {
        float f;
        int statusBarHeight = ViewExtensionKt.getStatusBarHeight(anchor, this.builder.isStatusBarVisible);
        FrameLayout frameLayout = this.binding.balloonContent;
        Intrinsics.checkNotNullExpressionValue((Object)frameLayout, (String)"binding.balloonContent");
        int balloonY = ViewExtensionKt.getViewPointOnScreen((View)((View)frameLayout)).y - statusBarHeight;
        int anchorY = ViewExtensionKt.getViewPointOnScreen((View)anchor).y - statusBarHeight;
        float minPosition = this.getMinArrowPosition();
        float maxPosition = (float)this.getMeasuredHeight() - minPosition - (float)this.builder.marginTop - (float)this.builder.marginBottom;
        int arrowHalfSize = this.builder.arrowSize / 2;
        switch (Balloon$WhenMappings.$EnumSwitchMapping$4[this.builder.arrowPositionRules.ordinal()]) {
            case 1: {
                FrameLayout frameLayout2 = this.binding.balloonWrapper;
                Intrinsics.checkNotNullExpressionValue((Object)frameLayout2, (String)"binding.balloonWrapper");
                f = (float)frameLayout2.getHeight() * this.builder.arrowPosition - (float)arrowHalfSize;
                break;
            }
            case 2: {
                if (anchorY + anchor.getHeight() < balloonY) {
                    f = minPosition;
                    break;
                }
                if (balloonY + this.getMeasuredHeight() < anchorY) {
                    f = maxPosition;
                    break;
                }
                float position = (float)anchor.getHeight() * this.builder.arrowPosition + (float)anchorY - (float)balloonY - (float)arrowHalfSize;
                if (position <= (float)this.getDoubleArrowSize()) {
                    f = minPosition;
                    break;
                }
                if (position > (float)(this.getMeasuredHeight() - this.getDoubleArrowSize())) {
                    f = maxPosition;
                    break;
                }
                f = position;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return f;
    }

    /*
     * WARNING - void declaration
     */
    private final void initializeBackground() {
        RadiusLayout radiusLayout = this.binding.balloonCard;
        boolean bl = false;
        boolean bl2 = false;
        RadiusLayout $this$with = radiusLayout;
        boolean bl3 = false;
        $this$with.setAlpha(this.builder.alpha);
        $this$with.setRadius(this.builder.cornerRadius);
        ViewCompat.setElevation((View)((View)$this$with), (float)this.builder.elevation);
        RadiusLayout radiusLayout2 = $this$with;
        Drawable drawable = this.builder.backgroundDrawable;
        if (drawable == null) {
            void $this$apply;
            GradientDrawable gradientDrawable = new GradientDrawable();
            boolean bl4 = false;
            boolean bl5 = false;
            GradientDrawable gradientDrawable2 = gradientDrawable;
            RadiusLayout radiusLayout3 = radiusLayout2;
            boolean bl6 = false;
            $this$apply.setColor(this.builder.backgroundColor);
            $this$apply.setCornerRadius(this.builder.cornerRadius);
            Unit unit = Unit.INSTANCE;
            radiusLayout2 = radiusLayout3;
            drawable = (Drawable)gradientDrawable;
        }
        radiusLayout2.setBackground(drawable);
        $this$with.setPadding(this.builder.paddingLeft, this.builder.paddingTop, this.builder.paddingRight, this.builder.paddingBottom);
    }

    private final void initializeBalloonWindow() {
        PopupWindow popupWindow = this.bodyWindow;
        boolean bl = false;
        boolean bl2 = false;
        PopupWindow $this$with = popupWindow;
        boolean bl3 = false;
        $this$with.setOutsideTouchable(true);
        $this$with.setFocusable(this.builder.isFocusable);
        $this$with.setBackgroundDrawable((Drawable)new ColorDrawable(0));
        boolean $i$f$runOnAfterSDK21 = false;
        if (Build.VERSION.SDK_INT >= 21) {
            boolean bl4 = false;
            $this$with.setElevation(this.builder.elevation);
        }
    }

    private final void initializeBalloonListeners() {
        this.setOnBalloonClickListener(this.builder.onBalloonClickListener);
        this.setOnBalloonDismissListener(this.builder.onBalloonDismissListener);
        this.setOnBalloonOutsideTouchListener(this.builder.onBalloonOutsideTouchListener);
        this.setOnBalloonTouchListener(this.builder.onBalloonTouchListener);
        this.setOnBalloonOverlayClickListener(this.builder.onBalloonOverlayClickListener);
        this.setOnBalloonOverlayTouchListener(this.builder.onBalloonOverlayTouchListener);
    }

    private final void initializeBalloonRoot() {
        FrameLayout frameLayout = this.binding.balloonWrapper;
        boolean bl = false;
        boolean bl2 = false;
        FrameLayout $this$with = frameLayout;
        boolean bl3 = false;
        ViewGroup.LayoutParams layoutParams = $this$with.getLayoutParams();
        if (layoutParams == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.view.ViewGroup.MarginLayoutParams");
        }
        ((ViewGroup.MarginLayoutParams)layoutParams).setMargins(this.builder.marginLeft, this.builder.marginTop, this.builder.marginRight, this.builder.marginBottom);
    }

    private final void initializeBalloonContent() {
        int paddingSize = this.builder.arrowSize - 1;
        int elevation = (int)this.builder.elevation;
        FrameLayout frameLayout = this.binding.balloonContent;
        boolean bl = false;
        boolean bl2 = false;
        FrameLayout $this$with = frameLayout;
        boolean bl3 = false;
        switch (Balloon$WhenMappings.$EnumSwitchMapping$5[this.builder.arrowOrientation.ordinal()]) {
            case 1: {
                $this$with.setPadding(paddingSize, elevation, paddingSize, elevation);
                break;
            }
            case 2: {
                $this$with.setPadding(paddingSize, elevation, paddingSize, elevation);
                break;
            }
            case 3: {
                $this$with.setPadding(elevation, paddingSize, elevation, RangesKt.coerceAtLeast((int)paddingSize, (int)elevation));
                break;
            }
            case 4: {
                $this$with.setPadding(elevation, paddingSize, elevation, RangesKt.coerceAtLeast((int)paddingSize, (int)elevation));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void initializeIcon() {
        VectorTextView vectorTextView = this.binding.balloonText;
        boolean bl = false;
        boolean bl2 = false;
        VectorTextView $this$with = vectorTextView;
        boolean bl3 = false;
        IconForm iconForm = this.builder.iconForm;
        if (iconForm != null) {
            IconForm iconForm2 = iconForm;
            boolean bl4 = false;
            boolean bl5 = false;
            IconForm it = iconForm2;
            boolean bl6 = false;
            TextViewExtensionKt.applyIconForm($this$with, it);
        } else {
            void $this$iconForm;
            Context context = $this$with.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
            Context context$iv = context;
            boolean $i$f$iconForm = false;
            IconForm.Builder builder = new IconForm.Builder(context$iv);
            boolean bl7 = false;
            boolean bl8 = false;
            IconForm.Builder builder2 = builder;
            VectorTextView vectorTextView2 = $this$with;
            boolean bl9 = false;
            $this$iconForm.setDrawable(((Balloon)this).builder.iconDrawable);
            $this$iconForm.setIconWidth(((Balloon)this).builder.iconWidth);
            $this$iconForm.setIconHeight(((Balloon)this).builder.iconHeight);
            $this$iconForm.setIconColor(((Balloon)this).builder.iconColor);
            $this$iconForm.setIconSpace(((Balloon)this).builder.iconSpace);
            $this$iconForm.setDrawableGravity(((Balloon)this).builder.iconGravity);
            Unit unit = Unit.INSTANCE;
            TextViewExtensionKt.applyIconForm(vectorTextView2, builder.build());
        }
        $this$with.isRtlSupport(this.builder.isRtlLayout);
    }

    /*
     * WARNING - void declaration
     */
    private final void initializeText() {
        VectorTextView vectorTextView = this.binding.balloonText;
        boolean bl = false;
        boolean bl2 = false;
        VectorTextView $this$with = vectorTextView;
        boolean bl3 = false;
        TextForm textForm = this.builder.textForm;
        if (textForm != null) {
            TextForm textForm2 = textForm;
            boolean bl4 = false;
            boolean bl5 = false;
            TextForm it = textForm2;
            boolean bl6 = false;
            TextViewExtensionKt.applyTextForm((TextView)$this$with, it);
        } else {
            void $this$textForm;
            TextView textView = (TextView)$this$with;
            Context context = $this$with.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
            Context context$iv = context;
            boolean $i$f$textForm = false;
            TextForm.Builder builder = new TextForm.Builder(context$iv);
            boolean bl7 = false;
            boolean bl8 = false;
            TextForm.Builder builder2 = builder;
            TextView textView2 = textView;
            boolean bl9 = false;
            $this$textForm.setText(((Balloon)this).builder.text);
            $this$textForm.setTextSize(((Balloon)this).builder.textSize);
            $this$textForm.setTextColor(((Balloon)this).builder.textColor);
            $this$textForm.setTextIsHtml(((Balloon)this).builder.textIsHtml);
            $this$textForm.setTextGravity(((Balloon)this).builder.textGravity);
            $this$textForm.setTextTypeface(((Balloon)this).builder.textTypeface);
            $this$textForm.setTextTypeface(((Balloon)this).builder.textTypefaceObject);
            $this$with.setMovementMethod(((Balloon)this).builder.movementMethod);
            Unit unit = Unit.INSTANCE;
            TextViewExtensionKt.applyTextForm(textView2, builder.build());
        }
        VectorTextView vectorTextView2 = $this$with;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)vectorTextView2), (String)"this");
        AppCompatTextView appCompatTextView = vectorTextView2;
        RadiusLayout radiusLayout = this.binding.balloonCard;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)radiusLayout), (String)"binding.balloonCard");
        this.measureTextWidth(appCompatTextView, (View)radiusLayout);
    }

    private final void initializeBalloonLayout() {
        if (this.hasCustomLayout()) {
            this.initializeCustomLayout();
        } else {
            this.initializeIcon();
            this.initializeText();
        }
    }

    private final boolean hasCustomLayout() {
        return this.builder.layoutRes != null || this.builder.layout != null;
    }

    private final void initializeCustomLayout() {
        Integer n;
        block5: {
            block4: {
                n = this.builder.layoutRes;
                if (n == null) break block4;
                Integer n2 = n;
                boolean bl = false;
                boolean bl2 = false;
                int it = ((Number)n2).intValue();
                boolean bl3 = false;
                n = LayoutInflater.from((Context)this.context).inflate(it, (ViewGroup)this.binding.balloonCard, false);
                if (n != null) break block5;
            }
            n = this.builder.layout;
        }
        if (n == null) {
            throw (Throwable)new IllegalArgumentException("The custom layout is null.");
        }
        Integer layout2 = n;
        this.binding.balloonCard.removeAllViews();
        this.binding.balloonCard.addView((View)layout2);
        RadiusLayout radiusLayout = this.binding.balloonCard;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)radiusLayout), (String)"binding.balloonCard");
        this.traverseAndMeasureTextWidth((ViewGroup)radiusLayout);
    }

    private final void initializeBalloonOverlay() {
        if (this.builder.isVisibleOverlay) {
            BalloonAnchorOverlayView balloonAnchorOverlayView = this.overlayBinding.balloonOverlayView;
            boolean bl = false;
            boolean bl2 = false;
            BalloonAnchorOverlayView $this$with = balloonAnchorOverlayView;
            boolean bl3 = false;
            $this$with.setOverlayColor(this.builder.overlayColor);
            $this$with.setOverlayPadding(this.builder.overlayPadding);
            $this$with.setOverlayPosition(this.builder.overlayPosition);
            $this$with.setBalloonOverlayShape(this.builder.overlayShape);
            this.overlayWindow.setClippingEnabled(false);
        }
    }

    private final void applyBalloonAnimation() {
        if (this.builder.balloonAnimationStyle == Integer.MIN_VALUE) {
            switch (Balloon$WhenMappings.$EnumSwitchMapping$6[this.builder.balloonAnimation.ordinal()]) {
                case 1: {
                    this.bodyWindow.setAnimationStyle(R.style.Elastic_Balloon_Library);
                    break;
                }
                case 2: {
                    View view = this.bodyWindow.getContentView();
                    Intrinsics.checkNotNullExpressionValue((Object)view, (String)"bodyWindow.contentView");
                    ViewExtensionKt.circularRevealed(view, this.builder.circularDuration);
                    this.bodyWindow.setAnimationStyle(R.style.NormalDispose_Balloon_Library);
                    break;
                }
                case 3: {
                    this.bodyWindow.setAnimationStyle(R.style.Fade_Balloon_Library);
                    break;
                }
                case 4: {
                    this.bodyWindow.setAnimationStyle(R.style.Overshoot_Balloon_Library);
                    break;
                }
                case 5: {
                    this.bodyWindow.setAnimationStyle(R.style.Normal_Balloon_Library);
                    break;
                }
            }
        } else {
            this.bodyWindow.setAnimationStyle(this.builder.balloonAnimationStyle);
        }
    }

    private final void applyBalloonOverlayAnimation() {
        if (this.builder.balloonOverlayAnimationStyle == Integer.MIN_VALUE) {
            switch (Balloon$WhenMappings.$EnumSwitchMapping$7[this.builder.balloonOverlayAnimation.ordinal()]) {
                case 1: {
                    this.overlayWindow.setAnimationStyle(R.style.Fade_Balloon_Library);
                    break;
                }
                default: {
                    this.overlayWindow.setAnimationStyle(R.style.Normal_Balloon_Library);
                    break;
                }
            }
        } else {
            this.overlayWindow.setAnimationStyle(this.builder.balloonAnimationStyle);
        }
    }

    /*
     * Unable to fully structure code
     */
    private final Animation getBalloonHighlightAnimation() {
        block10: {
            block9: {
                if (this.builder.balloonHighlightAnimationStyle != -2147483648) break block9;
                switch (Balloon$WhenMappings.$EnumSwitchMapping$9[this.builder.balloonHighlightAnimation.ordinal()]) {
                    case 1: {
                        if (!this.builder.isVisibleArrow) ** GOTO lbl20
                        switch (Balloon$WhenMappings.$EnumSwitchMapping$8[this.builder.arrowOrientation.ordinal()]) {
                            case 1: {
                                v0 = R.anim.heartbeat_bottom_balloon_library;
                                break block10;
                            }
                            case 2: {
                                v0 = R.anim.heartbeat_top_balloon_library;
                                break block10;
                            }
                            case 3: {
                                v0 = R.anim.heartbeat_right_balloon_library;
                                break block10;
                            }
                            case 4: {
                                v0 = R.anim.heartbeat_left_balloon_library;
                                break block10;
                            }
                            default: {
                                throw new NoWhenBranchMatchedException();
                            }
                        }
lbl20:
                        // 1 sources

                        v0 = R.anim.heartbeat_center_balloon_library;
                        break block10;
                    }
                    default: {
                        return null;
                    }
                }
            }
            v0 = this.builder.balloonHighlightAnimationStyle;
        }
        animRes = v0;
        return AnimationUtils.loadAnimation((Context)this.context, (int)animRes);
    }

    private final void startBalloonHighlightAnimation() {
        this.binding.balloon.post(new Runnable(this){
            final /* synthetic */ Balloon this$0;

            public final void run() {
                new Handler(Looper.getMainLooper()).postDelayed(new Runnable(this){
                    final /* synthetic */ startBalloonHighlightAnimation.1 this$0;

                    public final void run() {
                        block0: {
                            Animation animation = Balloon.access$getBalloonHighlightAnimation(this.this$0.this$0);
                            if (animation == null) break block0;
                            Animation animation2 = animation;
                            boolean bl = false;
                            boolean bl2 = false;
                            Animation animation3 = animation2;
                            boolean bl3 = false;
                            Balloon.access$getBinding$p((Balloon)this.this$0.this$0).balloon.startAnimation(animation3);
                        }
                    }
                    {
                        this.this$0 = var1_1;
                    }
                }, Balloon.access$getBuilder$p((Balloon)this.this$0).balloonHighlightAnimationStartDelay);
            }
            {
                this.this$0 = balloon2;
            }
        });
    }

    private final void stopBalloonHighlightAnimation() {
        FrameLayout frameLayout = this.binding.balloon;
        boolean bl = false;
        boolean bl2 = false;
        FrameLayout $this$apply = frameLayout;
        boolean bl3 = false;
        Animation animation = $this$apply.getAnimation();
        if (animation != null) {
            Animation animation2 = animation;
            boolean bl4 = false;
            boolean bl5 = false;
            Animation $this$apply2 = animation2;
            boolean bl6 = false;
            $this$apply2.cancel();
            $this$apply2.reset();
        }
        $this$apply.clearAnimation();
    }

    public final boolean shouldShowUp() {
        boolean bl;
        String string = this.builder.preferenceName;
        if (string != null) {
            String string2 = string;
            boolean bl2 = false;
            boolean bl3 = false;
            String it = string2;
            boolean bl4 = false;
            bl = this.getBalloonPersistence().shouldShowUp(it, this.builder.showTimes);
        } else {
            bl = true;
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    @MainThread
    private final void show(View anchor, Function0<Unit> block) {
        int $i$f$show = 0;
        if (!(this.isShowing() || this.destroyed || ContextExtensionKt.isFinishing(this.context))) {
            View view = this.bodyWindow.getContentView();
            Intrinsics.checkNotNullExpressionValue((Object)view, (String)"bodyWindow.contentView");
            if (view.getParent() == null && ViewCompat.isAttachedToWindow((View)anchor)) {
                anchor.post(new Runnable(this, anchor, block){
                    final /* synthetic */ Balloon this$0;
                    final /* synthetic */ View $anchor;
                    final /* synthetic */ Function0 $block;

                    public final void run() {
                        String string = Balloon.access$getBuilder$p((Balloon)this.this$0).preferenceName;
                        if (string != null) {
                            String string2 = string;
                            boolean bl = false;
                            boolean bl2 = false;
                            String it = string2;
                            boolean bl3 = false;
                            if (Balloon.access$getBalloonPersistence$p(this.this$0).shouldShowUp(it, Balloon.access$getBuilder$p((Balloon)this.this$0).showTimes)) {
                                Balloon.access$getBalloonPersistence$p(this.this$0).putIncrementedCounts(it);
                            } else {
                                Function0<Unit> function0 = Balloon.access$getBuilder$p((Balloon)this.this$0).runIfReachedShowCounts;
                                if (function0 != null) {
                                    Unit cfr_ignored_0 = (Unit)function0.invoke();
                                }
                                return;
                            }
                        }
                        Balloon.access$setShowing$p(this.this$0, true);
                        long dismissDelay = Balloon.access$getBuilder$p((Balloon)this.this$0).autoDismissDuration;
                        if (dismissDelay != -1L) {
                            this.this$0.dismissWithDelay(dismissDelay);
                        }
                        if (Balloon.access$hasCustomLayout(this.this$0)) {
                            RadiusLayout radiusLayout = Balloon.access$getBinding$p((Balloon)this.this$0).balloonCard;
                            Intrinsics.checkNotNullExpressionValue((Object)((Object)radiusLayout), (String)"binding.balloonCard");
                            Balloon.access$traverseAndMeasureTextWidth(this.this$0, (ViewGroup)radiusLayout);
                        } else {
                            VectorTextView vectorTextView = Balloon.access$getBinding$p((Balloon)this.this$0).balloonText;
                            Intrinsics.checkNotNullExpressionValue((Object)((Object)vectorTextView), (String)"binding.balloonText");
                            AppCompatTextView appCompatTextView = vectorTextView;
                            RadiusLayout radiusLayout = Balloon.access$getBinding$p((Balloon)this.this$0).balloonCard;
                            Intrinsics.checkNotNullExpressionValue((Object)((Object)radiusLayout), (String)"binding.balloonCard");
                            Balloon.access$measureTextWidth(this.this$0, appCompatTextView, (View)radiusLayout);
                        }
                        Balloon.access$getBinding$p(this.this$0).getRoot().measure(0, 0);
                        Balloon.access$getBodyWindow$p(this.this$0).setWidth(this.this$0.getMeasuredWidth());
                        Balloon.access$getBodyWindow$p(this.this$0).setHeight(this.this$0.getMeasuredHeight());
                        VectorTextView vectorTextView = Balloon.access$getBinding$p((Balloon)this.this$0).balloonText;
                        Intrinsics.checkNotNullExpressionValue((Object)((Object)vectorTextView), (String)"this.binding.balloonText");
                        vectorTextView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
                        Balloon.access$initializeArrow(this.this$0, this.$anchor);
                        Balloon.access$initializeBalloonContent(this.this$0);
                        Balloon.access$applyBalloonOverlayAnimation(this.this$0);
                        Balloon.access$showOverlayWindow(this.this$0, this.$anchor);
                        Balloon.access$applyBalloonAnimation(this.this$0);
                        Balloon.access$startBalloonHighlightAnimation(this.this$0);
                        this.$block.invoke();
                    }
                    {
                        this.this$0 = balloon2;
                        this.$anchor = view;
                        this.$block = function0;
                    }
                });
                return;
            }
        }
        if (!((Balloon)this).builder.dismissWhenShowAgain) return;
        this.dismiss();
    }

    private final void showOverlayWindow(View anchor) {
        if (this.builder.isVisibleOverlay) {
            this.overlayBinding.balloonOverlayView.setAnchorView(anchor);
            this.overlayWindow.showAtLocation(anchor, 17, 0, 0);
        }
    }

    @MainThread
    private final Balloon relay(Balloon balloon2, Function1<? super Balloon, Unit> block) {
        int $i$f$relay = 0;
        this.setOnBalloonDismissListener((Function0<Unit>)((Function0)new Function0<Unit>(this, block, balloon2){
            final /* synthetic */ Balloon this$0;
            final /* synthetic */ Function1 $block;
            final /* synthetic */ Balloon $balloon;

            public final void invoke() {
                if (!Balloon.access$getDestroyed$p(this.this$0)) {
                    this.$block.invoke((Object)this.$balloon);
                }
            }
            {
                this.this$0 = balloon2;
                this.$block = function1;
                this.$balloon = balloon3;
                super(0);
            }
        }));
        return balloon2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void show(@NotNull View anchor) {
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        Balloon this_$iv = this;
        boolean $i$f$show = false;
        if (!(this_$iv.isShowing() || this_$iv.destroyed || ContextExtensionKt.isFinishing(this_$iv.context))) {
            View view = this_$iv.bodyWindow.getContentView();
            Intrinsics.checkNotNullExpressionValue((Object)view, (String)"bodyWindow.contentView");
            if (view.getParent() == null && ViewCompat.isAttachedToWindow((View)anchor)) {
                anchor.post(new Runnable(this_$iv, anchor, this, anchor){
                    final /* synthetic */ Balloon this$0$inline_fun;
                    final /* synthetic */ View $anchor;
                    final /* synthetic */ Balloon this$0;
                    final /* synthetic */ View $anchor$inlined;
                    {
                        this.this$0$inline_fun = balloon2;
                        this.$anchor = view;
                        this.this$0 = balloon3;
                        this.$anchor$inlined = view2;
                    }

                    public final void run() {
                        String string = Balloon.access$getBuilder$p((Balloon)this.this$0$inline_fun).preferenceName;
                        if (string != null) {
                            String string2 = string;
                            boolean bl = false;
                            boolean bl2 = false;
                            String it = string2;
                            boolean bl3 = false;
                            if (Balloon.access$getBalloonPersistence$p(this.this$0$inline_fun).shouldShowUp(it, Balloon.access$getBuilder$p((Balloon)this.this$0$inline_fun).showTimes)) {
                                Balloon.access$getBalloonPersistence$p(this.this$0$inline_fun).putIncrementedCounts(it);
                            } else {
                                Function0<Unit> function0 = Balloon.access$getBuilder$p((Balloon)this.this$0$inline_fun).runIfReachedShowCounts;
                                if (function0 != null) {
                                    Unit cfr_ignored_0 = (Unit)function0.invoke();
                                }
                                return;
                            }
                        }
                        Balloon.access$setShowing$p(this.this$0$inline_fun, true);
                        long dismissDelay = Balloon.access$getBuilder$p((Balloon)this.this$0$inline_fun).autoDismissDuration;
                        if (dismissDelay != -1L) {
                            this.this$0$inline_fun.dismissWithDelay(dismissDelay);
                        }
                        if (Balloon.access$hasCustomLayout(this.this$0$inline_fun)) {
                            RadiusLayout radiusLayout = Balloon.access$getBinding$p((Balloon)this.this$0$inline_fun).balloonCard;
                            Intrinsics.checkNotNullExpressionValue((Object)((Object)radiusLayout), (String)"binding.balloonCard");
                            Balloon.access$traverseAndMeasureTextWidth(this.this$0$inline_fun, (ViewGroup)radiusLayout);
                        } else {
                            VectorTextView vectorTextView = Balloon.access$getBinding$p((Balloon)this.this$0$inline_fun).balloonText;
                            Intrinsics.checkNotNullExpressionValue((Object)((Object)vectorTextView), (String)"binding.balloonText");
                            AppCompatTextView appCompatTextView = vectorTextView;
                            RadiusLayout radiusLayout = Balloon.access$getBinding$p((Balloon)this.this$0$inline_fun).balloonCard;
                            Intrinsics.checkNotNullExpressionValue((Object)((Object)radiusLayout), (String)"binding.balloonCard");
                            Balloon.access$measureTextWidth(this.this$0$inline_fun, appCompatTextView, (View)radiusLayout);
                        }
                        Balloon.access$getBinding$p(this.this$0$inline_fun).getRoot().measure(0, 0);
                        Balloon.access$getBodyWindow$p(this.this$0$inline_fun).setWidth(this.this$0$inline_fun.getMeasuredWidth());
                        Balloon.access$getBodyWindow$p(this.this$0$inline_fun).setHeight(this.this$0$inline_fun.getMeasuredHeight());
                        VectorTextView vectorTextView = Balloon.access$getBinding$p((Balloon)this.this$0$inline_fun).balloonText;
                        Intrinsics.checkNotNullExpressionValue((Object)((Object)vectorTextView), (String)"this.binding.balloonText");
                        vectorTextView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
                        Balloon.access$initializeArrow(this.this$0$inline_fun, this.$anchor);
                        Balloon.access$initializeBalloonContent(this.this$0$inline_fun);
                        Balloon.access$applyBalloonOverlayAnimation(this.this$0$inline_fun);
                        Balloon.access$showOverlayWindow(this.this$0$inline_fun, this.$anchor);
                        Balloon.access$applyBalloonAnimation(this.this$0$inline_fun);
                        Balloon.access$startBalloonHighlightAnimation(this.this$0$inline_fun);
                        boolean bl = false;
                        Balloon.access$getBodyWindow$p(this.this$0).showAsDropDown(this.$anchor$inlined, Balloon.access$getBuilder$p((Balloon)this.this$0).supportRtlLayoutFactor * (this.$anchor$inlined.getMeasuredWidth() / 2 - this.this$0.getMeasuredWidth() / 2), -this.this$0.getMeasuredHeight() - this.$anchor$inlined.getMeasuredHeight() / 2);
                    }
                });
                return;
            }
        }
        if (!((Balloon)this_$iv).builder.dismissWhenShowAgain) return;
        this_$iv.dismiss();
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void show(@NotNull View anchor, int xOff, int yOff) {
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        Balloon this_$iv = this;
        boolean $i$f$show = false;
        if (!(this_$iv.isShowing() || this_$iv.destroyed || ContextExtensionKt.isFinishing(this_$iv.context))) {
            View view = this_$iv.bodyWindow.getContentView();
            Intrinsics.checkNotNullExpressionValue((Object)view, (String)"bodyWindow.contentView");
            if (view.getParent() == null && ViewCompat.isAttachedToWindow((View)anchor)) {
                anchor.post(new Runnable(this_$iv, anchor, this, anchor, xOff, yOff){
                    final /* synthetic */ Balloon this$0$inline_fun;
                    final /* synthetic */ View $anchor;
                    final /* synthetic */ Balloon this$0;
                    final /* synthetic */ View $anchor$inlined;
                    final /* synthetic */ int $xOff$inlined;
                    final /* synthetic */ int $yOff$inlined;
                    {
                        this.this$0$inline_fun = balloon2;
                        this.$anchor = view;
                        this.this$0 = balloon3;
                        this.$anchor$inlined = view2;
                        this.$xOff$inlined = n;
                        this.$yOff$inlined = n2;
                    }

                    public final void run() {
                        String string = Balloon.access$getBuilder$p((Balloon)this.this$0$inline_fun).preferenceName;
                        if (string != null) {
                            String string2 = string;
                            boolean bl = false;
                            boolean bl2 = false;
                            String it = string2;
                            boolean bl3 = false;
                            if (Balloon.access$getBalloonPersistence$p(this.this$0$inline_fun).shouldShowUp(it, Balloon.access$getBuilder$p((Balloon)this.this$0$inline_fun).showTimes)) {
                                Balloon.access$getBalloonPersistence$p(this.this$0$inline_fun).putIncrementedCounts(it);
                            } else {
                                Function0<Unit> function0 = Balloon.access$getBuilder$p((Balloon)this.this$0$inline_fun).runIfReachedShowCounts;
                                if (function0 != null) {
                                    Unit cfr_ignored_0 = (Unit)function0.invoke();
                                }
                                return;
                            }
                        }
                        Balloon.access$setShowing$p(this.this$0$inline_fun, true);
                        long dismissDelay = Balloon.access$getBuilder$p((Balloon)this.this$0$inline_fun).autoDismissDuration;
                        if (dismissDelay != -1L) {
                            this.this$0$inline_fun.dismissWithDelay(dismissDelay);
                        }
                        if (Balloon.access$hasCustomLayout(this.this$0$inline_fun)) {
                            RadiusLayout radiusLayout = Balloon.access$getBinding$p((Balloon)this.this$0$inline_fun).balloonCard;
                            Intrinsics.checkNotNullExpressionValue((Object)((Object)radiusLayout), (String)"binding.balloonCard");
                            Balloon.access$traverseAndMeasureTextWidth(this.this$0$inline_fun, (ViewGroup)radiusLayout);
                        } else {
                            VectorTextView vectorTextView = Balloon.access$getBinding$p((Balloon)this.this$0$inline_fun).balloonText;
                            Intrinsics.checkNotNullExpressionValue((Object)((Object)vectorTextView), (String)"binding.balloonText");
                            AppCompatTextView appCompatTextView = vectorTextView;
                            RadiusLayout radiusLayout = Balloon.access$getBinding$p((Balloon)this.this$0$inline_fun).balloonCard;
                            Intrinsics.checkNotNullExpressionValue((Object)((Object)radiusLayout), (String)"binding.balloonCard");
                            Balloon.access$measureTextWidth(this.this$0$inline_fun, appCompatTextView, (View)radiusLayout);
                        }
                        Balloon.access$getBinding$p(this.this$0$inline_fun).getRoot().measure(0, 0);
                        Balloon.access$getBodyWindow$p(this.this$0$inline_fun).setWidth(this.this$0$inline_fun.getMeasuredWidth());
                        Balloon.access$getBodyWindow$p(this.this$0$inline_fun).setHeight(this.this$0$inline_fun.getMeasuredHeight());
                        VectorTextView vectorTextView = Balloon.access$getBinding$p((Balloon)this.this$0$inline_fun).balloonText;
                        Intrinsics.checkNotNullExpressionValue((Object)((Object)vectorTextView), (String)"this.binding.balloonText");
                        vectorTextView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
                        Balloon.access$initializeArrow(this.this$0$inline_fun, this.$anchor);
                        Balloon.access$initializeBalloonContent(this.this$0$inline_fun);
                        Balloon.access$applyBalloonOverlayAnimation(this.this$0$inline_fun);
                        Balloon.access$showOverlayWindow(this.this$0$inline_fun, this.$anchor);
                        Balloon.access$applyBalloonAnimation(this.this$0$inline_fun);
                        Balloon.access$startBalloonHighlightAnimation(this.this$0$inline_fun);
                        boolean bl = false;
                        Balloon.access$getBodyWindow$p(this.this$0).showAsDropDown(this.$anchor$inlined, this.$xOff$inlined, this.$yOff$inlined);
                    }
                });
                return;
            }
        }
        if (!((Balloon)this_$iv).builder.dismissWhenShowAgain) return;
        this_$iv.dismiss();
    }

    @JvmOverloads
    @NotNull
    public final Balloon relayShow(@NotNull Balloon balloon2, @NotNull View anchor, int xOff, int yOff) {
        Intrinsics.checkNotNullParameter((Object)balloon2, (String)"balloon");
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        Balloon this_$iv = this;
        boolean $i$f$relay = false;
        this_$iv.setOnBalloonDismissListener((Function0<Unit>)((Function0)new Function0<Unit>(this_$iv, balloon2, anchor, xOff, yOff){
            final /* synthetic */ Balloon this$0;
            final /* synthetic */ Balloon $balloon;
            final /* synthetic */ View $anchor$inlined;
            final /* synthetic */ int $xOff$inlined;
            final /* synthetic */ int $yOff$inlined;
            {
                this.this$0 = balloon2;
                this.$balloon = balloon3;
                this.$anchor$inlined = view;
                this.$xOff$inlined = n;
                this.$yOff$inlined = n2;
                super(0);
            }

            public final void invoke() {
                if (!Balloon.access$getDestroyed$p(this.this$0)) {
                    Balloon it = this.$balloon;
                    boolean bl = false;
                    it.show(this.$anchor$inlined, this.$xOff$inlined, this.$yOff$inlined);
                }
            }
        }));
        return balloon2;
    }

    public static /* synthetic */ Balloon relayShow$default(Balloon balloon2, Balloon balloon3, View view, int n, int n2, int n3, Object object) {
        if ((n3 & 4) != 0) {
            n = 0;
        }
        if ((n3 & 8) != 0) {
            n2 = 0;
        }
        return balloon2.relayShow(balloon3, view, n, n2);
    }

    @JvmOverloads
    @NotNull
    public final Balloon relayShow(@NotNull Balloon balloon2, @NotNull View anchor, int xOff) {
        return Balloon.relayShow$default(this, balloon2, anchor, xOff, 0, 8, null);
    }

    @JvmOverloads
    @NotNull
    public final Balloon relayShow(@NotNull Balloon balloon2, @NotNull View anchor) {
        return Balloon.relayShow$default(this, balloon2, anchor, 0, 0, 12, null);
    }

    @NotNull
    public final Balloon relayShowAsDropDown(@NotNull Balloon balloon2, @NotNull View anchor) {
        Intrinsics.checkNotNullParameter((Object)balloon2, (String)"balloon");
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        Balloon this_$iv = this;
        boolean $i$f$relay = false;
        this_$iv.setOnBalloonDismissListener((Function0<Unit>)((Function0)new Function0<Unit>(this_$iv, balloon2, anchor){
            final /* synthetic */ Balloon this$0;
            final /* synthetic */ Balloon $balloon;
            final /* synthetic */ View $anchor$inlined;
            {
                this.this$0 = balloon2;
                this.$balloon = balloon3;
                this.$anchor$inlined = view;
                super(0);
            }

            public final void invoke() {
                if (!Balloon.access$getDestroyed$p(this.this$0)) {
                    Balloon it = this.$balloon;
                    boolean bl = false;
                    Balloon.showAsDropDown$default(it, this.$anchor$inlined, 0, 0, 6, null);
                }
            }
        }));
        return balloon2;
    }

    /*
     * Enabled aggressive block sorting
     */
    @JvmOverloads
    public final void showAsDropDown(@NotNull View anchor, int xOff, int yOff) {
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        Balloon this_$iv = this;
        boolean $i$f$show = false;
        if (!(this_$iv.isShowing() || this_$iv.destroyed || ContextExtensionKt.isFinishing(this_$iv.context))) {
            View view = this_$iv.bodyWindow.getContentView();
            Intrinsics.checkNotNullExpressionValue((Object)view, (String)"bodyWindow.contentView");
            if (view.getParent() == null && ViewCompat.isAttachedToWindow((View)anchor)) {
                anchor.post(new Runnable(this_$iv, anchor, this, anchor, xOff, yOff){
                    final /* synthetic */ Balloon this$0$inline_fun;
                    final /* synthetic */ View $anchor;
                    final /* synthetic */ Balloon this$0;
                    final /* synthetic */ View $anchor$inlined;
                    final /* synthetic */ int $xOff$inlined;
                    final /* synthetic */ int $yOff$inlined;
                    {
                        this.this$0$inline_fun = balloon2;
                        this.$anchor = view;
                        this.this$0 = balloon3;
                        this.$anchor$inlined = view2;
                        this.$xOff$inlined = n;
                        this.$yOff$inlined = n2;
                    }

                    public final void run() {
                        String string = Balloon.access$getBuilder$p((Balloon)this.this$0$inline_fun).preferenceName;
                        if (string != null) {
                            String string2 = string;
                            boolean bl = false;
                            boolean bl2 = false;
                            String it = string2;
                            boolean bl3 = false;
                            if (Balloon.access$getBalloonPersistence$p(this.this$0$inline_fun).shouldShowUp(it, Balloon.access$getBuilder$p((Balloon)this.this$0$inline_fun).showTimes)) {
                                Balloon.access$getBalloonPersistence$p(this.this$0$inline_fun).putIncrementedCounts(it);
                            } else {
                                Function0<Unit> function0 = Balloon.access$getBuilder$p((Balloon)this.this$0$inline_fun).runIfReachedShowCounts;
                                if (function0 != null) {
                                    Unit cfr_ignored_0 = (Unit)function0.invoke();
                                }
                                return;
                            }
                        }
                        Balloon.access$setShowing$p(this.this$0$inline_fun, true);
                        long dismissDelay = Balloon.access$getBuilder$p((Balloon)this.this$0$inline_fun).autoDismissDuration;
                        if (dismissDelay != -1L) {
                            this.this$0$inline_fun.dismissWithDelay(dismissDelay);
                        }
                        if (Balloon.access$hasCustomLayout(this.this$0$inline_fun)) {
                            RadiusLayout radiusLayout = Balloon.access$getBinding$p((Balloon)this.this$0$inline_fun).balloonCard;
                            Intrinsics.checkNotNullExpressionValue((Object)((Object)radiusLayout), (String)"binding.balloonCard");
                            Balloon.access$traverseAndMeasureTextWidth(this.this$0$inline_fun, (ViewGroup)radiusLayout);
                        } else {
                            VectorTextView vectorTextView = Balloon.access$getBinding$p((Balloon)this.this$0$inline_fun).balloonText;
                            Intrinsics.checkNotNullExpressionValue((Object)((Object)vectorTextView), (String)"binding.balloonText");
                            AppCompatTextView appCompatTextView = vectorTextView;
                            RadiusLayout radiusLayout = Balloon.access$getBinding$p((Balloon)this.this$0$inline_fun).balloonCard;
                            Intrinsics.checkNotNullExpressionValue((Object)((Object)radiusLayout), (String)"binding.balloonCard");
                            Balloon.access$measureTextWidth(this.this$0$inline_fun, appCompatTextView, (View)radiusLayout);
                        }
                        Balloon.access$getBinding$p(this.this$0$inline_fun).getRoot().measure(0, 0);
                        Balloon.access$getBodyWindow$p(this.this$0$inline_fun).setWidth(this.this$0$inline_fun.getMeasuredWidth());
                        Balloon.access$getBodyWindow$p(this.this$0$inline_fun).setHeight(this.this$0$inline_fun.getMeasuredHeight());
                        VectorTextView vectorTextView = Balloon.access$getBinding$p((Balloon)this.this$0$inline_fun).balloonText;
                        Intrinsics.checkNotNullExpressionValue((Object)((Object)vectorTextView), (String)"this.binding.balloonText");
                        vectorTextView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
                        Balloon.access$initializeArrow(this.this$0$inline_fun, this.$anchor);
                        Balloon.access$initializeBalloonContent(this.this$0$inline_fun);
                        Balloon.access$applyBalloonOverlayAnimation(this.this$0$inline_fun);
                        Balloon.access$showOverlayWindow(this.this$0$inline_fun, this.$anchor);
                        Balloon.access$applyBalloonAnimation(this.this$0$inline_fun);
                        Balloon.access$startBalloonHighlightAnimation(this.this$0$inline_fun);
                        boolean bl = false;
                        Balloon.access$getBodyWindow$p(this.this$0).showAsDropDown(this.$anchor$inlined, this.$xOff$inlined, this.$yOff$inlined);
                    }
                });
                return;
            }
        }
        if (!((Balloon)this_$iv).builder.dismissWhenShowAgain) return;
        this_$iv.dismiss();
    }

    public static /* synthetic */ void showAsDropDown$default(Balloon balloon2, View view, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = 0;
        }
        balloon2.showAsDropDown(view, n, n2);
    }

    @JvmOverloads
    public final void showAsDropDown(@NotNull View anchor, int xOff) {
        Balloon.showAsDropDown$default(this, anchor, xOff, 0, 4, null);
    }

    @JvmOverloads
    public final void showAsDropDown(@NotNull View anchor) {
        Balloon.showAsDropDown$default(this, anchor, 0, 0, 6, null);
    }

    @NotNull
    public final Balloon relayShowAsDropDown(@NotNull Balloon balloon2, @NotNull View anchor, int xOff, int yOff) {
        Intrinsics.checkNotNullParameter((Object)balloon2, (String)"balloon");
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        Balloon this_$iv = this;
        boolean $i$f$relay = false;
        this_$iv.setOnBalloonDismissListener((Function0<Unit>)((Function0)new Function0<Unit>(this_$iv, balloon2, anchor, xOff, yOff){
            final /* synthetic */ Balloon this$0;
            final /* synthetic */ Balloon $balloon;
            final /* synthetic */ View $anchor$inlined;
            final /* synthetic */ int $xOff$inlined;
            final /* synthetic */ int $yOff$inlined;
            {
                this.this$0 = balloon2;
                this.$balloon = balloon3;
                this.$anchor$inlined = view;
                this.$xOff$inlined = n;
                this.$yOff$inlined = n2;
                super(0);
            }

            public final void invoke() {
                if (!Balloon.access$getDestroyed$p(this.this$0)) {
                    Balloon it = this.$balloon;
                    boolean bl = false;
                    it.showAsDropDown(this.$anchor$inlined, this.$xOff$inlined, this.$yOff$inlined);
                }
            }
        }));
        return balloon2;
    }

    /*
     * Enabled aggressive block sorting
     */
    @JvmOverloads
    public final void showAlignTop(@NotNull View anchor, int xOff, int yOff) {
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        Balloon this_$iv = this;
        boolean $i$f$show = false;
        if (!(this_$iv.isShowing() || this_$iv.destroyed || ContextExtensionKt.isFinishing(this_$iv.context))) {
            View view = this_$iv.bodyWindow.getContentView();
            Intrinsics.checkNotNullExpressionValue((Object)view, (String)"bodyWindow.contentView");
            if (view.getParent() == null && ViewCompat.isAttachedToWindow((View)anchor)) {
                anchor.post(new Runnable(this_$iv, anchor, this, anchor, xOff, yOff){
                    final /* synthetic */ Balloon this$0$inline_fun;
                    final /* synthetic */ View $anchor;
                    final /* synthetic */ Balloon this$0;
                    final /* synthetic */ View $anchor$inlined;
                    final /* synthetic */ int $xOff$inlined;
                    final /* synthetic */ int $yOff$inlined;
                    {
                        this.this$0$inline_fun = balloon2;
                        this.$anchor = view;
                        this.this$0 = balloon3;
                        this.$anchor$inlined = view2;
                        this.$xOff$inlined = n;
                        this.$yOff$inlined = n2;
                    }

                    public final void run() {
                        String string = Balloon.access$getBuilder$p((Balloon)this.this$0$inline_fun).preferenceName;
                        if (string != null) {
                            String string2 = string;
                            boolean bl = false;
                            boolean bl2 = false;
                            String it = string2;
                            boolean bl3 = false;
                            if (Balloon.access$getBalloonPersistence$p(this.this$0$inline_fun).shouldShowUp(it, Balloon.access$getBuilder$p((Balloon)this.this$0$inline_fun).showTimes)) {
                                Balloon.access$getBalloonPersistence$p(this.this$0$inline_fun).putIncrementedCounts(it);
                            } else {
                                Function0<Unit> function0 = Balloon.access$getBuilder$p((Balloon)this.this$0$inline_fun).runIfReachedShowCounts;
                                if (function0 != null) {
                                    Unit cfr_ignored_0 = (Unit)function0.invoke();
                                }
                                return;
                            }
                        }
                        Balloon.access$setShowing$p(this.this$0$inline_fun, true);
                        long dismissDelay = Balloon.access$getBuilder$p((Balloon)this.this$0$inline_fun).autoDismissDuration;
                        if (dismissDelay != -1L) {
                            this.this$0$inline_fun.dismissWithDelay(dismissDelay);
                        }
                        if (Balloon.access$hasCustomLayout(this.this$0$inline_fun)) {
                            RadiusLayout radiusLayout = Balloon.access$getBinding$p((Balloon)this.this$0$inline_fun).balloonCard;
                            Intrinsics.checkNotNullExpressionValue((Object)((Object)radiusLayout), (String)"binding.balloonCard");
                            Balloon.access$traverseAndMeasureTextWidth(this.this$0$inline_fun, (ViewGroup)radiusLayout);
                        } else {
                            VectorTextView vectorTextView = Balloon.access$getBinding$p((Balloon)this.this$0$inline_fun).balloonText;
                            Intrinsics.checkNotNullExpressionValue((Object)((Object)vectorTextView), (String)"binding.balloonText");
                            AppCompatTextView appCompatTextView = vectorTextView;
                            RadiusLayout radiusLayout = Balloon.access$getBinding$p((Balloon)this.this$0$inline_fun).balloonCard;
                            Intrinsics.checkNotNullExpressionValue((Object)((Object)radiusLayout), (String)"binding.balloonCard");
                            Balloon.access$measureTextWidth(this.this$0$inline_fun, appCompatTextView, (View)radiusLayout);
                        }
                        Balloon.access$getBinding$p(this.this$0$inline_fun).getRoot().measure(0, 0);
                        Balloon.access$getBodyWindow$p(this.this$0$inline_fun).setWidth(this.this$0$inline_fun.getMeasuredWidth());
                        Balloon.access$getBodyWindow$p(this.this$0$inline_fun).setHeight(this.this$0$inline_fun.getMeasuredHeight());
                        VectorTextView vectorTextView = Balloon.access$getBinding$p((Balloon)this.this$0$inline_fun).balloonText;
                        Intrinsics.checkNotNullExpressionValue((Object)((Object)vectorTextView), (String)"this.binding.balloonText");
                        vectorTextView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
                        Balloon.access$initializeArrow(this.this$0$inline_fun, this.$anchor);
                        Balloon.access$initializeBalloonContent(this.this$0$inline_fun);
                        Balloon.access$applyBalloonOverlayAnimation(this.this$0$inline_fun);
                        Balloon.access$showOverlayWindow(this.this$0$inline_fun, this.$anchor);
                        Balloon.access$applyBalloonAnimation(this.this$0$inline_fun);
                        Balloon.access$startBalloonHighlightAnimation(this.this$0$inline_fun);
                        boolean bl = false;
                        Balloon.access$getBodyWindow$p(this.this$0).showAsDropDown(this.$anchor$inlined, Balloon.access$getBuilder$p((Balloon)this.this$0).supportRtlLayoutFactor * (this.$anchor$inlined.getMeasuredWidth() / 2 - this.this$0.getMeasuredWidth() / 2 + this.$xOff$inlined), -this.this$0.getMeasuredHeight() - this.$anchor$inlined.getMeasuredHeight() + this.$yOff$inlined);
                    }
                });
                return;
            }
        }
        if (!((Balloon)this_$iv).builder.dismissWhenShowAgain) return;
        this_$iv.dismiss();
    }

    public static /* synthetic */ void showAlignTop$default(Balloon balloon2, View view, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = 0;
        }
        balloon2.showAlignTop(view, n, n2);
    }

    @JvmOverloads
    public final void showAlignTop(@NotNull View anchor, int xOff) {
        Balloon.showAlignTop$default(this, anchor, xOff, 0, 4, null);
    }

    @JvmOverloads
    public final void showAlignTop(@NotNull View anchor) {
        Balloon.showAlignTop$default(this, anchor, 0, 0, 6, null);
    }

    @JvmOverloads
    @NotNull
    public final Balloon relayShowAlignTop(@NotNull Balloon balloon2, @NotNull View anchor, int xOff, int yOff) {
        Intrinsics.checkNotNullParameter((Object)balloon2, (String)"balloon");
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        Balloon this_$iv = this;
        boolean $i$f$relay = false;
        this_$iv.setOnBalloonDismissListener((Function0<Unit>)((Function0)new Function0<Unit>(this_$iv, balloon2, anchor, xOff, yOff){
            final /* synthetic */ Balloon this$0;
            final /* synthetic */ Balloon $balloon;
            final /* synthetic */ View $anchor$inlined;
            final /* synthetic */ int $xOff$inlined;
            final /* synthetic */ int $yOff$inlined;
            {
                this.this$0 = balloon2;
                this.$balloon = balloon3;
                this.$anchor$inlined = view;
                this.$xOff$inlined = n;
                this.$yOff$inlined = n2;
                super(0);
            }

            public final void invoke() {
                if (!Balloon.access$getDestroyed$p(this.this$0)) {
                    Balloon it = this.$balloon;
                    boolean bl = false;
                    it.showAlignTop(this.$anchor$inlined, this.$xOff$inlined, this.$yOff$inlined);
                }
            }
        }));
        return balloon2;
    }

    public static /* synthetic */ Balloon relayShowAlignTop$default(Balloon balloon2, Balloon balloon3, View view, int n, int n2, int n3, Object object) {
        if ((n3 & 4) != 0) {
            n = 0;
        }
        if ((n3 & 8) != 0) {
            n2 = 0;
        }
        return balloon2.relayShowAlignTop(balloon3, view, n, n2);
    }

    @JvmOverloads
    @NotNull
    public final Balloon relayShowAlignTop(@NotNull Balloon balloon2, @NotNull View anchor, int xOff) {
        return Balloon.relayShowAlignTop$default(this, balloon2, anchor, xOff, 0, 8, null);
    }

    @JvmOverloads
    @NotNull
    public final Balloon relayShowAlignTop(@NotNull Balloon balloon2, @NotNull View anchor) {
        return Balloon.relayShowAlignTop$default(this, balloon2, anchor, 0, 0, 12, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    @JvmOverloads
    public final void showAlignBottom(@NotNull View anchor, int xOff, int yOff) {
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        Balloon this_$iv = this;
        boolean $i$f$show = false;
        if (!(this_$iv.isShowing() || this_$iv.destroyed || ContextExtensionKt.isFinishing(this_$iv.context))) {
            View view = this_$iv.bodyWindow.getContentView();
            Intrinsics.checkNotNullExpressionValue((Object)view, (String)"bodyWindow.contentView");
            if (view.getParent() == null && ViewCompat.isAttachedToWindow((View)anchor)) {
                anchor.post(new Runnable(this_$iv, anchor, this, anchor, xOff, yOff){
                    final /* synthetic */ Balloon this$0$inline_fun;
                    final /* synthetic */ View $anchor;
                    final /* synthetic */ Balloon this$0;
                    final /* synthetic */ View $anchor$inlined;
                    final /* synthetic */ int $xOff$inlined;
                    final /* synthetic */ int $yOff$inlined;
                    {
                        this.this$0$inline_fun = balloon2;
                        this.$anchor = view;
                        this.this$0 = balloon3;
                        this.$anchor$inlined = view2;
                        this.$xOff$inlined = n;
                        this.$yOff$inlined = n2;
                    }

                    public final void run() {
                        String string = Balloon.access$getBuilder$p((Balloon)this.this$0$inline_fun).preferenceName;
                        if (string != null) {
                            String string2 = string;
                            boolean bl = false;
                            boolean bl2 = false;
                            String it = string2;
                            boolean bl3 = false;
                            if (Balloon.access$getBalloonPersistence$p(this.this$0$inline_fun).shouldShowUp(it, Balloon.access$getBuilder$p((Balloon)this.this$0$inline_fun).showTimes)) {
                                Balloon.access$getBalloonPersistence$p(this.this$0$inline_fun).putIncrementedCounts(it);
                            } else {
                                Function0<Unit> function0 = Balloon.access$getBuilder$p((Balloon)this.this$0$inline_fun).runIfReachedShowCounts;
                                if (function0 != null) {
                                    Unit cfr_ignored_0 = (Unit)function0.invoke();
                                }
                                return;
                            }
                        }
                        Balloon.access$setShowing$p(this.this$0$inline_fun, true);
                        long dismissDelay = Balloon.access$getBuilder$p((Balloon)this.this$0$inline_fun).autoDismissDuration;
                        if (dismissDelay != -1L) {
                            this.this$0$inline_fun.dismissWithDelay(dismissDelay);
                        }
                        if (Balloon.access$hasCustomLayout(this.this$0$inline_fun)) {
                            RadiusLayout radiusLayout = Balloon.access$getBinding$p((Balloon)this.this$0$inline_fun).balloonCard;
                            Intrinsics.checkNotNullExpressionValue((Object)((Object)radiusLayout), (String)"binding.balloonCard");
                            Balloon.access$traverseAndMeasureTextWidth(this.this$0$inline_fun, (ViewGroup)radiusLayout);
                        } else {
                            VectorTextView vectorTextView = Balloon.access$getBinding$p((Balloon)this.this$0$inline_fun).balloonText;
                            Intrinsics.checkNotNullExpressionValue((Object)((Object)vectorTextView), (String)"binding.balloonText");
                            AppCompatTextView appCompatTextView = vectorTextView;
                            RadiusLayout radiusLayout = Balloon.access$getBinding$p((Balloon)this.this$0$inline_fun).balloonCard;
                            Intrinsics.checkNotNullExpressionValue((Object)((Object)radiusLayout), (String)"binding.balloonCard");
                            Balloon.access$measureTextWidth(this.this$0$inline_fun, appCompatTextView, (View)radiusLayout);
                        }
                        Balloon.access$getBinding$p(this.this$0$inline_fun).getRoot().measure(0, 0);
                        Balloon.access$getBodyWindow$p(this.this$0$inline_fun).setWidth(this.this$0$inline_fun.getMeasuredWidth());
                        Balloon.access$getBodyWindow$p(this.this$0$inline_fun).setHeight(this.this$0$inline_fun.getMeasuredHeight());
                        VectorTextView vectorTextView = Balloon.access$getBinding$p((Balloon)this.this$0$inline_fun).balloonText;
                        Intrinsics.checkNotNullExpressionValue((Object)((Object)vectorTextView), (String)"this.binding.balloonText");
                        vectorTextView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
                        Balloon.access$initializeArrow(this.this$0$inline_fun, this.$anchor);
                        Balloon.access$initializeBalloonContent(this.this$0$inline_fun);
                        Balloon.access$applyBalloonOverlayAnimation(this.this$0$inline_fun);
                        Balloon.access$showOverlayWindow(this.this$0$inline_fun, this.$anchor);
                        Balloon.access$applyBalloonAnimation(this.this$0$inline_fun);
                        Balloon.access$startBalloonHighlightAnimation(this.this$0$inline_fun);
                        boolean bl = false;
                        Balloon.access$getBodyWindow$p(this.this$0).showAsDropDown(this.$anchor$inlined, Balloon.access$getBuilder$p((Balloon)this.this$0).supportRtlLayoutFactor * (this.$anchor$inlined.getMeasuredWidth() / 2 - this.this$0.getMeasuredWidth() / 2 + this.$xOff$inlined), this.$yOff$inlined);
                    }
                });
                return;
            }
        }
        if (!((Balloon)this_$iv).builder.dismissWhenShowAgain) return;
        this_$iv.dismiss();
    }

    public static /* synthetic */ void showAlignBottom$default(Balloon balloon2, View view, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = 0;
        }
        balloon2.showAlignBottom(view, n, n2);
    }

    @JvmOverloads
    public final void showAlignBottom(@NotNull View anchor, int xOff) {
        Balloon.showAlignBottom$default(this, anchor, xOff, 0, 4, null);
    }

    @JvmOverloads
    public final void showAlignBottom(@NotNull View anchor) {
        Balloon.showAlignBottom$default(this, anchor, 0, 0, 6, null);
    }

    @JvmOverloads
    @NotNull
    public final Balloon relayShowAlignBottom(@NotNull Balloon balloon2, @NotNull View anchor, int xOff, int yOff) {
        Intrinsics.checkNotNullParameter((Object)balloon2, (String)"balloon");
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        Balloon this_$iv = this;
        boolean $i$f$relay = false;
        this_$iv.setOnBalloonDismissListener((Function0<Unit>)((Function0)new Function0<Unit>(this_$iv, balloon2, anchor, xOff, yOff){
            final /* synthetic */ Balloon this$0;
            final /* synthetic */ Balloon $balloon;
            final /* synthetic */ View $anchor$inlined;
            final /* synthetic */ int $xOff$inlined;
            final /* synthetic */ int $yOff$inlined;
            {
                this.this$0 = balloon2;
                this.$balloon = balloon3;
                this.$anchor$inlined = view;
                this.$xOff$inlined = n;
                this.$yOff$inlined = n2;
                super(0);
            }

            public final void invoke() {
                if (!Balloon.access$getDestroyed$p(this.this$0)) {
                    Balloon it = this.$balloon;
                    boolean bl = false;
                    it.showAlignBottom(this.$anchor$inlined, this.$xOff$inlined, this.$yOff$inlined);
                }
            }
        }));
        return balloon2;
    }

    public static /* synthetic */ Balloon relayShowAlignBottom$default(Balloon balloon2, Balloon balloon3, View view, int n, int n2, int n3, Object object) {
        if ((n3 & 4) != 0) {
            n = 0;
        }
        if ((n3 & 8) != 0) {
            n2 = 0;
        }
        return balloon2.relayShowAlignBottom(balloon3, view, n, n2);
    }

    @JvmOverloads
    @NotNull
    public final Balloon relayShowAlignBottom(@NotNull Balloon balloon2, @NotNull View anchor, int xOff) {
        return Balloon.relayShowAlignBottom$default(this, balloon2, anchor, xOff, 0, 8, null);
    }

    @JvmOverloads
    @NotNull
    public final Balloon relayShowAlignBottom(@NotNull Balloon balloon2, @NotNull View anchor) {
        return Balloon.relayShowAlignBottom$default(this, balloon2, anchor, 0, 0, 12, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    @JvmOverloads
    public final void showAlignRight(@NotNull View anchor, int xOff, int yOff) {
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        Balloon this_$iv = this;
        boolean $i$f$show = false;
        if (!(this_$iv.isShowing() || this_$iv.destroyed || ContextExtensionKt.isFinishing(this_$iv.context))) {
            View view = this_$iv.bodyWindow.getContentView();
            Intrinsics.checkNotNullExpressionValue((Object)view, (String)"bodyWindow.contentView");
            if (view.getParent() == null && ViewCompat.isAttachedToWindow((View)anchor)) {
                anchor.post(new Runnable(this_$iv, anchor, this, anchor, xOff, yOff){
                    final /* synthetic */ Balloon this$0$inline_fun;
                    final /* synthetic */ View $anchor;
                    final /* synthetic */ Balloon this$0;
                    final /* synthetic */ View $anchor$inlined;
                    final /* synthetic */ int $xOff$inlined;
                    final /* synthetic */ int $yOff$inlined;
                    {
                        this.this$0$inline_fun = balloon2;
                        this.$anchor = view;
                        this.this$0 = balloon3;
                        this.$anchor$inlined = view2;
                        this.$xOff$inlined = n;
                        this.$yOff$inlined = n2;
                    }

                    public final void run() {
                        String string = Balloon.access$getBuilder$p((Balloon)this.this$0$inline_fun).preferenceName;
                        if (string != null) {
                            String string2 = string;
                            boolean bl = false;
                            boolean bl2 = false;
                            String it = string2;
                            boolean bl3 = false;
                            if (Balloon.access$getBalloonPersistence$p(this.this$0$inline_fun).shouldShowUp(it, Balloon.access$getBuilder$p((Balloon)this.this$0$inline_fun).showTimes)) {
                                Balloon.access$getBalloonPersistence$p(this.this$0$inline_fun).putIncrementedCounts(it);
                            } else {
                                Function0<Unit> function0 = Balloon.access$getBuilder$p((Balloon)this.this$0$inline_fun).runIfReachedShowCounts;
                                if (function0 != null) {
                                    Unit cfr_ignored_0 = (Unit)function0.invoke();
                                }
                                return;
                            }
                        }
                        Balloon.access$setShowing$p(this.this$0$inline_fun, true);
                        long dismissDelay = Balloon.access$getBuilder$p((Balloon)this.this$0$inline_fun).autoDismissDuration;
                        if (dismissDelay != -1L) {
                            this.this$0$inline_fun.dismissWithDelay(dismissDelay);
                        }
                        if (Balloon.access$hasCustomLayout(this.this$0$inline_fun)) {
                            RadiusLayout radiusLayout = Balloon.access$getBinding$p((Balloon)this.this$0$inline_fun).balloonCard;
                            Intrinsics.checkNotNullExpressionValue((Object)((Object)radiusLayout), (String)"binding.balloonCard");
                            Balloon.access$traverseAndMeasureTextWidth(this.this$0$inline_fun, (ViewGroup)radiusLayout);
                        } else {
                            VectorTextView vectorTextView = Balloon.access$getBinding$p((Balloon)this.this$0$inline_fun).balloonText;
                            Intrinsics.checkNotNullExpressionValue((Object)((Object)vectorTextView), (String)"binding.balloonText");
                            AppCompatTextView appCompatTextView = vectorTextView;
                            RadiusLayout radiusLayout = Balloon.access$getBinding$p((Balloon)this.this$0$inline_fun).balloonCard;
                            Intrinsics.checkNotNullExpressionValue((Object)((Object)radiusLayout), (String)"binding.balloonCard");
                            Balloon.access$measureTextWidth(this.this$0$inline_fun, appCompatTextView, (View)radiusLayout);
                        }
                        Balloon.access$getBinding$p(this.this$0$inline_fun).getRoot().measure(0, 0);
                        Balloon.access$getBodyWindow$p(this.this$0$inline_fun).setWidth(this.this$0$inline_fun.getMeasuredWidth());
                        Balloon.access$getBodyWindow$p(this.this$0$inline_fun).setHeight(this.this$0$inline_fun.getMeasuredHeight());
                        VectorTextView vectorTextView = Balloon.access$getBinding$p((Balloon)this.this$0$inline_fun).balloonText;
                        Intrinsics.checkNotNullExpressionValue((Object)((Object)vectorTextView), (String)"this.binding.balloonText");
                        vectorTextView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
                        Balloon.access$initializeArrow(this.this$0$inline_fun, this.$anchor);
                        Balloon.access$initializeBalloonContent(this.this$0$inline_fun);
                        Balloon.access$applyBalloonOverlayAnimation(this.this$0$inline_fun);
                        Balloon.access$showOverlayWindow(this.this$0$inline_fun, this.$anchor);
                        Balloon.access$applyBalloonAnimation(this.this$0$inline_fun);
                        Balloon.access$startBalloonHighlightAnimation(this.this$0$inline_fun);
                        boolean bl = false;
                        Balloon.access$getBodyWindow$p(this.this$0).showAsDropDown(this.$anchor$inlined, this.$anchor$inlined.getMeasuredWidth() + this.$xOff$inlined, -(this.this$0.getMeasuredHeight() / 2) - this.$anchor$inlined.getMeasuredHeight() / 2 + this.$yOff$inlined);
                    }
                });
                return;
            }
        }
        if (!((Balloon)this_$iv).builder.dismissWhenShowAgain) return;
        this_$iv.dismiss();
    }

    public static /* synthetic */ void showAlignRight$default(Balloon balloon2, View view, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = 0;
        }
        balloon2.showAlignRight(view, n, n2);
    }

    @JvmOverloads
    public final void showAlignRight(@NotNull View anchor, int xOff) {
        Balloon.showAlignRight$default(this, anchor, xOff, 0, 4, null);
    }

    @JvmOverloads
    public final void showAlignRight(@NotNull View anchor) {
        Balloon.showAlignRight$default(this, anchor, 0, 0, 6, null);
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    @NotNull
    public final Balloon relayShowAlignRight(@NotNull Balloon balloon2, @NotNull View anchor, int xOff, int yOff) {
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)balloon2, (String)"balloon");
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        Balloon balloon3 = this;
        boolean $i$f$relay = false;
        this_$iv.setOnBalloonDismissListener((Function0<Unit>)((Function0)new Function0<Unit>((Balloon)this_$iv, balloon2, anchor, xOff, yOff){
            final /* synthetic */ Balloon this$0;
            final /* synthetic */ Balloon $balloon;
            final /* synthetic */ View $anchor$inlined;
            final /* synthetic */ int $xOff$inlined;
            final /* synthetic */ int $yOff$inlined;
            {
                this.this$0 = balloon2;
                this.$balloon = balloon3;
                this.$anchor$inlined = view;
                this.$xOff$inlined = n;
                this.$yOff$inlined = n2;
                super(0);
            }

            public final void invoke() {
                if (!Balloon.access$getDestroyed$p(this.this$0)) {
                    Balloon it = this.$balloon;
                    boolean bl = false;
                    it.showAlignRight(this.$anchor$inlined, this.$xOff$inlined, this.$yOff$inlined);
                }
            }
        }));
        return balloon2;
    }

    public static /* synthetic */ Balloon relayShowAlignRight$default(Balloon balloon2, Balloon balloon3, View view, int n, int n2, int n3, Object object) {
        if ((n3 & 4) != 0) {
            n = 0;
        }
        if ((n3 & 8) != 0) {
            n2 = 0;
        }
        return balloon2.relayShowAlignRight(balloon3, view, n, n2);
    }

    @JvmOverloads
    @NotNull
    public final Balloon relayShowAlignRight(@NotNull Balloon balloon2, @NotNull View anchor, int xOff) {
        return Balloon.relayShowAlignRight$default(this, balloon2, anchor, xOff, 0, 8, null);
    }

    @JvmOverloads
    @NotNull
    public final Balloon relayShowAlignRight(@NotNull Balloon balloon2, @NotNull View anchor) {
        return Balloon.relayShowAlignRight$default(this, balloon2, anchor, 0, 0, 12, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    @JvmOverloads
    public final void showAlignLeft(@NotNull View anchor, int xOff, int yOff) {
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        Balloon this_$iv = this;
        boolean $i$f$show = false;
        if (!(this_$iv.isShowing() || this_$iv.destroyed || ContextExtensionKt.isFinishing(this_$iv.context))) {
            View view = this_$iv.bodyWindow.getContentView();
            Intrinsics.checkNotNullExpressionValue((Object)view, (String)"bodyWindow.contentView");
            if (view.getParent() == null && ViewCompat.isAttachedToWindow((View)anchor)) {
                anchor.post(new Runnable(this_$iv, anchor, this, anchor, xOff, yOff){
                    final /* synthetic */ Balloon this$0$inline_fun;
                    final /* synthetic */ View $anchor;
                    final /* synthetic */ Balloon this$0;
                    final /* synthetic */ View $anchor$inlined;
                    final /* synthetic */ int $xOff$inlined;
                    final /* synthetic */ int $yOff$inlined;
                    {
                        this.this$0$inline_fun = balloon2;
                        this.$anchor = view;
                        this.this$0 = balloon3;
                        this.$anchor$inlined = view2;
                        this.$xOff$inlined = n;
                        this.$yOff$inlined = n2;
                    }

                    public final void run() {
                        String string = Balloon.access$getBuilder$p((Balloon)this.this$0$inline_fun).preferenceName;
                        if (string != null) {
                            String string2 = string;
                            boolean bl = false;
                            boolean bl2 = false;
                            String it = string2;
                            boolean bl3 = false;
                            if (Balloon.access$getBalloonPersistence$p(this.this$0$inline_fun).shouldShowUp(it, Balloon.access$getBuilder$p((Balloon)this.this$0$inline_fun).showTimes)) {
                                Balloon.access$getBalloonPersistence$p(this.this$0$inline_fun).putIncrementedCounts(it);
                            } else {
                                Function0<Unit> function0 = Balloon.access$getBuilder$p((Balloon)this.this$0$inline_fun).runIfReachedShowCounts;
                                if (function0 != null) {
                                    Unit cfr_ignored_0 = (Unit)function0.invoke();
                                }
                                return;
                            }
                        }
                        Balloon.access$setShowing$p(this.this$0$inline_fun, true);
                        long dismissDelay = Balloon.access$getBuilder$p((Balloon)this.this$0$inline_fun).autoDismissDuration;
                        if (dismissDelay != -1L) {
                            this.this$0$inline_fun.dismissWithDelay(dismissDelay);
                        }
                        if (Balloon.access$hasCustomLayout(this.this$0$inline_fun)) {
                            RadiusLayout radiusLayout = Balloon.access$getBinding$p((Balloon)this.this$0$inline_fun).balloonCard;
                            Intrinsics.checkNotNullExpressionValue((Object)((Object)radiusLayout), (String)"binding.balloonCard");
                            Balloon.access$traverseAndMeasureTextWidth(this.this$0$inline_fun, (ViewGroup)radiusLayout);
                        } else {
                            VectorTextView vectorTextView = Balloon.access$getBinding$p((Balloon)this.this$0$inline_fun).balloonText;
                            Intrinsics.checkNotNullExpressionValue((Object)((Object)vectorTextView), (String)"binding.balloonText");
                            AppCompatTextView appCompatTextView = vectorTextView;
                            RadiusLayout radiusLayout = Balloon.access$getBinding$p((Balloon)this.this$0$inline_fun).balloonCard;
                            Intrinsics.checkNotNullExpressionValue((Object)((Object)radiusLayout), (String)"binding.balloonCard");
                            Balloon.access$measureTextWidth(this.this$0$inline_fun, appCompatTextView, (View)radiusLayout);
                        }
                        Balloon.access$getBinding$p(this.this$0$inline_fun).getRoot().measure(0, 0);
                        Balloon.access$getBodyWindow$p(this.this$0$inline_fun).setWidth(this.this$0$inline_fun.getMeasuredWidth());
                        Balloon.access$getBodyWindow$p(this.this$0$inline_fun).setHeight(this.this$0$inline_fun.getMeasuredHeight());
                        VectorTextView vectorTextView = Balloon.access$getBinding$p((Balloon)this.this$0$inline_fun).balloonText;
                        Intrinsics.checkNotNullExpressionValue((Object)((Object)vectorTextView), (String)"this.binding.balloonText");
                        vectorTextView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
                        Balloon.access$initializeArrow(this.this$0$inline_fun, this.$anchor);
                        Balloon.access$initializeBalloonContent(this.this$0$inline_fun);
                        Balloon.access$applyBalloonOverlayAnimation(this.this$0$inline_fun);
                        Balloon.access$showOverlayWindow(this.this$0$inline_fun, this.$anchor);
                        Balloon.access$applyBalloonAnimation(this.this$0$inline_fun);
                        Balloon.access$startBalloonHighlightAnimation(this.this$0$inline_fun);
                        boolean bl = false;
                        Balloon.access$getBodyWindow$p(this.this$0).showAsDropDown(this.$anchor$inlined, -this.this$0.getMeasuredWidth() + this.$xOff$inlined, -(this.this$0.getMeasuredHeight() / 2) - this.$anchor$inlined.getMeasuredHeight() / 2 + this.$yOff$inlined);
                    }
                });
                return;
            }
        }
        if (!((Balloon)this_$iv).builder.dismissWhenShowAgain) return;
        this_$iv.dismiss();
    }

    public static /* synthetic */ void showAlignLeft$default(Balloon balloon2, View view, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = 0;
        }
        balloon2.showAlignLeft(view, n, n2);
    }

    @JvmOverloads
    public final void showAlignLeft(@NotNull View anchor, int xOff) {
        Balloon.showAlignLeft$default(this, anchor, xOff, 0, 4, null);
    }

    @JvmOverloads
    public final void showAlignLeft(@NotNull View anchor) {
        Balloon.showAlignLeft$default(this, anchor, 0, 0, 6, null);
    }

    @JvmOverloads
    @NotNull
    public final Balloon relayShowAlignLeft(@NotNull Balloon balloon2, @NotNull View anchor, int xOff, int yOff) {
        Intrinsics.checkNotNullParameter((Object)balloon2, (String)"balloon");
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        Balloon this_$iv = this;
        boolean $i$f$relay = false;
        this_$iv.setOnBalloonDismissListener((Function0<Unit>)((Function0)new Function0<Unit>(this_$iv, balloon2, anchor, xOff, yOff){
            final /* synthetic */ Balloon this$0;
            final /* synthetic */ Balloon $balloon;
            final /* synthetic */ View $anchor$inlined;
            final /* synthetic */ int $xOff$inlined;
            final /* synthetic */ int $yOff$inlined;
            {
                this.this$0 = balloon2;
                this.$balloon = balloon3;
                this.$anchor$inlined = view;
                this.$xOff$inlined = n;
                this.$yOff$inlined = n2;
                super(0);
            }

            public final void invoke() {
                if (!Balloon.access$getDestroyed$p(this.this$0)) {
                    Balloon it = this.$balloon;
                    boolean bl = false;
                    it.showAlignLeft(this.$anchor$inlined, this.$xOff$inlined, this.$yOff$inlined);
                }
            }
        }));
        return balloon2;
    }

    public static /* synthetic */ Balloon relayShowAlignLeft$default(Balloon balloon2, Balloon balloon3, View view, int n, int n2, int n3, Object object) {
        if ((n3 & 4) != 0) {
            n = 0;
        }
        if ((n3 & 8) != 0) {
            n2 = 0;
        }
        return balloon2.relayShowAlignLeft(balloon3, view, n, n2);
    }

    @JvmOverloads
    @NotNull
    public final Balloon relayShowAlignLeft(@NotNull Balloon balloon2, @NotNull View anchor, int xOff) {
        return Balloon.relayShowAlignLeft$default(this, balloon2, anchor, xOff, 0, 8, null);
    }

    @JvmOverloads
    @NotNull
    public final Balloon relayShowAlignLeft(@NotNull Balloon balloon2, @NotNull View anchor) {
        return Balloon.relayShowAlignLeft$default(this, balloon2, anchor, 0, 0, 12, null);
    }

    @JvmOverloads
    public final void update(@NotNull View anchor, int xOff, int yOff) {
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        Balloon this_$iv = this;
        boolean $i$f$update = false;
        if (this_$iv.isShowing()) {
            this_$iv.initializeArrow(anchor);
            boolean bl = false;
            this.bodyWindow.update(anchor, xOff, yOff, this.getMeasuredWidth(), this.getMeasuredHeight());
        }
    }

    public static /* synthetic */ void update$default(Balloon balloon2, View view, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = 0;
        }
        balloon2.update(view, n, n2);
    }

    @JvmOverloads
    public final void update(@NotNull View anchor, int xOff) {
        Balloon.update$default(this, anchor, xOff, 0, 4, null);
    }

    @JvmOverloads
    public final void update(@NotNull View anchor) {
        Balloon.update$default(this, anchor, 0, 0, 6, null);
    }

    @MainThread
    private final void update(View anchor, Function0<Unit> block) {
        int $i$f$update = 0;
        if (this.isShowing()) {
            this.initializeArrow(anchor);
            block.invoke();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void dismiss() {
        if (this.isShowing) {
            Function0 dismissWindow2 = (Function0)new Function0<Unit>(this){
                final /* synthetic */ Balloon this$0;

                public final void invoke() {
                    Balloon.access$setShowing$p(this.this$0, false);
                    Balloon.access$getBodyWindow$p(this.this$0).dismiss();
                    Balloon.access$getOverlayWindow$p(this.this$0).dismiss();
                    Balloon.access$getHandler$p(this.this$0).removeCallbacks((Runnable)Balloon.access$getAutoDismissRunnable$p(this.this$0));
                }
                {
                    this.this$0 = balloon2;
                    super(0);
                }
            };
            if (this.builder.balloonAnimation == BalloonAnimation.CIRCULAR) {
                View view = this.bodyWindow.getContentView();
                Intrinsics.checkNotNullExpressionValue((Object)view, (String)"this.bodyWindow.contentView");
                View view2 = view;
                long circularDuration$iv = this.builder.circularDuration;
                boolean $i$f$circularUnRevealed = false;
                boolean $i$f$runOnAfterSDK21 = false;
                if (Build.VERSION.SDK_INT >= 21) {
                    void $this$circularUnRevealed$iv;
                    boolean bl = false;
                    $this$circularUnRevealed$iv.post(new Runnable((View)$this$circularUnRevealed$iv, circularDuration$iv, dismissWindow2){
                        final /* synthetic */ View $this_circularUnRevealed$inlined;
                        final /* synthetic */ long $circularDuration$inlined;
                        final /* synthetic */ Function0 $dismissWindow$inlined;
                        {
                            this.$this_circularUnRevealed$inlined = view;
                            this.$circularDuration$inlined = l;
                            this.$dismissWindow$inlined = function0;
                        }

                        public final void run() {
                            if (this.$this_circularUnRevealed$inlined.isAttachedToWindow()) {
                                int n = this.$this_circularUnRevealed$inlined.getWidth();
                                int n2 = this.$this_circularUnRevealed$inlined.getHeight();
                                boolean bl = false;
                                Animator animator = ViewAnimationUtils.createCircularReveal((View)this.$this_circularUnRevealed$inlined, (int)((this.$this_circularUnRevealed$inlined.getLeft() + this.$this_circularUnRevealed$inlined.getRight()) / 2), (int)((this.$this_circularUnRevealed$inlined.getTop() + this.$this_circularUnRevealed$inlined.getBottom()) / 2), (float)Math.max(n, n2), (float)0.0f);
                                n2 = 0;
                                bl = false;
                                Animator $this$apply = animator;
                                boolean bl2 = false;
                                $this$apply.setDuration(this.$circularDuration$inlined);
                                $this$apply.start();
                                animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(this){
                                    final /* synthetic */ dismiss$$inlined$circularUnRevealed$1 this$0;
                                    {
                                        this.this$0 = this$0;
                                    }

                                    public void onAnimationEnd(@Nullable Animator animation) {
                                        super.onAnimationEnd(animation);
                                        boolean bl = false;
                                        this.this$0.$dismissWindow$inlined.invoke();
                                    }
                                });
                            }
                        }
                    });
                }
            } else {
                dismissWindow2.invoke();
            }
        }
    }

    public final boolean dismissWithDelay(long delay) {
        return this.getHandler().postDelayed((Runnable)this.getAutoDismissRunnable(), delay);
    }

    public final void setOnBalloonClickListener(@Nullable OnBalloonClickListener onBalloonClickListener) {
        this.binding.balloonWrapper.setOnClickListener(new View.OnClickListener(this, onBalloonClickListener){
            final /* synthetic */ Balloon this$0;
            final /* synthetic */ OnBalloonClickListener $onBalloonClickListener;

            public final void onClick(View it) {
                OnBalloonClickListener onBalloonClickListener = this.$onBalloonClickListener;
                if (onBalloonClickListener != null) {
                    View view = it;
                    Intrinsics.checkNotNullExpressionValue((Object)view, (String)"it");
                    onBalloonClickListener.onBalloonClick(view);
                }
                if (Balloon.access$getBuilder$p((Balloon)this.this$0).dismissWhenClicked) {
                    this.this$0.dismiss();
                }
            }
            {
                this.this$0 = balloon2;
                this.$onBalloonClickListener = onBalloonClickListener;
            }
        });
    }

    public final /* synthetic */ void setOnBalloonClickListener(Function1<? super View, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        Function1<? super View, Unit> function1 = block;
        this.setOnBalloonClickListener(new BalloonKt$sam$com_skydoves_balloon_OnBalloonClickListener$0(function1));
    }

    public final void setOnBalloonInitializedListener(@Nullable OnBalloonInitializedListener onBalloonInitializedListener) {
        this.onBalloonInitializedListener = onBalloonInitializedListener;
    }

    public final /* synthetic */ void setOnBalloonInitializedListener(Function1<? super View, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        Function1<? super View, Unit> function1 = block;
        this.setOnBalloonInitializedListener(new BalloonKt$sam$com_skydoves_balloon_OnBalloonInitializedListener$0(function1));
    }

    public final void setOnBalloonDismissListener(@Nullable OnBalloonDismissListener onBalloonDismissListener) {
        this.bodyWindow.setOnDismissListener(new PopupWindow.OnDismissListener(this, onBalloonDismissListener){
            final /* synthetic */ Balloon this$0;
            final /* synthetic */ OnBalloonDismissListener $onBalloonDismissListener;

            public final void onDismiss() {
                block0: {
                    Balloon.access$stopBalloonHighlightAnimation(this.this$0);
                    this.this$0.dismiss();
                    OnBalloonDismissListener onBalloonDismissListener = this.$onBalloonDismissListener;
                    if (onBalloonDismissListener == null) break block0;
                    onBalloonDismissListener.onBalloonDismiss();
                }
            }
            {
                this.this$0 = balloon2;
                this.$onBalloonDismissListener = onBalloonDismissListener;
            }
        });
    }

    public final /* synthetic */ void setOnBalloonDismissListener(Function0<Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        Function0<Unit> function0 = block;
        this.setOnBalloonDismissListener(new BalloonKt$sam$com_skydoves_balloon_OnBalloonDismissListener$0(function0));
    }

    public final void setOnBalloonOutsideTouchListener(@Nullable OnBalloonOutsideTouchListener onBalloonOutsideTouchListener) {
        this.bodyWindow.setTouchInterceptor(new View.OnTouchListener(this, onBalloonOutsideTouchListener){
            final /* synthetic */ Balloon this$0;
            final /* synthetic */ OnBalloonOutsideTouchListener $onBalloonOutsideTouchListener;

            @SuppressLint(value={"ClickableViewAccessibility"})
            public boolean onTouch(@NotNull View view, @NotNull MotionEvent event) {
                Intrinsics.checkNotNullParameter((Object)view, (String)"view");
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (event.getAction() == 4) {
                    if (Balloon.access$getBuilder$p((Balloon)this.this$0).dismissWhenTouchOutside) {
                        this.this$0.dismiss();
                    }
                    OnBalloonOutsideTouchListener onBalloonOutsideTouchListener = this.$onBalloonOutsideTouchListener;
                    if (onBalloonOutsideTouchListener != null) {
                        onBalloonOutsideTouchListener.onBalloonOutsideTouch(view, event);
                    }
                    return true;
                }
                return false;
            }
            {
                this.this$0 = this$0;
                this.$onBalloonOutsideTouchListener = $captured_local_variable$1;
            }
        });
    }

    public final /* synthetic */ void setOnBalloonOutsideTouchListener(Function2<? super View, ? super MotionEvent, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        Function2<? super View, ? super MotionEvent, Unit> function2 = block;
        this.setOnBalloonOutsideTouchListener(new BalloonKt$sam$com_skydoves_balloon_OnBalloonOutsideTouchListener$0(function2));
    }

    public final void setOnBalloonTouchListener(@Nullable View.OnTouchListener onTouchListener) {
        if (onTouchListener != null) {
            this.bodyWindow.setTouchInterceptor(onTouchListener);
        }
    }

    public final void setOnBalloonOverlayTouchListener(@Nullable View.OnTouchListener onTouchListener) {
        if (onTouchListener != null) {
            this.overlayWindow.setTouchInterceptor(onTouchListener);
        }
    }

    public final void setOnBalloonOverlayTouchListener(@NotNull Function2<? super View, ? super MotionEvent, Boolean> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        Function2<? super View, ? super MotionEvent, Boolean> function2 = block;
        this.setOnBalloonOverlayTouchListener(new BalloonKt$sam$android_view_View_OnTouchListener$0(function2));
    }

    public final void setOnBalloonOverlayClickListener(@Nullable OnBalloonOverlayClickListener onBalloonOverlayClickListener) {
        this.overlayBinding.getRoot().setOnClickListener(new View.OnClickListener(this, onBalloonOverlayClickListener){
            final /* synthetic */ Balloon this$0;
            final /* synthetic */ OnBalloonOverlayClickListener $onBalloonOverlayClickListener;

            public final void onClick(View it) {
                OnBalloonOverlayClickListener onBalloonOverlayClickListener = this.$onBalloonOverlayClickListener;
                if (onBalloonOverlayClickListener != null) {
                    onBalloonOverlayClickListener.onBalloonOverlayClick();
                }
                if (Balloon.access$getBuilder$p((Balloon)this.this$0).dismissWhenOverlayClicked) {
                    this.this$0.dismiss();
                }
            }
            {
                this.this$0 = balloon2;
                this.$onBalloonOverlayClickListener = onBalloonOverlayClickListener;
            }
        });
    }

    public final /* synthetic */ void setOnBalloonOverlayClickListener(Function0<Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        Function0<Unit> function0 = block;
        this.setOnBalloonOverlayClickListener(new BalloonKt$sam$com_skydoves_balloon_OnBalloonOverlayClickListener$0(function0));
    }

    public final int getMeasuredWidth() {
        int n;
        int displayWidth = ContextExtensionKt.displaySize((Context)this.context).x;
        if (this.builder.widthRatio != 0.0f) {
            n = (int)((float)displayWidth * this.builder.widthRatio);
        } else if (this.builder.minWidthRatio != 0.0f || this.builder.maxWidthRatio != 0.0f) {
            float max = this.builder.maxWidthRatio != 0.0f ? this.builder.maxWidthRatio : 1.0f;
            FrameLayout frameLayout = this.binding.getRoot();
            Intrinsics.checkNotNullExpressionValue((Object)frameLayout, (String)"binding.root");
            n = RangesKt.coerceIn((int)frameLayout.getMeasuredWidth(), (int)((int)((float)displayWidth * this.builder.minWidthRatio)), (int)((int)((float)displayWidth * max)));
        } else if (this.builder.width != Integer.MIN_VALUE) {
            n = RangesKt.coerceAtMost((int)this.builder.width, (int)displayWidth);
        } else {
            FrameLayout frameLayout = this.binding.getRoot();
            Intrinsics.checkNotNullExpressionValue((Object)frameLayout, (String)"binding.root");
            n = RangesKt.coerceIn((int)frameLayout.getMeasuredWidth(), (int)this.builder.minWidth, (int)this.builder.maxWidth);
        }
        return n;
    }

    private final void measureTextWidth(AppCompatTextView textView, View rootView) {
        boolean bl = false;
        boolean bl2 = false;
        AppCompatTextView $this$with = textView;
        boolean bl3 = false;
        int measuredTextWidth = (int)textView.getPaint().measureText(((Object)textView.getText()).toString());
        Drawable[] drawableArray = $this$with.getCompoundDrawablesRelative();
        Intrinsics.checkNotNullExpressionValue((Object)drawableArray, (String)"compoundDrawablesRelative");
        if (DrawableExtensionKt.isExistHorizontalDrawable(drawableArray)) {
            Drawable[] drawableArray2 = $this$with.getCompoundDrawablesRelative();
            Intrinsics.checkNotNullExpressionValue((Object)drawableArray2, (String)"compoundDrawablesRelative");
            $this$with.setMinHeight(DrawableExtensionKt.getIntrinsicHeight(drawableArray2));
            Drawable[] drawableArray3 = $this$with.getCompoundDrawablesRelative();
            Intrinsics.checkNotNullExpressionValue((Object)drawableArray3, (String)"compoundDrawablesRelative");
            TextView $this$sumOfCompoundPadding$iv = (TextView)$this$with;
            boolean $i$f$getSumOfCompoundPadding = false;
            measuredTextWidth += DrawableExtensionKt.getSumOfIntrinsicWidth(drawableArray3) + ($this$sumOfCompoundPadding$iv.getCompoundPaddingStart() + $this$sumOfCompoundPadding$iv.getCompoundPaddingEnd());
        } else {
            Drawable[] drawableArray4 = $this$with.getCompoundDrawables();
            Intrinsics.checkNotNullExpressionValue((Object)drawableArray4, (String)"compoundDrawables");
            if (DrawableExtensionKt.isExistHorizontalDrawable(drawableArray4)) {
                Drawable[] drawableArray5 = $this$with.getCompoundDrawables();
                Intrinsics.checkNotNullExpressionValue((Object)drawableArray5, (String)"compoundDrawables");
                $this$with.setMinHeight(DrawableExtensionKt.getIntrinsicHeight(drawableArray5));
                Drawable[] drawableArray6 = $this$with.getCompoundDrawables();
                Intrinsics.checkNotNullExpressionValue((Object)drawableArray6, (String)"compoundDrawables");
                TextView $this$sumOfCompoundPadding$iv = (TextView)$this$with;
                boolean $i$f$getSumOfCompoundPadding = false;
                measuredTextWidth += DrawableExtensionKt.getSumOfIntrinsicWidth(drawableArray6) + ($this$sumOfCompoundPadding$iv.getCompoundPaddingStart() + $this$sumOfCompoundPadding$iv.getCompoundPaddingEnd());
            }
        }
        $this$with.setMaxWidth(this.getMeasuredTextWidth(measuredTextWidth, rootView));
    }

    /*
     * WARNING - void declaration
     */
    private final void traverseAndMeasureTextWidth(ViewGroup parent) {
        ViewGroup $this$forEach$iv = parent;
        boolean $i$f$forEach = false;
        int n = 0;
        int n2 = $this$forEach$iv.getChildCount();
        while (n < n2) {
            View child;
            void index$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)$this$forEach$iv.getChildAt((int)index$iv), (String)"getChildAt(index)");
            boolean bl = false;
            if (child instanceof AppCompatTextView) {
                this.measureTextWidth((AppCompatTextView)child, (View)parent);
            } else if (child instanceof ViewGroup) {
                this.traverseAndMeasureTextWidth((ViewGroup)child);
            }
            ++index$iv;
        }
    }

    private final int getMeasuredTextWidth(int measuredWidth, View rootView) {
        int n;
        int displayWidth = ContextExtensionKt.displaySize((Context)this.context).x;
        int spaces = rootView.getPaddingLeft() + rootView.getPaddingRight() + (this.builder.iconDrawable != null ? this.builder.iconWidth + this.builder.iconSpace : 0 + this.builder.marginRight + this.builder.marginLeft + this.builder.arrowSize * 2);
        int maxTextWidth = displayWidth - spaces;
        if (this.builder.widthRatio != 0.0f) {
            n = (int)((float)displayWidth * this.builder.widthRatio) - spaces;
        } else if (this.builder.minWidthRatio != 0.0f || this.builder.maxWidthRatio != 0.0f) {
            float max = this.builder.maxWidthRatio != 0.0f ? this.builder.maxWidthRatio : 1.0f;
            FrameLayout frameLayout = this.binding.getRoot();
            Intrinsics.checkNotNullExpressionValue((Object)frameLayout, (String)"binding.root");
            n = RangesKt.coerceIn((int)frameLayout.getMeasuredWidth(), (int)((int)((float)displayWidth * this.builder.minWidthRatio)), (int)((int)((float)displayWidth * max))) - spaces;
        } else {
            n = this.builder.width != Integer.MIN_VALUE && this.builder.width <= displayWidth ? this.builder.width - spaces : RangesKt.coerceAtMost((int)measuredWidth, (int)maxTextWidth);
        }
        return n;
    }

    public final int getMeasuredHeight() {
        if (this.builder.height != Integer.MIN_VALUE) {
            return this.builder.height;
        }
        FrameLayout frameLayout = this.binding.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)frameLayout, (String)"this.binding.root");
        return frameLayout.getMeasuredHeight();
    }

    @NotNull
    public final ViewGroup getContentView() {
        RadiusLayout radiusLayout = this.binding.balloonCard;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)radiusLayout), (String)"binding.balloonCard");
        return (ViewGroup)radiusLayout;
    }

    @NotNull
    public final View getBalloonArrowView() {
        AppCompatImageView appCompatImageView = this.binding.balloonArrow;
        Intrinsics.checkNotNullExpressionValue((Object)appCompatImageView, (String)"binding.balloonArrow");
        return (View)appCompatImageView;
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_PAUSE)
    public final void onPause() {
        if (this.builder.dismissWhenLifecycleOnPause) {
            this.dismiss();
        }
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_DESTROY)
    public final void onDestroy() {
        this.destroyed = true;
        this.overlayWindow.dismiss();
        this.bodyWindow.dismiss();
    }

    public Balloon(@NotNull Context context, @NotNull Builder builder) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        this.context = context;
        this.builder = builder;
        LayoutBalloonLibrarySkydovesBinding layoutBalloonLibrarySkydovesBinding = LayoutBalloonLibrarySkydovesBinding.inflate(LayoutInflater.from((Context)this.context), null, false);
        Intrinsics.checkNotNullExpressionValue((Object)layoutBalloonLibrarySkydovesBinding, (String)"LayoutBalloonLibrarySkyd\u2026om(context), null, false)");
        this.binding = layoutBalloonLibrarySkydovesBinding;
        LayoutBalloonOverlayLibrarySkydovesBinding layoutBalloonOverlayLibrarySkydovesBinding = LayoutBalloonOverlayLibrarySkydovesBinding.inflate(LayoutInflater.from((Context)this.context), null, false);
        Intrinsics.checkNotNullExpressionValue((Object)layoutBalloonOverlayLibrarySkydovesBinding, (String)"LayoutBalloonOverlayLibr\u2026om(context), null, false)");
        this.overlayBinding = layoutBalloonOverlayLibrarySkydovesBinding;
        this.onBalloonInitializedListener = this.builder.onBalloonInitializedListener;
        this.handler$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)handler.2.INSTANCE);
        this.autoDismissRunnable$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<AutoDismissRunnable>(this){
            final /* synthetic */ Balloon this$0;

            @NotNull
            public final AutoDismissRunnable invoke() {
                return new AutoDismissRunnable(this.this$0);
            }
            {
                this.this$0 = balloon2;
                super(0);
            }
        }));
        this.balloonPersistence$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<BalloonPersistence>(this){
            final /* synthetic */ Balloon this$0;

            @NotNull
            public final BalloonPersistence invoke() {
                return BalloonPersistence.Companion.getInstance(Balloon.access$getContext$p(this.this$0));
            }
            {
                this.this$0 = balloon2;
                super(0);
            }
        }));
        this.bodyWindow = new PopupWindow((View)this.binding.getRoot(), -2, -2);
        this.overlayWindow = new PopupWindow((View)this.overlayBinding.getRoot(), -1, -1);
        this.createByBuilder();
    }

    public static final /* synthetic */ void access$adjustArrowOrientationByRules(Balloon $this, View anchor) {
        $this.adjustArrowOrientationByRules(anchor);
    }

    public static final /* synthetic */ float access$getArrowConstraintPositionX(Balloon $this, View anchor) {
        return $this.getArrowConstraintPositionX(anchor);
    }

    public static final /* synthetic */ LayoutBalloonLibrarySkydovesBinding access$getBinding$p(Balloon $this) {
        return $this.binding;
    }

    public static final /* synthetic */ Bitmap access$adjustArrowColorByMatchingCardBackground(Balloon $this, AppCompatImageView imageView, float x, float y) {
        return $this.adjustArrowColorByMatchingCardBackground(imageView, x, y);
    }

    public static final /* synthetic */ float access$getArrowConstraintPositionY(Balloon $this, View anchor) {
        return $this.getArrowConstraintPositionY(anchor);
    }

    public static final /* synthetic */ Animation access$getBalloonHighlightAnimation(Balloon $this) {
        return $this.getBalloonHighlightAnimation();
    }

    public static final /* synthetic */ boolean access$isShowing$p(Balloon $this) {
        return $this.isShowing;
    }

    public static final /* synthetic */ void access$setShowing$p(Balloon $this, boolean bl) {
        $this.isShowing = bl;
    }

    public static final /* synthetic */ void access$setDestroyed$p(Balloon $this, boolean bl) {
        $this.destroyed = bl;
    }

    public static final /* synthetic */ BalloonPersistence access$getBalloonPersistence$p(Balloon $this) {
        return $this.getBalloonPersistence();
    }

    public static final /* synthetic */ boolean access$hasCustomLayout(Balloon $this) {
        return $this.hasCustomLayout();
    }

    public static final /* synthetic */ void access$traverseAndMeasureTextWidth(Balloon $this, ViewGroup parent) {
        $this.traverseAndMeasureTextWidth(parent);
    }

    public static final /* synthetic */ void access$measureTextWidth(Balloon $this, AppCompatTextView textView, View rootView) {
        $this.measureTextWidth(textView, rootView);
    }

    public static final /* synthetic */ void access$initializeBalloonContent(Balloon $this) {
        $this.initializeBalloonContent();
    }

    public static final /* synthetic */ void access$applyBalloonOverlayAnimation(Balloon $this) {
        $this.applyBalloonOverlayAnimation();
    }

    public static final /* synthetic */ void access$showOverlayWindow(Balloon $this, View anchor) {
        $this.showOverlayWindow(anchor);
    }

    public static final /* synthetic */ void access$applyBalloonAnimation(Balloon $this) {
        $this.applyBalloonAnimation();
    }

    public static final /* synthetic */ void access$startBalloonHighlightAnimation(Balloon $this) {
        $this.startBalloonHighlightAnimation();
    }

    public static final /* synthetic */ PopupWindow access$getOverlayWindow$p(Balloon $this) {
        return $this.overlayWindow;
    }

    public static final /* synthetic */ Handler access$getHandler$p(Balloon $this) {
        return $this.getHandler();
    }

    public static final /* synthetic */ AutoDismissRunnable access$getAutoDismissRunnable$p(Balloon $this) {
        return $this.getAutoDismissRunnable();
    }

    public static final /* synthetic */ void access$stopBalloonHighlightAnimation(Balloon $this) {
        $this.stopBalloonHighlightAnimation();
    }

    @BalloonInlineDsl
    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u008a\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\\\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b)\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010}\u001a\u00020~J\u0014\u0010m\u001a\u00020\u00002\f\u0010\u007f\u001a\b\u0012\u0004\u0012\u00020l0kJ\u0010\u0010m\u001a\u00020\u00002\b\u0010\u0080\u0001\u001a\u00030\u0081\u0001J\u0012\u0010\u0082\u0001\u001a\u00020\u00002\t\b\u0001\u0010\u0083\u0001\u001a\u00020\u0006J\u0012\u0010\u0084\u0001\u001a\u00020\u00002\t\b\u0001\u0010\u0083\u0001\u001a\u00020\bJ\u0010\u0010\u0085\u0001\u001a\u00020\u00002\u0007\u0010\u0083\u0001\u001a\u00020\u0006J\u0012\u0010\u0086\u0001\u001a\u00020\u00002\t\b\u0001\u0010\u0083\u0001\u001a\u00020\bJ\u0012\u0010\u0087\u0001\u001a\u00020\u00002\t\b\u0001\u0010\u0083\u0001\u001a\u00020\bJ\u0012\u0010\u0088\u0001\u001a\u00020\u00002\t\b\u0001\u0010\u0083\u0001\u001a\u00020\bJ\u0012\u0010\u0089\u0001\u001a\u00020\u00002\t\b\u0001\u0010\u0083\u0001\u001a\u00020\bJ\u0010\u0010\u008a\u0001\u001a\u00020\u00002\u0007\u0010\u0083\u0001\u001a\u00020\rJ\u0012\u0010\u008b\u0001\u001a\u00020\u00002\t\b\u0001\u0010\u0083\u0001\u001a\u00020\bJ\u0012\u0010\u008c\u0001\u001a\u00020\u00002\t\u0010\u0083\u0001\u001a\u0004\u0018\u00010\u000fJ\u0012\u0010\u008d\u0001\u001a\u00020\u00002\t\b\u0001\u0010\u0083\u0001\u001a\u00020\bJ\u0014\u0010\u008e\u0001\u001a\u00020\u00002\t\b\u0001\u0010\u0083\u0001\u001a\u00020\bH\u0007J\u0014\u0010\u008f\u0001\u001a\u00020\u00002\t\b\u0001\u0010\u0083\u0001\u001a\u00020\bH\u0007J\u0012\u0010\u0090\u0001\u001a\u00020\u00002\t\b\u0001\u0010\u0083\u0001\u001a\u00020\bJ\u0012\u0010\u0091\u0001\u001a\u00020\u00002\t\b\u0001\u0010\u0083\u0001\u001a\u00020\bJ\u0010\u0010\u0092\u0001\u001a\u00020\u00002\u0007\u0010\u0083\u0001\u001a\u00020\u0013J\u0010\u0010\u0093\u0001\u001a\u00020\u00002\u0007\u0010\u0083\u0001\u001a\u00020\u0015J\u0012\u0010\u0094\u0001\u001a\u00020\u00002\t\b\u0001\u0010\u0083\u0001\u001a\u00020\u0006J\u0010\u0010\u0095\u0001\u001a\u00020\u00002\u0007\u0010\u0083\u0001\u001a\u00020\u0018J\u0012\u0010\u0096\u0001\u001a\u00020\u00002\t\b\u0001\u0010\u0083\u0001\u001a\u00020\bJ\u0012\u0010\u0097\u0001\u001a\u00020\u00002\t\b\u0001\u0010\u0083\u0001\u001a\u00020\bJ\u0012\u0010\u0098\u0001\u001a\u00020\u00002\t\b\u0001\u0010\u0083\u0001\u001a\u00020\bJ\u0012\u0010\u0099\u0001\u001a\u00020\u00002\t\b\u0001\u0010\u0083\u0001\u001a\u00020\bJ\u0012\u0010\u009a\u0001\u001a\u00020\u00002\t\b\u0001\u0010\u0083\u0001\u001a\u00020\bJ\u0012\u0010\u009b\u0001\u001a\u00020\u00002\t\b\u0001\u0010\u0083\u0001\u001a\u00020\bJ\u0010\u0010\u009c\u0001\u001a\u00020\u00002\u0007\u0010\u0083\u0001\u001a\u00020\u001dJ\u0012\u0010\u009d\u0001\u001a\u00020\u00002\t\b\u0001\u0010\u0083\u0001\u001a\u00020\bJ\u0012\u0010\u009e\u0001\u001a\u00020\u00002\t\b\u0001\u0010\u0083\u0001\u001a\u00020\bJ\u0012\u0010\u009f\u0001\u001a\u00020\u00002\t\u0010\u0083\u0001\u001a\u0004\u0018\u00010\u000fJ\u0012\u0010\u00a0\u0001\u001a\u00020\u00002\t\b\u0001\u0010\u0083\u0001\u001a\u00020\bJ\u0010\u0010\u00a1\u0001\u001a\u00020\u00002\u0007\u0010\u0083\u0001\u001a\u00020!J\u0012\u0010\u00a2\u0001\u001a\u00020\u00002\t\b\u0001\u0010\u0083\u0001\u001a\u00020\bJ\u001b\u0010\u00a3\u0001\u001a\u00020\u00002\u0007\u0010\u0083\u0001\u001a\u00020$2\t\b\u0002\u0010\u00a4\u0001\u001a\u00020\u001dJ\u001d\u0010\u00a5\u0001\u001a\u00020\u00002\t\b\u0001\u0010\u0083\u0001\u001a\u00020\b2\t\b\u0002\u0010\u00a4\u0001\u001a\u00020\u001dJ\u0010\u0010\u00a6\u0001\u001a\u00020\u00002\u0007\u0010\u0083\u0001\u001a\u00020(J\u0012\u0010\u00a7\u0001\u001a\u00020\u00002\t\b\u0001\u0010\u0083\u0001\u001a\u00020\bJ\u0010\u0010\u00a8\u0001\u001a\u00020\u00002\u0007\u0010\u0083\u0001\u001a\u00020\u001dJ\u0012\u0010\u00a9\u0001\u001a\u00020\u00002\t\b\u0001\u0010\u0083\u0001\u001a\u00020\u0006J\u0012\u0010\u00aa\u0001\u001a\u00020\u00002\t\b\u0001\u0010\u0083\u0001\u001a\u00020\bJ\u0010\u0010\u00ab\u0001\u001a\u00020\u00002\u0007\u0010\u0083\u0001\u001a\u00020\rJ\u0010\u0010\u00ac\u0001\u001a\u00020\u00002\u0007\u0010\u0083\u0001\u001a\u00020\rJ\u0010\u0010\u00ad\u0001\u001a\u00020\u00002\u0007\u0010\u0083\u0001\u001a\u00020\rJ\u0010\u0010\u00ae\u0001\u001a\u00020\u00002\u0007\u0010\u0083\u0001\u001a\u00020\rJ\u0010\u0010\u00af\u0001\u001a\u00020\u00002\u0007\u0010\u0083\u0001\u001a\u00020\rJ\u0014\u0010\u00b0\u0001\u001a\u00020\u00002\t\b\u0001\u0010\u0083\u0001\u001a\u00020\bH\u0007J\u0014\u0010\u00b1\u0001\u001a\u00020\u00002\t\b\u0001\u0010\u0083\u0001\u001a\u00020\bH\u0007J\u0010\u0010\u00b2\u0001\u001a\u00020\u00002\u0007\u0010\u0083\u0001\u001a\u00020\rJ\u0012\u0010\u00b3\u0001\u001a\u00020\u00002\t\b\u0001\u0010\u0083\u0001\u001a\u00020\bJ\u0012\u0010\u00b4\u0001\u001a\u00020\u00002\t\b\u0001\u0010\u0083\u0001\u001a\u00020\bJ\u0012\u0010\u00b5\u0001\u001a\u00020\u00002\t\b\u0001\u0010\u0083\u0001\u001a\u00020\bJ\u0012\u0010\u00b6\u0001\u001a\u00020\u00002\t\b\u0001\u0010\u0083\u0001\u001a\u00020\bJ\u0012\u0010\u00b7\u0001\u001a\u00020\u00002\t\u0010\u0083\u0001\u001a\u0004\u0018\u00010\u000fJ\u0012\u0010\u00b8\u0001\u001a\u00020\u00002\t\b\u0001\u0010\u0083\u0001\u001a\u00020\bJ\u0010\u0010\u00b9\u0001\u001a\u00020\u00002\u0007\u0010\u0083\u0001\u001a\u000206J\u0010\u0010\u00ba\u0001\u001a\u00020\u00002\u0007\u0010\u0083\u0001\u001a\u000208J\u0012\u0010\u00bb\u0001\u001a\u00020\u00002\t\b\u0001\u0010\u0083\u0001\u001a\u00020\bJ\u0012\u0010\u00bc\u0001\u001a\u00020\u00002\t\b\u0001\u0010\u0083\u0001\u001a\u00020\bJ\u0012\u0010\u00bd\u0001\u001a\u00020\u00002\t\b\u0001\u0010\u0083\u0001\u001a\u00020\bJ\u0012\u0010\u00be\u0001\u001a\u00020\u00002\t\b\u0001\u0010\u0083\u0001\u001a\u00020\bJ\u0012\u0010\u00bf\u0001\u001a\u00020\u00002\t\b\u0001\u0010\u0083\u0001\u001a\u00020\bJ\u0012\u0010\u00c0\u0001\u001a\u00020\u00002\t\b\u0001\u0010\u0083\u0001\u001a\u00020\bJ\u0012\u0010\u00c1\u0001\u001a\u00020\u00002\t\b\u0001\u0010\u0083\u0001\u001a\u00020\bJ\u0012\u0010\u00c2\u0001\u001a\u00020\u00002\t\b\u0001\u0010\u0083\u0001\u001a\u00020\bJ\u0010\u0010\u00c3\u0001\u001a\u00020\u00002\u0007\u0010\u0083\u0001\u001a\u00020\rJ\u0010\u0010\u00c4\u0001\u001a\u00020\u00002\u0007\u0010\u0083\u0001\u001a\u00020\rJ\u0010\u0010\u00c5\u0001\u001a\u00020\u00002\u0007\u0010\u0083\u0001\u001a\u00020\rJ\u000f\u0010\u00c6\u0001\u001a\u00020\u00002\u0006\u0010C\u001a\u00020BJ\u0011\u0010\u00c6\u0001\u001a\u00020\u00002\b\b\u0001\u0010D\u001a\u00020\bJ\u0012\u0010\u00c7\u0001\u001a\u00020\u00002\t\u0010\u0083\u0001\u001a\u0004\u0018\u00010FJ\u0012\u0010\u00c8\u0001\u001a\u00020\u00002\t\b\u0001\u0010\u0083\u0001\u001a\u00020\bJ\u0012\u0010\u00c9\u0001\u001a\u00020\u00002\t\b\u0001\u0010\u0083\u0001\u001a\u00020\bJ\u0012\u0010\u00ca\u0001\u001a\u00020\u00002\t\b\u0001\u0010\u0083\u0001\u001a\u00020\bJ\u0012\u0010\u00cb\u0001\u001a\u00020\u00002\t\b\u0001\u0010\u0083\u0001\u001a\u00020\bJ\u0012\u0010\u00cc\u0001\u001a\u00020\u00002\t\b\u0001\u0010\u0083\u0001\u001a\u00020\bJ\u0012\u0010\u00cd\u0001\u001a\u00020\u00002\t\b\u0001\u0010\u0083\u0001\u001a\u00020\bJ\u0012\u0010\u00ce\u0001\u001a\u00020\u00002\t\b\u0001\u0010\u0083\u0001\u001a\u00020\bJ\u0012\u0010\u00cf\u0001\u001a\u00020\u00002\t\b\u0001\u0010\u0083\u0001\u001a\u00020\bJ\u0012\u0010\u00d0\u0001\u001a\u00020\u00002\t\b\u0001\u0010\u0083\u0001\u001a\u00020\bJ\u0012\u0010\u00d1\u0001\u001a\u00020\u00002\t\b\u0001\u0010\u0083\u0001\u001a\u00020\bJ\u0012\u0010\u00d2\u0001\u001a\u00020\u00002\t\b\u0001\u0010\u0083\u0001\u001a\u00020\bJ\u0012\u0010\u00d3\u0001\u001a\u00020\u00002\t\b\u0001\u0010\u0083\u0001\u001a\u00020\bJ\u0012\u0010\u00d4\u0001\u001a\u00020\u00002\t\b\u0001\u0010\u0083\u0001\u001a\u00020\bJ\u0012\u0010\u00d5\u0001\u001a\u00020\u00002\t\b\u0001\u0010\u0083\u0001\u001a\u00020\bJ\u0012\u0010\u00d6\u0001\u001a\u00020\u00002\t\b\u0001\u0010\u0083\u0001\u001a\u00020\bJ\u0012\u0010\u00d7\u0001\u001a\u00020\u00002\t\b\u0001\u0010\u0083\u0001\u001a\u00020\u0006J\u0012\u0010\u00d8\u0001\u001a\u00020\u00002\t\b\u0001\u0010\u0083\u0001\u001a\u00020\bJ\u0012\u0010\u00d9\u0001\u001a\u00020\u00002\t\b\u0001\u0010\u0083\u0001\u001a\u00020\bJ\u0012\u0010\u00da\u0001\u001a\u00020\u00002\t\b\u0001\u0010\u0083\u0001\u001a\u00020\u0006J\u0012\u0010\u00db\u0001\u001a\u00020\u00002\t\b\u0001\u0010\u0083\u0001\u001a\u00020\bJ\u0010\u0010\u00dc\u0001\u001a\u00020\u00002\u0007\u0010\u0083\u0001\u001a\u00020PJ\u001c\u0010\u00dd\u0001\u001a\u00020\u00002\u0013\u0010\u007f\u001a\u000f\u0012\u0004\u0012\u00020B\u0012\u0004\u0012\u00020l0\u00de\u0001J\u0010\u0010\u00dd\u0001\u001a\u00020\u00002\u0007\u0010\u0083\u0001\u001a\u00020RJ\u0015\u0010\u00df\u0001\u001a\u00020\u00002\f\u0010\u007f\u001a\b\u0012\u0004\u0012\u00020l0kJ\u0010\u0010\u00df\u0001\u001a\u00020\u00002\u0007\u0010\u0083\u0001\u001a\u00020TJ\u001c\u0010\u00e0\u0001\u001a\u00020\u00002\u0013\u0010\u007f\u001a\u000f\u0012\u0004\u0012\u00020B\u0012\u0004\u0012\u00020l0\u00de\u0001J\u0010\u0010\u00e0\u0001\u001a\u00020\u00002\u0007\u0010\u0083\u0001\u001a\u00020VJ#\u0010\u00e1\u0001\u001a\u00020\u00002\u001a\u0010\u007f\u001a\u0016\u0012\u0004\u0012\u00020B\u0012\u0005\u0012\u00030\u00e3\u0001\u0012\u0004\u0012\u00020l0\u00e2\u0001J\u0010\u0010\u00e1\u0001\u001a\u00020\u00002\u0007\u0010\u0083\u0001\u001a\u00020XJ\u0015\u0010\u00e4\u0001\u001a\u00020\u00002\f\u0010\u007f\u001a\b\u0012\u0004\u0012\u00020l0kJ\u0010\u0010\u00e4\u0001\u001a\u00020\u00002\u0007\u0010\u0083\u0001\u001a\u00020ZJ\u0010\u0010\u00e5\u0001\u001a\u00020\u00002\u0007\u0010\u0083\u0001\u001a\u00020\\J\u0010\u0010\u00e6\u0001\u001a\u00020\u00002\u0007\u0010\u0083\u0001\u001a\u00020\\J\u0012\u0010\u00e7\u0001\u001a\u00020\u00002\t\b\u0001\u0010\u0083\u0001\u001a\u00020\bJ\u0012\u0010\u00e8\u0001\u001a\u00020\u00002\t\b\u0001\u0010\u0083\u0001\u001a\u00020\bJ\u0012\u0010\u00e9\u0001\u001a\u00020\u00002\t\b\u0001\u0010\u0083\u0001\u001a\u00020\u0006J\u0012\u0010\u00ea\u0001\u001a\u00020\u00002\t\b\u0001\u0010\u0083\u0001\u001a\u00020\bJ\u0010\u0010\u00eb\u0001\u001a\u00020\u00002\u0007\u0010\u0083\u0001\u001a\u00020aJ\u0010\u0010\u00ec\u0001\u001a\u00020\u00002\u0007\u0010\u0083\u0001\u001a\u00020cJ\u0012\u0010\u00ed\u0001\u001a\u00020\u00002\t\b\u0001\u0010\u0083\u0001\u001a\u00020\bJ\u0012\u0010\u00ee\u0001\u001a\u00020\u00002\t\b\u0001\u0010\u0083\u0001\u001a\u00020\bJ\u0012\u0010\u00ef\u0001\u001a\u00020\u00002\t\b\u0001\u0010\u0083\u0001\u001a\u00020\bJ\u0012\u0010\u00f0\u0001\u001a\u00020\u00002\t\b\u0001\u0010\u0083\u0001\u001a\u00020\bJ\u0012\u0010\u00f1\u0001\u001a\u00020\u00002\t\b\u0001\u0010\u0083\u0001\u001a\u00020\bJ\u0012\u0010\u00f2\u0001\u001a\u00020\u00002\t\b\u0001\u0010\u0083\u0001\u001a\u00020\bJ\u0012\u0010\u00f3\u0001\u001a\u00020\u00002\t\b\u0001\u0010\u0083\u0001\u001a\u00020\bJ\u0012\u0010\u00f4\u0001\u001a\u00020\u00002\t\b\u0001\u0010\u0083\u0001\u001a\u00020\bJ\u0012\u0010\u00f5\u0001\u001a\u00020\u00002\t\b\u0001\u0010\u0083\u0001\u001a\u00020\bJ\u0012\u0010\u00f6\u0001\u001a\u00020\u00002\t\b\u0001\u0010\u0083\u0001\u001a\u00020\bJ\u0012\u0010\u00f7\u0001\u001a\u00020\u00002\t\b\u0001\u0010\u0083\u0001\u001a\u00020\bJ\u0012\u0010\u00f8\u0001\u001a\u00020\u00002\t\b\u0001\u0010\u0083\u0001\u001a\u00020\bJ\u0012\u0010\u00f9\u0001\u001a\u00020\u00002\t\b\u0001\u0010\u0083\u0001\u001a\u00020\bJ\u0012\u0010\u00fa\u0001\u001a\u00020\u00002\t\b\u0001\u0010\u0083\u0001\u001a\u00020\bJ\u0010\u0010\u00fb\u0001\u001a\u00020\u00002\u0007\u0010\u0083\u0001\u001a\u00020iJ\u0010\u0010\u00fc\u0001\u001a\u00020\u00002\u0007\u0010\u0083\u0001\u001a\u00020\bJ\u001b\u0010\u00fd\u0001\u001a\u00020\u00002\b\b\u0001\u0010{\u001a\u00020\b2\b\b\u0001\u00103\u001a\u00020\bJ\u001b\u0010\u00fe\u0001\u001a\u00020\u00002\b\b\u0001\u0010{\u001a\u00020\b2\b\b\u0001\u00103\u001a\u00020\bJ\u0010\u0010\u00ff\u0001\u001a\u00020\u00002\u0007\u0010\u0083\u0001\u001a\u00020pJ\u0012\u0010\u0080\u0002\u001a\u00020\u00002\t\b\u0001\u0010\u0083\u0001\u001a\u00020\bJ\u0012\u0010\u0081\u0002\u001a\u00020\u00002\t\b\u0001\u0010\u0083\u0001\u001a\u00020\bJ\u0010\u0010\u0082\u0002\u001a\u00020\u00002\u0007\u0010\u0083\u0001\u001a\u00020sJ\u0010\u0010\u0083\u0002\u001a\u00020\u00002\u0007\u0010\u0083\u0001\u001a\u00020\bJ\u0010\u0010\u0084\u0002\u001a\u00020\u00002\u0007\u0010\u0083\u0001\u001a\u00020\rJ\u0012\u0010\u0085\u0002\u001a\u00020\u00002\t\b\u0001\u0010\u0083\u0001\u001a\u00020\bJ\u0012\u0010\u0086\u0002\u001a\u00020\u00002\t\b\u0001\u0010\u0083\u0001\u001a\u00020\u0006J\u0012\u0010\u0087\u0002\u001a\u00020\u00002\t\b\u0001\u0010\u0083\u0001\u001a\u00020\bJ\u0010\u0010\u0088\u0002\u001a\u00020\u00002\u0007\u0010\u0083\u0001\u001a\u00020yJ\u0010\u0010\u0088\u0002\u001a\u00020\u00002\u0007\u0010\u0083\u0001\u001a\u00020\bJ\u0012\u0010\u0089\u0002\u001a\u00020\u00002\t\b\u0001\u0010\u0083\u0001\u001a\u00020\bJ\u0012\u0010\u008a\u0002\u001a\u00020\u00002\t\b\u0001\u0010\u0083\u0001\u001a\u00020\u0006J\u0012\u0010\u008b\u0002\u001a\u00020\u00002\t\b\u0001\u0010\u0083\u0001\u001a\u00020\bR\u001a\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00068\u0006@FX\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\b8\u0006@FX\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00068\u0006@FX\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\b8\u0006@FX\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\b8\u0006@FX\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\r8\u0006@FX\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0005\u001a\u0004\u0018\u00010\u000f8\u0006@FX\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00068\u0006@FX\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\b8\u0006@FX\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0005\u001a\u00020\u00138\u0006@FX\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0005\u001a\u00020\u00158\u0006@FX\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00068\u0006@FX\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0005\u001a\u00020\u00188\u0006@FX\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001a\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\b8\u0006@FX\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001b\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\b8\u0006@FX\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001c\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\b8\u0006@FX\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u0005\u001a\u00020\u001d8\u0006@FX\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001f\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\b8\u0006@FX\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010 \u001a\u0004\u0018\u00010\u000f2\b\u0010\u0005\u001a\u0004\u0018\u00010\u000f8\u0006@FX\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\"\u001a\u00020!2\u0006\u0010\u0005\u001a\u00020!8\u0006@FX\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010#\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\b8\u0006@FX\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010%\u001a\u00020$2\u0006\u0010\u0005\u001a\u00020$8\u0006@FX\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010&\u001a\u00020\u001d2\u0006\u0010\u0005\u001a\u00020\u001d8\u0006@FX\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010'\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\b8\u0006@FX\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010)\u001a\u00020(2\u0006\u0010\u0005\u001a\u00020(8\u0006@FX\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010*\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\b8\u0006@FX\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010+\u001a\u00020\u001d2\u0006\u0010\u0005\u001a\u00020\u001d8\u0006@FX\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010,\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00068\u0006@FX\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010-\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\r8\u0006@FX\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010.\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\r8\u0006@FX\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010/\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\r8\u0006@FX\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u00100\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\r8\u0006@FX\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u00101\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\r8\u0006@FX\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u00102\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00068\u0006@FX\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u00103\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\b8\u0006@FX\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u00104\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\b8\u0006@FX\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u00105\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0005\u001a\u0004\u0018\u00010\u000f8\u0006@FX\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u00107\u001a\u0004\u0018\u0001062\b\u0010\u0005\u001a\u0004\u0018\u0001068\u0006@FX\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u00109\u001a\u0002082\u0006\u0010\u0005\u001a\u0002088\u0006@FX\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010:\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\b8\u0006@FX\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010;\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\b8\u0006@FX\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010<\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\b8\u0006@FX\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010=\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\r8\u0006@FX\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010>\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\r8\u0006@FX\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010?\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\r8\u0006@FX\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010@\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\r8\u0006@FX\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010A\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\r8\u0006@FX\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010C\u001a\u0004\u0018\u00010B2\b\u0010\u0005\u001a\u0004\u0018\u00010B8\u0006@FX\u0087\u000e\u00a2\u0006\u0002\n\u0000R \u0010D\u001a\u0004\u0018\u00010\b2\b\u0010\u0005\u001a\u0004\u0018\u00010\b8\u0006@FX\u0087\u000e\u00a2\u0006\u0004\n\u0002\u0010ER\u001e\u0010G\u001a\u0004\u0018\u00010F2\b\u0010\u0005\u001a\u0004\u0018\u00010F8\u0006@FX\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010H\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\b8\u0006@FX\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010I\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\b8\u0006@FX\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010J\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\b8\u0006@FX\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010K\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\b8\u0006@FX\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010L\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\b8\u0006@FX\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010M\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00068\u0006@FX\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010N\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\b8\u0006@FX\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010O\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00068\u0006@FX\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010Q\u001a\u0004\u0018\u00010P2\b\u0010\u0005\u001a\u0004\u0018\u00010P8\u0006@FX\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010S\u001a\u0004\u0018\u00010R2\b\u0010\u0005\u001a\u0004\u0018\u00010R8\u0006@FX\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010U\u001a\u0004\u0018\u00010T2\b\u0010\u0005\u001a\u0004\u0018\u00010T8\u0006@FX\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010W\u001a\u0004\u0018\u00010V2\b\u0010\u0005\u001a\u0004\u0018\u00010V8\u0006@FX\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010Y\u001a\u0004\u0018\u00010X2\b\u0010\u0005\u001a\u0004\u0018\u00010X8\u0006@FX\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010[\u001a\u0004\u0018\u00010Z2\b\u0010\u0005\u001a\u0004\u0018\u00010Z8\u0006@FX\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010]\u001a\u0004\u0018\u00010\\2\b\u0010\u0005\u001a\u0004\u0018\u00010\\8\u0006@FX\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010^\u001a\u0004\u0018\u00010\\2\b\u0010\u0005\u001a\u0004\u0018\u00010\\8\u0006@FX\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010_\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\b8\u0006@FX\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010`\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00068\u0006@FX\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010b\u001a\u0004\u0018\u00010a2\b\u0010\u0005\u001a\u0004\u0018\u00010a8\u0006@FX\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010d\u001a\u00020c2\u0006\u0010\u0005\u001a\u00020c8\u0006@FX\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010e\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\b8\u0006@FX\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010f\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\b8\u0006@FX\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010g\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\b8\u0006@FX\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010h\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\b8\u0006@FX\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010j\u001a\u0004\u0018\u00010i2\b\u0010\u0005\u001a\u0004\u0018\u00010i8\u0006@FX\u0087\u000e\u00a2\u0006\u0002\n\u0000R*\u0010m\u001a\n\u0012\u0004\u0012\u00020l\u0018\u00010k2\u000e\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020l\u0018\u00010k8\u0006@FX\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010n\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\b8\u0006@FX\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010o\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\b8\u0006@FX\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010q\u001a\u00020p2\u0006\u0010\u0005\u001a\u00020p8\u0006@FX\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010r\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\b8\u0006@FX\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010t\u001a\u0004\u0018\u00010s2\b\u0010\u0005\u001a\u0004\u0018\u00010s8\u0006@FX\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010u\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\b8\u0006@FX\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010v\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\r8\u0006@FX\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010w\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00068\u0006@FX\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010x\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\b8\u0006@FX\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010z\u001a\u0004\u0018\u00010y2\b\u0010\u0005\u001a\u0004\u0018\u00010y8\u0006@FX\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010{\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\b8\u0006@FX\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010|\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00068\u0006@FX\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u008c\u0002"}, d2={"Lcom/skydoves/balloon/Balloon$Builder;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "<set-?>", "", "alpha", "", "arrowAlignAnchorPadding", "arrowAlignAnchorPaddingRatio", "arrowBottomPadding", "arrowColor", "", "arrowColorMatchBalloon", "Landroid/graphics/drawable/Drawable;", "arrowDrawable", "arrowElevation", "arrowLeftPadding", "Lcom/skydoves/balloon/ArrowOrientation;", "arrowOrientation", "Lcom/skydoves/balloon/ArrowOrientationRules;", "arrowOrientationRules", "arrowPosition", "Lcom/skydoves/balloon/ArrowPositionRules;", "arrowPositionRules", "arrowRightPadding", "arrowSize", "arrowTopPadding", "", "autoDismissDuration", "backgroundColor", "backgroundDrawable", "Lcom/skydoves/balloon/BalloonAnimation;", "balloonAnimation", "balloonAnimationStyle", "Lcom/skydoves/balloon/BalloonHighlightAnimation;", "balloonHighlightAnimation", "balloonHighlightAnimationStartDelay", "balloonHighlightAnimationStyle", "Lcom/skydoves/balloon/overlay/BalloonOverlayAnimation;", "balloonOverlayAnimation", "balloonOverlayAnimationStyle", "circularDuration", "cornerRadius", "dismissWhenClicked", "dismissWhenLifecycleOnPause", "dismissWhenOverlayClicked", "dismissWhenShowAgain", "dismissWhenTouchOutside", "elevation", "height", "iconColor", "iconDrawable", "Lcom/skydoves/balloon/IconForm;", "iconForm", "Lcom/skydoves/balloon/IconGravity;", "iconGravity", "iconHeight", "iconSpace", "iconWidth", "isFocusable", "isRtlLayout", "isStatusBarVisible", "isVisibleArrow", "isVisibleOverlay", "Landroid/view/View;", "layout", "layoutRes", "Ljava/lang/Integer;", "Landroidx/lifecycle/LifecycleOwner;", "lifecycleOwner", "marginBottom", "marginLeft", "marginRight", "marginTop", "maxWidth", "maxWidthRatio", "minWidth", "minWidthRatio", "Landroid/text/method/MovementMethod;", "movementMethod", "Lcom/skydoves/balloon/OnBalloonClickListener;", "onBalloonClickListener", "Lcom/skydoves/balloon/OnBalloonDismissListener;", "onBalloonDismissListener", "Lcom/skydoves/balloon/OnBalloonInitializedListener;", "onBalloonInitializedListener", "Lcom/skydoves/balloon/OnBalloonOutsideTouchListener;", "onBalloonOutsideTouchListener", "Lcom/skydoves/balloon/OnBalloonOverlayClickListener;", "onBalloonOverlayClickListener", "Landroid/view/View$OnTouchListener;", "onBalloonOverlayTouchListener", "onBalloonTouchListener", "overlayColor", "overlayPadding", "Landroid/graphics/Point;", "overlayPosition", "Lcom/skydoves/balloon/overlay/BalloonOverlayShape;", "overlayShape", "paddingBottom", "paddingLeft", "paddingRight", "paddingTop", "", "preferenceName", "Lkotlin/Function0;", "", "runIfReachedShowCounts", "showTimes", "supportRtlLayoutFactor", "", "text", "textColor", "Lcom/skydoves/balloon/TextForm;", "textForm", "textGravity", "textIsHtml", "textSize", "textTypeface", "Landroid/graphics/Typeface;", "textTypefaceObject", "width", "widthRatio", "build", "Lcom/skydoves/balloon/Balloon;", "block", "runnable", "Ljava/lang/Runnable;", "setAlpha", "value", "setArrowAlignAnchorPadding", "setArrowAlignAnchorPaddingRatio", "setArrowAlignAnchorPaddingResource", "setArrowBottomPadding", "setArrowBottomPaddingResource", "setArrowColor", "setArrowColorMatchBalloon", "setArrowColorResource", "setArrowDrawable", "setArrowDrawableResource", "setArrowElevation", "setArrowElevationResource", "setArrowLeftPadding", "setArrowLeftPaddingResource", "setArrowOrientation", "setArrowOrientationRules", "setArrowPosition", "setArrowPositionRules", "setArrowRightPadding", "setArrowRightPaddingResource", "setArrowSize", "setArrowSizeResource", "setArrowTopPadding", "setArrowTopPaddingResource", "setAutoDismissDuration", "setBackgroundColor", "setBackgroundColorResource", "setBackgroundDrawable", "setBackgroundDrawableResource", "setBalloonAnimation", "setBalloonAnimationStyle", "setBalloonHighlightAnimation", "startDelay", "setBalloonHighlightAnimationResource", "setBalloonOverlayAnimation", "setBalloonOverlayAnimationStyle", "setCircularDuration", "setCornerRadius", "setCornerRadiusResource", "setDismissWhenClicked", "setDismissWhenLifecycleOnPause", "setDismissWhenOverlayClicked", "setDismissWhenShowAgain", "setDismissWhenTouchOutside", "setElevation", "setElevationResource", "setFocusable", "setHeight", "setHeightResource", "setIconColor", "setIconColorResource", "setIconDrawable", "setIconDrawableResource", "setIconForm", "setIconGravity", "setIconHeight", "setIconHeightResource", "setIconSize", "setIconSizeResource", "setIconSpace", "setIconSpaceResource", "setIconWidth", "setIconWidthResource", "setIsStatusBarVisible", "setIsVisibleArrow", "setIsVisibleOverlay", "setLayout", "setLifecycleOwner", "setMargin", "setMarginBottom", "setMarginBottomResource", "setMarginHorizontal", "setMarginHorizontalResource", "setMarginLeft", "setMarginLeftResource", "setMarginResource", "setMarginRight", "setMarginRightResource", "setMarginTop", "setMarginTopResource", "setMarginVertical", "setMarginVerticalResource", "setMaxWidth", "setMaxWidthRatio", "setMaxWidthResource", "setMinWidth", "setMinWidthRatio", "setMinWidthResource", "setMovementMethod", "setOnBalloonClickListener", "Lkotlin/Function1;", "setOnBalloonDismissListener", "setOnBalloonInitializedListener", "setOnBalloonOutsideTouchListener", "Lkotlin/Function2;", "Landroid/view/MotionEvent;", "setOnBalloonOverlayClickListener", "setOnBalloonOverlayTouchListener", "setOnBalloonTouchListener", "setOverlayColor", "setOverlayColorResource", "setOverlayPadding", "setOverlayPaddingResource", "setOverlayPosition", "setOverlayShape", "setPadding", "setPaddingBottom", "setPaddingBottomResource", "setPaddingHorizontal", "setPaddingHorizontalResource", "setPaddingLeft", "setPaddingLeftResource", "setPaddingResource", "setPaddingRight", "setPaddingRightResource", "setPaddingTop", "setPaddingTopResource", "setPaddingVertical", "setPaddingVerticalResource", "setPreferenceName", "setShowCounts", "setSize", "setSizeResource", "setText", "setTextColor", "setTextColorResource", "setTextForm", "setTextGravity", "setTextIsHtml", "setTextResource", "setTextSize", "setTextSizeResource", "setTextTypeface", "setWidth", "setWidthRatio", "setWidthResource", "balloon_release"})
    public static final class Builder {
        @JvmField
        @Px
        public int width;
        @JvmField
        @Px
        public int minWidth;
        @JvmField
        @Px
        public int maxWidth;
        @JvmField
        @FloatRange(from=0.0, to=1.0)
        public float widthRatio;
        @JvmField
        @FloatRange(from=0.0, to=1.0)
        public float minWidthRatio;
        @JvmField
        @FloatRange(from=0.0, to=1.0)
        public float maxWidthRatio;
        @JvmField
        @Px
        public int height;
        @JvmField
        @Px
        public int paddingLeft;
        @JvmField
        @Px
        public int paddingTop;
        @JvmField
        @Px
        public int paddingRight;
        @JvmField
        @Px
        public int paddingBottom;
        @JvmField
        @Px
        public int marginRight;
        @JvmField
        @Px
        public int marginLeft;
        @JvmField
        @Px
        public int marginTop;
        @JvmField
        @Px
        public int marginBottom;
        @JvmField
        public boolean isVisibleArrow;
        @JvmField
        @ColorInt
        public int arrowColor;
        @JvmField
        public boolean arrowColorMatchBalloon;
        @JvmField
        @Px
        public int arrowSize;
        @JvmField
        @FloatRange(from=0.0, to=1.0)
        public float arrowPosition;
        @JvmField
        @NotNull
        public ArrowPositionRules arrowPositionRules;
        @JvmField
        @NotNull
        public ArrowOrientationRules arrowOrientationRules;
        @JvmField
        @NotNull
        public ArrowOrientation arrowOrientation;
        @JvmField
        @Nullable
        public Drawable arrowDrawable;
        @JvmField
        public int arrowLeftPadding;
        @JvmField
        public int arrowRightPadding;
        @JvmField
        public int arrowTopPadding;
        @JvmField
        public int arrowBottomPadding;
        @JvmField
        public int arrowAlignAnchorPadding;
        @JvmField
        public float arrowAlignAnchorPaddingRatio;
        @JvmField
        public float arrowElevation;
        @JvmField
        @ColorInt
        public int backgroundColor;
        @JvmField
        @Nullable
        public Drawable backgroundDrawable;
        @JvmField
        @Px
        public float cornerRadius;
        @JvmField
        @NotNull
        public CharSequence text;
        @JvmField
        @ColorInt
        public int textColor;
        @JvmField
        public boolean textIsHtml;
        @JvmField
        @Nullable
        public MovementMethod movementMethod;
        @JvmField
        @Sp
        public float textSize;
        @JvmField
        public int textTypeface;
        @JvmField
        @Nullable
        public Typeface textTypefaceObject;
        @JvmField
        public int textGravity;
        @JvmField
        @Nullable
        public TextForm textForm;
        @JvmField
        @Nullable
        public Drawable iconDrawable;
        @JvmField
        @NotNull
        public IconGravity iconGravity;
        @JvmField
        @Px
        public int iconWidth;
        @JvmField
        @Px
        public int iconHeight;
        @JvmField
        @Px
        public int iconSpace;
        @JvmField
        @ColorInt
        public int iconColor;
        @JvmField
        @Nullable
        public IconForm iconForm;
        @JvmField
        @FloatRange(from=0.0, to=1.0)
        public float alpha;
        @JvmField
        public float elevation;
        @JvmField
        @Nullable
        public View layout;
        @JvmField
        @LayoutRes
        @Nullable
        public Integer layoutRes;
        @JvmField
        public boolean isVisibleOverlay;
        @JvmField
        @ColorInt
        public int overlayColor;
        @JvmField
        @Px
        public float overlayPadding;
        @JvmField
        @Nullable
        public Point overlayPosition;
        @JvmField
        @NotNull
        public BalloonOverlayShape overlayShape;
        @JvmField
        @Nullable
        public OnBalloonClickListener onBalloonClickListener;
        @JvmField
        @Nullable
        public OnBalloonDismissListener onBalloonDismissListener;
        @JvmField
        @Nullable
        public OnBalloonInitializedListener onBalloonInitializedListener;
        @JvmField
        @Nullable
        public OnBalloonOutsideTouchListener onBalloonOutsideTouchListener;
        @JvmField
        @Nullable
        public View.OnTouchListener onBalloonTouchListener;
        @JvmField
        @Nullable
        public View.OnTouchListener onBalloonOverlayTouchListener;
        @JvmField
        @Nullable
        public OnBalloonOverlayClickListener onBalloonOverlayClickListener;
        @JvmField
        public boolean dismissWhenTouchOutside;
        @JvmField
        public boolean dismissWhenShowAgain;
        @JvmField
        public boolean dismissWhenClicked;
        @JvmField
        public boolean dismissWhenOverlayClicked;
        @JvmField
        public boolean dismissWhenLifecycleOnPause;
        @JvmField
        public long autoDismissDuration;
        @JvmField
        @Nullable
        public LifecycleOwner lifecycleOwner;
        @JvmField
        @StyleRes
        public int balloonAnimationStyle;
        @JvmField
        @StyleRes
        public int balloonOverlayAnimationStyle;
        @JvmField
        @NotNull
        public BalloonAnimation balloonAnimation;
        @JvmField
        @NotNull
        public BalloonOverlayAnimation balloonOverlayAnimation;
        @JvmField
        public long circularDuration;
        @JvmField
        @NotNull
        public BalloonHighlightAnimation balloonHighlightAnimation;
        @JvmField
        @StyleRes
        public int balloonHighlightAnimationStyle;
        @JvmField
        public long balloonHighlightAnimationStartDelay;
        @JvmField
        @Nullable
        public String preferenceName;
        @JvmField
        public int showTimes;
        @JvmField
        @Nullable
        public Function0<Unit> runIfReachedShowCounts;
        @JvmField
        public boolean isRtlLayout;
        @JvmField
        public int supportRtlLayoutFactor;
        @JvmField
        public boolean isFocusable;
        @JvmField
        public boolean isStatusBarVisible;
        private final Context context;

        @NotNull
        public final Builder setWidth(@Dp int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            boolean bl4 = value2 > 0 || value2 == Integer.MIN_VALUE;
            boolean bl5 = false;
            boolean bl6 = false;
            if (!bl4) {
                boolean bl7 = false;
                String string = "The width of the balloon must bigger than zero.";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            int $this$dp$iv = value2;
            boolean $i$f$getDp = false;
            float f = $this$dp$iv;
            Resources resources = Resources.getSystem();
            Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"Resources.getSystem()");
            $this$apply.width = MathKt.roundToInt((float)TypedValue.applyDimension((int)1, (float)f, (DisplayMetrics)resources.getDisplayMetrics()));
            return builder;
        }

        @NotNull
        public final Builder setWidthResource(@DimenRes int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.width = ContextExtensionKt.dimenPixel($this$apply.context, value2);
            return builder;
        }

        @NotNull
        public final Builder setMinWidth(@Dp int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            int $this$dp$iv = value2;
            boolean $i$f$getDp = false;
            float f = $this$dp$iv;
            Resources resources = Resources.getSystem();
            Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"Resources.getSystem()");
            $this$apply.minWidth = MathKt.roundToInt((float)TypedValue.applyDimension((int)1, (float)f, (DisplayMetrics)resources.getDisplayMetrics()));
            return builder;
        }

        @NotNull
        public final Builder setMinWidthResource(@DimenRes int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.minWidth = ContextExtensionKt.dimenPixel($this$apply.context, value2);
            return builder;
        }

        @NotNull
        public final Builder setMaxWidth(@Dp int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            int $this$dp$iv = value2;
            boolean $i$f$getDp = false;
            float f = $this$dp$iv;
            Resources resources = Resources.getSystem();
            Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"Resources.getSystem()");
            $this$apply.maxWidth = MathKt.roundToInt((float)TypedValue.applyDimension((int)1, (float)f, (DisplayMetrics)resources.getDisplayMetrics()));
            return builder;
        }

        @NotNull
        public final Builder setMaxWidthResource(@DimenRes int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.maxWidth = ContextExtensionKt.dimenPixel($this$apply.context, value2);
            return builder;
        }

        @NotNull
        public final Builder setWidthRatio(@FloatRange(from=0.0, to=1.0) float value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.widthRatio = value2;
            return builder;
        }

        @NotNull
        public final Builder setMinWidthRatio(@FloatRange(from=0.0, to=1.0) float value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.minWidthRatio = value2;
            return builder;
        }

        @NotNull
        public final Builder setMaxWidthRatio(@FloatRange(from=0.0, to=1.0) float value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.maxWidthRatio = value2;
            return builder;
        }

        @NotNull
        public final Builder setHeight(@Dp int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            boolean bl4 = value2 > 0 || value2 == Integer.MIN_VALUE;
            boolean bl5 = false;
            boolean bl6 = false;
            if (!bl4) {
                boolean bl7 = false;
                String string = "The height of the balloon must bigger than zero.";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            int $this$dp$iv = value2;
            boolean $i$f$getDp = false;
            float f = $this$dp$iv;
            Resources resources = Resources.getSystem();
            Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"Resources.getSystem()");
            $this$apply.height = MathKt.roundToInt((float)TypedValue.applyDimension((int)1, (float)f, (DisplayMetrics)resources.getDisplayMetrics()));
            return builder;
        }

        @NotNull
        public final Builder setHeightResource(@DimenRes int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.height = ContextExtensionKt.dimenPixel($this$apply.context, value2);
            return builder;
        }

        @NotNull
        public final Builder setSize(@Dp int width, @Dp int height) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.setWidth(width);
            $this$apply.setHeight(height);
            return builder;
        }

        @NotNull
        public final Builder setSizeResource(@DimenRes int width, @DimenRes int height) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.setWidthResource(width);
            $this$apply.setHeightResource(height);
            return builder;
        }

        @NotNull
        public final Builder setPadding(@Dp int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.setPaddingLeft(value2);
            $this$apply.setPaddingTop(value2);
            $this$apply.setPaddingRight(value2);
            $this$apply.setPaddingBottom(value2);
            return builder;
        }

        @NotNull
        public final Builder setPaddingResource(@DimenRes int value2) {
            int padding;
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.paddingLeft = padding = ContextExtensionKt.dimenPixel($this$apply.context, value2);
            $this$apply.paddingTop = padding;
            $this$apply.paddingRight = padding;
            $this$apply.paddingBottom = padding;
            return builder;
        }

        @NotNull
        public final Builder setPaddingHorizontal(@Dp int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.setPaddingLeft(value2);
            $this$apply.setPaddingRight(value2);
            return builder;
        }

        @NotNull
        public final Builder setPaddingHorizontalResource(@DimenRes int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.setPaddingLeftResource(value2);
            $this$apply.setPaddingRightResource(value2);
            return builder;
        }

        @NotNull
        public final Builder setPaddingVertical(@Dp int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.setPaddingTop(value2);
            $this$apply.setPaddingBottom(value2);
            return builder;
        }

        @NotNull
        public final Builder setPaddingVerticalResource(@DimenRes int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.setPaddingTopResource(value2);
            $this$apply.setPaddingBottomResource(value2);
            return builder;
        }

        @NotNull
        public final Builder setPaddingLeft(@Dp int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            int $this$dp$iv = value2;
            boolean $i$f$getDp = false;
            float f = $this$dp$iv;
            Resources resources = Resources.getSystem();
            Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"Resources.getSystem()");
            $this$apply.paddingLeft = MathKt.roundToInt((float)TypedValue.applyDimension((int)1, (float)f, (DisplayMetrics)resources.getDisplayMetrics()));
            return builder;
        }

        @NotNull
        public final Builder setPaddingLeftResource(@DimenRes int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.paddingLeft = ContextExtensionKt.dimenPixel($this$apply.context, value2);
            return builder;
        }

        @NotNull
        public final Builder setPaddingTop(@Dp int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            int $this$dp$iv = value2;
            boolean $i$f$getDp = false;
            float f = $this$dp$iv;
            Resources resources = Resources.getSystem();
            Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"Resources.getSystem()");
            $this$apply.paddingTop = MathKt.roundToInt((float)TypedValue.applyDimension((int)1, (float)f, (DisplayMetrics)resources.getDisplayMetrics()));
            return builder;
        }

        @NotNull
        public final Builder setPaddingTopResource(@DimenRes int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.paddingTop = ContextExtensionKt.dimenPixel($this$apply.context, value2);
            return builder;
        }

        @NotNull
        public final Builder setPaddingRight(@Dp int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            int $this$dp$iv = value2;
            boolean $i$f$getDp = false;
            float f = $this$dp$iv;
            Resources resources = Resources.getSystem();
            Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"Resources.getSystem()");
            $this$apply.paddingRight = MathKt.roundToInt((float)TypedValue.applyDimension((int)1, (float)f, (DisplayMetrics)resources.getDisplayMetrics()));
            return builder;
        }

        @NotNull
        public final Builder setPaddingRightResource(@DimenRes int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.paddingRight = ContextExtensionKt.dimenPixel($this$apply.context, value2);
            return builder;
        }

        @NotNull
        public final Builder setPaddingBottom(@Dp int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            int $this$dp$iv = value2;
            boolean $i$f$getDp = false;
            float f = $this$dp$iv;
            Resources resources = Resources.getSystem();
            Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"Resources.getSystem()");
            $this$apply.paddingBottom = MathKt.roundToInt((float)TypedValue.applyDimension((int)1, (float)f, (DisplayMetrics)resources.getDisplayMetrics()));
            return builder;
        }

        @NotNull
        public final Builder setPaddingBottomResource(@DimenRes int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.paddingBottom = ContextExtensionKt.dimenPixel($this$apply.context, value2);
            return builder;
        }

        @NotNull
        public final Builder setMargin(@Dp int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.setMarginLeft(value2);
            $this$apply.setMarginTop(value2);
            $this$apply.setMarginRight(value2);
            $this$apply.setMarginBottom(value2);
            return builder;
        }

        @NotNull
        public final Builder setMarginResource(@DimenRes int value2) {
            int margin;
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.marginLeft = margin = ContextExtensionKt.dimenPixel($this$apply.context, value2);
            $this$apply.marginTop = margin;
            $this$apply.marginRight = margin;
            $this$apply.marginBottom = margin;
            return builder;
        }

        @NotNull
        public final Builder setMarginHorizontal(@Dp int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.setMarginLeft(value2);
            $this$apply.setMarginRight(value2);
            return builder;
        }

        @NotNull
        public final Builder setMarginHorizontalResource(@DimenRes int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.setMarginLeftResource(value2);
            $this$apply.setMarginRightResource(value2);
            return builder;
        }

        @NotNull
        public final Builder setMarginVertical(@Dp int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.setMarginTop(value2);
            $this$apply.setMarginBottom(value2);
            return builder;
        }

        @NotNull
        public final Builder setMarginVerticalResource(@DimenRes int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.setMarginTopResource(value2);
            $this$apply.setMarginBottomResource(value2);
            return builder;
        }

        @NotNull
        public final Builder setMarginLeft(@Dp int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            int $this$dp$iv = value2;
            boolean $i$f$getDp = false;
            float f = $this$dp$iv;
            Resources resources = Resources.getSystem();
            Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"Resources.getSystem()");
            $this$apply.marginLeft = MathKt.roundToInt((float)TypedValue.applyDimension((int)1, (float)f, (DisplayMetrics)resources.getDisplayMetrics()));
            return builder;
        }

        @NotNull
        public final Builder setMarginLeftResource(@DimenRes int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.marginLeft = ContextExtensionKt.dimenPixel($this$apply.context, value2);
            return builder;
        }

        @NotNull
        public final Builder setMarginTop(@Dp int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            int $this$dp$iv = value2;
            boolean $i$f$getDp = false;
            float f = $this$dp$iv;
            Resources resources = Resources.getSystem();
            Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"Resources.getSystem()");
            $this$apply.marginTop = MathKt.roundToInt((float)TypedValue.applyDimension((int)1, (float)f, (DisplayMetrics)resources.getDisplayMetrics()));
            return builder;
        }

        @NotNull
        public final Builder setMarginTopResource(@DimenRes int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.marginTop = ContextExtensionKt.dimenPixel($this$apply.context, value2);
            return builder;
        }

        @NotNull
        public final Builder setMarginRight(@Dp int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            int $this$dp$iv = value2;
            boolean $i$f$getDp = false;
            float f = $this$dp$iv;
            Resources resources = Resources.getSystem();
            Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"Resources.getSystem()");
            $this$apply.marginRight = MathKt.roundToInt((float)TypedValue.applyDimension((int)1, (float)f, (DisplayMetrics)resources.getDisplayMetrics()));
            return builder;
        }

        @NotNull
        public final Builder setMarginRightResource(@DimenRes int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.marginRight = ContextExtensionKt.dimenPixel($this$apply.context, value2);
            return builder;
        }

        @NotNull
        public final Builder setMarginBottom(@Dp int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            int $this$dp$iv = value2;
            boolean $i$f$getDp = false;
            float f = $this$dp$iv;
            Resources resources = Resources.getSystem();
            Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"Resources.getSystem()");
            $this$apply.marginBottom = MathKt.roundToInt((float)TypedValue.applyDimension((int)1, (float)f, (DisplayMetrics)resources.getDisplayMetrics()));
            return builder;
        }

        @NotNull
        public final Builder setMarginBottomResource(@DimenRes int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.marginBottom = ContextExtensionKt.dimenPixel($this$apply.context, value2);
            return builder;
        }

        @NotNull
        public final Builder setIsVisibleArrow(boolean value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.isVisibleArrow = value2;
            return builder;
        }

        @NotNull
        public final Builder setArrowColor(@ColorInt int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.arrowColor = value2;
            return builder;
        }

        @NotNull
        public final Builder setArrowColorMatchBalloon(boolean value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.arrowColorMatchBalloon = value2;
            return builder;
        }

        @NotNull
        public final Builder setArrowColorResource(@ColorRes int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.arrowColor = ContextExtensionKt.contextColor($this$apply.context, value2);
            return builder;
        }

        @NotNull
        public final Builder setArrowSize(@Dp int value2) {
            int n;
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            if (value2 == Integer.MIN_VALUE) {
                n = Integer.MIN_VALUE;
            } else {
                int $this$dp$iv = value2;
                boolean $i$f$getDp = false;
                float f = $this$dp$iv;
                Resources resources = Resources.getSystem();
                Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"Resources.getSystem()");
                n = MathKt.roundToInt((float)TypedValue.applyDimension((int)1, (float)f, (DisplayMetrics)resources.getDisplayMetrics()));
            }
            $this$apply.arrowSize = n;
            return builder;
        }

        @NotNull
        public final Builder setArrowSizeResource(@DimenRes int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.arrowSize = ContextExtensionKt.dimenPixel($this$apply.context, value2);
            return builder;
        }

        @NotNull
        public final Builder setArrowPosition(@FloatRange(from=0.0, to=1.0) float value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.arrowPosition = value2;
            return builder;
        }

        @NotNull
        public final Builder setArrowPositionRules(@NotNull ArrowPositionRules value2) {
            Intrinsics.checkNotNullParameter((Object)((Object)value2), (String)"value");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.arrowPositionRules = value2;
            return builder;
        }

        @NotNull
        public final Builder setArrowOrientation(@NotNull ArrowOrientation value2) {
            Intrinsics.checkNotNullParameter((Object)((Object)value2), (String)"value");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.arrowOrientation = value2;
            return builder;
        }

        @NotNull
        public final Builder setArrowOrientationRules(@NotNull ArrowOrientationRules value2) {
            Intrinsics.checkNotNullParameter((Object)((Object)value2), (String)"value");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.arrowOrientationRules = value2;
            return builder;
        }

        @NotNull
        public final Builder setArrowDrawable(@Nullable Drawable value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            Drawable drawable = value2;
            Object object = $this$apply.arrowDrawable = drawable != null ? drawable.mutate() : null;
            if (value2 != null && $this$apply.arrowSize == Integer.MIN_VALUE) {
                int n = value2.getIntrinsicWidth();
                int n2 = value2.getIntrinsicHeight();
                boolean bl4 = false;
                $this$apply.arrowSize = Math.max(n, n2);
            }
            return builder;
        }

        @NotNull
        public final Builder setArrowDrawableResource(@DrawableRes int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.setArrowDrawable(ContextExtensionKt.contextDrawable($this$apply.context, value2));
            return builder;
        }

        @NotNull
        public final Builder setArrowLeftPadding(@Dp int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            int $this$dp$iv = value2;
            boolean $i$f$getDp = false;
            float f = $this$dp$iv;
            Resources resources = Resources.getSystem();
            Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"Resources.getSystem()");
            $this$apply.arrowLeftPadding = MathKt.roundToInt((float)TypedValue.applyDimension((int)1, (float)f, (DisplayMetrics)resources.getDisplayMetrics()));
            return builder;
        }

        @NotNull
        public final Builder setArrowLeftPaddingResource(@DimenRes int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.arrowLeftPadding = ContextExtensionKt.dimenPixel($this$apply.context, value2);
            return builder;
        }

        @NotNull
        public final Builder setArrowRightPadding(@Dp int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            int $this$dp$iv = value2;
            boolean $i$f$getDp = false;
            float f = $this$dp$iv;
            Resources resources = Resources.getSystem();
            Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"Resources.getSystem()");
            $this$apply.arrowRightPadding = MathKt.roundToInt((float)TypedValue.applyDimension((int)1, (float)f, (DisplayMetrics)resources.getDisplayMetrics()));
            return builder;
        }

        @NotNull
        public final Builder setArrowRightPaddingResource(@DimenRes int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.arrowRightPadding = ContextExtensionKt.dimenPixel($this$apply.context, value2);
            return builder;
        }

        @NotNull
        public final Builder setArrowTopPadding(@Dp int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            int $this$dp$iv = value2;
            boolean $i$f$getDp = false;
            float f = $this$dp$iv;
            Resources resources = Resources.getSystem();
            Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"Resources.getSystem()");
            $this$apply.arrowTopPadding = MathKt.roundToInt((float)TypedValue.applyDimension((int)1, (float)f, (DisplayMetrics)resources.getDisplayMetrics()));
            return builder;
        }

        @NotNull
        public final Builder setArrowTopPaddingResource(@DimenRes int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.arrowTopPadding = ContextExtensionKt.dimenPixel($this$apply.context, value2);
            return builder;
        }

        @NotNull
        public final Builder setArrowBottomPadding(@Dp int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            int $this$dp$iv = value2;
            boolean $i$f$getDp = false;
            float f = $this$dp$iv;
            Resources resources = Resources.getSystem();
            Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"Resources.getSystem()");
            $this$apply.arrowBottomPadding = MathKt.roundToInt((float)TypedValue.applyDimension((int)1, (float)f, (DisplayMetrics)resources.getDisplayMetrics()));
            return builder;
        }

        @NotNull
        public final Builder setArrowBottomPaddingResource(@DimenRes int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.arrowBottomPadding = ContextExtensionKt.dimenPixel($this$apply.context, value2);
            return builder;
        }

        @NotNull
        public final Builder setArrowAlignAnchorPadding(@Dp int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            int $this$dp$iv = value2;
            boolean $i$f$getDp = false;
            float f = $this$dp$iv;
            Resources resources = Resources.getSystem();
            Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"Resources.getSystem()");
            $this$apply.arrowAlignAnchorPadding = MathKt.roundToInt((float)TypedValue.applyDimension((int)1, (float)f, (DisplayMetrics)resources.getDisplayMetrics()));
            return builder;
        }

        @NotNull
        public final Builder setArrowAlignAnchorPaddingResource(@DimenRes int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.arrowAlignAnchorPadding = ContextExtensionKt.dimenPixel($this$apply.context, value2);
            return builder;
        }

        @NotNull
        public final Builder setArrowAlignAnchorPaddingRatio(float value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.arrowAlignAnchorPaddingRatio = value2;
            return builder;
        }

        @TargetApi(value=21)
        @NotNull
        public final Builder setArrowElevation(@Dp int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            int $this$dp$iv = value2;
            boolean $i$f$getDp = false;
            float f = $this$dp$iv;
            Resources resources = Resources.getSystem();
            Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"Resources.getSystem()");
            $this$apply.arrowElevation = MathKt.roundToInt((float)TypedValue.applyDimension((int)1, (float)f, (DisplayMetrics)resources.getDisplayMetrics()));
            return builder;
        }

        @TargetApi(value=21)
        @NotNull
        public final Builder setArrowElevationResource(@DimenRes int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.arrowElevation = ContextExtensionKt.dimen($this$apply.context, value2);
            return builder;
        }

        @NotNull
        public final Builder setBackgroundColor(@ColorInt int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.backgroundColor = value2;
            return builder;
        }

        @NotNull
        public final Builder setBackgroundColorResource(@ColorRes int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.backgroundColor = ContextExtensionKt.contextColor($this$apply.context, value2);
            return builder;
        }

        @NotNull
        public final Builder setBackgroundDrawable(@Nullable Drawable value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            Drawable drawable = value2;
            $this$apply.backgroundDrawable = drawable != null ? drawable.mutate() : null;
            return builder;
        }

        @NotNull
        public final Builder setBackgroundDrawableResource(@DrawableRes int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            Drawable drawable = ContextExtensionKt.contextDrawable($this$apply.context, value2);
            $this$apply.backgroundDrawable = drawable != null ? drawable.mutate() : null;
            return builder;
        }

        @NotNull
        public final Builder setCornerRadius(@Dp float value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            float $this$dp$iv = value2;
            boolean $i$f$getDp = false;
            Resources resources = Resources.getSystem();
            Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"Resources.getSystem()");
            $this$apply.cornerRadius = TypedValue.applyDimension((int)1, (float)$this$dp$iv, (DisplayMetrics)resources.getDisplayMetrics());
            return builder;
        }

        @NotNull
        public final Builder setCornerRadiusResource(@DimenRes int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.cornerRadius = ContextExtensionKt.dimen($this$apply.context, value2);
            return builder;
        }

        @NotNull
        public final Builder setText(@NotNull CharSequence value2) {
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.text = value2;
            return builder;
        }

        @NotNull
        public final Builder setTextResource(@StringRes int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            String string = $this$apply.context.getString(value2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"context.getString(value)");
            $this$apply.text = string;
            return builder;
        }

        @NotNull
        public final Builder setTextColor(@ColorInt int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.textColor = value2;
            return builder;
        }

        @NotNull
        public final Builder setTextColorResource(@ColorRes int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.textColor = ContextExtensionKt.contextColor($this$apply.context, value2);
            return builder;
        }

        @NotNull
        public final Builder setTextIsHtml(boolean value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.textIsHtml = value2;
            return builder;
        }

        @NotNull
        public final Builder setMovementMethod(@NotNull MovementMethod value2) {
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.movementMethod = value2;
            return builder;
        }

        @NotNull
        public final Builder setTextSize(@Sp float value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.textSize = value2;
            return builder;
        }

        @NotNull
        public final Builder setTextSizeResource(@DimenRes int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.textSize = ContextExtensionKt.px2Sp($this$apply.context, ContextExtensionKt.dimen($this$apply.context, value2));
            return builder;
        }

        @NotNull
        public final Builder setTextTypeface(int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.textTypeface = value2;
            return builder;
        }

        @NotNull
        public final Builder setTextTypeface(@NotNull Typeface value2) {
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.textTypefaceObject = value2;
            return builder;
        }

        @NotNull
        public final Builder setTextGravity(int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.textGravity = value2;
            return builder;
        }

        @NotNull
        public final Builder setTextForm(@NotNull TextForm value2) {
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.textForm = value2;
            return builder;
        }

        @NotNull
        public final Builder setIconDrawable(@Nullable Drawable value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            Drawable drawable = value2;
            $this$apply.iconDrawable = drawable != null ? drawable.mutate() : null;
            return builder;
        }

        @NotNull
        public final Builder setIconDrawableResource(@DrawableRes int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            Drawable drawable = ContextExtensionKt.contextDrawable($this$apply.context, value2);
            $this$apply.iconDrawable = drawable != null ? drawable.mutate() : null;
            return builder;
        }

        @NotNull
        public final Builder setIconGravity(@NotNull IconGravity value2) {
            Intrinsics.checkNotNullParameter((Object)((Object)value2), (String)"value");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.iconGravity = value2;
            return builder;
        }

        @NotNull
        public final Builder setIconWidth(@Dp int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            int $this$dp$iv = value2;
            boolean $i$f$getDp = false;
            float f = $this$dp$iv;
            Resources resources = Resources.getSystem();
            Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"Resources.getSystem()");
            $this$apply.iconWidth = MathKt.roundToInt((float)TypedValue.applyDimension((int)1, (float)f, (DisplayMetrics)resources.getDisplayMetrics()));
            return builder;
        }

        @NotNull
        public final Builder setIconWidthResource(@DimenRes int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.iconWidth = ContextExtensionKt.dimenPixel($this$apply.context, value2);
            return builder;
        }

        @NotNull
        public final Builder setIconHeight(@Dp int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            int $this$dp$iv = value2;
            boolean $i$f$getDp = false;
            float f = $this$dp$iv;
            Resources resources = Resources.getSystem();
            Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"Resources.getSystem()");
            $this$apply.iconHeight = MathKt.roundToInt((float)TypedValue.applyDimension((int)1, (float)f, (DisplayMetrics)resources.getDisplayMetrics()));
            return builder;
        }

        @NotNull
        public final Builder setIconHeightResource(@DimenRes int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.iconHeight = ContextExtensionKt.dimenPixel($this$apply.context, value2);
            return builder;
        }

        @NotNull
        public final Builder setIconSize(@Dp int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.setIconWidth(value2);
            $this$apply.setIconHeight(value2);
            return builder;
        }

        @NotNull
        public final Builder setIconSizeResource(@DimenRes int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.setIconWidthResource(value2);
            $this$apply.setIconHeightResource(value2);
            return builder;
        }

        @NotNull
        public final Builder setIconColor(@ColorInt int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.iconColor = value2;
            return builder;
        }

        @NotNull
        public final Builder setIconColorResource(@ColorRes int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.iconColor = ContextExtensionKt.contextColor($this$apply.context, value2);
            return builder;
        }

        @NotNull
        public final Builder setIconSpace(@Dp int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            int $this$dp$iv = value2;
            boolean $i$f$getDp = false;
            float f = $this$dp$iv;
            Resources resources = Resources.getSystem();
            Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"Resources.getSystem()");
            $this$apply.iconSpace = MathKt.roundToInt((float)TypedValue.applyDimension((int)1, (float)f, (DisplayMetrics)resources.getDisplayMetrics()));
            return builder;
        }

        @NotNull
        public final Builder setIconSpaceResource(@DimenRes int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.iconSpace = ContextExtensionKt.dimenPixel($this$apply.context, value2);
            return builder;
        }

        @NotNull
        public final Builder setIconForm(@NotNull IconForm value2) {
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.iconForm = value2;
            return builder;
        }

        @NotNull
        public final Builder setAlpha(@FloatRange(from=0.0, to=1.0) float value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.alpha = value2;
            return builder;
        }

        @TargetApi(value=21)
        @NotNull
        public final Builder setElevation(@Dp int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            int $this$dp$iv = value2;
            boolean $i$f$getDp = false;
            float f = $this$dp$iv;
            Resources resources = Resources.getSystem();
            Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"Resources.getSystem()");
            $this$apply.elevation = MathKt.roundToInt((float)TypedValue.applyDimension((int)1, (float)f, (DisplayMetrics)resources.getDisplayMetrics()));
            return builder;
        }

        @TargetApi(value=21)
        @NotNull
        public final Builder setElevationResource(@DimenRes int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.elevation = ContextExtensionKt.dimen($this$apply.context, value2);
            return builder;
        }

        @NotNull
        public final Builder setLayout(@LayoutRes int layoutRes) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.layoutRes = layoutRes;
            return builder;
        }

        @NotNull
        public final Builder setLayout(@NotNull View layout2) {
            Intrinsics.checkNotNullParameter((Object)layout2, (String)"layout");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.layout = layout2;
            return builder;
        }

        @NotNull
        public final Builder setIsVisibleOverlay(boolean value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.isVisibleOverlay = value2;
            return builder;
        }

        @NotNull
        public final Builder setOverlayColor(@ColorInt int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.overlayColor = value2;
            return builder;
        }

        @NotNull
        public final Builder setOverlayColorResource(@ColorRes int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.overlayColor = ContextExtensionKt.contextColor($this$apply.context, value2);
            return builder;
        }

        @NotNull
        public final Builder setOverlayPadding(@Dp float value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            float $this$dp$iv = value2;
            boolean $i$f$getDp = false;
            Resources resources = Resources.getSystem();
            Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"Resources.getSystem()");
            $this$apply.overlayPadding = TypedValue.applyDimension((int)1, (float)$this$dp$iv, (DisplayMetrics)resources.getDisplayMetrics());
            return builder;
        }

        @NotNull
        public final Builder setOverlayPaddingResource(@DimenRes int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.overlayPadding = ContextExtensionKt.dimen($this$apply.context, value2);
            return builder;
        }

        @NotNull
        public final Builder setOverlayPosition(@NotNull Point value2) {
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.overlayPosition = value2;
            return builder;
        }

        @NotNull
        public final Builder setOverlayShape(@NotNull BalloonOverlayShape value2) {
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.overlayShape = value2;
            return builder;
        }

        @NotNull
        public final Builder setIsStatusBarVisible(boolean value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.isStatusBarVisible = value2;
            return builder;
        }

        @NotNull
        public final Builder setLifecycleOwner(@Nullable LifecycleOwner value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.lifecycleOwner = value2;
            return builder;
        }

        @NotNull
        public final Builder setBalloonAnimation(@NotNull BalloonAnimation value2) {
            Intrinsics.checkNotNullParameter((Object)((Object)value2), (String)"value");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.balloonAnimation = value2;
            if (value2 == BalloonAnimation.CIRCULAR) {
                $this$apply.setFocusable(false);
            }
            return builder;
        }

        @NotNull
        public final Builder setBalloonAnimationStyle(@StyleRes int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.balloonAnimationStyle = value2;
            return builder;
        }

        @NotNull
        public final Builder setBalloonOverlayAnimation(@NotNull BalloonOverlayAnimation value2) {
            Intrinsics.checkNotNullParameter((Object)((Object)value2), (String)"value");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.balloonOverlayAnimation = value2;
            return builder;
        }

        @NotNull
        public final Builder setBalloonOverlayAnimationStyle(@StyleRes int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.balloonOverlayAnimationStyle = value2;
            return builder;
        }

        @NotNull
        public final Builder setCircularDuration(long value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.circularDuration = value2;
            return builder;
        }

        @NotNull
        public final Builder setBalloonHighlightAnimation(@NotNull BalloonHighlightAnimation value2, long startDelay) {
            Intrinsics.checkNotNullParameter((Object)((Object)value2), (String)"value");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.balloonHighlightAnimation = value2;
            $this$apply.balloonHighlightAnimationStartDelay = startDelay;
            return builder;
        }

        public static /* synthetic */ Builder setBalloonHighlightAnimation$default(Builder builder, BalloonHighlightAnimation balloonHighlightAnimation, long l, int n, Object object) {
            if ((n & 2) != 0) {
                l = 0L;
            }
            return builder.setBalloonHighlightAnimation(balloonHighlightAnimation, l);
        }

        @NotNull
        public final Builder setBalloonHighlightAnimationResource(@AnimRes int value2, long startDelay) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.balloonHighlightAnimationStyle = value2;
            $this$apply.balloonHighlightAnimationStartDelay = startDelay;
            return builder;
        }

        public static /* synthetic */ Builder setBalloonHighlightAnimationResource$default(Builder builder, int n, long l, int n2, Object object) {
            if ((n2 & 2) != 0) {
                l = 0L;
            }
            return builder.setBalloonHighlightAnimationResource(n, l);
        }

        @NotNull
        public final Builder setOnBalloonClickListener(@NotNull OnBalloonClickListener value2) {
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.onBalloonClickListener = value2;
            return builder;
        }

        @NotNull
        public final Builder setOnBalloonDismissListener(@NotNull OnBalloonDismissListener value2) {
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.onBalloonDismissListener = value2;
            return builder;
        }

        @NotNull
        public final Builder setOnBalloonInitializedListener(@NotNull OnBalloonInitializedListener value2) {
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.onBalloonInitializedListener = value2;
            return builder;
        }

        @NotNull
        public final Builder setOnBalloonOutsideTouchListener(@NotNull OnBalloonOutsideTouchListener value2) {
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.onBalloonOutsideTouchListener = value2;
            return builder;
        }

        @NotNull
        public final Builder setOnBalloonTouchListener(@NotNull View.OnTouchListener value2) {
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.onBalloonTouchListener = value2;
            return builder;
        }

        @NotNull
        public final Builder setOnBalloonOverlayClickListener(@NotNull OnBalloonOverlayClickListener value2) {
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.onBalloonOverlayClickListener = value2;
            return builder;
        }

        public final /* synthetic */ Builder setOnBalloonClickListener(Function1<? super View, Unit> block) {
            Intrinsics.checkNotNullParameter(block, (String)"block");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            Function1<? super View, Unit> function1 = block;
            $this$apply.onBalloonClickListener = new BalloonKt$sam$i$com_skydoves_balloon_OnBalloonClickListener$0(function1);
            return builder;
        }

        public final /* synthetic */ Builder setOnBalloonDismissListener(Function0<Unit> block) {
            Intrinsics.checkNotNullParameter(block, (String)"block");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            Function0<Unit> function0 = block;
            $this$apply.onBalloonDismissListener = new BalloonKt$sam$i$com_skydoves_balloon_OnBalloonDismissListener$0(function0);
            return builder;
        }

        public final /* synthetic */ Builder setOnBalloonInitializedListener(Function1<? super View, Unit> block) {
            Intrinsics.checkNotNullParameter(block, (String)"block");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            Function1<? super View, Unit> function1 = block;
            $this$apply.onBalloonInitializedListener = new BalloonKt$sam$i$com_skydoves_balloon_OnBalloonInitializedListener$0(function1);
            return builder;
        }

        public final /* synthetic */ Builder setOnBalloonOutsideTouchListener(Function2<? super View, ? super MotionEvent, Unit> block) {
            Intrinsics.checkNotNullParameter(block, (String)"block");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            Function2<? super View, ? super MotionEvent, Unit> function2 = block;
            $this$apply.onBalloonOutsideTouchListener = new BalloonKt$sam$i$com_skydoves_balloon_OnBalloonOutsideTouchListener$0(function2);
            $this$apply.setDismissWhenTouchOutside(false);
            return builder;
        }

        @NotNull
        public final Builder setOnBalloonOverlayClickListener(@NotNull Function0<Unit> block) {
            Intrinsics.checkNotNullParameter(block, (String)"block");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            Function0<Unit> function0 = block;
            $this$apply.onBalloonOverlayClickListener = new BalloonKt$sam$i$com_skydoves_balloon_OnBalloonOverlayClickListener$0(function0);
            return builder;
        }

        @NotNull
        public final Builder setDismissWhenTouchOutside(boolean value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.dismissWhenTouchOutside = value2;
            if (!value2) {
                $this$apply.setFocusable(value2);
            }
            return builder;
        }

        @NotNull
        public final Builder setOnBalloonOverlayTouchListener(@NotNull View.OnTouchListener value2) {
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.onBalloonOverlayTouchListener = value2;
            $this$apply.setDismissWhenOverlayClicked(false);
            return builder;
        }

        @NotNull
        public final Builder setDismissWhenShowAgain(boolean value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.dismissWhenShowAgain = value2;
            return builder;
        }

        @NotNull
        public final Builder setDismissWhenClicked(boolean value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.dismissWhenClicked = value2;
            return builder;
        }

        @NotNull
        public final Builder setDismissWhenLifecycleOnPause(boolean value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.dismissWhenLifecycleOnPause = value2;
            return builder;
        }

        @NotNull
        public final Builder setDismissWhenOverlayClicked(boolean value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.dismissWhenOverlayClicked = value2;
            return builder;
        }

        @NotNull
        public final Builder setAutoDismissDuration(long value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.autoDismissDuration = value2;
            return builder;
        }

        @NotNull
        public final Builder setPreferenceName(@NotNull String value2) {
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.preferenceName = value2;
            return builder;
        }

        @NotNull
        public final Builder setShowCounts(int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.showTimes = value2;
            return builder;
        }

        @NotNull
        public final Builder runIfReachedShowCounts(@NotNull Function0<Unit> block) {
            Intrinsics.checkNotNullParameter(block, (String)"block");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.runIfReachedShowCounts = block;
            return builder;
        }

        @NotNull
        public final Builder runIfReachedShowCounts(@NotNull Runnable runnable) {
            Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.runIfReachedShowCounts((Function0<Unit>)((Function0)new Function0<Unit>(runnable){
                final /* synthetic */ Runnable $runnable$inlined;
                {
                    this.$runnable$inlined = runnable;
                    super(0);
                }

                public final void invoke() {
                    this.$runnable$inlined.run();
                }
            }));
            return builder;
        }

        @NotNull
        public final Builder setFocusable(boolean value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.isFocusable = value2;
            return builder;
        }

        @NotNull
        public final Balloon build() {
            return new Balloon(this.context, this);
        }

        public Builder(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            this.context = context;
            this.width = Integer.MIN_VALUE;
            this.maxWidth = ContextExtensionKt.displaySize((Context)this.context).x;
            this.height = Integer.MIN_VALUE;
            this.isVisibleArrow = true;
            this.arrowColor = Integer.MIN_VALUE;
            int $this$dp$iv = 12;
            boolean $i$f$getDp = false;
            float f = $this$dp$iv;
            Resources resources = Resources.getSystem();
            Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"Resources.getSystem()");
            this.arrowSize = MathKt.roundToInt((float)TypedValue.applyDimension((int)1, (float)f, (DisplayMetrics)resources.getDisplayMetrics()));
            this.arrowPosition = 0.5f;
            this.arrowPositionRules = ArrowPositionRules.ALIGN_BALLOON;
            this.arrowOrientationRules = ArrowOrientationRules.ALIGN_ANCHOR;
            this.arrowOrientation = ArrowOrientation.BOTTOM;
            this.arrowAlignAnchorPaddingRatio = 2.5f;
            this.backgroundColor = -16777216;
            float $this$dp$iv2 = 5.0f;
            $i$f$getDp = false;
            Resources resources2 = Resources.getSystem();
            Intrinsics.checkNotNullExpressionValue((Object)resources2, (String)"Resources.getSystem()");
            this.cornerRadius = TypedValue.applyDimension((int)1, (float)$this$dp$iv2, (DisplayMetrics)resources2.getDisplayMetrics());
            this.text = "";
            this.textColor = -1;
            this.textSize = 12.0f;
            this.textGravity = 17;
            this.iconGravity = IconGravity.START;
            $this$dp$iv = 28;
            $i$f$getDp = false;
            float f2 = $this$dp$iv;
            Resources resources3 = Resources.getSystem();
            Intrinsics.checkNotNullExpressionValue((Object)resources3, (String)"Resources.getSystem()");
            this.iconWidth = MathKt.roundToInt((float)TypedValue.applyDimension((int)1, (float)f2, (DisplayMetrics)resources3.getDisplayMetrics()));
            $this$dp$iv = 28;
            $i$f$getDp = false;
            float f3 = $this$dp$iv;
            Resources resources4 = Resources.getSystem();
            Intrinsics.checkNotNullExpressionValue((Object)resources4, (String)"Resources.getSystem()");
            this.iconHeight = MathKt.roundToInt((float)TypedValue.applyDimension((int)1, (float)f3, (DisplayMetrics)resources4.getDisplayMetrics()));
            $this$dp$iv = 8;
            $i$f$getDp = false;
            float f4 = $this$dp$iv;
            Resources resources5 = Resources.getSystem();
            Intrinsics.checkNotNullExpressionValue((Object)resources5, (String)"Resources.getSystem()");
            this.iconSpace = MathKt.roundToInt((float)TypedValue.applyDimension((int)1, (float)f4, (DisplayMetrics)resources5.getDisplayMetrics()));
            this.iconColor = Integer.MIN_VALUE;
            this.alpha = 1.0f;
            float $this$dp$iv3 = 2.0f;
            $i$f$getDp = false;
            Resources resources6 = Resources.getSystem();
            Intrinsics.checkNotNullExpressionValue((Object)resources6, (String)"Resources.getSystem()");
            this.elevation = TypedValue.applyDimension((int)1, (float)$this$dp$iv3, (DisplayMetrics)resources6.getDisplayMetrics());
            this.overlayShape = BalloonOverlayOval.INSTANCE;
            this.dismissWhenTouchOutside = true;
            this.dismissWhenOverlayClicked = true;
            this.autoDismissDuration = -1L;
            this.balloonAnimationStyle = Integer.MIN_VALUE;
            this.balloonOverlayAnimationStyle = Integer.MIN_VALUE;
            this.balloonAnimation = BalloonAnimation.FADE;
            this.balloonOverlayAnimation = BalloonOverlayAnimation.FADE;
            this.circularDuration = 500L;
            this.balloonHighlightAnimation = BalloonHighlightAnimation.NONE;
            this.balloonHighlightAnimationStyle = Integer.MIN_VALUE;
            this.showTimes = 1;
            Resources resources7 = this.context.getResources();
            Intrinsics.checkNotNullExpressionValue((Object)resources7, (String)"context.resources");
            Configuration configuration = resources7.getConfiguration();
            Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"context.resources.configuration");
            this.isRtlLayout = configuration.getLayoutDirection() == 1;
            this.supportRtlLayoutFactor = DefinitionKt.unaryMinus(1, this.isRtlLayout);
            this.isFocusable = true;
            this.isStatusBarVisible = true;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH&\u00a8\u0006\t"}, d2={"Lcom/skydoves/balloon/Balloon$Factory;", "", "()V", "create", "Lcom/skydoves/balloon/Balloon;", "context", "Landroid/content/Context;", "lifecycle", "Landroidx/lifecycle/LifecycleOwner;", "balloon_release"})
    public static abstract class Factory {
        @NotNull
        public abstract Balloon create(@NotNull Context var1, @Nullable LifecycleOwner var2);
    }
}

