/*
 * Decompiled with CFR 0.152.
 */
package com.skydoves.balloon;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.Typeface;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.PopupWindow;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.annotation.FloatRange;
import androidx.annotation.LayoutRes;
import androidx.annotation.MainThread;
import androidx.core.widget.ImageViewCompat;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.OnLifecycleEvent;
import com.skydoves.balloon.ArrowOrientation;
import com.skydoves.balloon.Balloon$WhenMappings;
import com.skydoves.balloon.BalloonAnimation;
import com.skydoves.balloon.BalloonDsl;
import com.skydoves.balloon.BalloonPreferenceManager;
import com.skydoves.balloon.ContextExtensionKt;
import com.skydoves.balloon.IconForm;
import com.skydoves.balloon.ImageViewExtensionKt;
import com.skydoves.balloon.OnBalloonClickListener;
import com.skydoves.balloon.OnBalloonDismissListener;
import com.skydoves.balloon.OnBalloonOutsideTouchListener;
import com.skydoves.balloon.R;
import com.skydoves.balloon.TextForm;
import com.skydoves.balloon.TextViewExtensionKt;
import com.skydoves.balloon.ViewExtensionKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\n\b\u0007\u0018\u00002\u00020\u0001:\u0002=>B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010#\u001a\u00020$H\u0002J\b\u0010%\u001a\u00020$H\u0002J\u0006\u0010&\u001a\u00020$J\u0006\u0010'\u001a\u00020\nJ\u0006\u0010(\u001a\u00020)J\b\u0010*\u001a\u00020$H\u0002J\b\u0010+\u001a\u00020$H\u0002J\b\u0010,\u001a\u00020$H\u0002J\b\u0010-\u001a\u00020$H\u0002J\b\u0010.\u001a\u00020$H\u0002J\b\u0010/\u001a\u00020$H\u0002J\b\u00100\u001a\u00020$H\u0002J\b\u00101\u001a\u00020$H\u0007J\u000e\u00102\u001a\u00020$2\u0006\u00103\u001a\u00020\nJ!\u00102\u001a\u00020$2\u0006\u00103\u001a\u00020\n2\u000e\b\u0004\u00104\u001a\b\u0012\u0004\u0012\u00020$05H\u0083\bJ\u001e\u00102\u001a\u00020$2\u0006\u00103\u001a\u00020\n2\u0006\u00106\u001a\u00020)2\u0006\u00107\u001a\u00020)J\u000e\u00108\u001a\u00020$2\u0006\u00103\u001a\u00020\nJ\u001e\u00108\u001a\u00020$2\u0006\u00103\u001a\u00020\n2\u0006\u00106\u001a\u00020)2\u0006\u00107\u001a\u00020)J\u000e\u00109\u001a\u00020$2\u0006\u00103\u001a\u00020\nJ\u001e\u00109\u001a\u00020$2\u0006\u00103\u001a\u00020\n2\u0006\u00106\u001a\u00020)2\u0006\u00107\u001a\u00020)J\u000e\u0010:\u001a\u00020$2\u0006\u00103\u001a\u00020\nJ\u001e\u0010:\u001a\u00020$2\u0006\u00103\u001a\u00020\n2\u0006\u00106\u001a\u00020)2\u0006\u00107\u001a\u00020)J\u000e\u0010;\u001a\u00020$2\u0006\u00103\u001a\u00020\nJ\u001e\u0010;\u001a\u00020$2\u0006\u00103\u001a\u00020\n2\u0006\u00106\u001a\u00020)2\u0006\u00107\u001a\u00020)J\u000e\u0010<\u001a\u00020$2\u0006\u00103\u001a\u00020\nJ\u001e\u0010<\u001a\u00020$2\u0006\u00103\u001a\u00020\n2\u0006\u00106\u001a\u00020)2\u0006\u00107\u001a\u00020)R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001c\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"\u00a8\u0006?"}, d2={"Lcom/skydoves/balloon/Balloon;", "Landroidx/lifecycle/LifecycleObserver;", "context", "Landroid/content/Context;", "builder", "Lcom/skydoves/balloon/Balloon$Builder;", "(Landroid/content/Context;Lcom/skydoves/balloon/Balloon$Builder;)V", "balloonPreferenceManager", "Lcom/skydoves/balloon/BalloonPreferenceManager;", "bodyView", "Landroid/view/View;", "bodyWindow", "Landroid/widget/PopupWindow;", "<set-?>", "", "isShowing", "()Z", "onBalloonClickListener", "Lcom/skydoves/balloon/OnBalloonClickListener;", "getOnBalloonClickListener", "()Lcom/skydoves/balloon/OnBalloonClickListener;", "setOnBalloonClickListener", "(Lcom/skydoves/balloon/OnBalloonClickListener;)V", "onBalloonDismissListener", "Lcom/skydoves/balloon/OnBalloonDismissListener;", "getOnBalloonDismissListener", "()Lcom/skydoves/balloon/OnBalloonDismissListener;", "setOnBalloonDismissListener", "(Lcom/skydoves/balloon/OnBalloonDismissListener;)V", "onBalloonOutsideTouchListener", "Lcom/skydoves/balloon/OnBalloonOutsideTouchListener;", "getOnBalloonOutsideTouchListener", "()Lcom/skydoves/balloon/OnBalloonOutsideTouchListener;", "setOnBalloonOutsideTouchListener", "(Lcom/skydoves/balloon/OnBalloonOutsideTouchListener;)V", "applyBalloonAnimation", "", "createByBuilder", "dismiss", "getContentView", "getMeasureWidth", "", "initializeArrow", "initializeBackground", "initializeBalloonContent", "initializeBalloonListeners", "initializeCustomLayout", "initializeIcon", "initializeText", "onDestroy", "show", "anchor", "block", "Lkotlin/Function0;", "xOff", "yOff", "showAlignBottom", "showAlignLeft", "showAlignRight", "showAlignTop", "showAsDropDown", "Builder", "Factory", "balloon_release"})
@SuppressLint(value={"InflateParams"})
public final class Balloon
implements LifecycleObserver {
    private final View bodyView;
    private final PopupWindow bodyWindow;
    private boolean isShowing;
    @Nullable
    private OnBalloonClickListener onBalloonClickListener;
    @Nullable
    private OnBalloonDismissListener onBalloonDismissListener;
    @Nullable
    private OnBalloonOutsideTouchListener onBalloonOutsideTouchListener;
    private final BalloonPreferenceManager balloonPreferenceManager;
    private final Context context;
    private final Builder builder;

    public final boolean isShowing() {
        return this.isShowing;
    }

    @Nullable
    public final OnBalloonClickListener getOnBalloonClickListener() {
        return this.onBalloonClickListener;
    }

    public final void setOnBalloonClickListener(@Nullable OnBalloonClickListener onBalloonClickListener) {
        this.onBalloonClickListener = onBalloonClickListener;
    }

    @Nullable
    public final OnBalloonDismissListener getOnBalloonDismissListener() {
        return this.onBalloonDismissListener;
    }

    public final void setOnBalloonDismissListener(@Nullable OnBalloonDismissListener onBalloonDismissListener) {
        this.onBalloonDismissListener = onBalloonDismissListener;
    }

    @Nullable
    public final OnBalloonOutsideTouchListener getOnBalloonOutsideTouchListener() {
        return this.onBalloonOutsideTouchListener;
    }

    public final void setOnBalloonOutsideTouchListener(@Nullable OnBalloonOutsideTouchListener onBalloonOutsideTouchListener) {
        this.onBalloonOutsideTouchListener = onBalloonOutsideTouchListener;
    }

    private final void createByBuilder() {
        block2: {
            LifecycleOwner lifecycleOwner;
            this.initializeArrow();
            this.initializeBackground();
            this.initializeBalloonListeners();
            if (this.builder.layout == -1) {
                this.initializeBalloonContent();
                this.initializeIcon();
                this.initializeText();
            } else {
                this.initializeCustomLayout();
            }
            if ((lifecycleOwner = this.builder.lifecycleOwner) == null || (lifecycleOwner = lifecycleOwner.getLifecycle()) == null) break block2;
            lifecycleOwner.addObserver((LifecycleObserver)this);
        }
    }

    private final void initializeArrow() {
        ImageView imageView = (ImageView)this.bodyView.findViewById(R.id.balloon_arrow);
        boolean bl = false;
        boolean bl2 = false;
        ImageView $this$with = imageView;
        boolean bl3 = false;
        Drawable drawable = this.builder.arrowDrawable;
        if (drawable != null) {
            Drawable drawable2 = drawable;
            boolean bl4 = false;
            boolean bl5 = false;
            Drawable it = drawable2;
            boolean bl6 = false;
            $this$with.setImageDrawable(it);
        }
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(this.builder.arrowSize, this.builder.arrowSize);
        switch (Balloon$WhenMappings.$EnumSwitchMapping$0[this.builder.arrowOrientation.ordinal()]) {
            case 1: {
                RelativeLayout relativeLayout = (RelativeLayout)this.bodyView.findViewById(R.id.balloon_content);
                Intrinsics.checkExpressionValueIsNotNull((Object)relativeLayout, (String)"bodyView.balloon_content");
                params.addRule(8, relativeLayout.getId());
                $this$with.setRotation(180.0f);
                break;
            }
            case 2: {
                RelativeLayout relativeLayout = (RelativeLayout)this.bodyView.findViewById(R.id.balloon_content);
                Intrinsics.checkExpressionValueIsNotNull((Object)relativeLayout, (String)"bodyView.balloon_content");
                params.addRule(6, relativeLayout.getId());
                $this$with.setRotation(0.0f);
                break;
            }
            case 3: {
                RelativeLayout relativeLayout = (RelativeLayout)this.bodyView.findViewById(R.id.balloon_content);
                Intrinsics.checkExpressionValueIsNotNull((Object)relativeLayout, (String)"bodyView.balloon_content");
                params.addRule(5, relativeLayout.getId());
                $this$with.setRotation(-90.0f);
                break;
            }
            case 4: {
                RelativeLayout relativeLayout = (RelativeLayout)this.bodyView.findViewById(R.id.balloon_content);
                Intrinsics.checkExpressionValueIsNotNull((Object)relativeLayout, (String)"bodyView.balloon_content");
                params.addRule(7, relativeLayout.getId());
                $this$with.setRotation(90.0f);
            }
        }
        switch (Balloon$WhenMappings.$EnumSwitchMapping$1[this.builder.arrowOrientation.ordinal()]) {
            case 1: 
            case 2: {
                $this$with.setX((float)this.bodyWindow.getWidth() * this.builder.arrowPosition - (float)(this.builder.arrowSize / 2));
                break;
            }
            case 3: 
            case 4: {
                $this$with.setY((float)this.bodyWindow.getHeight() * this.builder.arrowPosition - (float)(this.builder.arrowSize / 2));
            }
        }
        $this$with.setLayoutParams((ViewGroup.LayoutParams)params);
        $this$with.setAlpha(this.builder.getAlpha());
        ViewExtensionKt.visible((View)$this$with, this.builder.arrowVisible);
        ImageViewCompat.setImageTintList((ImageView)$this$with, (ColorStateList)ColorStateList.valueOf((int)this.builder.backgroundColor));
    }

    private final void initializeBackground() {
        LinearLayout linearLayout = (LinearLayout)this.bodyView.findViewById(R.id.balloon_background);
        boolean bl = false;
        boolean bl2 = false;
        LinearLayout $this$with = linearLayout;
        boolean bl3 = false;
        $this$with.setAlpha(this.builder.getAlpha());
        if (this.builder.backgroundDrawable == null) {
            GradientDrawable drawable = new GradientDrawable();
            drawable.setColor(this.builder.backgroundColor);
            drawable.setCornerRadius(this.builder.cornerRadius);
            $this$with.setBackground((Drawable)drawable);
        } else {
            $this$with.setBackground(this.builder.backgroundDrawable);
        }
    }

    private final void initializeBalloonListeners() {
        this.onBalloonClickListener = this.builder.onBalloonClickListener;
        this.onBalloonDismissListener = this.builder.onBalloonDismissListener;
        this.onBalloonOutsideTouchListener = this.builder.onBalloonOutsideTouchListener;
        this.bodyView.setOnClickListener(new View.OnClickListener(this){
            final /* synthetic */ Balloon this$0;

            public final void onClick(View it) {
                OnBalloonClickListener onBalloonClickListener = this.this$0.getOnBalloonClickListener();
                if (onBalloonClickListener != null) {
                    View view = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"it");
                    onBalloonClickListener.onBalloonClick(view);
                }
                if (Balloon.access$getBuilder$p((Balloon)this.this$0).dismissWhenClicked) {
                    this.this$0.dismiss();
                }
            }
            {
                this.this$0 = balloon2;
            }
        });
        this.bodyWindow.setOnDismissListener(new PopupWindow.OnDismissListener(this){
            final /* synthetic */ Balloon this$0;

            public final void onDismiss() {
                block0: {
                    OnBalloonDismissListener onBalloonDismissListener = this.this$0.getOnBalloonDismissListener();
                    if (onBalloonDismissListener == null) break block0;
                    onBalloonDismissListener.onBalloonDismiss();
                }
            }
            {
                this.this$0 = balloon2;
            }
        });
        this.bodyWindow.setBackgroundDrawable((Drawable)new ColorDrawable(0));
        this.bodyWindow.setOutsideTouchable(true);
        this.bodyWindow.setTouchInterceptor(new View.OnTouchListener(this){
            final /* synthetic */ Balloon this$0;

            @SuppressLint(value={"ClickableViewAccessibility"})
            public boolean onTouch(@NotNull View view, @NotNull MotionEvent event) {
                Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
                Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                if (Balloon.access$getBuilder$p((Balloon)this.this$0).dismissWhenTouchOutside) {
                    this.this$0.dismiss();
                }
                if (event.getAction() == 4) {
                    OnBalloonOutsideTouchListener onBalloonOutsideTouchListener = this.this$0.getOnBalloonOutsideTouchListener();
                    if (onBalloonOutsideTouchListener != null) {
                        onBalloonOutsideTouchListener.onBalloonOutsideTouch(view, event);
                    }
                    return true;
                }
                return false;
            }
            {
                this.this$0 = $outer;
            }
        });
    }

    private final void initializeBalloonContent() {
        RelativeLayout relativeLayout = (RelativeLayout)this.bodyView.findViewById(R.id.balloon_content);
        boolean bl = false;
        boolean bl2 = false;
        RelativeLayout $this$with = relativeLayout;
        boolean bl3 = false;
        switch (Balloon$WhenMappings.$EnumSwitchMapping$2[this.builder.arrowOrientation.ordinal()]) {
            case 1: 
            case 2: {
                $this$with.setPadding(this.builder.arrowSize, this.builder.arrowSize, this.builder.arrowSize, this.builder.arrowSize);
                break;
            }
            case 3: 
            case 4: {
                $this$with.setPadding(this.builder.arrowSize, $this$with.getPaddingTop(), $this$with.getPaddingBottom(), this.builder.arrowSize);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void initializeIcon() {
        ImageView imageView = (ImageView)this.bodyView.findViewById(R.id.balloon_icon);
        boolean bl = false;
        boolean bl2 = false;
        ImageView $this$with = imageView;
        boolean bl3 = false;
        IconForm iconForm = this.builder.iconForm;
        if (iconForm != null) {
            IconForm iconForm2 = iconForm;
            boolean bl4 = false;
            boolean bl5 = false;
            IconForm it = iconForm2;
            boolean bl6 = false;
            ImageViewExtensionKt.applyIconForm($this$with, it);
        } else {
            void context$iv;
            Context context = $this$with.getContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
            Context context2 = context;
            ImageView imageView2 = $this$with;
            boolean $i$f$iconForm = false;
            IconForm.Builder builder = new IconForm.Builder((Context)context$iv);
            boolean bl7 = false;
            boolean bl8 = false;
            IconForm.Builder $this$iconForm = builder;
            boolean bl9 = false;
            $this$iconForm.setDrawable(this.builder.iconDrawable);
            $this$iconForm.setIconSize(this.builder.iconSize);
            $this$iconForm.setIconColor(this.builder.iconColor);
            $this$iconForm.setIconSpace(this.builder.iconSpace);
            IconForm iconForm3 = builder.build();
            ImageViewExtensionKt.applyIconForm(imageView2, iconForm3);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void initializeText() {
        TextView textView = (TextView)this.bodyView.findViewById(R.id.balloon_text);
        boolean bl = false;
        boolean bl2 = false;
        TextView $this$with = textView;
        boolean bl3 = false;
        TextForm textForm = this.builder.textForm;
        if (textForm != null) {
            TextForm textForm2 = textForm;
            boolean bl4 = false;
            boolean bl5 = false;
            TextForm it = textForm2;
            boolean bl6 = false;
            TextViewExtensionKt.applyTextForm($this$with, it);
        } else {
            void context$iv;
            Context context = $this$with.getContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
            Context context2 = context;
            TextView textView2 = $this$with;
            boolean $i$f$textForm = false;
            TextForm.Builder builder = new TextForm.Builder((Context)context$iv);
            boolean bl7 = false;
            boolean bl8 = false;
            TextForm.Builder $this$textForm = builder;
            boolean bl9 = false;
            $this$textForm.setText(this.builder.text);
            $this$textForm.setTextSize(this.builder.textSize);
            $this$textForm.setTextColor(this.builder.textColor);
            $this$textForm.setTextTypeface(this.builder.textTypeface);
            $this$textForm.setTextTypeface(this.builder.textTypefaceObject);
            TextForm textForm3 = builder.build();
            TextViewExtensionKt.applyTextForm(textView2, textForm3);
        }
    }

    private final void initializeCustomLayout() {
        ((LinearLayout)this.bodyView.findViewById(R.id.balloon_detail)).removeAllViews();
        Object object = this.context.getSystemService("layout_inflater");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.view.LayoutInflater");
        }
        LayoutInflater inflater = (LayoutInflater)object;
        inflater.inflate(this.builder.layout, (ViewGroup)((LinearLayout)this.bodyView.findViewById(R.id.balloon_detail)));
    }

    private final void applyBalloonAnimation() {
        switch (Balloon$WhenMappings.$EnumSwitchMapping$3[this.builder.balloonAnimation.ordinal()]) {
            case 1: {
                this.bodyWindow.setAnimationStyle(R.style.Elastic);
                break;
            }
            case 2: {
                View view = this.bodyWindow.getContentView();
                Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"bodyWindow.contentView");
                ViewExtensionKt.circularRevealed(view);
                this.bodyWindow.setAnimationStyle(R.style.NormalDispose);
                break;
            }
            case 3: {
                this.bodyWindow.setAnimationStyle(R.style.Fade);
                break;
            }
            default: {
                this.bodyWindow.setAnimationStyle(R.style.Normal);
            }
        }
    }

    @MainThread
    private final void show(View anchor, Function0<Unit> block) {
        int $i$f$show = 0;
        if (!this.isShowing()) {
            this.isShowing = true;
            String string = ((Balloon)this).builder.preferenceName;
            if (string != null) {
                String string2 = string;
                boolean bl = false;
                boolean bl2 = false;
                String it = string2;
                boolean bl3 = false;
                if (this.balloonPreferenceManager.shouldShowUP(it, ((Balloon)this).builder.showTimes)) {
                    this.balloonPreferenceManager.putIncrementedTimes(it);
                } else {
                    return;
                }
            }
            anchor.post(new Runnable(this, block){
                final /* synthetic */ Balloon this$0;
                final /* synthetic */ Function0 $block;

                public final void run() {
                    Balloon.access$applyBalloonAnimation(this.this$0);
                    this.$block.invoke();
                }
                {
                    this.this$0 = balloon2;
                    this.$block = function0;
                }
            });
        } else if (((Balloon)this).builder.dismissWhenShowAgain) {
            this.dismiss();
        }
    }

    public final void show(@NotNull View anchor) {
        block5: {
            Balloon this_$iv;
            block3: {
                block4: {
                    Intrinsics.checkParameterIsNotNull((Object)anchor, (String)"anchor");
                    this_$iv = this;
                    boolean $i$f$show = false;
                    if (this_$iv.isShowing()) break block3;
                    this_$iv.isShowing = true;
                    String string = ((Balloon)this_$iv).builder.preferenceName;
                    if (string == null) break block4;
                    String string2 = string;
                    boolean bl = false;
                    boolean bl2 = false;
                    String it$iv = string2;
                    boolean bl3 = false;
                    if (!this_$iv.balloonPreferenceManager.shouldShowUP(it$iv, ((Balloon)this_$iv).builder.showTimes)) break block5;
                    this_$iv.balloonPreferenceManager.putIncrementedTimes(it$iv);
                }
                anchor.post(new Runnable(this_$iv, this, anchor){
                    final /* synthetic */ Balloon this$0$inline_fun;
                    final /* synthetic */ Balloon this$0;
                    final /* synthetic */ View $anchor$inlined;
                    {
                        this.this$0$inline_fun = balloon2;
                        this.this$0 = balloon3;
                        this.$anchor$inlined = view;
                    }

                    public final void run() {
                        Balloon.access$applyBalloonAnimation(this.this$0$inline_fun);
                        boolean bl = false;
                        Balloon.access$getBodyWindow$p(this.this$0).showAsDropDown(this.$anchor$inlined, -(this.$anchor$inlined.getMeasuredWidth() / 2), -Balloon.access$getBuilder$p((Balloon)this.this$0).height - this.$anchor$inlined.getMeasuredHeight() / 2);
                    }
                });
                break block5;
            }
            if (((Balloon)this_$iv).builder.dismissWhenShowAgain) {
                this_$iv.dismiss();
            }
        }
    }

    public final void show(@NotNull View anchor, int xOff, int yOff) {
        block5: {
            Balloon this_$iv;
            block3: {
                block4: {
                    Intrinsics.checkParameterIsNotNull((Object)anchor, (String)"anchor");
                    this_$iv = this;
                    boolean $i$f$show = false;
                    if (this_$iv.isShowing()) break block3;
                    this_$iv.isShowing = true;
                    String string = ((Balloon)this_$iv).builder.preferenceName;
                    if (string == null) break block4;
                    String string2 = string;
                    boolean bl = false;
                    boolean bl2 = false;
                    String it$iv = string2;
                    boolean bl3 = false;
                    if (!this_$iv.balloonPreferenceManager.shouldShowUP(it$iv, ((Balloon)this_$iv).builder.showTimes)) break block5;
                    this_$iv.balloonPreferenceManager.putIncrementedTimes(it$iv);
                }
                anchor.post(new Runnable(this_$iv, this, anchor, xOff, yOff){
                    final /* synthetic */ Balloon this$0$inline_fun;
                    final /* synthetic */ Balloon this$0;
                    final /* synthetic */ View $anchor$inlined;
                    final /* synthetic */ int $xOff$inlined;
                    final /* synthetic */ int $yOff$inlined;
                    {
                        this.this$0$inline_fun = balloon2;
                        this.this$0 = balloon3;
                        this.$anchor$inlined = view;
                        this.$xOff$inlined = n;
                        this.$yOff$inlined = n2;
                    }

                    public final void run() {
                        Balloon.access$applyBalloonAnimation(this.this$0$inline_fun);
                        boolean bl = false;
                        Balloon.access$getBodyWindow$p(this.this$0).showAsDropDown(this.$anchor$inlined, this.$xOff$inlined, this.$yOff$inlined);
                    }
                });
                break block5;
            }
            if (((Balloon)this_$iv).builder.dismissWhenShowAgain) {
                this_$iv.dismiss();
            }
        }
    }

    public final void showAsDropDown(@NotNull View anchor) {
        block5: {
            Balloon this_$iv;
            block3: {
                block4: {
                    Intrinsics.checkParameterIsNotNull((Object)anchor, (String)"anchor");
                    this_$iv = this;
                    boolean $i$f$show = false;
                    if (this_$iv.isShowing()) break block3;
                    this_$iv.isShowing = true;
                    String string = ((Balloon)this_$iv).builder.preferenceName;
                    if (string == null) break block4;
                    String string2 = string;
                    boolean bl = false;
                    boolean bl2 = false;
                    String it$iv = string2;
                    boolean bl3 = false;
                    if (!this_$iv.balloonPreferenceManager.shouldShowUP(it$iv, ((Balloon)this_$iv).builder.showTimes)) break block5;
                    this_$iv.balloonPreferenceManager.putIncrementedTimes(it$iv);
                }
                anchor.post(new Runnable(this_$iv, this, anchor){
                    final /* synthetic */ Balloon this$0$inline_fun;
                    final /* synthetic */ Balloon this$0;
                    final /* synthetic */ View $anchor$inlined;
                    {
                        this.this$0$inline_fun = balloon2;
                        this.this$0 = balloon3;
                        this.$anchor$inlined = view;
                    }

                    public final void run() {
                        Balloon.access$applyBalloonAnimation(this.this$0$inline_fun);
                        boolean bl = false;
                        Balloon.access$getBodyWindow$p(this.this$0).showAsDropDown(this.$anchor$inlined);
                    }
                });
                break block5;
            }
            if (((Balloon)this_$iv).builder.dismissWhenShowAgain) {
                this_$iv.dismiss();
            }
        }
    }

    public final void showAsDropDown(@NotNull View anchor, int xOff, int yOff) {
        block5: {
            Balloon this_$iv;
            block3: {
                block4: {
                    Intrinsics.checkParameterIsNotNull((Object)anchor, (String)"anchor");
                    this_$iv = this;
                    boolean $i$f$show = false;
                    if (this_$iv.isShowing()) break block3;
                    this_$iv.isShowing = true;
                    String string = ((Balloon)this_$iv).builder.preferenceName;
                    if (string == null) break block4;
                    String string2 = string;
                    boolean bl = false;
                    boolean bl2 = false;
                    String it$iv = string2;
                    boolean bl3 = false;
                    if (!this_$iv.balloonPreferenceManager.shouldShowUP(it$iv, ((Balloon)this_$iv).builder.showTimes)) break block5;
                    this_$iv.balloonPreferenceManager.putIncrementedTimes(it$iv);
                }
                anchor.post(new Runnable(this_$iv, this, anchor, xOff, yOff){
                    final /* synthetic */ Balloon this$0$inline_fun;
                    final /* synthetic */ Balloon this$0;
                    final /* synthetic */ View $anchor$inlined;
                    final /* synthetic */ int $xOff$inlined;
                    final /* synthetic */ int $yOff$inlined;
                    {
                        this.this$0$inline_fun = balloon2;
                        this.this$0 = balloon3;
                        this.$anchor$inlined = view;
                        this.$xOff$inlined = n;
                        this.$yOff$inlined = n2;
                    }

                    public final void run() {
                        Balloon.access$applyBalloonAnimation(this.this$0$inline_fun);
                        boolean bl = false;
                        Balloon.access$getBodyWindow$p(this.this$0).showAsDropDown(this.$anchor$inlined, this.$xOff$inlined, this.$yOff$inlined);
                    }
                });
                break block5;
            }
            if (((Balloon)this_$iv).builder.dismissWhenShowAgain) {
                this_$iv.dismiss();
            }
        }
    }

    public final void showAlignTop(@NotNull View anchor) {
        block5: {
            Balloon this_$iv;
            block3: {
                block4: {
                    Intrinsics.checkParameterIsNotNull((Object)anchor, (String)"anchor");
                    this_$iv = this;
                    boolean $i$f$show = false;
                    if (this_$iv.isShowing()) break block3;
                    this_$iv.isShowing = true;
                    String string = ((Balloon)this_$iv).builder.preferenceName;
                    if (string == null) break block4;
                    String string2 = string;
                    boolean bl = false;
                    boolean bl2 = false;
                    String it$iv = string2;
                    boolean bl3 = false;
                    if (!this_$iv.balloonPreferenceManager.shouldShowUP(it$iv, ((Balloon)this_$iv).builder.showTimes)) break block5;
                    this_$iv.balloonPreferenceManager.putIncrementedTimes(it$iv);
                }
                anchor.post(new Runnable(this_$iv, this, anchor){
                    final /* synthetic */ Balloon this$0$inline_fun;
                    final /* synthetic */ Balloon this$0;
                    final /* synthetic */ View $anchor$inlined;
                    {
                        this.this$0$inline_fun = balloon2;
                        this.this$0 = balloon3;
                        this.$anchor$inlined = view;
                    }

                    public final void run() {
                        Balloon.access$applyBalloonAnimation(this.this$0$inline_fun);
                        boolean bl = false;
                        Balloon.access$getBodyWindow$p(this.this$0).showAsDropDown(this.$anchor$inlined, this.$anchor$inlined.getMeasuredWidth() / 2 - this.this$0.getMeasureWidth() / 2, -Balloon.access$getBuilder$p((Balloon)this.this$0).height - this.$anchor$inlined.getMeasuredHeight());
                    }
                });
                break block5;
            }
            if (((Balloon)this_$iv).builder.dismissWhenShowAgain) {
                this_$iv.dismiss();
            }
        }
    }

    public final void showAlignTop(@NotNull View anchor, int xOff, int yOff) {
        block5: {
            Balloon this_$iv;
            block3: {
                block4: {
                    Intrinsics.checkParameterIsNotNull((Object)anchor, (String)"anchor");
                    this_$iv = this;
                    boolean $i$f$show = false;
                    if (this_$iv.isShowing()) break block3;
                    this_$iv.isShowing = true;
                    String string = ((Balloon)this_$iv).builder.preferenceName;
                    if (string == null) break block4;
                    String string2 = string;
                    boolean bl = false;
                    boolean bl2 = false;
                    String it$iv = string2;
                    boolean bl3 = false;
                    if (!this_$iv.balloonPreferenceManager.shouldShowUP(it$iv, ((Balloon)this_$iv).builder.showTimes)) break block5;
                    this_$iv.balloonPreferenceManager.putIncrementedTimes(it$iv);
                }
                anchor.post(new Runnable(this_$iv, this, anchor, xOff, yOff){
                    final /* synthetic */ Balloon this$0$inline_fun;
                    final /* synthetic */ Balloon this$0;
                    final /* synthetic */ View $anchor$inlined;
                    final /* synthetic */ int $xOff$inlined;
                    final /* synthetic */ int $yOff$inlined;
                    {
                        this.this$0$inline_fun = balloon2;
                        this.this$0 = balloon3;
                        this.$anchor$inlined = view;
                        this.$xOff$inlined = n;
                        this.$yOff$inlined = n2;
                    }

                    public final void run() {
                        Balloon.access$applyBalloonAnimation(this.this$0$inline_fun);
                        boolean bl = false;
                        Balloon.access$getBodyWindow$p(this.this$0).showAsDropDown(this.$anchor$inlined, this.$anchor$inlined.getMeasuredWidth() / 2 - this.this$0.getMeasureWidth() / 2 + this.$xOff$inlined, -Balloon.access$getBuilder$p((Balloon)this.this$0).height - this.$anchor$inlined.getMeasuredHeight() + this.$yOff$inlined);
                    }
                });
                break block5;
            }
            if (((Balloon)this_$iv).builder.dismissWhenShowAgain) {
                this_$iv.dismiss();
            }
        }
    }

    public final void showAlignBottom(@NotNull View anchor) {
        block5: {
            Balloon this_$iv;
            block3: {
                block4: {
                    Intrinsics.checkParameterIsNotNull((Object)anchor, (String)"anchor");
                    this_$iv = this;
                    boolean $i$f$show = false;
                    if (this_$iv.isShowing()) break block3;
                    this_$iv.isShowing = true;
                    String string = ((Balloon)this_$iv).builder.preferenceName;
                    if (string == null) break block4;
                    String string2 = string;
                    boolean bl = false;
                    boolean bl2 = false;
                    String it$iv = string2;
                    boolean bl3 = false;
                    if (!this_$iv.balloonPreferenceManager.shouldShowUP(it$iv, ((Balloon)this_$iv).builder.showTimes)) break block5;
                    this_$iv.balloonPreferenceManager.putIncrementedTimes(it$iv);
                }
                anchor.post(new Runnable(this_$iv, this, anchor){
                    final /* synthetic */ Balloon this$0$inline_fun;
                    final /* synthetic */ Balloon this$0;
                    final /* synthetic */ View $anchor$inlined;
                    {
                        this.this$0$inline_fun = balloon2;
                        this.this$0 = balloon3;
                        this.$anchor$inlined = view;
                    }

                    public final void run() {
                        Balloon.access$applyBalloonAnimation(this.this$0$inline_fun);
                        boolean bl = false;
                        Balloon.access$getBodyWindow$p(this.this$0).showAsDropDown(this.$anchor$inlined, this.$anchor$inlined.getMeasuredWidth() / 2 - this.this$0.getMeasureWidth() / 2, 0);
                    }
                });
                break block5;
            }
            if (((Balloon)this_$iv).builder.dismissWhenShowAgain) {
                this_$iv.dismiss();
            }
        }
    }

    public final void showAlignBottom(@NotNull View anchor, int xOff, int yOff) {
        block5: {
            Balloon this_$iv;
            block3: {
                block4: {
                    Intrinsics.checkParameterIsNotNull((Object)anchor, (String)"anchor");
                    this_$iv = this;
                    boolean $i$f$show = false;
                    if (this_$iv.isShowing()) break block3;
                    this_$iv.isShowing = true;
                    String string = ((Balloon)this_$iv).builder.preferenceName;
                    if (string == null) break block4;
                    String string2 = string;
                    boolean bl = false;
                    boolean bl2 = false;
                    String it$iv = string2;
                    boolean bl3 = false;
                    if (!this_$iv.balloonPreferenceManager.shouldShowUP(it$iv, ((Balloon)this_$iv).builder.showTimes)) break block5;
                    this_$iv.balloonPreferenceManager.putIncrementedTimes(it$iv);
                }
                anchor.post(new Runnable(this_$iv, this, anchor, xOff, yOff){
                    final /* synthetic */ Balloon this$0$inline_fun;
                    final /* synthetic */ Balloon this$0;
                    final /* synthetic */ View $anchor$inlined;
                    final /* synthetic */ int $xOff$inlined;
                    final /* synthetic */ int $yOff$inlined;
                    {
                        this.this$0$inline_fun = balloon2;
                        this.this$0 = balloon3;
                        this.$anchor$inlined = view;
                        this.$xOff$inlined = n;
                        this.$yOff$inlined = n2;
                    }

                    public final void run() {
                        Balloon.access$applyBalloonAnimation(this.this$0$inline_fun);
                        boolean bl = false;
                        Balloon.access$getBodyWindow$p(this.this$0).showAsDropDown(this.$anchor$inlined, this.$anchor$inlined.getMeasuredWidth() / 2 - this.this$0.getMeasureWidth() / 2 + this.$xOff$inlined, this.$yOff$inlined);
                    }
                });
                break block5;
            }
            if (((Balloon)this_$iv).builder.dismissWhenShowAgain) {
                this_$iv.dismiss();
            }
        }
    }

    public final void showAlignRight(@NotNull View anchor) {
        block5: {
            Balloon this_$iv;
            block3: {
                block4: {
                    Intrinsics.checkParameterIsNotNull((Object)anchor, (String)"anchor");
                    this_$iv = this;
                    boolean $i$f$show = false;
                    if (this_$iv.isShowing()) break block3;
                    this_$iv.isShowing = true;
                    String string = ((Balloon)this_$iv).builder.preferenceName;
                    if (string == null) break block4;
                    String string2 = string;
                    boolean bl = false;
                    boolean bl2 = false;
                    String it$iv = string2;
                    boolean bl3 = false;
                    if (!this_$iv.balloonPreferenceManager.shouldShowUP(it$iv, ((Balloon)this_$iv).builder.showTimes)) break block5;
                    this_$iv.balloonPreferenceManager.putIncrementedTimes(it$iv);
                }
                anchor.post(new Runnable(this_$iv, this, anchor){
                    final /* synthetic */ Balloon this$0$inline_fun;
                    final /* synthetic */ Balloon this$0;
                    final /* synthetic */ View $anchor$inlined;
                    {
                        this.this$0$inline_fun = balloon2;
                        this.this$0 = balloon3;
                        this.$anchor$inlined = view;
                    }

                    public final void run() {
                        Balloon.access$applyBalloonAnimation(this.this$0$inline_fun);
                        boolean bl = false;
                        Balloon.access$getBodyWindow$p(this.this$0).showAsDropDown(this.$anchor$inlined, this.$anchor$inlined.getMeasuredWidth(), -(Balloon.access$getBuilder$p((Balloon)this.this$0).height / 2) - this.$anchor$inlined.getMeasuredHeight() / 2);
                    }
                });
                break block5;
            }
            if (((Balloon)this_$iv).builder.dismissWhenShowAgain) {
                this_$iv.dismiss();
            }
        }
    }

    public final void showAlignRight(@NotNull View anchor, int xOff, int yOff) {
        block5: {
            Balloon this_$iv;
            block3: {
                block4: {
                    Intrinsics.checkParameterIsNotNull((Object)anchor, (String)"anchor");
                    this_$iv = this;
                    boolean $i$f$show = false;
                    if (this_$iv.isShowing()) break block3;
                    this_$iv.isShowing = true;
                    String string = ((Balloon)this_$iv).builder.preferenceName;
                    if (string == null) break block4;
                    String string2 = string;
                    boolean bl = false;
                    boolean bl2 = false;
                    String it$iv = string2;
                    boolean bl3 = false;
                    if (!this_$iv.balloonPreferenceManager.shouldShowUP(it$iv, ((Balloon)this_$iv).builder.showTimes)) break block5;
                    this_$iv.balloonPreferenceManager.putIncrementedTimes(it$iv);
                }
                anchor.post(new Runnable(this_$iv, this, anchor, xOff, yOff){
                    final /* synthetic */ Balloon this$0$inline_fun;
                    final /* synthetic */ Balloon this$0;
                    final /* synthetic */ View $anchor$inlined;
                    final /* synthetic */ int $xOff$inlined;
                    final /* synthetic */ int $yOff$inlined;
                    {
                        this.this$0$inline_fun = balloon2;
                        this.this$0 = balloon3;
                        this.$anchor$inlined = view;
                        this.$xOff$inlined = n;
                        this.$yOff$inlined = n2;
                    }

                    public final void run() {
                        Balloon.access$applyBalloonAnimation(this.this$0$inline_fun);
                        boolean bl = false;
                        Balloon.access$getBodyWindow$p(this.this$0).showAsDropDown(this.$anchor$inlined, this.$anchor$inlined.getMeasuredWidth() + this.$xOff$inlined, -(Balloon.access$getBuilder$p((Balloon)this.this$0).height / 2) - this.$anchor$inlined.getMeasuredHeight() / 2 + this.$yOff$inlined);
                    }
                });
                break block5;
            }
            if (((Balloon)this_$iv).builder.dismissWhenShowAgain) {
                this_$iv.dismiss();
            }
        }
    }

    public final void showAlignLeft(@NotNull View anchor) {
        block5: {
            Balloon this_$iv;
            block3: {
                block4: {
                    Intrinsics.checkParameterIsNotNull((Object)anchor, (String)"anchor");
                    this_$iv = this;
                    boolean $i$f$show = false;
                    if (this_$iv.isShowing()) break block3;
                    this_$iv.isShowing = true;
                    String string = ((Balloon)this_$iv).builder.preferenceName;
                    if (string == null) break block4;
                    String string2 = string;
                    boolean bl = false;
                    boolean bl2 = false;
                    String it$iv = string2;
                    boolean bl3 = false;
                    if (!this_$iv.balloonPreferenceManager.shouldShowUP(it$iv, ((Balloon)this_$iv).builder.showTimes)) break block5;
                    this_$iv.balloonPreferenceManager.putIncrementedTimes(it$iv);
                }
                anchor.post(new Runnable(this_$iv, this, anchor){
                    final /* synthetic */ Balloon this$0$inline_fun;
                    final /* synthetic */ Balloon this$0;
                    final /* synthetic */ View $anchor$inlined;
                    {
                        this.this$0$inline_fun = balloon2;
                        this.this$0 = balloon3;
                        this.$anchor$inlined = view;
                    }

                    public final void run() {
                        Balloon.access$applyBalloonAnimation(this.this$0$inline_fun);
                        boolean bl = false;
                        Balloon.access$getBodyWindow$p(this.this$0).showAsDropDown(this.$anchor$inlined, -this.this$0.getMeasureWidth(), -(Balloon.access$getBuilder$p((Balloon)this.this$0).height / 2) - this.$anchor$inlined.getMeasuredHeight() / 2);
                    }
                });
                break block5;
            }
            if (((Balloon)this_$iv).builder.dismissWhenShowAgain) {
                this_$iv.dismiss();
            }
        }
    }

    public final void showAlignLeft(@NotNull View anchor, int xOff, int yOff) {
        block5: {
            Balloon this_$iv;
            block3: {
                block4: {
                    Intrinsics.checkParameterIsNotNull((Object)anchor, (String)"anchor");
                    this_$iv = this;
                    boolean $i$f$show = false;
                    if (this_$iv.isShowing()) break block3;
                    this_$iv.isShowing = true;
                    String string = ((Balloon)this_$iv).builder.preferenceName;
                    if (string == null) break block4;
                    String string2 = string;
                    boolean bl = false;
                    boolean bl2 = false;
                    String it$iv = string2;
                    boolean bl3 = false;
                    if (!this_$iv.balloonPreferenceManager.shouldShowUP(it$iv, ((Balloon)this_$iv).builder.showTimes)) break block5;
                    this_$iv.balloonPreferenceManager.putIncrementedTimes(it$iv);
                }
                anchor.post(new Runnable(this_$iv, this, anchor, xOff, yOff){
                    final /* synthetic */ Balloon this$0$inline_fun;
                    final /* synthetic */ Balloon this$0;
                    final /* synthetic */ View $anchor$inlined;
                    final /* synthetic */ int $xOff$inlined;
                    final /* synthetic */ int $yOff$inlined;
                    {
                        this.this$0$inline_fun = balloon2;
                        this.this$0 = balloon3;
                        this.$anchor$inlined = view;
                        this.$xOff$inlined = n;
                        this.$yOff$inlined = n2;
                    }

                    public final void run() {
                        Balloon.access$applyBalloonAnimation(this.this$0$inline_fun);
                        boolean bl = false;
                        Balloon.access$getBodyWindow$p(this.this$0).showAsDropDown(this.$anchor$inlined, -this.this$0.getMeasureWidth() + this.$xOff$inlined, -(Balloon.access$getBuilder$p((Balloon)this.this$0).height / 2) - this.$anchor$inlined.getMeasuredHeight() / 2 + this.$yOff$inlined);
                    }
                });
                break block5;
            }
            if (((Balloon)this_$iv).builder.dismissWhenShowAgain) {
                this_$iv.dismiss();
            }
        }
    }

    public final void dismiss() {
        if (this.isShowing) {
            this.bodyWindow.dismiss();
            this.isShowing = false;
        }
    }

    public final int getMeasureWidth() {
        if (this.builder.widthRatio != 0.0f) {
            return (int)((float)ContextExtensionKt.displaySize((Context)this.context).x * this.builder.widthRatio - (float)this.builder.space);
        }
        return this.builder.width - this.builder.space;
    }

    @NotNull
    public final View getContentView() {
        LinearLayout linearLayout = (LinearLayout)this.bodyView.findViewById(R.id.balloon_detail);
        Intrinsics.checkExpressionValueIsNotNull((Object)linearLayout, (String)"bodyView.balloon_detail");
        return (View)linearLayout;
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_DESTROY)
    public final void onDestroy() {
        this.dismiss();
    }

    public Balloon(@NotNull Context context, @NotNull Builder builder) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        this.context = context;
        this.builder = builder;
        this.balloonPreferenceManager = new BalloonPreferenceManager(this.context).getInstance();
        Object object = this.context.getSystemService("layout_inflater");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.view.LayoutInflater");
        }
        LayoutInflater inflater = (LayoutInflater)object;
        View view = inflater.inflate(R.layout.layout_balloon, null);
        Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"inflater.inflate(R.layout.layout_balloon, null)");
        this.bodyView = view;
        int width = this.getMeasureWidth();
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(width, this.builder.height);
        this.bodyView.setLayoutParams((ViewGroup.LayoutParams)params);
        this.bodyWindow = new PopupWindow(this.bodyView, width, this.builder.height);
        this.createByBuilder();
    }

    public static final /* synthetic */ boolean access$isShowing$p(Balloon $this) {
        return $this.isShowing;
    }

    public static final /* synthetic */ void access$applyBalloonAnimation(Balloon $this) {
        $this.applyBalloonAnimation();
    }

    public static final /* synthetic */ PopupWindow access$getBodyWindow$p(Balloon $this) {
        return $this.bodyWindow;
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    @BalloonDsl
    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\f\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010:\u001a\u00020;J\u0010\u0010\t\u001a\u00020\u00002\b\b\u0001\u0010<\u001a\u00020\u0006J\u0010\u0010=\u001a\u00020\u00002\b\u0010<\u001a\u0004\u0018\u00010\fJ\u000e\u0010>\u001a\u00020\u00002\u0006\u0010<\u001a\u00020\u0011J\u000e\u0010?\u001a\u00020\u00002\u0006\u0010<\u001a\u00020\u000eJ\u0010\u0010@\u001a\u00020\u00002\b\b\u0001\u0010<\u001a\u00020\u0006J\u000e\u0010A\u001a\u00020\u00002\u0006\u0010<\u001a\u00020\u0011J\u000e\u0010B\u001a\u00020\u00002\u0006\u0010<\u001a\u00020\u0013J\u0010\u0010C\u001a\u00020\u00002\b\b\u0001\u0010<\u001a\u00020\u0011J\u000e\u0010D\u001a\u00020\u00002\u0006\u0010<\u001a\u00020\u0011J\u0010\u0010E\u001a\u00020\u00002\b\u0010<\u001a\u0004\u0018\u00010\fJ\u000e\u0010F\u001a\u00020\u00002\u0006\u0010<\u001a\u00020\u0011J\u000e\u0010G\u001a\u00020\u00002\u0006\u0010<\u001a\u00020\u0017J\u000e\u0010H\u001a\u00020\u00002\u0006\u0010<\u001a\u00020\u0006J\u000e\u0010I\u001a\u00020\u00002\u0006\u0010<\u001a\u00020\u0013J\u000e\u0010J\u001a\u00020\u00002\u0006\u0010<\u001a\u00020\u0013J\u000e\u0010K\u001a\u00020\u00002\u0006\u0010<\u001a\u00020\u0013J\u000e\u0010L\u001a\u00020\u00002\u0006\u0010<\u001a\u00020\u0011J\u0010\u0010M\u001a\u00020\u00002\b\b\u0001\u0010<\u001a\u00020\u0011J\u0010\u0010N\u001a\u00020\u00002\b\b\u0001\u0010<\u001a\u00020\u0011J\u0010\u0010O\u001a\u00020\u00002\b\u0010<\u001a\u0004\u0018\u00010\fJ\u000e\u0010P\u001a\u00020\u00002\u0006\u0010<\u001a\u00020\u0011J\u000e\u0010Q\u001a\u00020\u00002\u0006\u0010<\u001a\u00020 J\u000e\u0010R\u001a\u00020\u00002\u0006\u0010<\u001a\u00020\u0011J\u000e\u0010S\u001a\u00020\u00002\u0006\u0010<\u001a\u00020\u0011J\u0010\u0010T\u001a\u00020\u00002\b\b\u0001\u0010#\u001a\u00020\u0011J\u000e\u0010U\u001a\u00020\u00002\u0006\u0010<\u001a\u00020%J\u001a\u0010V\u001a\u00020\u00002\u0012\u0010W\u001a\u000e\u0012\u0004\u0012\u00020Y\u0012\u0004\u0012\u00020Z0XJ\u000e\u0010V\u001a\u00020\u00002\u0006\u0010<\u001a\u00020'J\u0014\u0010[\u001a\u00020\u00002\f\u0010W\u001a\b\u0012\u0004\u0012\u00020Z0\\J\u000e\u0010[\u001a\u00020\u00002\u0006\u0010<\u001a\u00020)J \u0010]\u001a\u00020\u00002\u0018\u0010W\u001a\u0014\u0012\u0004\u0012\u00020Y\u0012\u0004\u0012\u00020_\u0012\u0004\u0012\u00020Z0^J\u000e\u0010]\u001a\u00020\u00002\u0006\u0010<\u001a\u00020+J\u000e\u0010`\u001a\u00020\u00002\u0006\u0010<\u001a\u00020-J\u000e\u0010a\u001a\u00020\u00002\u0006\u0010<\u001a\u00020\u0011J\u000e\u0010b\u001a\u00020\u00002\u0006\u0010<\u001a\u00020\u0011J\u000e\u0010c\u001a\u00020\u00002\u0006\u0010<\u001a\u00020-J\u0010\u0010d\u001a\u00020\u00002\b\b\u0001\u0010<\u001a\u00020\u0011J\u000e\u0010e\u001a\u00020\u00002\u0006\u0010<\u001a\u00020\u0011J\u000e\u0010f\u001a\u00020\u00002\u0006\u0010<\u001a\u000203J\u000e\u0010g\u001a\u00020\u00002\u0006\u0010<\u001a\u00020\u0006J\u000e\u0010h\u001a\u00020\u00002\u0006\u0010<\u001a\u000207J\u000e\u0010h\u001a\u00020\u00002\u0006\u0010<\u001a\u00020\u0011J\u000e\u0010i\u001a\u00020\u00002\u0006\u0010<\u001a\u00020\u0011J\u0010\u0010j\u001a\u00020\u00002\b\b\u0001\u0010<\u001a\u00020\u0006R\u001e\u0010\u0005\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u0004\u0018\u00010\f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\r\u001a\u00020\u000e8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000f\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0010\u001a\u00020\u00118\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0012\u001a\u00020\u00138\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0014\u001a\u00020\u00118\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u0004\u0018\u00010\f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0016\u001a\u00020\u00178\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0018\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0019\u001a\u00020\u00138\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001a\u001a\u00020\u00138\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001b\u001a\u00020\u00138\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001c\u001a\u00020\u00118\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001d\u001a\u00020\u00118\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\u0004\u0018\u00010\f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\u0004\u0018\u00010 8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010!\u001a\u00020\u00118\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\"\u001a\u00020\u00118\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010#\u001a\u00020\u00118\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010$\u001a\u0004\u0018\u00010%8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010&\u001a\u0004\u0018\u00010'8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010(\u001a\u0004\u0018\u00010)8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010*\u001a\u0004\u0018\u00010+8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010,\u001a\u0004\u0018\u00010-8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010.\u001a\u00020\u00118\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010/\u001a\u00020\u00118\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u00100\u001a\u00020-8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u00101\u001a\u00020\u00118\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u00102\u001a\u0004\u0018\u0001038\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u00104\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u00105\u001a\u00020\u00118\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u00106\u001a\u0004\u0018\u0001078\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u00108\u001a\u00020\u00118\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u00109\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006k"}, d2={"Lcom/skydoves/balloon/Balloon$Builder;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "alpha", "", "getAlpha", "()F", "setAlpha", "(F)V", "arrowDrawable", "Landroid/graphics/drawable/Drawable;", "arrowOrientation", "Lcom/skydoves/balloon/ArrowOrientation;", "arrowPosition", "arrowSize", "", "arrowVisible", "", "backgroundColor", "backgroundDrawable", "balloonAnimation", "Lcom/skydoves/balloon/BalloonAnimation;", "cornerRadius", "dismissWhenClicked", "dismissWhenShowAgain", "dismissWhenTouchOutside", "height", "iconColor", "iconDrawable", "iconForm", "Lcom/skydoves/balloon/IconForm;", "iconSize", "iconSpace", "layout", "lifecycleOwner", "Landroidx/lifecycle/LifecycleOwner;", "onBalloonClickListener", "Lcom/skydoves/balloon/OnBalloonClickListener;", "onBalloonDismissListener", "Lcom/skydoves/balloon/OnBalloonDismissListener;", "onBalloonOutsideTouchListener", "Lcom/skydoves/balloon/OnBalloonOutsideTouchListener;", "preferenceName", "", "showTimes", "space", "text", "textColor", "textForm", "Lcom/skydoves/balloon/TextForm;", "textSize", "textTypeface", "textTypefaceObject", "Landroid/graphics/Typeface;", "width", "widthRatio", "build", "Lcom/skydoves/balloon/Balloon;", "value", "setArrowDrawable", "setArrowDrawableResource", "setArrowOrientation", "setArrowPosition", "setArrowSize", "setArrowVisible", "setBackgroundColor", "setBackgroundColorResource", "setBackgroundDrawable", "setBackgroundDrawableResource", "setBalloonAnimation", "setCornerRadius", "setDismissWhenClicked", "setDismissWhenShowAgain", "setDismissWhenTouchOutside", "setHeight", "setIconColor", "setIconColorResource", "setIconDrawable", "setIconDrawableResource", "setIconForm", "setIconSize", "setIconSpace", "setLayout", "setLifecycleOwner", "setOnBalloonClickListener", "unit", "Lkotlin/Function1;", "Landroid/view/View;", "", "setOnBalloonDismissListener", "Lkotlin/Function0;", "setOnBalloonOutsideTouchListener", "Lkotlin/Function2;", "Landroid/view/MotionEvent;", "setPreferenceName", "setShowTime", "setSpace", "setText", "setTextColor", "setTextColorResource", "setTextForm", "setTextSize", "setTextTypeface", "setWidth", "setWidthRatio", "balloon_release"})
    public static final class Builder {
        @JvmField
        public int width;
        @JvmField
        @FloatRange(from=0.0, to=1.0)
        public float widthRatio;
        @JvmField
        public int height;
        @JvmField
        public int space;
        @JvmField
        public boolean arrowVisible;
        @JvmField
        public int arrowSize;
        @JvmField
        @FloatRange(from=0.0, to=1.0)
        public float arrowPosition;
        @JvmField
        @NotNull
        public ArrowOrientation arrowOrientation;
        @JvmField
        @Nullable
        public Drawable arrowDrawable;
        @JvmField
        @ColorInt
        public int backgroundColor;
        @JvmField
        @Nullable
        public Drawable backgroundDrawable;
        @JvmField
        public float cornerRadius;
        @JvmField
        @NotNull
        public String text;
        @JvmField
        @ColorInt
        public int textColor;
        @JvmField
        public float textSize;
        @JvmField
        public int textTypeface;
        @JvmField
        @Nullable
        public Typeface textTypefaceObject;
        @JvmField
        @Nullable
        public TextForm textForm;
        @JvmField
        @Nullable
        public Drawable iconDrawable;
        @JvmField
        public int iconSize;
        @JvmField
        public int iconSpace;
        @JvmField
        @ColorInt
        public int iconColor;
        @JvmField
        @Nullable
        public IconForm iconForm;
        @FloatRange(from=0.0, to=1.0)
        private float alpha;
        @JvmField
        @LayoutRes
        public int layout;
        @JvmField
        @Nullable
        public OnBalloonClickListener onBalloonClickListener;
        @JvmField
        @Nullable
        public OnBalloonDismissListener onBalloonDismissListener;
        @JvmField
        @Nullable
        public OnBalloonOutsideTouchListener onBalloonOutsideTouchListener;
        @JvmField
        public boolean dismissWhenTouchOutside;
        @JvmField
        public boolean dismissWhenShowAgain;
        @JvmField
        public boolean dismissWhenClicked;
        @JvmField
        @Nullable
        public LifecycleOwner lifecycleOwner;
        @JvmField
        @NotNull
        public BalloonAnimation balloonAnimation;
        @JvmField
        @Nullable
        public String preferenceName;
        @JvmField
        public int showTimes;
        private final Context context;

        public final float getAlpha() {
            return this.alpha;
        }

        public final void setAlpha(float f) {
            this.alpha = f;
        }

        @NotNull
        public final Builder setWidth(int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.width = ContextExtensionKt.dp2Px($this$apply.context, value2);
            return builder;
        }

        @NotNull
        public final Builder setWidthRatio(@FloatRange(from=0.0, to=1.0) float value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.widthRatio = value2;
            return builder;
        }

        @NotNull
        public final Builder setHeight(int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.height = ContextExtensionKt.dp2Px($this$apply.context, value2);
            return builder;
        }

        @NotNull
        public final Builder setSpace(int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.space = ContextExtensionKt.dp2Px($this$apply.context, value2);
            return builder;
        }

        @NotNull
        public final Builder setArrowVisible(boolean value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.arrowVisible = value2;
            return builder;
        }

        @NotNull
        public final Builder setArrowSize(int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.arrowSize = ContextExtensionKt.dp2Px($this$apply.context, value2);
            return builder;
        }

        @NotNull
        public final Builder setArrowPosition(@FloatRange(from=0.0, to=1.0) float value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.arrowPosition = value2;
            return builder;
        }

        @NotNull
        public final Builder setArrowOrientation(@NotNull ArrowOrientation value2) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)value2), (String)"value");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.arrowOrientation = value2;
            return builder;
        }

        @NotNull
        public final Builder setArrowDrawable(@Nullable Drawable value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.arrowDrawable = value2;
            return builder;
        }

        @NotNull
        public final Builder setArrowDrawableResource(int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.arrowDrawable = ContextExtensionKt.contextDrawable($this$apply.context, value2);
            return builder;
        }

        @NotNull
        public final Builder setBackgroundColor(@ColorInt int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.backgroundColor = value2;
            return builder;
        }

        @NotNull
        public final Builder setBackgroundColorResource(int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.backgroundColor = ContextExtensionKt.contextColor($this$apply.context, value2);
            return builder;
        }

        @NotNull
        public final Builder setBackgroundDrawable(@Nullable Drawable value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.backgroundDrawable = value2;
            return builder;
        }

        @NotNull
        public final Builder setBackgroundDrawableResource(int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.backgroundDrawable = ContextExtensionKt.contextDrawable($this$apply.context, value2);
            return builder;
        }

        @NotNull
        public final Builder setCornerRadius(float value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.cornerRadius = ContextExtensionKt.dp2Px($this$apply.context, value2);
            return builder;
        }

        @NotNull
        public final Builder setText(@NotNull String value2) {
            Intrinsics.checkParameterIsNotNull((Object)value2, (String)"value");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.text = value2;
            return builder;
        }

        @NotNull
        public final Builder setTextColor(@ColorInt int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.textColor = value2;
            return builder;
        }

        @NotNull
        public final Builder setTextColorResource(int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.textColor = ContextExtensionKt.contextColor($this$apply.context, value2);
            return builder;
        }

        @NotNull
        public final Builder setTextSize(float value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.textSize = value2;
            return builder;
        }

        @NotNull
        public final Builder setTextTypeface(int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.textTypeface = value2;
            return builder;
        }

        @NotNull
        public final Builder setTextTypeface(@NotNull Typeface value2) {
            Intrinsics.checkParameterIsNotNull((Object)value2, (String)"value");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.textTypefaceObject = value2;
            return builder;
        }

        @NotNull
        public final Builder setTextForm(@NotNull TextForm value2) {
            Intrinsics.checkParameterIsNotNull((Object)value2, (String)"value");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.textForm = value2;
            return builder;
        }

        @NotNull
        public final Builder setIconDrawable(@Nullable Drawable value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.iconDrawable = value2;
            return builder;
        }

        @NotNull
        public final Builder setIconDrawableResource(int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.iconDrawable = ContextExtensionKt.contextDrawable($this$apply.context, value2);
            return builder;
        }

        @NotNull
        public final Builder setIconSize(int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.iconSize = ContextExtensionKt.dp2Px($this$apply.context, value2);
            return builder;
        }

        @NotNull
        public final Builder setIconColor(@ColorInt int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.iconColor = value2;
            return builder;
        }

        @NotNull
        public final Builder setIconColorResource(@ColorInt int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.iconColor = ContextExtensionKt.contextColor($this$apply.context, value2);
            return builder;
        }

        @NotNull
        public final Builder setIconSpace(int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.iconSpace = ContextExtensionKt.dp2Px($this$apply.context, value2);
            return builder;
        }

        @NotNull
        public final Builder setIconForm(@NotNull IconForm value2) {
            Intrinsics.checkParameterIsNotNull((Object)value2, (String)"value");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.iconForm = value2;
            return builder;
        }

        @NotNull
        public final Builder setAlpha(@FloatRange(from=0.0, to=1.0) float value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.alpha = value2;
            return builder;
        }

        @NotNull
        public final Builder setLayout(@LayoutRes int layout) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.layout = layout;
            return builder;
        }

        @NotNull
        public final Builder setLifecycleOwner(@NotNull LifecycleOwner value2) {
            Intrinsics.checkParameterIsNotNull((Object)value2, (String)"value");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.lifecycleOwner = value2;
            return builder;
        }

        @NotNull
        public final Builder setBalloonAnimation(@NotNull BalloonAnimation value2) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)value2), (String)"value");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.balloonAnimation = value2;
            return builder;
        }

        @NotNull
        public final Builder setOnBalloonClickListener(@NotNull OnBalloonClickListener value2) {
            Intrinsics.checkParameterIsNotNull((Object)value2, (String)"value");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.onBalloonClickListener = value2;
            return builder;
        }

        @NotNull
        public final Builder setOnBalloonDismissListener(@NotNull OnBalloonDismissListener value2) {
            Intrinsics.checkParameterIsNotNull((Object)value2, (String)"value");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.onBalloonDismissListener = value2;
            return builder;
        }

        @NotNull
        public final Builder setOnBalloonOutsideTouchListener(@NotNull OnBalloonOutsideTouchListener value2) {
            Intrinsics.checkParameterIsNotNull((Object)value2, (String)"value");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.onBalloonOutsideTouchListener = value2;
            return builder;
        }

        @NotNull
        public final Builder setOnBalloonClickListener(@NotNull Function1<? super View, Unit> unit) {
            Intrinsics.checkParameterIsNotNull(unit, (String)"unit");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.onBalloonClickListener = new OnBalloonClickListener(unit){
                final /* synthetic */ Function1 $unit$inlined;
                {
                    this.$unit$inlined = function1;
                }

                public void onBalloonClick(@NotNull View view) {
                    Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
                    this.$unit$inlined.invoke((Object)view);
                }
            };
            return builder;
        }

        @NotNull
        public final Builder setOnBalloonDismissListener(@NotNull Function0<Unit> unit) {
            Intrinsics.checkParameterIsNotNull(unit, (String)"unit");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.onBalloonDismissListener = new OnBalloonDismissListener(unit){
                final /* synthetic */ Function0 $unit$inlined;
                {
                    this.$unit$inlined = function0;
                }

                public void onBalloonDismiss() {
                    this.$unit$inlined.invoke();
                }
            };
            return builder;
        }

        @NotNull
        public final Builder setOnBalloonOutsideTouchListener(@NotNull Function2<? super View, ? super MotionEvent, Unit> unit) {
            Intrinsics.checkParameterIsNotNull(unit, (String)"unit");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.onBalloonOutsideTouchListener = new OnBalloonOutsideTouchListener(unit){
                final /* synthetic */ Function2 $unit$inlined;
                {
                    this.$unit$inlined = function2;
                }

                public void onBalloonOutsideTouch(@NotNull View view, @NotNull MotionEvent event) {
                    Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
                    Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                    this.$unit$inlined.invoke((Object)view, (Object)event);
                }
            };
            return builder;
        }

        @NotNull
        public final Builder setDismissWhenTouchOutside(boolean value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.dismissWhenTouchOutside = value2;
            return builder;
        }

        @NotNull
        public final Builder setDismissWhenShowAgain(boolean value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.dismissWhenShowAgain = value2;
            return builder;
        }

        @NotNull
        public final Builder setDismissWhenClicked(boolean value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.dismissWhenClicked = value2;
            return builder;
        }

        @NotNull
        public final Builder setPreferenceName(@NotNull String value2) {
            Intrinsics.checkParameterIsNotNull((Object)value2, (String)"value");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.preferenceName = value2;
            return builder;
        }

        @NotNull
        public final Builder setShowTime(int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.showTimes = value2;
            return builder;
        }

        @NotNull
        public final Balloon build() {
            return new Balloon(this.context, this);
        }

        public Builder(@NotNull Context context) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            this.context = context;
            this.width = ContextExtensionKt.displaySize((Context)this.context).x;
            this.height = ContextExtensionKt.dp2Px(this.context, 60);
            this.arrowVisible = true;
            this.arrowSize = ContextExtensionKt.dp2Px(this.context, 15);
            this.arrowPosition = 0.5f;
            this.arrowOrientation = ArrowOrientation.BOTTOM;
            this.backgroundColor = -16777216;
            this.cornerRadius = ContextExtensionKt.dp2Px(this.context, 5);
            this.text = "";
            this.textColor = -1;
            this.textSize = 12.0f;
            this.iconSize = ContextExtensionKt.dp2Px(this.context, 28);
            this.iconSpace = ContextExtensionKt.dp2Px(this.context, 8);
            this.iconColor = -1;
            this.alpha = 1.0f;
            this.layout = -1;
            this.balloonAnimation = BalloonAnimation.FADE;
            this.showTimes = 1;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH&\u00a8\u0006\t"}, d2={"Lcom/skydoves/balloon/Balloon$Factory;", "", "()V", "create", "Lcom/skydoves/balloon/Balloon;", "context", "Landroid/content/Context;", "lifecycle", "Landroidx/lifecycle/LifecycleOwner;", "balloon_release"})
    public static abstract class Factory {
        @NotNull
        public abstract Balloon create(@NotNull Context var1, @NotNull LifecycleOwner var2);
    }
}

