/*
 * Decompiled with CFR 0.152.
 */
package org.sindaryn.mockeri.service;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.sindaryn.mockeri.service.CustomKeywords;
import org.sindaryn.mockeri.service.MockFactory;
import org.sindaryn.mockeri.service.NullCustomKeywords;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="CustomizedMockers")
public class CustomizedMockers {
    @Autowired
    private List<? extends MockFactory> mockFactories;
    @Autowired
    private List<? extends CustomKeywords> customKeywords;
    private static Map<String, List<Object>> customKeywordsMap;
    private static Map<String, MockFactory> factoryMap;

    public static List<Object> getCustomKeyword(String keyword) {
        List<Object> result = customKeywordsMap.get(keyword);
        if (result != null) {
            return result;
        }
        throw new RuntimeException("cannot find custom dataset for keyword: " + keyword);
    }

    @PostConstruct
    private void init() {
        this.initMockFactories();
        this.initCustomKeywords();
    }

    private void initCustomKeywords() {
        customKeywordsMap = new HashMap<String, List<Object>>();
        this.customKeywords.forEach(customKeywords -> {
            if (!customKeywords.getClass().equals(NullCustomKeywords.class)) {
                Iterator<Map.Entry<String, List<Object>>> iterator = customKeywords.customKeywords().entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, List<Object>> keyword;
                    Map.Entry<String, List<Object>> keywordEntry = keyword = iterator.next();
                    customKeywordsMap.putIfAbsent(keywordEntry.getKey().toUpperCase(), keywordEntry.getValue());
                }
            }
        });
    }

    private void initMockFactories() {
        factoryMap = new HashMap<String, MockFactory>();
        this.mockFactories.forEach(mockFactory -> {
            if (!mockFactory.getClass().equals(MockFactory.class)) {
                factoryMap.put(mockFactory.key(), (MockFactory)mockFactory);
            }
        });
    }

    public static MockFactory getMockFactory(String typeName) {
        MockFactory result = factoryMap.get(typeName);
        if (result != null) {
            return result;
        }
        throw new RuntimeException("cannot find mock factory implementation for type: " + typeName);
    }

    public List<? extends MockFactory> getMockFactories() {
        return this.mockFactories;
    }
}

