/*
 * Decompiled with CFR 0.152.
 */
package org.sindaryn.mockeri.generator;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.sindaryn.datafi.reflection.CachedEntityType;
import org.sindaryn.datafi.reflection.ReflectionCache;
import org.sindaryn.datafi.service.DataManager;
import org.sindaryn.mockeri.StaticUtils;
import org.sindaryn.mockeri.annotations.MockData;
import org.sindaryn.mockeri.generator.TestDataGenerator;
import org.sindaryn.mockeri.meta.CircularReferenceException;
import org.sindaryn.mockeri.meta.CollectionInstantiator;
import org.sindaryn.mockeri.meta.FieldMetaInfo;
import org.sindaryn.mockeri.meta.FieldMetaInfoFactory;
import org.sindaryn.mockeri.service.CustomizedMockers;
import org.sindaryn.mockeri.service.MockFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Component;

@Transactional
@Component(value="EntityMocker")
@DependsOn(value={"CustomizedMockers"})
public class EntityMocker {
    @Autowired
    private ReflectionCache reflectionCache;
    @Autowired
    private TestDataGenerator testData;
    @Autowired
    private DataManager dataManager;
    @Autowired
    private FieldMetaInfoFactory fieldMetaInfoFactory;
    @Autowired
    private CollectionInstantiator collectionInstantiator;
    private static final Logger logger = Logger.getLogger(EntityMocker.class);

    public <T> T instantiateEntity(Class<?> clazz) {
        return this.instantiateEntity(clazz, (Map<String, Object>)new HashMap<String, Object>(){
            {
                this.put("INSTANTIATION_STACK", new Stack());
            }
        });
    }

    public <T> T instantiateEntity(String clazzName) {
        return this.instantiateEntity(((CachedEntityType)this.reflectionCache.getEntitiesCache().get(clazzName)).getClazz());
    }

    public <T> T instantiateTransientEntity(Class<?> clazz) {
        return this.instantiateEntity(clazz, (Map<String, Object>)new HashMap<String, Object>(){
            {
                this.put("INSTANTIATION_STACK", new Stack());
                this.put("NO_PERSIST", true);
            }
        });
    }

    public Object mockFieldValue(Class<?> clazz, String fieldName) {
        Object instance = ((CachedEntityType)this.reflectionCache.getEntitiesCache().get(clazz.getSimpleName())).getDefaultInstance();
        Collection fields = ReflectionCache.getClassFields(instance.getClass());
        Field field = null;
        for (Field aField : fields) {
            if (!aField.getName().equals(fieldName)) continue;
            field = aField;
            break;
        }
        if (field == null) {
            throw new IllegalArgumentException("Cannot find field by name " + fieldName + " in " + instance.getClass().getSimpleName());
        }
        this.assignFieldValue(field, instance, (Map<String, Object>)new HashMap<String, Object>(){
            {
                this.put("INSTANTIATION_STACK", new Stack());
                this.put("NO_PERSIST", true);
            }
        });
        return ((CachedEntityType)this.reflectionCache.getEntitiesCache().get(instance.getClass().getSimpleName())).invokeGetter(instance, field.getName());
    }

    public <T> T mockUpdate(Object toMockUpdate) {
        Class<?> clazz = toMockUpdate.getClass();
        Object other = this.instantiateTransientEntity(toMockUpdate.getClass());
        ReflectionCache.getClassFields(clazz).forEach(field -> {
            FieldMetaInfo fieldMetaInfo = this.fieldMetaInfoFactory.fieldMetaInfo(toMockUpdate, (Field)field);
            if (fieldMetaInfo.isUpdatable()) {
                this.setField(toMockUpdate, (Field)field, ((CachedEntityType)this.reflectionCache.getEntitiesCache().get(clazz.getSimpleName())).invokeGetter(other, field.getName()));
            }
        });
        return (T)toMockUpdate;
    }

    private <T> T instantiateEntity(Class<?> clazz, Map<String, Object> args) {
        Stack instantiationStack = (Stack)args.get("INSTANTIATION_STACK");
        if (instantiationStack.contains(clazz)) {
            return this.preExistingInstance(clazz, args);
        }
        String indentation = this.indentation(instantiationStack);
        this.log(indentation + "Instantiating " + clazz.getSimpleName());
        Object instance = CachedEntityType.genDefaultInstance(clazz);
        instantiationStack.push(clazz);
        ReflectionCache.getClassFields(clazz).forEach(field -> this.assignFieldValue((Field)field, instance, args));
        instantiationStack.pop();
        if (args.get("NO_PERSIST") == null) {
            this.log(indentation + "Persisting instance of " + clazz.getSimpleName());
            return (T)this.dataManager.save(instance);
        }
        this.log(indentation + "Returning transient instance of " + clazz.getSimpleName());
        return (T)instance;
    }

    private void assignFieldValue(Field field, Object parent, Map<String, Object> args) {
        FieldMetaInfo fieldMetaInfo = this.fieldMetaInfoFactory.fieldMetaInfo(parent, field);
        if (!fieldMetaInfo.isToInstantiate()) {
            return;
        }
        switch (fieldMetaInfo.getMockDataSource()) {
            case DEFAULT: {
                this.autoAssign(field, parent, fieldMetaInfo, args);
                break;
            }
            case KEYWORD: {
                this.assignFromKeyword(field, parent);
                break;
            }
            case CUSTOM_KEYWORD: {
                this.assignFromCustomKeyword(field, parent);
                break;
            }
            case OF_SET: {
                this.assignFromOfSet(field, parent);
                break;
            }
            case MIN_MAX_RANGE: {
                this.assignFromMinMaxRange(field, parent);
                break;
            }
            case MOCK_FACTORY: {
                this.assignFromMockFactory(field, parent);
            }
        }
    }

    private void autoAssign(Field field, Object parent, FieldMetaInfo fieldMetaInfo, Map<String, Object> args) {
        switch (fieldMetaInfo.getFieldReferenceType()) {
            case SINGLE_PRIMITIVE: {
                this.autoAssignSinglePrimitive(field, parent);
                break;
            }
            case PRIMITIVE_COLLECTION: {
                this.autoAssignPrimitivesCollection(field, parent);
                break;
            }
            case SINGLE_FOREIGN_KEY: {
                this.autoAssignSingleForeignKey(field, parent, fieldMetaInfo, args);
                break;
            }
            case FOREIGN_KEY_COLLECTION: {
                this.autoAssignForeignKeyCollection(field, parent, fieldMetaInfo, args);
            }
        }
    }

    private void autoAssignForeignKeyCollection(Field field, Object parent, FieldMetaInfo fieldMetaInfo, Map<String, Object> args) {
        if (args.get("NO_PERSIST") != null && fieldMetaInfo.isOptional()) {
            return;
        }
        Class<?> collectibleType = StaticUtils.collectibleType(field, this.reflectionCache);
        Collection values = this.collectionInstantiator.instantiateCollection(field.getType(), collectibleType);
        HashMap<Object, Object> valuesMap = new HashMap<Object, Object>();
        for (int i = 0; i < ThreadLocalRandom.current().nextInt(5, 10); ++i) {
            Object value = this.instantiateEntity(collectibleType, args);
            if (value == null) continue;
            valuesMap.putIfAbsent(org.sindaryn.datafi.StaticUtils.getId(value, (ReflectionCache)this.reflectionCache), value);
        }
        this.removeAnyCircularSelfReference(valuesMap, parent);
        values.addAll(valuesMap.values());
        if (values.isEmpty() && !fieldMetaInfo.isOptional()) {
            CircularReferenceException.throwGeneralCircularReferenceException(field, parent);
        }
        this.setField(parent, field, values);
    }

    private void removeAnyCircularSelfReference(Map<Object, Object> valuesMap, Object parent) {
        Object parentId = org.sindaryn.datafi.StaticUtils.getId((Object)parent, (ReflectionCache)this.reflectionCache);
        if (valuesMap.get(parentId) != null) {
            valuesMap.remove(parentId);
        }
    }

    private void autoAssignSingleForeignKey(Field field, Object parent, FieldMetaInfo fieldMetaInfo, Map<String, Object> args) {
        if (args.get("NO_PERSIST") != null && fieldMetaInfo.isOptional()) {
            return;
        }
        Object value = this.instantiateEntity(field.getType(), args);
        if (value == null && !fieldMetaInfo.isOptional()) {
            CircularReferenceException.throwGeneralCircularReferenceException(field, parent);
        }
        if (this.isCircularSelfReference(parent, value)) {
            this.handleSingleForeignKeyCircularSelfReference(field, fieldMetaInfo, value, parent);
        } else {
            this.setField(parent, field, value);
        }
    }

    private void handleSingleForeignKeyCircularSelfReference(Field field, FieldMetaInfo fieldMetaInfo, Object value, Object parent) {
        if (this.dataManager.count(field.getType()) <= 1L) {
            if (!fieldMetaInfo.isOptional()) {
                CircularReferenceException.throwGeneralCircularReferenceException(field, parent);
            } else {
                return;
            }
        }
        Object parentId = org.sindaryn.datafi.StaticUtils.getId((Object)parent, (ReflectionCache)this.reflectionCache);
        List allValues = this.dataManager.findAll(field.getType()).stream().filter(_value -> !org.sindaryn.datafi.StaticUtils.getId((Object)_value, (ReflectionCache)this.reflectionCache).equals(parentId)).collect(Collectors.toList());
        if (allValues.size() == 1) {
            this.setField(parent, field, allValues.get(0));
        } else {
            this.setField(parent, field, TestDataGenerator.randomFrom(allValues));
        }
    }

    private boolean isCircularSelfReference(Object parent, Object value) {
        return value.getClass().equals(parent.getClass()) && org.sindaryn.datafi.StaticUtils.getId((Object)value, (ReflectionCache)this.reflectionCache).equals(org.sindaryn.datafi.StaticUtils.getId((Object)parent, (ReflectionCache)this.reflectionCache));
    }

    private void autoAssignPrimitivesCollection(Field field, Object parent) {
        switch (StaticUtils.primitiveCollectionType(field)) {
            case "String": {
                this.setField(parent, field, this.testData.collectionOfStrings(field.getType()));
                break;
            }
            case "Double": {
                this.setField(parent, field, this.testData.collectionOfDoubles(field.getType()));
                break;
            }
            case "Long": {
                this.setField(parent, field, this.testData.collectionOfLongs(field.getType()));
                break;
            }
            case "Integer": {
                this.setField(parent, field, this.testData.collectionOfIntegers(field.getType()));
                break;
            }
            case "Boolean": {
                this.setField(parent, field, this.testData.collectionOfBooleans(field.getType()));
                break;
            }
            case "LocalDateTime": {
                this.setField(parent, field, this.testData.collectionOfLocalDateTimes(field.getType()));
                break;
            }
            case "LocalDate": {
                this.setField(parent, field, this.testData.collectionOfLocalDates(field.getType()));
                break;
            }
            case "URL": {
                this.setField(parent, field, this.testData.collectionOfUrls(field.getType()));
            }
        }
    }

    private void autoAssignSinglePrimitive(Field field, Object parent) {
        switch (field.getType().getSimpleName()) {
            case "String": {
                this.setField(parent, field, this.testData.dummySentence());
                break;
            }
            case "Double": {
                this.setField(parent, field, this.testData.aDouble());
                break;
            }
            case "Long": {
                this.setField(parent, field, ThreadLocalRandom.current().nextLong());
                break;
            }
            case "Integer": {
                this.setField(parent, field, ThreadLocalRandom.current().nextInt());
                break;
            }
            case "Boolean": {
                this.setField(parent, field, ThreadLocalRandom.current().nextBoolean());
                break;
            }
            case "LocalDateTime": {
                this.setField(parent, field, this.testData.aLocalDateTime());
                break;
            }
            case "LocalDate": {
                this.setField(parent, field, this.testData.aLocalDate());
                break;
            }
            case "URL": {
                this.setField(parent, field, TestDataGenerator.randomFrom(this.testData.getWebsites()));
            }
        }
    }

    private void assignFromKeyword(Field field, Object parent) {
        switch (field.getAnnotation(MockData.class).keyword()) {
            case PAST_DATE: {
                this.setField(parent, field, this.testData.pastDate());
                break;
            }
            case FUTURE_DATE: {
                this.setField(parent, field, this.testData.futureDate());
                break;
            }
            case NAME: {
                this.setField(parent, field, TestDataGenerator.randomFrom(this.testData.getFirstNames()));
                break;
            }
            case ADDRESS: {
                this.setField(parent, field, TestDataGenerator.randomFrom(this.testData.getAddresses()));
                break;
            }
            case CITY: {
                this.setField(parent, field, TestDataGenerator.randomFrom(this.testData.getCities()));
                break;
            }
            case STATE: {
                this.setField(parent, field, TestDataGenerator.randomFrom(this.testData.getStateOrProvinces()));
                break;
            }
            case COUNTRY: {
                this.setField(parent, field, TestDataGenerator.randomFrom(this.testData.getCountries()));
                break;
            }
            case ZIP: {
                this.setField(parent, field, TestDataGenerator.randomFrom(this.testData.getZipCodes()));
                break;
            }
            case PHONE: {
                this.setField(parent, field, TestDataGenerator.randomFrom(this.testData.getPhone1s()));
                break;
            }
            case EMAIL: {
                this.setField(parent, field, TestDataGenerator.randomFrom(this.testData.getEmails()));
                break;
            }
            case PARAGRAPH: {
                this.setField(parent, field, this.testData.dummyParagraph());
                break;
            }
            case COMPANY: {
                this.setField(parent, field, TestDataGenerator.randomFrom(this.testData.getCompanies()));
                break;
            }
            case URL: {
                this.setField(parent, field, TestDataGenerator.randomFrom(this.testData.getWebsites()));
                break;
            }
            case PASSWORD: {
                this.setField(parent, field, this.testData.password());
            }
        }
    }

    private void assignFromCustomKeyword(Field field, Object parent) {
        String customKeyword = field.getAnnotation(MockData.class).customKeyword();
        List<Object> dataset = CustomizedMockers.getCustomKeyword(customKeyword.toUpperCase());
        this.setField(parent, field, TestDataGenerator.randomFrom(dataset));
    }

    private void assignFromOfSet(Field field, Object parent) {
        MockData mockData = field.getAnnotation(MockData.class);
        this.setField(parent, field, TestDataGenerator.randomFrom(Arrays.asList(mockData.ofSet())));
    }

    private void assignFromMinMaxRange(Field field, Object parent) {
        MockData mockData = field.getAnnotation(MockData.class);
        switch (field.getType().getSimpleName()) {
            case "Double": {
                this.setField(parent, field, ThreadLocalRandom.current().nextDouble(mockData.min(), mockData.max()));
                break;
            }
            case "Float": {
                this.setField(parent, field, Float.valueOf((float)ThreadLocalRandom.current().nextDouble(mockData.min(), mockData.max())));
                break;
            }
            case "Long": {
                this.setField(parent, field, ThreadLocalRandom.current().nextLong(mockData.min(), mockData.max()));
                break;
            }
            case "Integer": {
                this.setField(parent, field, ThreadLocalRandom.current().nextInt(mockData.min(), mockData.max()));
                break;
            }
            case "Short": {
                this.setField(parent, field, (short)ThreadLocalRandom.current().nextInt(mockData.min(), mockData.max()));
                break;
            }
            case "BigDecimal": {
                this.setField(parent, field, StaticUtils.generateRandomBigDecimalFromRange(mockData.min(), mockData.max()));
            }
        }
    }

    private void assignFromMockFactory(Field field, Object parent) {
        Class<? extends MockFactory> mockFactoryType = field.getAnnotation(MockData.class).mockFactoryBean();
        MockFactory mockFactory = CustomizedMockers.getMockFactory(mockFactoryType.getSimpleName());
        this.setField(parent, field, mockFactory.value());
    }

    private void setField(Object parent, Field field, Object value) {
        try {
            field.setAccessible(true);
            field.set(parent, value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void log(String s) {
        logger.log((Priority)Level.DEBUG, (Object)s);
    }

    private String indentation(Stack instantiationStack) {
        StringBuilder stringBuilder = new StringBuilder("|\n|");
        for (int i = 0; i < instantiationStack.size(); ++i) {
            stringBuilder.append("-");
        }
        return stringBuilder.toString();
    }

    private <T> T preExistingInstance(Class<?> clazz, Map<String, Object> args) {
        List preExistingInstances = this.dataManager.findAll(clazz);
        String indentation = this.indentation((Stack)args.get("INSTANTIATION_STACK"));
        if (preExistingInstances.isEmpty()) {
            this.log(indentation + "Cannot find previous instance of " + clazz.getSimpleName() + " to assign, assigning null value.");
            return null;
        }
        this.log(indentation + "Assigning previous instance of " + clazz.getSimpleName());
        if (preExistingInstances.size() == 1) {
            return (T)preExistingInstances.get(0);
        }
        return TestDataGenerator.randomFrom(preExistingInstances);
    }

    public CollectionInstantiator getCollectionInstantiator() {
        return this.collectionInstantiator;
    }
}

