/*
 * Decompiled with CFR 0.152.
 */
package org.sindaryn.datafi.service;

import java.util.Collection;
import java.util.List;
import org.sindaryn.datafi.StaticUtils;
import org.sindaryn.datafi.persistence.Archivable;
import org.sindaryn.datafi.service.BaseDataManager;
import org.springframework.stereotype.Service;

@Service
public class ArchivableDataManager<T extends Archivable>
extends BaseDataManager<T> {
    public T archive(T input) {
        Object id = StaticUtils.getId(input, this.reflectionCache);
        String simpleName = input.getClass().getSimpleName();
        Archivable toArchive = this.findById(input.getClass(), id).orElse(null);
        if (toArchive == null) {
            StaticUtils.throwEntityNotFoundException(simpleName, id);
        }
        toArchive.setIsArchived(true);
        return (T)this.save(toArchive);
    }

    public T deArchive(T input) {
        Object id = StaticUtils.getId(input, this.reflectionCache);
        String simpleName = input.getClass().getSimpleName();
        Archivable toDeArchive = this.findById(input.getClass(), id).orElse(null);
        if (toDeArchive == null) {
            StaticUtils.throwEntityNotFoundException(simpleName, id);
        }
        toDeArchive.setIsArchived(false);
        return (T)this.save(toDeArchive);
    }

    public List<T> archiveCollection(Collection<T> input) {
        Class<?> clazz = ((Archivable)input.iterator().next()).getClass();
        List<Object> ids = StaticUtils.getIdList(input, this.reflectionCache);
        List<?> toArchive = this.findAllById(clazz, ids);
        toArchive.forEach(item -> item.setIsArchived(true));
        return this.saveAll(toArchive);
    }

    public List<T> deArchiveCollection(Collection<T> input) {
        Class<?> clazz = ((Archivable)input.iterator().next()).getClass();
        List<Object> ids = StaticUtils.getIdList(input, this.reflectionCache);
        List<?> toDeArchive = this.findAllById(clazz, ids);
        toDeArchive.forEach(item -> item.setIsArchived(false));
        return this.saveAll(toDeArchive);
    }
}

