/*
 * Decompiled with CFR 0.152.
 */
package com.github.sinboun;

import com.github.sinboun.Emoji;
import com.github.sinboun.EmojiManager;
import com.github.sinboun.EmojiTrie;
import com.github.sinboun.Fitzpatrick;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmojiParser {
    private static final Pattern ALIAS_CANDIDATE_PATTERN = Pattern.compile("(?<=:)\\+?(\\w|\\||\\-)+(?=:)");

    public static String parseToAliases(String input) {
        return EmojiParser.parseToAliases(input, FitzpatrickAction.PARSE);
    }

    public static String parseToAliases(String input, final FitzpatrickAction fitzpatrickAction) {
        EmojiTransformer emojiTransformer = new EmojiTransformer(){

            public String transform(UnicodeCandidate unicodeCandidate) {
                switch (fitzpatrickAction) {
                    default: {
                        if (unicodeCandidate.hasFitzpatrick()) {
                            return ":" + unicodeCandidate.getEmoji().getAliases().get(0) + "|" + unicodeCandidate.getFitzpatrickType() + ":";
                        }
                    }
                    case REMOVE: {
                        return ":" + unicodeCandidate.getEmoji().getAliases().get(0) + ":";
                    }
                    case IGNORE: 
                }
                return ":" + unicodeCandidate.getEmoji().getAliases().get(0) + ":" + unicodeCandidate.getFitzpatrickUnicode();
            }
        };
        return EmojiParser.parseFromUnicode(input, emojiTransformer);
    }

    public static String replaceAllEmojis(String str, final String replacementString) {
        EmojiTransformer emojiTransformer = new EmojiTransformer(){

            public String transform(UnicodeCandidate unicodeCandidate) {
                return replacementString;
            }
        };
        return EmojiParser.parseFromUnicode(str, emojiTransformer);
    }

    public static String parseToUnicode(String input) {
        List<AliasCandidate> candidates = EmojiParser.getAliasCandidates(input);
        String result = input;
        for (AliasCandidate candidate : candidates) {
            Emoji emoji = EmojiManager.getForAlias(candidate.alias);
            if (emoji == null || !emoji.supportsFitzpatrick() && (emoji.supportsFitzpatrick() || candidate.fitzpatrick != null)) continue;
            String replacement = emoji.getUnicode();
            if (candidate.fitzpatrick != null) {
                replacement = replacement + candidate.fitzpatrick.unicode;
            }
            result = result.replace(":" + candidate.fullString + ":", replacement);
        }
        for (Emoji emoji : EmojiManager.getAll()) {
            result = result.replace(emoji.getHtmlHexadecimal(), emoji.getUnicode());
            result = result.replace(emoji.getHtmlDecimal(), emoji.getUnicode());
        }
        return result;
    }

    protected static List<AliasCandidate> getAliasCandidates(String input) {
        ArrayList<AliasCandidate> candidates = new ArrayList<AliasCandidate>();
        Matcher matcher = ALIAS_CANDIDATE_PATTERN.matcher(input);
        matcher = matcher.useTransparentBounds(true);
        while (matcher.find()) {
            String match = matcher.group();
            if (!match.contains("|")) {
                candidates.add(new AliasCandidate(match, match, null));
                continue;
            }
            String[] splitted = match.split("\\|");
            if (splitted.length == 2 || splitted.length > 2) {
                candidates.add(new AliasCandidate(match, splitted[0], splitted[1]));
                continue;
            }
            candidates.add(new AliasCandidate(match, match, null));
        }
        return candidates;
    }

    public static String parseToHtmlDecimal(String input) {
        return EmojiParser.parseToHtmlDecimal(input, FitzpatrickAction.PARSE);
    }

    public static String parseToHtmlDecimal(String input, final FitzpatrickAction fitzpatrickAction) {
        EmojiTransformer emojiTransformer = new EmojiTransformer(){

            public String transform(UnicodeCandidate unicodeCandidate) {
                switch (fitzpatrickAction) {
                    default: {
                        return unicodeCandidate.getEmoji().getHtmlDecimal();
                    }
                    case IGNORE: 
                }
                return unicodeCandidate.getEmoji().getHtmlDecimal() + unicodeCandidate.getFitzpatrickUnicode();
            }
        };
        return EmojiParser.parseFromUnicode(input, emojiTransformer);
    }

    public static String parseToHtmlHexadecimal(String input) {
        return EmojiParser.parseToHtmlHexadecimal(input, FitzpatrickAction.PARSE);
    }

    public static String parseToHtmlHexadecimal(String input, final FitzpatrickAction fitzpatrickAction) {
        EmojiTransformer emojiTransformer = new EmojiTransformer(){

            public String transform(UnicodeCandidate unicodeCandidate) {
                switch (fitzpatrickAction) {
                    default: {
                        return unicodeCandidate.getEmoji().getHtmlHexadecimal();
                    }
                    case IGNORE: 
                }
                return unicodeCandidate.getEmoji().getHtmlHexadecimal() + unicodeCandidate.getFitzpatrickUnicode();
            }
        };
        return EmojiParser.parseFromUnicode(input, emojiTransformer);
    }

    public static String removeAllEmojis(String str) {
        EmojiTransformer emojiTransformer = new EmojiTransformer(){

            public String transform(UnicodeCandidate unicodeCandidate) {
                return "";
            }
        };
        return EmojiParser.parseFromUnicode(str, emojiTransformer);
    }

    public static String removeEmojis(String str, final Collection<Emoji> emojisToRemove) {
        EmojiTransformer emojiTransformer = new EmojiTransformer(){

            public String transform(UnicodeCandidate unicodeCandidate) {
                if (!emojisToRemove.contains(unicodeCandidate.getEmoji())) {
                    return unicodeCandidate.getEmoji().getUnicode() + unicodeCandidate.getFitzpatrickUnicode();
                }
                return "";
            }
        };
        return EmojiParser.parseFromUnicode(str, emojiTransformer);
    }

    public static String removeAllEmojisExcept(String str, final Collection<Emoji> emojisToKeep) {
        EmojiTransformer emojiTransformer = new EmojiTransformer(){

            public String transform(UnicodeCandidate unicodeCandidate) {
                if (emojisToKeep.contains(unicodeCandidate.getEmoji())) {
                    return unicodeCandidate.getEmoji().getUnicode() + unicodeCandidate.getFitzpatrickUnicode();
                }
                return "";
            }
        };
        return EmojiParser.parseFromUnicode(str, emojiTransformer);
    }

    public static String parseFromUnicode(String input, EmojiTransformer transformer) {
        int prev = 0;
        StringBuilder sb = new StringBuilder();
        List<UnicodeCandidate> replacements = EmojiParser.getUnicodeCandidates(input);
        for (UnicodeCandidate candidate : replacements) {
            sb.append(input.substring(prev, candidate.getEmojiStartIndex()));
            sb.append(transformer.transform(candidate));
            prev = candidate.getFitzpatrickEndIndex();
        }
        return sb.append(input.substring(prev)).toString();
    }

    public static List<String> extractEmojis(String input) {
        List<UnicodeCandidate> emojis = EmojiParser.getUnicodeCandidates(input);
        ArrayList<String> result = new ArrayList<String>();
        for (UnicodeCandidate emoji : emojis) {
            result.add(emoji.getEmoji().getUnicode());
        }
        return result;
    }

    protected static List<UnicodeCandidate> getUnicodeCandidates(String input) {
        UnicodeCandidate next;
        char[] inputCharArray = input.toCharArray();
        ArrayList<UnicodeCandidate> candidates = new ArrayList<UnicodeCandidate>();
        int i = 0;
        while ((next = EmojiParser.getNextUnicodeCandidate(inputCharArray, i)) != null) {
            candidates.add(next);
            i = next.getFitzpatrickEndIndex();
        }
        return candidates;
    }

    protected static UnicodeCandidate getNextUnicodeCandidate(char[] chars, int start) {
        for (int i = start; i < chars.length; ++i) {
            int emojiEnd = EmojiParser.getEmojiEndPos(chars, i);
            if (emojiEnd == -1) continue;
            Emoji emoji = EmojiManager.getByUnicode(new String(chars, i, emojiEnd - i));
            String fitzpatrickString = emojiEnd + 2 <= chars.length ? new String(chars, emojiEnd, 2) : null;
            return new UnicodeCandidate(emoji, fitzpatrickString, i);
        }
        return null;
    }

    protected static int getEmojiEndPos(char[] text, int startPos) {
        int best = -1;
        for (int j = startPos + 1; j <= text.length; ++j) {
            EmojiTrie.Matches status = EmojiManager.isEmoji(Arrays.copyOfRange(text, startPos, j));
            if (status.exactMatch()) {
                best = j;
                continue;
            }
            if (!status.impossibleMatch()) continue;
            return best;
        }
        return best;
    }

    public static interface EmojiTransformer {
        public String transform(UnicodeCandidate var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FitzpatrickAction {
        PARSE,
        REMOVE,
        IGNORE;

    }

    protected static class AliasCandidate {
        public final String fullString;
        public final String alias;
        public final Fitzpatrick fitzpatrick;

        private AliasCandidate(String fullString, String alias, String fitzpatrickString) {
            this.fullString = fullString;
            this.alias = alias;
            this.fitzpatrick = fitzpatrickString == null ? null : Fitzpatrick.fitzpatrickFromType(fitzpatrickString);
        }
    }

    public static class UnicodeCandidate {
        private final Emoji emoji;
        private final Fitzpatrick fitzpatrick;
        private final int startIndex;

        private UnicodeCandidate(Emoji emoji, String fitzpatrick, int startIndex) {
            this.emoji = emoji;
            this.fitzpatrick = Fitzpatrick.fitzpatrickFromUnicode(fitzpatrick);
            this.startIndex = startIndex;
        }

        public Emoji getEmoji() {
            return this.emoji;
        }

        public boolean hasFitzpatrick() {
            return this.getFitzpatrick() != null;
        }

        public Fitzpatrick getFitzpatrick() {
            return this.fitzpatrick;
        }

        public String getFitzpatrickType() {
            return this.hasFitzpatrick() ? this.fitzpatrick.name().toLowerCase() : "";
        }

        public String getFitzpatrickUnicode() {
            return this.hasFitzpatrick() ? this.fitzpatrick.unicode : "";
        }

        public int getEmojiStartIndex() {
            return this.startIndex;
        }

        public int getEmojiEndIndex() {
            return this.startIndex + this.emoji.getUnicode().length();
        }

        public int getFitzpatrickEndIndex() {
            return this.getEmojiEndIndex() + (this.fitzpatrick != null ? 2 : 0);
        }
    }
}

